core.declare("being_prototype")
core.declare("being_demon_table")
core.declare("Beings")
core.declare("beings",{})
core.declare("BeingSkills",{})

function Beings( b )
	if b.proto then
		table.prototype( b, b.proto )
	end
	b.namep = b.namep or b.name.."s"
	core.register( beings, b )
end

being_prototype = {
	picture = '?',
	color   = RED,
	sprite  = 50,
	st      = 10,
	dx      = 10,
	wp      = 10,
	en      = 10,
	hp      = 10,
	energy  = 100,
	speed   = 100,
	armor   = 0,
	weight  = 10,
	ranged  = 0,
	flags   = {},
	ai      = AI_MONSTER,
}

function BeingSkills.Consume(self)
	if self.hp < self.hp_max / 3 and self.energy > 30 then
		local being = nil
		Level.find_cell( function(x,y) 
				being = Level.get_being(x,y) 
				return being ~= nil and beings[being.id].is_consumable
			end,
			area.around( self.pos_x, self.pos_y, 1 )
		)
		if being then
			if self.visible then ui.msg('The '..self.name..' consumes the '..being.name..'!') end
			self.hp = math.min( self.hp_max, self.hp + being.hp )
			being:die()
			self.energy = self.energy - 30
			self.speed_count = self.speed_count - 1500
			return false
		end
	end
	return true
end

function BeingSkills.Scavenge(self)
	if self.hp < self.hp_max / 2 and self.energy > 30 and math.random(10) < 5 then
		local x,y = Level.find_cell( 
			function(x,y) return Level.get_cell(x,y) == "bloody_corpse" end,
			area.around( self.pos_x, self.pos_y, 1 )
		)
		if x then
			if self.visible then ui.msg('The '..self.name..' eats a corpse!') end
			Level.set_cell("pool_of_blood",x,y)
			self.hp = self.hp_max
			self.energy = self.energy - 30
			self.speed_count = self.speed_count - 1500
			return false
		end
	end
	return true
end

function BeingSkills.Ressurect(self)
	if self.energy > 10 then
		local count = 0
		Level.for_all_cells( 
			function(x,y) 
				if self.energy > 10 and Level.get_cell(x,y) == "bloody_corpse" and 
					math.random(100) < 30 and Level.get_being(x,y) == nil then
					Level.set_cell( "pool_of_blood", x,y )
					Level.summon( "skeleton", x,y )
					self.energy = self.energy - 10
					count = count + 1
				end
			end,
			area.around( self.pos_x, self.pos_y, 3 )
		)
		if count > 0 then
			self.speed_count = self.speed_count - math.min(3000,500+count*100)
			return false
		end
	end
	return true
end

function BeingSkills.Animate(self)
	if self.energy > 60 then
		local x,y = Level.find_cell( 
			function(x,y) 
				return cells[Level.get_cell(x,y)].is_tree 
			end,
			area.around( self.pos_x, self.pos_y, 3 )
		)
		if x then
			Level.set_cell( "grass", x,y )
			local tree = Level.summon( "treant", x,y )
			if tree.visible then ui.msg('Suddenly a tree starts moving!') end
			self.energy      = self.energy - 60
			self.speed_count = self.speed_count - 2000
			return false
		end
	end
	return true
end

function BeingSkills.Blink(self, _, dist)
	if dist < 3 and self.energy > 20 and self.hp < self.hp_max / 2 then
		local sx,sy = self.pos_x, self.pos_y
		local x,y = Level.random_coord( function(x,y) 
				return Level.get_being(x,y) == nil and math.distance( x,y, sx,sy ) > 3
			end,
			area.around( sx, sy, 5 )
		)
		if x then
			if self.visible then ui.msg('The '..self.name..' blinks!') end
			Level.explosion( sx, sy, BLUE, 1, 0, 30 )
			self:move(x,y)
			Level.explosion( x, y, BLUE, 1, 0, 30 )
			self.energy      = self.energy - 20
			self.speed_count = self.speed_count - 1200
			return false
		end
	end
	return true
end

function BeingSkills.Defile(self, vis, dist)
	if vis and dist > 1 and dist < 7 and self.energy > 10 and math.random(3) > 1 then
		local x,y = Level.random_coord( nil, area.around( self.target_x, self.target_x, 2 ) )
		self:send_missile( x, y, MTSPORE )
		self.energy      = self.energy - 10
		self.speed_count = self.speed_count - 1500
		return false
	end
	return true
end

function BeingSkills.RangedEnergy(self, vis, dist)
	if vis and dist > 1 and dist < 7 and self.energy > 8 then
		self:send_missile( self.target_x, self.target_y, MTENERGY )
		self.energy      = self.energy - 8
		self.speed_count = self.speed_count - 2000
		return false
	end
	return true
end

function BeingSkills.RangedIce(self, vis, dist)
	if vis and dist > 1 and dist < 6 and self.energy > 8 then
		self:send_missile( self.target_x, self.target_y, MTICE )
		self.energy      = self.energy - 8
		self.speed_count = self.speed_count - 2000
		return false
	end
	return true
end



being_demon_table = {
	{ name = 'Ab', hp = 20, color = LIGHTGRAY },
	{ name = 'Da', st = 10, dx = 2, color = DARKGRAY },
	{ name = 'Ian', skill = BeingSkills.RangedEnergy, wp = 4, color = BLUE },
	{ name = 'Hee', speed = 20, color = LIGHTBLUE },
	{ name = 'Nar', skill = BeingSkills.Consume, hp = 20, en = 4, speed = -10, color = RED },
	{ name = 'Tur', flags = {BF_IMPALE}, hp = 10, st = 10, color = RED },
	{ name = 'Keh', skill = BeingSkills.Scavenge, color = RED },
	{ name = 'Gon', skill = BeingSkills.Defile, color = MAGENTA },
	{ name = 'Qua', skill = BeingSkills.Blink, flags = {BF_REGEN}, speed = 5, color = LIGHTCYAN },
	{ name = 'Nod', skill = BeingSkills.Ressurect, hp = 10, wp = 10, color = CYAN },
}

Beings{
	proto   = being_prototype,
	name    = 'yourself',
	namep   = '',
	picture = '@',
	color   = DARKGRAY,
	sprite  = 1,
	ai      = AI_PLAYER,
}	

Beings{
	proto   = being_prototype,
	name    = 'demon',
	picture = '&',
	color   = RED,
	sprite  = 49,
	weight  = 20,
	flags   = { BF_DEMON, BF_SPORERES },
	
	OnCreate = function( self, level )
		local props = math.min( math.floor(level / 5) + 1, 5 )
		if math.random(40) < math.min(level,20) then props = props + 1 end
		if math.random(10) + 5 < level then self.flags[ BF_REGEN ] = true end
		
		self.st = self.st + level + math.min( level, 5 )	
		self.dx = self.dx + math.floor( level / 5 ) + math.min( level, 8 )
		self.en = self.en + math.floor( level / 3 )
		self.wp = self.wp + math.floor( level / 3 )
		self.speed = self.speed + level
		self.hp = 30 + level * 3
		self.name = ""
		
		local max_prop = math.max( math.floor( level / 2 ) + 4, #being_demon_table )
		local high_prop = 0
		
		for count = 1,props do
			local prop = math.random( max_prop )
			if prop > high_prop then high_prop = prop end
			local demon = being_demon_table[prop]
			self.name = self.name .. demon.name
			if demon.flags then self.flags[demon.flags] = true end
			for k,v in ipairs(demon) do
				if type(v) == "number" then self[k] = self[k] + v end
			end
		end
		
		self.energy = 10*self.wp
		self.hp_max = self.hp
		self.energy_max = self.energy
		self.color = being_demon_table[ high_prop ].color		
	end,
	
	OnAction = function(self, vis, dist)
		local name = self.name
		for _,v in ipairs(being_demon_table) do
			if v.skill and string.find(name,v.name) then
				if not v.skill(self,vis,dist) then return false end
			end
		end
		return true
	end,
		
}

Beings{
	proto   = being_prototype,
	name    = 'beast',
	picture = 'b',
	color   = DARKGRAY,
	sprite  = 50,
	weight  = 9,
	is_consumable = true,
}

Beings{
	proto   = being_prototype,
	name    = 'bulldemon',
	picture = 'B',
	color   = BROWN,
	sprite  = 51,
	st      = 15,
	dx      = 14,
	hp      = 30,
	speed   = 90,
	weight  = 12,
	is_consumable = true,
	flags         = { BF_IMPALE },
}

Beings{
	proto   = being_prototype,
	name 	= 'mandagore',
	picture = 'M',
	color   = RED,
	sprite  = 52,
	st      = 22,
	dx      = 12,
	hp      = 60,
	speed   = 60, 
	armor 	= 2,
	weight  = 12,
	
	OnCreate = function(self)
		ui.msg('You hear a howl!')
	end,
	
	OnAction = BeingSkills.Consume,
}

Beings{
	proto   = being_prototype,
	name 	= 'defiler',
	picture = 'D',
	color   = MAGENTA,
	sprite  = 53,
	st      = 14,
	dx      = 12,
	wp      = 14,
	hp      = 50,
	speed   = 110,
	flags   = { BF_SPORERES },
		
	OnCreate = function(self)
		ui.msg('You feel a stench!')
	end,
	
	OnAction = BeingSkills.Defile,
}

Beings{
	proto   = being_prototype,
	name    = 'imp',
	picture = 'i',
	color   = BLUE,
	sprite  = 54,
	st      = 12,
	dx      = 9,
	wp      = 12,
	speed   = 110,
	is_consumable = true,
	
	OnAction = BeingSkills.RangedEnergy,
}

Beings{
	proto   = being_prototype,
	name    = 'phasehound',
	picture = 'h',
	color   = CYAN,      
	sprite  = 55,
	st      = 12,
	dx      = 14,
	wp      = 12,
	hp      = 20,
	speed   = 120,
	weight  = 9, 
	is_consumable = true,
	flags   = { BF_REGEN },
	
	OnAction = BeingSkills.Blink,
}

Beings{
	proto   = being_prototype,
	name    = 'skeleton',
	picture = 's',
	color   = LIGHTGRAY,
	sprite  = 56, 
	dx      = 9,
	speed   = 70, 
	weight  = 6,
	flags   = { BF_SPORERES, BF_SKELETAL, BF_NOCORPSE },
}

Beings{
	proto   = being_prototype,
	name    = 'wraith',
	picture = 'W',
	color   = LIGHTCYAN,
	sprite  = 57,
	st      = 20,
	dx      = 12, 
	wp      = 14, 
	hp      = 60,
	speed   = 60,
	flags   = { BF_SPORERES, BF_SKELETAL, BF_NOCORPSE },
	
	OnCreate = function(self)
		ui.msg('The smell of death!')
	end,
	
	OnAction = BeingSkills.Ressurect,
}

Beings{
	proto   = being_prototype,
	name    = 'spore',
	picture = '.',
	color   = LIGHTGREEN,
	sprite  = 58,
	dx      = 0,
	energy  = 5,
	armor   = 3, 
	flags   = { BF_SPORERES, BF_DEFILED, BF_NOCORPSE },
	
	OnCreate = function(self)
		self.energy = 0
	end,

	OnAction = function(self)
		self.speed_count = self.speed_count - 500
		if self.energy > 1 then
			if self.energy < 4 then 
				self.picture = 'o' 
				self.sprite = 59 
			elseif self.energy < 10 then 
				self.picture = 'O' 
				self.sprite = 60
			end				
		end
		if self.energy == self.energy_max then self:die() end
		return false
	end,
}

Beings{
	proto   = being_prototype,
	name    = 'scavenger',
	picture = 's',
	color   = BROWN,     
	sprite  = 61,
	st      = 12, 
	dx      = 14,
    hp      = 25,
	speed   = 110,
	is_consumable = true,
	
	OnAction = BeingSkills.Scavenge
}


Beings{
	proto   = being_prototype,
	name    = 'treespirit',
	picture = '*',
	color   = YELLOW,
    sprite  = 63,
	st      = 8,
	dx      = 14,
	wp      = 15,
	hp      = 20,
	speed   = 90,
	armor   = 2,
	weight  = 8, 
	flags   = { BF_SPORERES, BF_FLAMABLE, BF_REGEN },
	
	OnAction = function(self, vis, dist)
		if not BeingSkills.Animate(self,vis,dist) then return false end
		if not BeingSkills.Blink(self,vis,dist) then return false end
		return true
	end,
}

Beings{
	proto   = being_prototype,
	name    = 'treant',
	picture = 'T',
	color   = LIGHTGREEN,
	sprite  = 62,
	st      = 20,
	hp      = 70,
	speed   = 40,
	armor   = 2,
	weight  = 20,
	flags   = { BF_SPORERES, BF_FLAMABLE, BF_SKELETAL, BF_NOCORPSE },
}

Beings{
	proto   = being_prototype,
	name 	= 'townsman',
	namep   = 'townsmen',
	picture = '@',
	color   = BROWN,
	sprite  = 33,
	speed   = 90,
	ai      = AI_CIVILIAN,
}

Beings{
	proto   = being_prototype,
	name    = 'ice devil',
	picture = 'i',
	color   = LIGHTCYAN,
	sprite  = 70,
	dx      = 9,
	wp      = 11,
	speed   = 90,
	weight  = 8,
	is_consumable = true,
	flags   = { BF_FLAMABLE },
	
	OnAction = BeingSkills.RangedIce,
}

Beings{
	proto   = being_prototype,
	name    = 'yeti',
	picture = 'Y',
	color   = BLUE,
	sprite  = 68,
	st      = 22,
	hp      = 80,
	speed   = 80,
	armor   = 2,
	weight  = 14,
	flags   = { BF_FLAMABLE },
		
	OnCreate = function(self)
		ui.msg('You hear a howl!')
	end,
	
	OnAction = BeingSkills.Consume,
}

Beings{
	proto   = being_prototype,
	name    = 'blizzard',  
	picture = '#',
	color   = LIGHTBLUE,
	sprite  = 66,
	hp      = 160,
	speed   = 80,
	armor   = 2,
	weight  = 5,
	flags   = { BF_FLAMABLE, BF_NOCORPSE, BF_SPORERES },
	
	OnCreate = function( self )
		ui.msg('A gust of cold wind approaches!')
	end,
	
	OnAction = function( self, _, dist )
		if dist < 10 and self.hp > 40 and math.random(3) == 1 then
			local clone = Level.summon( self.id, self.pos_x, self.pos_y )
			if clone then
				self.hp = math.floor(self.hp / 2)
				clone.hp = self.hp
				self.speed_count = self.speed_count - 2000
			end
		end
		
		if dist == 1 then
			local target = self:get_target()
			if self.energy > 5 then
				if target.id == "yourself" then ui.msg('The blizzard freezes you!') end
				target:apply_damage( math.die_roll(2,4), DAMAGE_FREEZE )
				self.energy = self.energy - 5
			end
			self.speed_count = self.speed_count - 2000
			return false
		end
		return true
	end,
}

