[CCode (cprefix = "OssoABook", 
lower_case_cprefix = "osso_abook_")]
namespace OssoABook {
	[CCode (cheader_filename = "libosso-abook/osso-abook-button.h")]
	enum ButtonStyle {
		NORMAL,
		PICKER,
		LABEL,
		NOTE
	}
	[CCode (cheader_filename = "libosso-abook/osso-abook-button.h")]
	class Button : Gtk.Button {
		public Button (Hildon.SizeType size);
		public Button.with_text (Hildon.SizeType size, string title, string value);
		public void set_icon_name (string icon_name);
		public void set_icon_visible (bool visible);
		public string title { get; set; }
		public string value { get; set; }
		public OssoABook.ButtonStyle style { get; set; }
	}
	[CCode (cheader_filename = "libosso-abook/osso-abook-contact.h")]
	class Contact : E.Contact {
		public Contact ();
		public Contact.new_from_vcard (string? uid, string vcard);
	}
	[CCode (cheader_filename = "libosso-abook/osso-abook-temporary-contact-dialog.h")]
	class TemporaryContactDialog : Gtk.Dialog {
		public TemporaryContactDialog (Gtk.Window? parent, E.Book? book, E.VCardAttribute? attribute, void *account);
		public TemporaryContactDialog.with_contact (Gtk.Window? parent, OssoABook.Contact? contact);
	}
}
