/* This file is part of Beifahrer.
 *
 * Copyright (C) 2010 Philipp Zabel
 *
 * Beifahrer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Beifahrer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Beifahrer. If not, see <http://www.gnu.org/licenses/>.
 */

using Gtk;
using Hildon;

namespace Hildon {
	[CCode (cname = "hildon_gtk_entry_set_placeholder_text")]
	extern static void gtk_entry_set_placeholder_text (Gtk.Entry entry, string placeholder_text);

	[CCode (cname = "hildon_gtk_entry_set_input_mode")]
	extern static void gtk_entry_set_input_mode (Gtk.Entry entry, Hildon.GtkInputMode mode);
}

public class SettingsDialog : Gtk.Dialog {
	public const string GCONF_KEY_USE_LOCATION = "/apps/beifahrer/use_location";
	public const string GCONF_KEY_PRELOAD = "/apps/beifahrer/preload";
	public const string GCONF_KEY_USERNAME = "/apps/beifahrer/adac/username";
	public const string GCONF_KEY_PASSWORD = "/apps/beifahrer/adac/password";

	Hildon.CheckButton use_location;
	Hildon.CheckButton preload;
	Hildon.Entry username;
	Hildon.Entry password;
	GConf.Client gconf;

	public SettingsDialog (Gtk.Window window) {
		set_title (_("Settings"));
		set_transient_for (window);

		var vbox = (VBox) get_content_area ();
		use_location = new Hildon.CheckButton (SizeType.FINGER_HEIGHT);
		use_location.set_label (_("Determine point of departure automatically"));
		preload = new Hildon.CheckButton (SizeType.FINGER_HEIGHT);
		preload.set_label (_("Preload lift details in the background"));
		username = new Hildon.Entry (SizeType.FINGER_HEIGHT);
		Hildon.gtk_entry_set_placeholder_text (username, _("Username"));
		password = new Hildon.Entry (SizeType.FINGER_HEIGHT);
		password.set_visibility (false);
		Hildon.gtk_entry_set_placeholder_text (password, _("Password"));
		vbox.pack_start (use_location, true, true, 0);
		vbox.pack_start (preload, true, true, 0);
		vbox.pack_start (username, true, true, 0);
		vbox.pack_start (password, true, true, 0);
		vbox.show_all ();

		add_button (_("Save"), ResponseType.APPLY);

		gconf = GConf.Client.get_default ();
		try {
			use_location.set_active (gconf.get_bool (GCONF_KEY_USE_LOCATION));
			preload.set_active (gconf.get_bool (GCONF_KEY_PRELOAD));
			username.set_text (gconf.get_string (GCONF_KEY_USERNAME));
			password.set_text (gconf.get_string (GCONF_KEY_PASSWORD));
		} catch (Error e) {
			use_location.set_active (true);
		}

		response.connect (on_response);
	}

	void on_response (int response_id) {
		if (response_id == ResponseType.APPLY) try {
			gconf.set_bool (GCONF_KEY_USE_LOCATION, use_location.get_active ());
			gconf.set_bool (GCONF_KEY_PRELOAD, preload.get_active ());
			gconf.set_string (GCONF_KEY_USERNAME, username.get_text ());
			gconf.set_string (GCONF_KEY_PASSWORD, password.get_text ());
 			this.destroy ();
		} catch (Error e) {
		}
	}
}
