/* This file is part of Beifahrer.
 *
 * Copyright (C) 2010 Philipp Zabel
 *
 * Beifahrer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Beifahrer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Beifahrer. If not, see <http://www.gnu.org/licenses/>.
 */

using Gtk;
using Hildon;

public class OfferEditDialog : Gtk.Dialog {
	TimeButton time_button;
	DateButton date_button;
	CityButton departure_button;
	CityButton arrival_button;
	Hildon.TextView comment_entry;
	Hildon.CheckButton cell;
	Hildon.CheckButton phone;
	Hildon.CheckButton email;

	public OfferEditDialog (Gtk.Window window, AdacMitfahrclub adac, Lift lift) {
		set_title (_("Edit offer"));
		set_transient_for (window);

		var vbox = (VBox) get_content_area ();
		vbox.set_size_request (-1, 5*70);
		var pannable = new PannableArea ();
		vbox.pack_start (pannable, true, true, 0);
		vbox = new Gtk.VBox (false, 0);
		pannable.add_with_viewport (vbox);

		var title_size = new SizeGroup (SizeGroupMode.HORIZONTAL);

		time_button = new Hildon.TimeButton (SizeType.FINGER_HEIGHT, ButtonArrangement.HORIZONTAL);
		time_button.add_title_size_group (title_size);
		time_button.set_alignment (0.0f, 0.5f, 0.5f, 0.5f);
		time_button.set_time (lift.time.hour, lift.time.minute);
		date_button = new Hildon.DateButton (SizeType.FINGER_HEIGHT, ButtonArrangement.HORIZONTAL);
		date_button.add_title_size_group (title_size);
		date_button.set_alignment (0.0f, 0.5f, 0.5f, 0.5f);
		date_button.set_date (lift.time.year, lift.time.month - DateMonth.JANUARY, lift.time.day);
		departure_button = new CityButton (SizeType.FINGER_HEIGHT, ButtonArrangement.HORIZONTAL, adac.get_city_list (), false);
		departure_button.set_title (_("Departure"));
		departure_button.set_value (_("Please select"));
		departure_button.add_title_size_group (title_size);
		departure_button.set_alignment (0.0f, 0.5f, 0.5f, 0.5f);
		departure_button.set_city (lift.city_from);
		arrival_button = new CityButton (SizeType.FINGER_HEIGHT, ButtonArrangement.HORIZONTAL, adac.get_city_list (), false);
		arrival_button.set_title (_("Arrival"));
		arrival_button.set_value (_("Please select"));
		arrival_button.add_title_size_group (title_size);
		arrival_button.set_alignment (0.0f, 0.5f, 0.5f, 0.5f);
		arrival_button.set_city (lift.city_to);

		var comment_hbox = new Gtk.HBox (false, Hildon.MARGIN_DOUBLE);
		var comment_label = new Label (_("Comment"));
		comment_label.set_alignment (0.0f, 0.5f);
		title_size.add_widget (comment_label);
		comment_entry = new Hildon.TextView (); // 1000 chars
		comment_entry.set_wrap_mode (Gtk.WrapMode.WORD_CHAR);
		cell = new Hildon.CheckButton (SizeType.FINGER_HEIGHT);
		cell.set_label (_("Show cell number"));
		phone = new Hildon.CheckButton (SizeType.FINGER_HEIGHT);
		phone.set_label (_("Show phone number"));
		email = new Hildon.CheckButton (SizeType.FINGER_HEIGHT);
		email.set_label (_("Show E-mail address"));

		comment_hbox.pack_start (comment_label, false, false, 0);
		comment_hbox.pack_start (comment_entry, true, true, 0);

		vbox.pack_start (time_button, true, true, 0);
		vbox.pack_start (date_button, true, true, 0);
		vbox.pack_start (departure_button, true, true, 0);
		vbox.pack_start (arrival_button, true, true, 0);
		vbox.pack_start (comment_hbox, true, false, 0);
		vbox.pack_start (cell, true, true, 0);
		vbox.pack_start (phone, true, true, 0);
		vbox.pack_start (email, true, true, 0);
		pannable.show_all ();

		add_button (_("Save"), ResponseType.APPLY);

		response.connect (on_response);
	}

	void on_response (int response_id) {
		if (response_id == ResponseType.APPLY) try {
			//x
			this.destroy ();
		} catch (Error e) {
		}
	}
}
