/* This file is part of Beifahrer.
 *
 * Copyright (C) 2010 Philipp Zabel
 *
 * Beifahrer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Beifahrer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Beifahrer. If not, see <http://www.gnu.org/licenses/>.
 */

public class Orientation : Object {
	private const string MCE_SERVICE = "com.nokia.mce";
	private const string MCE_REQUEST_PATH = "/com/nokia/mce/request";
	private const string MCE_SIGNAL_PATH = "/com/nokia/mce/signal";
	private const string MCE_REQUEST_IF = "com.nokia.mce.request";
	private const string MCE_SIGNAL_IF = "com.nokia.mce.signal";

	private const string HAL_SERVICE = "org.freedesktop.Hal";
	private const string HAL_SLIDE_PATH = "/org/freedesktop/Hal/devices/platform_slide";
	private const string HAL_DEVICE_IF = "org.freedesktop.Hal.Device";

	public bool portrait;
	public bool keyboard;
	private DBus.Connection conn;
	private dynamic DBus.Object mce_request;
	private dynamic DBus.Object mce_signal;
	private dynamic DBus.Object hal_slide;

	public signal void changed ();

	construct {
		portrait = false;
		try {
			conn = DBus.Bus.get (DBus.BusType.SYSTEM);

			mce_request = conn.get_object (MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF);
			mce_enable_accelerometer ();

			mce_signal = conn.get_object (MCE_SERVICE, MCE_SIGNAL_PATH, MCE_SIGNAL_IF);
			mce_signal.sig_device_orientation_ind.connect (on_mce_orientation_changed);

			hal_slide = conn.get_object (HAL_SERVICE, HAL_SLIDE_PATH, HAL_DEVICE_IF);
			hal_slide.Condition.connect (on_hal_slide_condition);
			bool closed = hal_slide.GetPropertyBoolean ("button.state.value");
			keyboard = !closed;
		} catch (Error e) {
			stderr.printf ("Error: %s\n", e.message);
		}
	}

	private void mce_enable_accelerometer () {
		string orientation, stand, face;
		int x, y, z;

		mce_request.req_accelerometer_enable (out orientation, out stand, out face, out x, out y, out z);
		on_mce_orientation_changed (mce_request, orientation, stand, face, x, y, z);
	}

	private void on_mce_orientation_changed (dynamic DBus.Object mce, string orientation,
	                                         string stand, string face, int x, int y , int z) {
		portrait = (orientation == "portrait" & !keyboard);
		changed ();
	}

	private void on_hal_slide_condition (dynamic DBus.Object slide, string cond_name, string cond_details) {
		if (cond_name == "ButtonPressed" && cond_details == "cover") {
			bool closed = hal_slide.GetPropertyBoolean ("button.state.value");
			keyboard = !closed;
			portrait &= closed;
		}
		changed ();
	}
}
