/* This file is part of Beifahrer.
 *
 * Copyright (C) 2010 Philipp Zabel
 *
 * Beifahrer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Beifahrer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Beifahrer. If not, see <http://www.gnu.org/licenses/>.
 */

AdacMitfahrclub adac;
MainLoop loop;

async void get_lifts (string city_from, string city_to, Date date) {
	print ("Lifts from %s to %s on %d.%d.%d\n", city_from, city_to,
	       date.get_day (), date.get_month (), date.get_year ());

	var lift_list = yield adac.get_lift_list (city_from, city_to, date);
	foreach (Lift lift in lift_list) {
		print ("%s\t%s\t%s\t%s\t%d\t%s\t", lift.city_from, lift.city_to, lift.date, lift.time, lift.places, lift.price);
		if (LiftFlags.SMOKER in lift.flags)
			print ("smoker ");
		else if (LiftFlags.NON_SMOKER in lift.flags)
			print ("non_smoker ");
		if (LiftFlags.ADAC_MEMBER in lift.flags)
			print ("adac ");
		if  (LiftFlags.WOMEN_ONLY in lift.flags)
			print ("women ");
		print ("\n");
		print ("%s\n", lift.href);
	}

	loop.quit ();
}

async void get_details (string href) {
	var lift = new Lift ();
	lift.href = href;
	yield adac.update_lift_details (lift);

	print ("%s\t%s\t%s\t%s\t%d\t%s\t", lift.city_from, lift.city_to, lift.date, lift.time, lift.places, lift.price);
	if (LiftFlags.SMOKER in lift.flags)
		print ("smoker ");
	else if (LiftFlags.NON_SMOKER in lift.flags)
		print ("non_smoker ");
	if (LiftFlags.ADAC_MEMBER in lift.flags)
		print ("adac ");
	if  (LiftFlags.WOMEN_ONLY in lift.flags)
		print ("women ");
               print ("\n");
	foreach (string via in lift.city_via) {
		print ("\tvia %s\n", via);
	}

	print ("Driver: %s (%s)\n", lift.name, lift.phone);
	print ("Description:\n%s\n", lift.description);

	loop.quit ();
}

static int main (string[] args) {
	loop = new MainLoop (null);

	if (args.length < 3) {
		print ("usage: beifahrer-cli <city_from> <city_to> [date]\n");
		print ("or:    beifahrer-cli details <lift_url>\n");
		return 1;
	}

	adac = new AdacMitfahrclub ();

	if (args[1] == "details") {
		get_details.begin (args[2]);

		loop.run ();
		return 0;
	}

	string city_from = args[1];
	string city_to = args[2];

	var date = Date ();
	if (args.length > 3) {
		date.set_parse (args[3]);
	} else {
		var now = TimeVal ();
		date.set_time_val (now);
	}

	get_lifts.begin (city_from, city_to, date);

	loop.run ();
	return 0;
}
