import gobject

import gtk
import hildon

import time

import beye

import dataprocessing

def dhmSince(since):
    if since == None:
        return '-'
    now = time.time()
    if since > now - 60:
        return '-'
    return dhm(now - since)

def dhm(timeDuration):
    if timeDuration == None or timeDuration < 60:
        return '-'
    m = int(timeDuration / 60)
    h = m / 60
    m = m % 60
    if (h >= 24):
        d = int(h / 24)
        h = h % 24
        if d == 1:
            days = 'day'
        else:
            days = 'days'
        return "%d %s, %d:%02d" % (d, days, h, m)
    else:
        return "%d:%02d" % (h, m)
   

class Statistics(hildon.StackableWindow):
    def __init__(self, dataStorage):
        hildon.StackableWindow.__init__(self)

        self.dataStorage = dataStorage

        self.connect("delete_event", self.onWindowClose)

        oldest = self.dataStorage.getOldestObservationTime()
        if oldest == None:
            oldest = 0
        self.set_title('Statistics, last %d days' % int((time.time() - oldest) / 86400))

        # Setting a label in the new window
        label = gtk.Label("Loading statistics...")
 
        vbox = gtk.VBox(False, 0)
        vbox.pack_start(label, True, True, 0)
        self.add(vbox)
 
        # This call show the window and also add the window to the stack
        hildon.hildon_gtk_window_set_progress_indicator(self, False)
        gobject.idle_add(self.showStatistics)
        self.show_all()

    def onWindowClose(self, param1, param2):
        hildon.hildon_gtk_window_set_progress_indicator(self, False)

    def showStatistics(self):
        now = time.time()
        chargeData = dataprocessing.getChargeInfo(self.dataStorage,
                                                  self.dataStorage.getOldestObservationTime(),
                                                  now, now)

        discharges = []
        charges = []

        for segment in chargeData:
            discharges.extend((i for i in segment if i[0] == (False, True) and i[2] - i[1] > 120))
            charges.extend((i for i in segment if i[0] == (True, False) and i[2] - i[1] > 120))

        chargeTime = 0
        dischargeTime = 0

        maxChargeTime = 0
        maxDischargeTime = 0

        for item in charges:
            chargeTime += item[2] - item[1]
            maxChargeTime = max(maxChargeTime, item[2] - item[1])

        for item in discharges:
            dischargeTime += item[2] - item[1]
            maxDischargeTime = max(maxDischargeTime, item[2] - item[1])

        try:
            avgChargeTime = int(chargeTime/len(charges))
        except ZeroDivisionError:
            avgChargeTime = None

        try:
            avgDischargeTime = int(dischargeTime/len(discharges))
        except ZeroDivisionError:
            avgDischargeTime = None

        try:
            lastChargeEnd = charges[-1][2]
        except IndexError:
            lastChargeEnd = None

        totalmAh = 0.0
        for dc in discharges:
            start = self.dataStorage.getNextObservedValueForType(dc[1], beye.DataSourceHal.CHARGE)
            end = self.dataStorage.getPreviousObservedValueForType(dc[2], beye.DataSourceHal.CHARGE)
            totalmAh += start - end

        avgRate = totalmAh / dischargeTime

        maxCharge = self.dataStorage.getMaxCharge()
        if (maxCharge == None):
            maxCharge = 1300
        try:
            batteryLife = int(maxCharge / avgRate)
        except ZeroDivisionError:
            batteryLife = None

        currentCharge = self.dataStorage.getPreviousObservedValueForType(now, beye.DataSourceHal.CHARGE)
        if currentCharge == None:
            currentCharge = 0
            
        try:
            batteryRemain = int(currentCharge / avgRate)
        except ZeroDivisionError:
            batteryRemain = None

        parea = hildon.PannableArea()
        hbox = gtk.HBox(False, 0)
        vboxKeys = gtk.VBox(False, 0)
        vboxValues = gtk.VBox(False, 0)
        hbox.pack_start(gtk.VBox(False, 0))
        hbox.pack_start(vboxKeys)
        hbox.pack_start(vboxValues)
        for k, v in (('', ''),
                     ('Time since last charge', '%s' % dhmSince(lastChargeEnd)),
                     ('Number of charges (>120s) recorded', '%d' % len(charges)),
                     ('Total charge time', '%s' % dhm(chargeTime)),
                     ('Average charge time', '%s' % dhm(avgChargeTime)),
                     ('Longest charge time', '%s' % dhm(maxChargeTime)),
                     ('', ''),
                     ('Number of discharges (>120s) recorded', '%d' % len(discharges)),
                     ('Total discharge time', '%s' % dhm(dischargeTime)),
                     ('Average time between charges', '%s' % dhm(avgDischargeTime)),
                     ('Longest time between charges', '%s' % dhm(maxDischargeTime)),
                     ('Total ampere-hours discharged', '%.2f Ah' % (totalmAh / 1000)),
                     ('Average discharge current (mAh/hour)', '%.1f mA' % (avgRate * 3600)),
                     ('', ''),
                     ('*Average battery life for full charge (%d mAh)' % maxCharge, '%s' % dhm(batteryLife)), 
                     ('*Battery life left now (%d mAh)' % currentCharge, '%s' % dhm(batteryRemain)),
                     ('', ''),
                     ('(*) Values are extrapolated from average', ''),
                     ('      discharge current, accuracy may vary.', '')
                    ):
            label = gtk.Label(k)
            label.set_alignment(0, 0)
            vboxKeys.pack_start(label, False, False, 0)
 
            label = gtk.Label(v)
            label.set_alignment(0, 0)
            vboxValues.pack_start(label, False, False, 0)
           

        self.remove(self.get_children()[0])
        parea.add_with_viewport(hbox)
        self.add(parea)
        self.show_all()

        hildon.hildon_gtk_window_set_progress_indicator(self, False)
