#    This file is part of battery-eye.
#
#    battery-eye is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    battery-eye is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with battery-eye.  If not, see <http://www.gnu.org/licenses/>.

#    Copyright 2010 Jussi Holm

from Daemon import *
from DataStorage import *
from DataSource import *
from timezone import local, utc

import os
import os.path

def setupAndGetDbPath():
    dbDir = os.path.expanduser('~/.config/battery-eye')
    if not os.path.isdir(dbDir):
        os.makedirs(dbDir)
    
    dbFile = os.path.join(dbDir, 'beyed.sqlite')
    return dbFile

