#!/usr/bin/env python

#    This file is part of battery-eye.
#
#    battery-eye is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    battery-eye is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with battery-eye.  If not, see <http://www.gnu.org/licenses/>.

#    Copyright 2010 Jussi Holm


# Don't run as root, we don't need that.
if __name__ == "__main__":
    import os
    if os.getuid() == 0 or os.geteuid() == 0:
        import pwd
        unprivileged = pwd.getpwnam('user')
        os.setregid(unprivileged[3], unprivileged[3])
        os.setreuid(unprivileged[2], unprivileged[2])
        
    
import beye

if __name__ == "__main__":
    dbFile = beye.setupAndGetDbPath()
    ds = beye.DataSourceHal()
    storage = beye.DataStorage(dbFile, [ds])
    daemon = beye.Daemon(storage, [ds])
    daemon.run()
