#ifndef WIDGET_H
#define WIDGET_H

#include <QWidget>
#include <QProgressBar>
#include <QProcess>
#include <QWindowsStyle>
#include <QMotifStyle>
#include <QPlastiqueStyle>
#include <QMaemo5Style>

class QSlider;
class QLabel;
class QTextEdit;
class QColor;
class QStyle;
class QPushButton;
class QMaemo5ValueButton;
class QMaemo5ListPickSelector;
class QStandardItemModel;
class QColorDialog;
class QMainWindow;
class QMenu;
class QAction;
class QHBoxLayout;
class QVBoxLayout;


class Widget : public QProgressBar
{
    Q_OBJECT

public:
    Widget(QWidget *parent = 0);
	void mousePressEvent(QMouseEvent* event);
	bool x11Event ( XEvent * event );
	void setCurrentStyle(QString style);

public slots:
	void updateBatteryLevel();
	void displayStateChanged(QString);
	void changePollInterval(int);
	void cmdFinished( int exitCode, QProcess::ExitStatus exitStatus );
	void changeBarColor(QColor color);
	void changeBackColor(QColor color);
	void changeTextColor(QColor color);
	void applyStyle(QString style = "motif");
	void showAbout();
	void showDonate();

protected:
	QTextEdit *battInfo;
	QProcess* _processPtr;

public:

private:
	QMainWindow *detailWindow;
	QMenu *menu;
	QAction *aboutAct;
	QAction *donateAct;

	QMainWindow *styleWindow;
	QWidget *styleWidget;
	QHBoxLayout *layout;
	QVBoxLayout *v1layout;
	QVBoxLayout *v2layout;
	QSlider	*pollSlider;
	QLabel	*pollValueLabel;
	QPushButton *barColor;
	QPushButton *backColor;
	QPushButton *textColor;
	QPushButton *applyOnlyStyleButton;
	QMaemo5ValueButton *styleButton;
	QMaemo5ListPickSelector *styleSelector;
	QStandardItemModel *styleSelectionModel;
	QColorDialog *barColorDialog;
	QColorDialog *backColorDialog;
	QColorDialog *textColorDialog;
	QWindowsStyle *_windowsStyle;
	QMotifStyle *_motifStyle;
	QPlastiqueStyle *_plastiqueStyle;
	QMaemo5Style *_maemo5Style;
	QStyle *currentStyle;
	QString _currentStyleText;	

	QTimer	*_timer;
	int _pollingInterval;
	bool	_screenOff;
};

#endif
