#include "widget.h"
#include <QMainWindow>
#include <QMenu>
#include <QMenuBar>
#include <QStyleOption>
#include <QPainter>
#include <QPaintEvent>
#include <QTextBrowser>
#include <QApplication>
//#include <QMaemo5KineticScroller>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QPushButton>
#include <QMaemo5ListPickSelector>
#include <QMaemo5ValueButton>
#include <QStandardItemModel>
#include <QColorDialog>
#include <QDesktopServices>
#include <QMessageBox>
#include <QSlider>
#include <QLabel>
#include <QTimer>
#include <QUrl>
#include <QMaemo5InformationBox>
#include <QDebug>
#include <QDBusConnection>
#include <mce/dbus-names.h>
#include <mce/mode-names.h>


#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <QtGui/QX11Info>
#include <QtCore/QByteArray>
#include <QtCore/QCoreApplication>

#include <QtGui/QMessageBox>

Widget::Widget(QWidget *parent) : QProgressBar (parent), _screenOff(false), _pollingInterval(10) // 10 sec default polling
{
    QCoreApplication::instance()->setApplicationName("Hildon-Desktop battery level widget");

    // Get required atoms
    Atom winTypeAtom = XInternAtom(QX11Info::display(), "_NET_WM_WINDOW_TYPE", false);
    Atom homeAppletAtom = XInternAtom(QX11Info::display(), "_HILDON_WM_WINDOW_TYPE_HOME_APPLET", false);
    Atom appletIDAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_ID", false);
    Atom utf8Atom = XInternAtom(QX11Info::display(), "UTF8_STRING", false); 
   
    // Set correct window type
    XChangeProperty(QX11Info::display(), winId(), winTypeAtom, XA_ATOM, 32,
		    PropModeReplace, (unsigned char *) &homeAppletAtom, 1);

    // Use application name to fill AppletID
    QByteArray id (QCoreApplication::instance()->applicationName().remove(' ').toUtf8());
    XChangeProperty(QX11Info::display(), winId(), appletIDAtom, utf8Atom, 8, 
    	            PropModeReplace, (unsigned char *)id.constData(), id.length());

    // Add setting button. This button is shown when hildon-desktop is in edit mode. 
    Atom appletSettingAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_SETTINGS", false);
    int settings = 0;
    XChangeProperty(QX11Info::display(), winId(), appletSettingAtom, XA_CARDINAL, 32,
		    PropModeReplace, (unsigned char*)&settings, 1);
   

   	// SETTINGS WIDGET STUFF
	// listen to the display status, if its OFF we shouldnt poll
	QDBusConnection::systemBus().connect(QString(), MCE_SIGNAL_PATH, MCE_SIGNAL_IF,
			                			MCE_DISPLAY_SIG, this, SLOT(displayStateChanged(QString)));

	pollSlider = new QSlider(Qt::Horizontal);
	pollSlider->setRange(0, 500);
	pollSlider->setSingleStep(10);
	pollSlider->setValue(10);
	pollValueLabel = new QLabel;
	pollValueLabel->setText("Polling Interval : " + QString::number(_pollingInterval) + "sec");

	// sytle and color widget objects
	styleWindow = new QMainWindow;
	styleWidget = new QWidget;

	v1layout = new QVBoxLayout;
	v2layout = new QVBoxLayout;
	layout = new QHBoxLayout;
	barColor = new QPushButton("BAR COLOR");
	backColor = new QPushButton("BACKGROUND COLOR");
	textColor = new QPushButton("TEXT COLOR");
	styleButton = new QMaemo5ValueButton("SELECT STYLE");
	styleSelector = new QMaemo5ListPickSelector;
	styleSelectionModel = new QStandardItemModel;
	styleSelector->setModel(styleSelectionModel);
	styleButton->setPickSelector(styleSelector);
	styleButton->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered);

	barColorDialog = new QColorDialog;
	backColorDialog = new QColorDialog;
	textColorDialog = new QColorDialog;
	_windowsStyle = new QWindowsStyle;
	_motifStyle = new QMotifStyle;
	_plastiqueStyle = new QPlastiqueStyle;
	_maemo5Style = new QMaemo5Style;

	v1layout->addWidget(pollValueLabel);
	v1layout->addWidget(pollSlider);
	v2layout->addWidget(styleButton);
	v2layout->addWidget(barColor);
	v2layout->addWidget(backColor);
	v2layout->addWidget(textColor);
	layout->addLayout(v1layout);
	layout->addLayout(v2layout);

	styleWidget->setLayout(layout);
	styleWindow->setCentralWidget(styleWidget);
	styleWindow->setWindowTitle("SETTINGS");

	// detailed info window objects
	_processPtr = new QProcess(this);
	battInfo = new QTextBrowser;
	battInfo->setAttribute(Qt::WA_DeleteOnClose);
	aboutAct = new QAction(tr("&ABOUT"), this);
	aboutAct->setShortcut(tr("Ctrl+A"));
	aboutAct->setStatusTip(tr("About"));
	connect(aboutAct, SIGNAL(triggered()), this , SLOT(showAbout()));

	detailWindow = new QMainWindow;
	detailWindow->setWindowTitle("OUTPUT of hal-device bme");
    donateAct = new QAction(tr("&DONATE"), this);
    donateAct->setShortcut(tr("Ctrl+D"));
    donateAct->setStatusTip(tr("Donate"));
    connect(donateAct, SIGNAL(triggered()), this , SLOT(showDonate()));

	menu = (detailWindow->menuBar())->addMenu(tr(""));
	menu->addAction(aboutAct);
    menu->addAction(donateAct);

	QStringList stylelist;
	stylelist << "motif" << "maemo5" << "windows" << "plastique";
	foreach(QString style, stylelist)
	{
		QStandardItem *item = new QStandardItem(style);
		item->setTextAlignment(Qt::AlignCenter); // the Maemo 5 design spec recommends this.
		item->setEditable(false); // prevent editing of the item
		styleSelectionModel->appendRow(item);
	}

	// connected for the settings window
	connect(pollSlider, SIGNAL(valueChanged(int)), this, SLOT(changePollInterval(int)));

	// connect's for the detail window
	connect(_processPtr, SIGNAL(finished(int , QProcess::ExitStatus)), this, SLOT(cmdFinished(int , QProcess::ExitStatus)) );

	// connects for the style window
	connect(styleSelector, SIGNAL(selected(QString)), this, SLOT(applyStyle(QString)));
	connect(barColor, SIGNAL(clicked()), barColorDialog, SLOT(show()));
	connect(backColor, SIGNAL(clicked()), backColorDialog, SLOT(show()));
	connect(textColor, SIGNAL(clicked()), textColorDialog, SLOT(show()));
	connect(barColorDialog, SIGNAL(colorSelected(QColor)), this, SLOT(changeBarColor(QColor)));
	connect(backColorDialog, SIGNAL(colorSelected(QColor)), this, SLOT(changeBackColor(QColor)));
	connect(textColorDialog, SIGNAL(colorSelected(QColor)), this, SLOT(changeTextColor(QColor)));

	// polling timer and its connect slot
	_timer = new QTimer;
	_timer->start(_pollingInterval*1000);
	updateBatteryLevel();

	connect(_timer, SIGNAL(timeout()), this, SLOT(updateBatteryLevel()));

}

//Filter show setting requests
bool Widget::x11Event ( XEvent * event )
{
  static Atom appletShowSettingAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_SHOW_SETTINGS", false);

  if (event->xclient.message_type == appletShowSettingAtom ) 
  { 
	styleWindow->show();
	return true;
  }
  return false;
}

void Widget::mousePressEvent ( QMouseEvent * event )
{
	updateBatteryLevel();
	detailWindow->show();
}

void Widget::updateBatteryLevel ()
{
	QString cmd("/opt/batlevel/bin/run_lshal");

	if ( !_screenOff )
	{
		_processPtr->start(cmd);
		_processPtr->waitForFinished();
	}
}

void Widget::cmdFinished( int exitCode, QProcess::ExitStatus exitStatus )
{
	battInfo->clear();

	while (!_processPtr->atEnd())
	{
		QByteArray byteArray = _processPtr->readLine();
		QString line(byteArray);
		battInfo->append(line);
		if ( line.contains("percentage"))
		{
			QStringList tmpS1 = line.split("  ", QString::SkipEmptyParts);
			QString percentage = tmpS1[0].section(" = ", 1, 1);
			qDebug() << "Percentage = " << percentage;
			setValue(int(percentage.toInt()));
		}
	}
	battInfo->setReadOnly(true);
	battInfo->moveCursor(QTextCursor::Start);

	detailWindow->setCentralWidget(battInfo);
}

void Widget::changeBarColor(QColor color)
{
	applyStyle(styleButton->valueText());

	QPalette pal = palette();

	pal.setColor ( QPalette::Highlight, color );
	setPalette(pal);
}

void Widget::changeBackColor(QColor color)
{
	applyStyle(styleButton->valueText());

	QPalette pal = palette();

	if ( styleButton->valueText() == "motif" || styleButton->valueText() == "windows")
		pal.setColor ( QPalette::Window, color );
	else if ( styleButton->valueText() == "plastique")
		pal.setColor ( QPalette::Base, color );
	setPalette(pal);
}

void Widget::changeTextColor(QColor color)
{
	applyStyle(styleButton->valueText());

	QPalette pal = palette();

	if ( styleButton->valueText() == "motif" )
	{
		pal.setColor ( QPalette::HighlightedText, color );
		pal.setColor ( QPalette::Text, color );
	}
	else if ( styleButton->valueText() == "windows" )
		pal.setColor ( QPalette::WindowText, color );
	else if ( styleButton->valueText() == "plastique" )
		pal.setColor ( QPalette::Text, color );

	setPalette(pal);
}

void Widget::setCurrentStyle(QString styleText)
{
		//qDebug() << "setting current style to " << styleButton->valueText();
		
		if (styleText.toStdString() == "windows")
						currentStyle = _windowsStyle;
		else if (styleText.toStdString() == "motif")
						currentStyle = _motifStyle;
		else if (styleText.toStdString() == "plastique")
						currentStyle = _plastiqueStyle;
		else if (styleText.toStdString() == "maemo5")
						currentStyle = _maemo5Style;

		setStyle(currentStyle);
		_currentStyleText = styleText;

		if ( styleText == "maemo5" )
		{
			//QLabel *label2 = new QLabel("You have chosen <b>MAEMO5 style</b> everything now defaults to system colors");
			QLabel *label2 = new QLabel;
			label2->setText("<font color=#000000>"+QString("You have chosen MAEMO5 style.Default to system colors")+"</font>");
			QMaemo5InformationBox infoBox;
			infoBox.setWidget(label2);
			infoBox.exec();
		}
}


void Widget::applyStyle(QString style)
{
		qDebug() << "Applying style " << style;

		if ( style != "" )
		{
			setCurrentStyle(style);
		}
		else
		{
			QLabel *label1 = new QLabel;
			label1->setText("<font color=#000000>"+ QString("Motif has been used as default style, you could change it.")+ 
								QString("Maemo style supports only theme colours")+"</font>");
			label1->setWordWrap(true);
			QMaemo5InformationBox infoBox;
			infoBox.setWidget(label1);
			infoBox.exec();
			setCurrentStyle("motif");
		}
}

void Widget::displayStateChanged(QString displayState)
{ 
	if (displayState == QLatin1String(MCE_DISPLAY_OFF_STRING))
	{
		_screenOff = true;
		//qDebug() << "Stopping timer now screen is off";
	}
	else if (displayState != QLatin1String(MCE_DISPLAY_OFF_STRING))
	{
		_screenOff = false;
		//qDebug() << "Starting timer now screen is on";
		updateBatteryLevel(); // update the level as soon as screen is on before starting the timer
		_timer->start(_pollingInterval*1000);
	}
}

void Widget::changePollInterval(int value)
{ 
	_timer->stop();
	_pollingInterval = value;
	pollValueLabel->setText("Polling Interval : " + QString::number(_pollingInterval) + "sec");
	_timer->start(_pollingInterval*1000);
}

void Widget::showAbout()
{
		QMessageBox::about(detailWindow,"BATLEVEL-2.0 DESKTOP BATTERY WIDGET FOR MAEMO", "This is a desktop battery widget for the N900 that displays a bar and the percentage of battery left. The Styles and Colors can be customized, and detailed information about the battery is available on tapping the widget");
}

void Widget::showDonate()
{
	QDesktopServices::openUrl(QUrl("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=rkmaemo@gmx.com&lc=GB&item_name=Batlevel desktop widget Maemo&currency_code=GBP&bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted"));
}
