/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the Graphics Dojo project on Trolltech Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
#ifndef WIDGET_H
#define WIDGET_H

#include <QWidget>
#include <QProgressBar>
#include <QProcess>
#include <QWindowsStyle>
#include <QMotifStyle>
#include <QPlastiqueStyle>
#include <QMaemo5Style>

class QSlider;
class QLabel;
class QTextEdit;
class QColor;
class QStyle;
class QPushButton;
class QMaemo5ValueButton;
class QMaemo5ListPickSelector;
class QStandardItemModel;
class QColorDialog;
class QMainWindow;
class QMenu;
class QAction;
class QHBoxLayout;
class QVBoxLayout;


class Widget : public QProgressBar
{
    Q_OBJECT

public:
    Widget(QWidget *parent = 0);
	void mousePressEvent(QMouseEvent* event);
	bool x11Event ( XEvent * event );
	void setCurrentStyle(QString style);

public slots:
	void updateBatteryLevel();
	void displayStateChanged(QString);
	void changePollInterval(int);
	void cmdFinished( int exitCode, QProcess::ExitStatus exitStatus );
	void changeBarColor(QColor color);
	void changeBackColor(QColor color);
	void changeTextColor(QColor color);
	void applyStyle(QString style = "motif");
	void showAbout();
	void showDonate();

protected:
	QTextEdit *battInfo;
	QProcess* _processPtr;

public:

private:
	QMainWindow *detailWindow;
	QMenu *menu;
	QAction *aboutAct;
	QAction *donateAct;

	QMainWindow *styleWindow;
	QWidget *styleWidget;
	QHBoxLayout *layout;
	QVBoxLayout *v1layout;
	QVBoxLayout *v2layout;
	QSlider	*pollSlider;
	QLabel	*pollValueLabel;
	QPushButton *barColor;
	QPushButton *backColor;
	QPushButton *textColor;
	QPushButton *applyOnlyStyleButton;
	QMaemo5ValueButton *styleButton;
	QMaemo5ListPickSelector *styleSelector;
	QStandardItemModel *styleSelectionModel;
	QColorDialog *barColorDialog;
	QColorDialog *backColorDialog;
	QColorDialog *textColorDialog;
	QWindowsStyle *_windowsStyle;
	QMotifStyle *_motifStyle;
	QPlastiqueStyle *_plastiqueStyle;
	QMaemo5Style *_maemo5Style;
	QStyle *currentStyle;
	QString _currentStyleText;	

	QTimer	*_timer;
	int _pollingInterval;
	bool	_screenOff;
};

#endif
