/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the Graphics Dojo project on Trolltech Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
#include "widget.h"
#include <QMainWindow>
#include <QMenu>
#include <QMenuBar>
#include <QStyleOption>
#include <QPainter>
#include <QPaintEvent>
#include <QTextBrowser>
#include <QApplication>
//#include <QMaemo5KineticScroller>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QPushButton>
#include <QMaemo5ListPickSelector>
#include <QMaemo5ValueButton>
#include <QStandardItemModel>
#include <QColorDialog>
#include <QDesktopServices>
#include <QMessageBox>
#include <QUrl>
#include <QMaemo5InformationBox>
#include <QDebug>


#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <QtGui/QX11Info>
#include <QtCore/QByteArray>
#include <QtCore/QCoreApplication>

#include <QtGui/QMessageBox>

Widget::Widget(QWidget *parent) : QProgressBar (parent)
{
    QCoreApplication::instance()->setApplicationName("Hildon-Desktop battery level widget");

    // Get required atoms
    Atom winTypeAtom = XInternAtom(QX11Info::display(), "_NET_WM_WINDOW_TYPE", false);
    Atom homeAppletAto = XInternAtom(QX11Info::display(), "_HILDON_WM_WINDOW_TYPE_HOME_APPLET", false);
    Atom appletIDAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_ID", false);
    Atom utf8Atom = XInternAtom(QX11Info::display(), "UTF8_STRING", false); 
    Atom appletSettingAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_SETTINGS", false);
   
    // Set correct window type
    XChangeProperty(QX11Info::display(), winId(), winTypeAtom, XA_ATOM, 32,
		    PropModeReplace, (unsigned char *) &homeAppletAto, 1);

    // Use application name to fill AppletID
    QByteArray id (QCoreApplication::instance()->applicationName().remove(' ').toUtf8());
    XChangeProperty(QX11Info::display(), winId(), appletIDAtom, utf8Atom, 8, 
    	            PropModeReplace, (unsigned char *)id.constData(), id.length());

    // Add setting button. This button is shown when hildon-desktop is in edit mode. 
    int settings = 0;
    XChangeProperty(QX11Info::display(), winId(), appletSettingAtom, XA_CARDINAL, 32,
		    PropModeReplace, (unsigned char*)&settings, 1);
    
	// sytle and color widget objects
	styleWidget = new QWidget;
	v1layout = new QVBoxLayout;
	v2layout = new QVBoxLayout;
	layout = new QHBoxLayout;
	barColor = new QPushButton("BAR COLOR");
	backColor = new QPushButton("BACKGROUND COLOR");
	textColor = new QPushButton("TEXT COLOR");
	styleButton = new QMaemo5ValueButton("SELECT STYLE");
	applyOnlyStyleButton = new QPushButton("APPLY ONLY STYLE");
	styleSelector = new QMaemo5ListPickSelector;
	styleSelectionModel = new QStandardItemModel(0, 1);
	barColorDialog = new QColorDialog;
	backColorDialog = new QColorDialog;
	textColorDialog = new QColorDialog;
	_windowsStyle = new QWindowsStyle;
	_motifStyle = new QMotifStyle;
	_plastiqueStyle = new QPlastiqueStyle;
	_maemo5Style = new QMaemo5Style;

	// detailed info window objects
	_processPtr = new QProcess(this);
	battInfo = new QTextBrowser;
	//QMaemo5KineticScroller* ks = new QMaemo5KineticScroller(battInfo);
	battInfo->setAttribute(Qt::WA_DeleteOnClose);
	aboutAct = new QAction(tr("&ABOUT"), this);
	aboutAct->setShortcut(tr("Ctrl+A"));
	aboutAct->setStatusTip(tr("About"));
	connect(aboutAct, SIGNAL(triggered()), this , SLOT(showAbout()));

	detailWindow = new QMainWindow;
    donateAct = new QAction(tr("&DONATE"), this);
    donateAct->setShortcut(tr("Ctrl+D"));
    donateAct->setStatusTip(tr("Donate"));
    connect(donateAct, SIGNAL(triggered()), this , SLOT(showDonate()));

	menu = (detailWindow->menuBar())->addMenu(tr(""));
	menu->addAction(aboutAct);
    menu->addAction(donateAct);

	QStringList stylelist;
	stylelist << "motif" << "maemo5" << "windows" << "plastique";
	foreach(QString style, stylelist)
	{
		QStandardItem *item = new QStandardItem(style);
		item->setTextAlignment(Qt::AlignCenter); // the Maemo 5 design spec recommends this.
		item->setEditable(false); // prevent editing of the item
		styleSelectionModel->appendRow(item);
	}

	// connect's for the detail window
	connect(_processPtr, SIGNAL(finished(int , QProcess::ExitStatus)), this, SLOT(cmdFinished(int , QProcess::ExitStatus)) );

	// connects for the style window
	connect(barColor, SIGNAL(clicked()), barColorDialog, SLOT(show()));
	connect(backColor, SIGNAL(clicked()), backColorDialog, SLOT(show()));
	connect(textColor, SIGNAL(clicked()), textColorDialog, SLOT(show()));
	connect(applyOnlyStyleButton, SIGNAL(clicked()), this, SLOT(applyStyle()));
	connect(barColorDialog, SIGNAL(colorSelected(QColor)), this, SLOT(changeBarColor(QColor)));
	connect(backColorDialog, SIGNAL(colorSelected(QColor)), this, SLOT(changeBackColor(QColor)));
	connect(textColorDialog, SIGNAL(colorSelected(QColor)), this, SLOT(changeTextColor(QColor)));

	v1layout->addWidget(styleButton);
	v1layout->addWidget(applyOnlyStyleButton);
	v2layout->addWidget(barColor);
	v2layout->addWidget(backColor);
	v2layout->addWidget(textColor);
	layout->addLayout(v1layout);
	layout->addLayout(v2layout);

	styleWidget->setLayout(layout);

}

//Filter show setting requests
bool Widget::x11Event ( XEvent * event )
{
  static Atom appletShowSettingAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_SHOW_SETTINGS", false);


  if (event->xclient.message_type == appletShowSettingAtom ) 
  { 
	if ( _currentStyleText == "")
	{
		//qDebug() << "Style is empty so default to Motif";
		setCurrentStyle(QString("motif"));
		QMaemo5InformationBox::information(styleWidget, "<b>Motif</b> has been used as default style, you could change it", QMaemo5InformationBox::DefaultTimeout);
	}
	else
	{
		//qDebug() << "Style is " << _currentStyleText;
		setCurrentStyle(_currentStyleText);
		styleButton->setValueText(_currentStyleText);
	}

	//qDebug() << "Here in x11 event "  << currentStyle->objectName();

	styleSelector->setModel(styleSelectionModel);
	styleButton->setPickSelector(styleSelector);
	styleButton->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered);

	styleWidget->show();
	return true;
  }
  return false;
}

void Widget::mousePressEvent ( QMouseEvent * event )
{
	QString cmd("/home/user/run_lshal");

	_processPtr->start(cmd);
	_processPtr->waitForFinished();
}

void Widget::cmdFinished( int exitCode, QProcess::ExitStatus exitStatus )
{
	battInfo->clear();

	while (!_processPtr->atEnd())
	{
		QByteArray byteArray = _processPtr->readLine();
		QString line(byteArray);
		battInfo->append(line);
	}
	battInfo->setReadOnly(true);
	battInfo->moveCursor(QTextCursor::Start);

	detailWindow->setCentralWidget(battInfo);
	detailWindow->show();
}

void Widget::changeBarColor(QColor color)
{
	QPalette pal = palette();

	setCurrentStyle(styleButton->valueText());

	pal.setColor ( QPalette::Highlight, color );
	setPalette(pal);
}

void Widget::changeBackColor(QColor color)
{
	QPalette pal = palette();

	setCurrentStyle(styleButton->valueText());

	if ( styleButton->valueText() == "motif" || styleButton->valueText() == "windows")
		pal.setColor ( QPalette::Window, color );
	else if ( styleButton->valueText() == "plastique")
		pal.setColor ( QPalette::Base, color );
	setPalette(pal);
}

void Widget::changeTextColor(QColor color)
{
	QPalette pal = palette();

	setCurrentStyle(styleButton->valueText());

	if ( styleButton->valueText() == "motif" )
	{
		pal.setColor ( QPalette::HighlightedText, color );
		pal.setColor ( QPalette::Text, color );
	}
	else if ( styleButton->valueText() == "windows" )
		pal.setColor ( QPalette::WindowText, color );
	else if ( styleButton->valueText() == "plastique" )
		pal.setColor ( QPalette::Text, color );

	setPalette(pal);
}

void Widget::setCurrentStyle(QString styleText)
{
		//qDebug() << "setting current style to " << styleButton->valueText();
		
		if (styleText.toStdString() == "windows")
						currentStyle = _windowsStyle;
		else if (styleText.toStdString() == "motif")
						currentStyle = _motifStyle;
		else if (styleText.toStdString() == "plastique")
						currentStyle = _plastiqueStyle;
		else if (styleText.toStdString() == "maemo5")
						currentStyle = _maemo5Style;

		setStyle(currentStyle);
		_currentStyleText = styleText;

		if ( styleText == "maemo5" )
			QMaemo5InformationBox::information(styleWidget, "You have chosen <b>MAEMO5 style</b> everything now defaults to system colors", QMaemo5InformationBox::DefaultTimeout);
}

void Widget::applyStyle()
{
		if ( styleButton->valueText() != "" )
			setCurrentStyle(styleButton->valueText());
}

void Widget::showAbout()
{
		QMessageBox::about(detailWindow,"BATLEVEL-2.0 DESKTOP BATTERY WIDGET FOR MAEMO", "This is a desktop battery widget for the N900 that displays a bar and the percentage of battery left. The Styles and Colors can be customized, and detailed information about the battery is available on tapping the widget");
}

void Widget::showDonate()
{
	QDesktopServices::openUrl(QUrl("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=rkmaemo@gmx.com&lc=GB&item_name=Batlevel desktop widget Maemo&currency_code=GBP&bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted"));
}
