#
# foursquare.py
#
# Helper functions for accessing the foursquare API.
#

import oauthclient
import oauthlib
import socket
from xml.dom import minidom

SERVER='api.foursquare.com'
PORT=80

def authorize_token(key, secret, url, oauth_params):
        infoNoticeString = ""
        connectionResult = False
        response = None
        fsRequestToken = oauthlib.OAuthToken(key, secret)
        client = oauthclient.SimpleOAuthClient(SERVER, PORT, url, oauth_params['ACCESS_TOKEN_URL'], oauth_params['AUTHORIZATION_URL'])
        oauth_request = oauthlib.OAuthRequest.from_token_and_callback(token=fsRequestToken, http_url=client.authorization_url)
        try:
                response = client.authorize_token(oauth_request)
                connectionResult = True
        except socket.gaierror, e:
                connectionResult = False
                if e[0] == -3:
                        infoNoticeString = 'Error: unable to resolve api.foursquare.com hostname'
                else:
                        infoNoticeString = 'Error: unable to connect to api.foursquare.com'
        except socket.error, e:
                connectionResult = False
                if e[0] == -3:
                        infoNoticeString = 'Error: unable to resolve api.foursquare.com hostname'
                else:
                        infoNoticeString = 'Error: unable to connect to api.foursquare.com'

        return (connectionResult, infoNoticeString, fsRequestToken, response)


def fetch_request_token(url,params, oauth_params):
        authResult = None
        infoNoticeString = ""
        client = oauthclient.SimpleOAuthClient(SERVER, PORT, url, oauth_params['ACCESS_TOKEN_URL'], oauth_params['AUTHORIZATION_URL'])
        consumer = oauthlib.OAuthConsumer(oauth_params['CONSUMER_KEY'], oauth_params['CONSUMER_SECRET'])
        signature_method_plaintext = oauthlib.OAuthSignatureMethod_PLAINTEXT()
        oauth_request = oauthlib.OAuthRequest.from_consumer_and_token(consumer, callback=oauth_params['CALLBACK_URL'], http_url=url, parameters=params)
        oauth_request.sign_request(signature_method_plaintext, consumer, None)
        connectionResult = False
        try:
                authResult = client.fetch_request_token(oauth_request)
                connectionResult = True
        except socket.gaierror, e:
                connectionResult = False
                if e[0] == -3:
                        infoNoticeString = 'Error: unable to resolve api.foursquare.com hostname'
                else:
                        infoNoticeString = 'Error: unable to connect to api.foursquare.com'
        except socket.error, e:
                connectionResult = False
                if e[0] == -3:
                        infoNoticeString = 'Error: unable to resolve api.foursquare.com hostname'
                else:
                        infoNoticeString = 'Error: unable to connect to api.foursquare.com'

        return (connectionResult, infoNoticeString, authResult)


def api_request(url, parameters, oauth_params, method="GET"):
        resultsXml = ""
        infoNoticeString = ""
        client = oauthclient.SimpleOAuthClient(SERVER, PORT, url, oauth_params["ACCESS_TOKEN_URL"], oauth_params["AUTHORIZATION_URL"])
        consumer = oauthlib.OAuthConsumer(oauth_params["CONSUMER_KEY"], oauth_params["CONSUMER_SECRET"])
        signature_method_plaintext = oauthlib.OAuthSignatureMethod_PLAINTEXT()
        oauth_request = oauthlib.OAuthRequest.from_consumer_and_token(consumer, callback=oauth_params["CALLBACK_URL"], http_url=url, parameters=parameters)
        oauth_request.sign_request(signature_method_plaintext, consumer, oauth_params["fsRequestToken"])
        connectionResult = False
        try:
                resultsXml = client.access_resource(oauth_request, http_url=url, requestType=method)
                connectionResult = True
        except socket.gaierror, e:
                connectionResult = False
                if e[0] == -3:
                        infoNoticeString = 'Error: unable to resolve api.foursquare.com hostname'
                else:
                        infoNoticeString = 'Error: unable to connect to api.foursquare.com'
        except socket.error, e:
                connectionResult = False
                if e[0] == -3:
                        infoNoticeString = 'Error: unable to resolve api.foursquare.com hostname'
                else:
                        infoNoticeString = 'Error: unable to connect to api.foursquare.com'

        return (connectionResult, infoNoticeString, resultsXml)

def api_parse_xml_response(xml):
        parseSuccess = False
        valid = False
        infoNoticeString = ""
        parsedXml = None
        try:
                parsedXml = minidom.parseString(xml)
                parseSuccess = True
        except xml.parsers.expat.ExpatError:
                parseSuccess = False
                infoNoticeString = 'Error: api.foursquare.com problem parsing XML response'
                
        if xml.find("INTERNAL_SERVER_ERROR") >= 0:
                infoNoticeString = "Error: api.foursquare.com internal server error"
                parseSuccess = False

        if parseSuccess == True:
                errorNode = parsedXml.getElementsByTagName('error')
                if errorNode.length == 1:
                        infoNoticeString = errorNode[0].firstChild.data
                else:				
                        unAuthorizedNode = parsedXml.getElementsByTagName('unauthorized')
                        if unAuthorizedNode.length == 1 and unAuthorizedNode[0].firstChild.data == 'TOKEN_EXPIRED':
                                infoNoticeString = 'Error: foursquare.com token expired. Please sign back in'
                        else:
                                valid = True

        return (valid, infoNoticeString, parsedXml)

def api_request_and_parse(url, parameters, oauth_params, method="GET"):
        print "foursquare.api_request_and_parse(%s, %s, %s, %s)" % (url, str(parameters), str(oauth_params), method)
        (connectionResult, errstr, checkinsResultsXml) = api_request(url, parameters, oauth_params, method)
        if not connectionResult:
                return (False, errstr, None)
        return api_parse_xml_response(checkinsResultsXml)


