#!/usr/bin/env python2.5
#
# bootstrap.py - barriosquare application bootstrap for quicker init
# 
# barrioSquare v0.2.5
# Copyright(c) 2010 Chili Technologies LLC
# http://www.chilitechno.com/fster
#
# This file is part of barrioSquare.
#
# barrioSquare is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# barrioSquare is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with barrioSquare. If not, see <http://www.gnu.org/licenses/>.
# or write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# By using this software you agree to be bound by the terms of the foursquare.com service
# which are available at http://foursquare.com/legal/terms
# 
# This software makes extensive use of the foursquare.com api, but is not affiliated by, 
# or endorsed by foursquare and is a 3rd party application which makes use of the foursquare.com api.
#
# ============================================================================
# Name        : bootstrap.py
# Author      : Chris J. Burris - chris@chilitechno.com
# Version     : 0.2.5
# Description : barrioSquare
# ============================================================================

import sys
from PyQt4 import QtGui, QtCore

class InitDialog(QtGui.QDialog):
	def __init__(self, parent=None):
		QtGui.QDialog.__init__(self, parent)
		self.setWindowTitle('Initializing')
		self.resize(800,250)
		
		self.lblLogo = QtGui.QLabel('',self)
		self.lblLogo.setGeometry(104,1,591,100)
		self.pixmap = QtGui.QPixmap('/opt/barriosquare/barriosquareLogo.png')
		self.lblLogo.setPixmap(self.pixmap)
		
		self.lblStatus = QtGui.QLabel('',self)
		self.lblStatus.setGeometry(10,101,780,50);

		self.progressBar = QtGui.QProgressBar(self)
		self.progressBar.setGeometry(10,151,790,75)
		self.progressBar.setMinimum(0)
		self.progressBar.setMaximum(31)	
		
	def setText(self,statusText):
		self.lblStatus.setText(statusText)			
	
	def __del__(self):
		print 'InitDialog.__del__()'
		del self.lblLogo
		del self.pixmap

app = QtGui.QApplication(sys.argv)
appwindow = QtGui.QMainWindow()
appwindow.setWindowTitle("BarrioSquare")
initDialog = InitDialog(appwindow)
initDialog.show()
appwindow.show()

import __builtin__
__builtin__.initDialog = initDialog
__builtin__.appwindow = appwindow

import_string = "from barriosq import *"
exec import_string

sys.exit(app.exec_())

