from PyQt4 import QtGui, QtCore

class TwitterPinInputDialog(QtGui.QMainWindow):
	def __init__(self, parent=None):
		QtGui.QMainWindow.__init__(self, parent)
		self.setWindowTitle('Authorize with PIN')
		self.parent = parent
		p = self.palette()
		p.setColor(QtGui.QPalette.Window, QtGui.QColor(0, 0, 0))
		self.setPalette(p)
		self.resize(800,480)
		self.setWindowModality(QtCore.Qt.ApplicationModal)
		self.allowClose = True

		# add descriptive text
		self.lblText = QtGui.QLabel('Click the "Connect" button to launch a web browser to twitter.com to authorize this application.', self)
		self.lblText.setGeometry(5,5,790,160)
		self.lblText.setWordWrap(True)
		self.lblText.setAlignment(QtCore.Qt.AlignTop)
		
		self.txtPIN = QtGui.QLineEdit(self)
		# non-hildon: txtEmail.setGeometry(190, 10, 220, 50)
		self.txtPIN.setGeometry(5, 160, 460, 60)
		self.txtPIN.setFont(QtGui.QFont('Helvetica', 27))	
		self.txtPIN.hide()			
		
		self.bttnAuthorize = QtGui.QPushButton('Authorize',self)
		self.bttnAuthorize.setGeometry(480,175,140,55)
		self.bttnAuthorize.setStyleSheet(QPUSHBUTTON_THIN_BORDER)
		self.connect(self.bttnAuthorize, QtCore.SIGNAL('clicked()'),self.doAuthorizeClicked)
		self.bttnAuthorize.hide()

		self.bttnConnect = QtGui.QPushButton('Connect',self)
		self.bttnConnect.setGeometry(480,175,140,55)
		self.bttnConnect.setStyleSheet(QPUSHBUTTON_THIN_BORDER)
		self.connect(self.bttnConnect, QtCore.SIGNAL('clicked()'),self.doConnect)		
		

		self.bttnCancel = QtGui.QPushButton('Cancel',self)
		self.bttnCancel.setGeometry(635,175,140,55)
		self.bttnCancel.setStyleSheet(QPUSHBUTTON_THIN_BORDER)
		self.connect(self.bttnCancel, QtCore.SIGNAL('clicked()'),self.doCancelClicked)
		
	def doConnect(self):
		 twitter = oauthtwitter.OAuthApi(TWITTER_CONSUMER_KEY, TWITTER_CONSUMER_SECRET)
		 self.request_token = twitter.getRequestToken()
		 authorization_url = twitter.getAuthorizationURL(self.request_token)
		 print authorization_url
		 self.parent.osso_rpc.rpc_run_with_defaults("osso_browser", "open_new_window", (authorization_url,))
		 self.bttnConnect.hide()
		 self.bttnAuthorize.show()
		 self.txtPIN.show()
		 self.lblText.setText('Enter the numeric PIN from twitter.com below:')
		
	def doCancelClicked(self):
		self.allowClose = True
		self.close()
		
	def doAuthorizeClicked(self):
		global qb
		pin = str(self.txtPIN.text())
		twitter = oauthtwitter.OAuthApi(TWITTER_CONSUMER_KEY, TWITTER_CONSUMER_SECRET, self.request_token)
		access_token = twitter.getAccessToken(pin)		
		print access_token
		self.access_token = access_token	
		qb.saveSettingToDB('twitterOAuthToken',str(access_token))
		qb.displayInfoNotice('Connection with Twitter successfully completed')
		self.allowClose = True
		self.close()		
		
	def setCurrentValue(self,value):
		self.currentValue = value

	def closeEvent(self, event):
		# print 'closeEvent'
		if self.allowClose:
			event.accept()
		else:
			event.ignore()	
	
