#!/usr/bin/env python2.5
#
# barriosqdata.py - barrioSquare data access layer
# 
# barrioSquare v0.2.5
# Copyright(c) 2010 Chili Technologies LLC
# http://www.chilitechno.com/fster
#
# This file is part of barrioSquare.
#
# barrioSquare is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# barrioSquare is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with barrioSquare. If not, see <http://www.gnu.org/licenses/>.
# or write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# By using this software you agree to be bound by the terms of the foursquare.com service
# which are available at http://foursquare.com/legal/terms
# 
# This software makes extensive use of the foursquare.com api, but is not affiliated by, 
# or endorsed by foursquare and is a 3rd party application which makes use of the foursquare.com api.
#
# ============================================================================
# Name        : barriodata.py
# Author      : Chris J. Burris - chris@chilitechno.com
# Version     : 0.2.5
# Description : barrioSquare
# ============================================================================

import os
import shutil
import datetime
import string

from PyQt4 import QtCore, QtSql

class DataWorker(QtCore.QObject):
	def __init__(self, db):
		QtCore.QObject.__init__(self)
		self.db = db

	@QtCore.pyqtSlot('PyQt_PyObject')
	def selectQuerySlot(self, queryParams):
		columns = queryParams['Columns'].split(',')
		query = QtSql.QSqlQuery(self.db)
		if query.exec_(queryParams['SELECT']):
			while query.next():
				row = { '_UIListWidget': queryParams['UIListWidget'] }
				idx = 0
				for column in columns:
					row[column] = query.value(idx)
					idx = idx + 1
				self.emit(QtCore.SIGNAL('pushRowToUIListWidgetViaThread'),row)
			row = { '_UIListWidget': queryParams['UIListWidget'], 'Finished': True }				
			self.emit(QtCore.SIGNAL('pushRowToUIListWidgetViaThread'),row)
		del query


	@QtCore.pyqtSlot('PyQt_PyObject')
	def insertUpdateDeleteQuerySlot(self, queryParams):
		# print 'insertUpdateDeleteQuerySlot'
		# print queryParams
		self.db.transaction()
		query = QtSql.QSqlQuery(self.db)
		result = False
		if queryParams['Action'] == 'InsertOrUpdate':
			countExec = False
			if 'PrimaryKeyWhereClause' in queryParams:
				print "SELECT COUNT(%s) AS RowExists FROM %s WHERE %s" % (queryParams['PrimaryKeyColumn'],queryParams['TABLE'],queryParams['PrimaryKeyWhereClause']) 
				countExec = query.exec_("SELECT COUNT(%s) AS RowExists FROM %s WHERE %s" % (queryParams['PrimaryKeyColumn'],queryParams['TABLE'],queryParams['PrimaryKeyWhereClause']))
			elif queryParams['PrimaryKeyColumnType'] == 'VARCHAR':
				# print "SELECT COUNT(%s) AS RowExists FROM %s WHERE %s='%s'" % (queryParams['PrimaryKeyColumn'],queryParams['TABLE'],queryParams['PrimaryKeyColumn'],queryParams['PrimaryKey'])
				countExec = query.exec_("SELECT COUNT(%s) AS RowExists FROM %s WHERE %s='%s'" % (queryParams['PrimaryKeyColumn'],queryParams['TABLE'],queryParams['PrimaryKeyColumn'],queryParams['PrimaryKey']))
			else:
				countExec = query.exec_("SELECT COUNT(%s) AS RowExists FROM %s WHERE %s=%d" % (queryParams['PrimaryKeyColumn'],queryParams['TABLE'],queryParams['PrimaryKeyColumn'],queryParams['PrimaryKey']))
			# print 'countExec: %s' % countExec
			if countExec:
				if query.next():
					rowExists = int(query.value(0).toString())
					if 'BEFORE_INSERT_UPDATE' in queryParams:
						query.exec_(queryParams['BEFORE_INSERT_UPDATE'])					
					if rowExists == 0:
						if 'INSERT' in queryParams:
							# print queryParams['INSERT']
							result = query.exec_(queryParams['INSERT'])
							if result:
								# insert sequence binder
								# print queryParams['AFTER_INSERT_UPDATE']
								if 'AFTER_INSERT' in queryParams:
									strQuery = queryParams['AFTER_INSERT'].replace('$PrimaryKey$',str(queryParams['PrimaryKey']))
									# print strQuery
									query.exec_(strQuery)

					else:
						if 'UPDATE' in queryParams:
							# print queryParams['UPDATE']
							result = query.exec_(queryParams['UPDATE'])
						else:
							result = True	
		elif queryParams['Action'] == 'Update':		
			result = query.exec_(queryParams['UPDATE'])	
		elif queryParams['Action'] == 'Delete':		
			result = query.exec_(queryParams['DELETE'])
		elif queryParams['Action'] == 'Insert':		
			result = query.exec_(queryParams['INSERT'])			
		if result:
			# insert sequence binder
			# print queryParams['AFTER_INSERT_UPDATE']
			if 'AFTER_INSERT_UPDATE' in queryParams:
				strQuery = queryParams['AFTER_INSERT_UPDATE'].replace('$PrimaryKey$',str(queryParams['PrimaryKey']))
				# print strQuery
				query.exec_(strQuery)	
		else:
			print 'result was false: Action: %s' % queryParams['Action'] 
			if queryParams['Action'] == 'InsertOrUpdate':
				print 'query: %s' % queryParams['INSERT']	
				if 'UPDATE' in queryParams:
					print '-updateQuery: %s' % queryParams['UPDATE']			
			elif queryParams['Action'] == 'Update':		
				print 'query: %s' % queryParams['UPDATE']	
			elif queryParams['Action'] == 'Delete':		
				print 'query: %s' % queryParams['DELETE']
			elif queryParams['Action'] == 'Insert':		
				print 'query: %s' % queryParams['INSERT']
		if result:
			self.db.commit()
		else:
			self.db.rollback()

		del query
		# emit the signal
		if 'callingThreadName' in queryParams:
			self.emit(QtCore.SIGNAL('queryFinished'),queryParams['callingThreadName'])
		else:
			self.emit(QtCore.SIGNAL('queryFinished'),'')

	def getScalerValueSlot(self, queryStr):
		print 'getScalerValueSlot'

class DataWorkerThread(QtCore.QThread):
	def __init__(self, parent = None):
    		QtCore.QThread.__init__(self, parent)
		self.exiting = False

	def setup(self,dbFilePath,connectionName):
		self.dbFilePath = dbFilePath
		self.connectionName = connectionName

	def doSelectQuery(self,queryParams):
		self.emit(QtCore.SIGNAL('selectQuery(PyQt_PyObject)'),queryParams)

	def insertUpdateDeleteQuery(self,queryParams):
		# print 'insertUpdateDeleteQuery'
		self.emit(QtCore.SIGNAL('insertUpdateDeleteQuery(PyQt_PyObject)'),queryParams)

	def queryFinished(self,callingThreadName):
		# print 'DataWorkerThread.queryFinished(%s)' % callingThreadName
		# emit signal to parent
		self.emit(QtCore.SIGNAL('queryFinishedFromWorkerThread'),callingThreadName)

	def pushRowToUIListWidgetViaThread(self,row):
		self.emit(QtCore.SIGNAL('pushRowToUIListWidgetFromWorkerThread'),row)

	def run(self):
		self.db = QtSql.QSqlDatabase.addDatabase("QSQLITE",self.connectionName)
		self.db.setDatabaseName(self.dbFilePath)
		self.isDbOpen = self.db.open()

		# init the worker
		self.worker = DataWorker(self.db)
		# connect the signal to the slot
		
		self.worker.connect(self, QtCore.SIGNAL('insertUpdateDeleteQuery(PyQt_PyObject)'), QtCore.SLOT('insertUpdateDeleteQuerySlot(PyQt_PyObject)'), QtCore.Qt.QueuedConnection)
		self.worker.connect(self, QtCore.SIGNAL('selectQuery(PyQt_PyObject)'), QtCore.SLOT('selectQuerySlot(PyQt_PyObject)'), QtCore.Qt.QueuedConnection)
		self.connect(self.worker, QtCore.SIGNAL('queryFinished'), self.queryFinished)
		self.connect(self.worker, QtCore.SIGNAL('pushRowToUIListWidgetViaThread'), self.pushRowToUIListWidgetViaThread)

		# enter event loop
		self.exec_()

	def closeDb(self):
		if self.db.isOpen():
			self.db.close()
		del self.db

	def __del__(self):
		print 'DataWorkerThread.__del__'
		self.exiting = True		


class DataManager(QtCore.QObject):
	def __init__(self,sourceDbFile,dbFilePath):
		dbExists = os.path.exists(dbFilePath)
		if not dbExists:		
			# copy db file from app directory
			shutil.copy(sourceDbFile,dbFilePath)
			# print 'copied db file to user dir'

		self.db = QtSql.QSqlDatabase.addDatabase("QSQLITE","DataManager")
		self.db.setDatabaseName(dbFilePath)
		self.isDbOpen = self.db.open()

		# setup thread
		self.insertUpdateDeleteThread = DataWorkerThread()
		# add a callback to slot
		# self.connect(self.insertUpdateDeleteThread, QtCore.SIGNAL('queryFinishedFromWorkerThread'), self.queryFinishedFromWorkerThread)
		self.insertUpdateDeleteThread.setup(dbFilePath,"InsertUpdate")
		self.insertUpdateDeleteThread.start()

		# setup thread for selects
		self.selectQueryThread = DataWorkerThread()
		self.selectQueryThread.setup(dbFilePath,"Select")
		self.selectQueryThread.start()

	def doScalarQueryOnMainThread(self,queryString):
		returnValue = (False, None)
		if self.db.isOpen():			
			# print queryString
			query = QtSql.QSqlQuery(self.db)
			if query.exec_(queryString):
				if query.next():
					result = query.value(0)
					returnValue = (True, result)
			del query
		return returnValue
	
	def doQueryOnMainThread(self,queryString):
		result = False
		if self.db.isOpen():
			# print queryString
			query = QtSql.QSqlQuery(self.db)
			result = query.exec_(queryString)
			del query			
		return result	

	def doSelectQueryOnMainThread(self,queryString,columnList, connectionName = None, dbFilePath = None):
		result = { 'RecordCount': 0}
		result['Records'] = []
		columns = columnList.split(',')
		recordCount = 0
		if dbFilePath == None:
			if self.db.isOpen():
				# print queryString
				query = QtSql.QSqlQuery(self.db)
				if query.exec_(queryString):
					while query.next():
						idx = 0
						row = { }
						recordCount = recordCount + 1
						for column in columns:
							row[column] = query.value(idx)
							idx = idx + 1
						result['Records'].append(row)
				del query
			else:
				recordCount = -1
		else:
			print 'doSelectQueryOnMainThread: %s' % queryString
			tempdb = QtSql.QSqlDatabase.addDatabase("QSQLITE",connectionName)
			tempdb.setDatabaseName(dbFilePath)
			if tempdb.open():
				query = QtSql.QSqlQuery(tempdb)
				if query.exec_(queryString):
					while query.next():
						idx = 0
						row = { }
						recordCount = recordCount + 1
						for column in columns:
							row[column] = query.value(idx)
							idx = idx + 1
						result['Records'].append(row)
				del query		
				tempdb.close()
				del tempdb
			else:
				print 'doSelectQueryOnMainThread: db not open!'	
				recordCount = -1		
						
		result['RecordCount'] = recordCount		
		return result

	def getStatus(self):
		print 'database manager ok'

	def saveSetting(self,settingName,settingValue):
		queryParams = { }

		queryParams['Action'] = 'Update'
		queryParams['TABLE'] = 'Settings'
		queryParams['UPDATE'] = "UPDATE Settings SET settingValue='%s' WHERE settingName='%s'" % (self.safeStr(settingValue),settingName)

		self.insertUpdateDeleteThread.insertUpdateDeleteQuery(queryParams)	

	def safeStr(self,string):
		return string.replace("'","''")

	def queryFinishedFromWorkerThread(self,callingThreadName):
		print 'DataManager.queryFinishedFromWorkerThread(%s)' % callingThreadName
		# emit signal to main 

	def test(self,venueID):
		self.addEditVenueItem(1,venueID,'test','123 test','5th and 6th','new york', 'ny','10029','1233333',1,1,40.555323,-70.2020283,0,'Main Thread')

	def shutdown(self):
		print 'received shutdown'
		# shut down the worker thread event loop
		self.insertUpdateDeleteThread.quit()
		self.insertUpdateDeleteThread.closeDb()
		if self.insertUpdateDeleteThread.wait():
			del self.insertUpdateDeleteThread		
			self.insertUpdateDeleteThread = None
	
		self.selectQueryThread.quit()
		self.selectQueryThread.closeDb()
		if self.selectQueryThread.wait():
			del self.selectQueryThread
			self.selectQueryThread = None
		
		if self.db.isOpen():
			print 'closing db'
			self.db.close()
			del self.db

	def doInsertQueryInBackgroundThread(self,queryString):
		queryParams = { }
		queryParams['Action'] = 'Insert'
		queryParams['INSERT'] = queryString
		if self.insertUpdateDeleteThread != None:
			self.insertUpdateDeleteThread.insertUpdateDeleteQuery(queryParams)

	def doDeleteQueryInBackgroundThread(self,queryString):
		print queryString
		queryParams = { }
		queryParams['Action'] = 'Delete'
		queryParams['DELETE'] = queryString
		if self.insertUpdateDeleteThread != None:
			self.insertUpdateDeleteThread.insertUpdateDeleteQuery(queryParams)

	def doSelectQueryInBackgroundThread(self,queryString,listWidget,columnList):
		print queryString
		queryParams = { }
		queryParams['UIListWidget'] = listWidget
		queryParams['Columns'] = columnList
		queryParams['SELECT'] = queryString
		if self.selectQueryThread != None:
			self.selectQueryThread.doSelectQuery(queryParams)
			
	def addEditCategory(self,catID,catNodeName,fullPathName,catIconUrl,iconFilePath):
		queryParams = { }

		queryParams['Action'] = 'InsertOrUpdate'
		queryParams['TABLE'] = 'Categories'
		queryParams['PrimaryKeyColumn'] = 'id'
		queryParams['PrimaryKey'] = catID
		queryParams['PrimaryKeyColumnType'] = 'VARCHAR'
		queryParams['INSERT'] = "INSERT INTO Categories(id, iconurl, iconFilePath, category, fullpathname) VALUES('%s', '%s', '%s', '%s', '%s')" % (self.safeStr(catID),self.safeStr(catIconUrl),self.safeStr(iconFilePath),self.safeStr(catNodeName),self.safeStr(fullPathName))
		# queryParams['UPDATE'] = "UPDATE UserCheckinHistory SET userID='%s', calculatedDistance=%s, distanceCalcDate='%s', CustomVenue='%s', displayString='%s' WHERE id='%s'" % (self.safeStr(userID),calcDistance,strNow,self.safeStr(customVenueName),self.safeStr(displayString),self.safeStr(checkinID))
		if self.insertUpdateDeleteThread != None:
			self.insertUpdateDeleteThread.insertUpdateDeleteQuery(queryParams)
			
	def addVenueCategory(self,catID,venueID,isPrimary):
		if isPrimary:
			isPrimaryInt = 1
		else:
			isPrimaryInt = 0
		queryParams = { }
		queryParams['Action'] = 'InsertOrUpdate'
		queryParams['TABLE'] = 'VenueCategories'
		queryParams['PrimaryKeyWhereClause'] = "categoryID='%s' and venueID='%s'" % (self.safeStr(catID), self.safeStr(venueID))
		queryParams['PrimaryKeyColumn'] = 'categoryID'
		queryParams['INSERT'] = "INSERT INTO VenueCategories(categoryID, venueID, isPrimary) VALUES('%s', '%s', %d)" % (self.safeStr(catID),self.safeStr(venueID),isPrimaryInt)
		if self.insertUpdateDeleteThread != None:
			self.insertUpdateDeleteThread.insertUpdateDeleteQuery(queryParams)							
			
	def setVenueMayorship(self,venueID,userID):
		queryParams = { }

		queryParams['Action'] = 'InsertOrUpdate'
		queryParams['TABLE'] = 'VenueMayors'
		queryParams['PrimaryKeyColumn'] = 'venueID'
		queryParams['PrimaryKey'] = venueID
		queryParams['PrimaryKeyColumnType'] = 'VARCHAR'
		queryParams['INSERT'] = "INSERT INTO VenueMayors(userID, venueID) VALUES('%s', '%s')" % (self.safeStr(userID),self.safeStr(venueID))
		queryParams['UPDATE'] = "UPDATE VenueMayors SET userID='%s' WHERE venueID='%s'" % (self.safeStr(userID),self.safeStr(venueID))
		if self.insertUpdateDeleteThread != None:
			self.insertUpdateDeleteThread.insertUpdateDeleteQuery(queryParams)
			
	def ignorePendingFriends(self):	
		queryParams = { }
								
		queryParams['Action'] = 'Update'
		queryParams['UPDATE'] = "UPDATE UserFriendStatus SET status=3 WHERE status=2"
		if self.insertUpdateDeleteThread != None:
			self.insertUpdateDeleteThread.insertUpdateDeleteQuery(queryParams)			
						
	def addUserFriendStatus(self,userID,status):
		queryParams = { }

		queryParams['Action'] = 'InsertOrUpdate'
		queryParams['TABLE'] = 'UserFriendStatus'
		queryParams['PrimaryKeyColumn'] = 'userID'
		queryParams['PrimaryKey'] = userID
		queryParams['PrimaryKeyColumnType'] = 'VARCHAR'
		queryParams['INSERT'] = "INSERT INTO UserFriendStatus(userID, status) VALUES('%s', %d)" % (self.safeStr(userID),status)
		# queryParams['UPDATE'] = "UPDATE UserCheckinHistory SET userID='%s', calculatedDistance=%s, distanceCalcDate='%s', CustomVenue='%s', displayString='%s' WHERE id='%s'" % (self.safeStr(userID),calcDistance,strNow,self.safeStr(customVenueName),self.safeStr(displayString),self.safeStr(checkinID))
		if self.insertUpdateDeleteThread != None:
			self.insertUpdateDeleteThread.insertUpdateDeleteQuery(queryParams)							

	def addCheckinHistoryItem(self,checkinID,venueID,userID,calcDistance,shout,createdDateStr,customVenueName,displayString,callingThreadName):
		# build the query
		strNow = datetime.datetime.utcnow()
		# convert the created date to database friendly
		createdDate = str(datetime.datetime.strptime(createdDateStr,'%a, %d %b %y %H:%M:%S +0000'))

		queryParams = { }

		if callingThreadName != None:
			queryParams['callingThreadName'] = callingThreadName
		queryParams['Action'] = 'InsertOrUpdate'
		queryParams['TABLE'] = 'UserCheckinHistory'
		queryParams['PrimaryKeyColumn'] = 'id'
		queryParams['PrimaryKey'] = checkinID
		queryParams['PrimaryKeyColumnType'] = 'VARCHAR'
		queryParams['INSERT'] = "INSERT INTO UserCheckinHistory(id, userID, venueID, createdDate, calculatedDistance, distanceCalcDate, shout, CustomVenue, displayString) VALUES('%s', '%s', '%s', '%s', %s, '%s', '%s', '%s', '%s')" % (self.safeStr(checkinID),self.safeStr(userID),self.safeStr(venueID),self.safeStr(createdDate),calcDistance,strNow,self.safeStr(shout),self.safeStr(customVenueName),self.safeStr(displayString))
		# queryParams['UPDATE'] = "UPDATE UserCheckinHistory SET userID='%s', calculatedDistance=%s, distanceCalcDate='%s', CustomVenue='%s', displayString='%s' WHERE id='%s'" % (self.safeStr(userID),calcDistance,strNow,self.safeStr(customVenueName),self.safeStr(displayString),self.safeStr(checkinID))
		if self.insertUpdateDeleteThread != None:
			self.insertUpdateDeleteThread.insertUpdateDeleteQuery(queryParams)		

	def updateVenueDistance(self,venueID,distance):
		queryParams = { }
		queryParams['Action'] = 'Update'
		queryParams['TABLE'] = 'Venues'
		queryParams['PrimaryKeyColumn'] = 'id'
		queryParams['PrimaryKey'] = venueID
		queryParams['PrimaryKeyColumnType'] = 'VARCHAR'
		queryParams['UPDATE'] = "UPDATE Venues SET distance=%d WHERE id='%s'" % (distance,venueID)
		if self.insertUpdateDeleteThread != None:
			self.insertUpdateDeleteThread.insertUpdateDeleteQuery(queryParams)	

	def updateVenueIsTrendingFavorite(self,venueID,isTrending,isFavorite):
		queryParams = { }
		queryParams['Action'] = 'Update'
		queryParams['TABLE'] = 'Venues'
		queryParams['PrimaryKeyColumn'] = 'id'
		queryParams['PrimaryKey'] = venueID
		queryParams['PrimaryKeyColumnType'] = 'VARCHAR'
		queryParams['UPDATE'] = "UPDATE Venues SET isTrending=%d, isFavorite=%d WHERE id='%s'" % (isTrending,isFavorite,venueID)
		if self.insertUpdateDeleteThread != None:
			self.insertUpdateDeleteThread.insertUpdateDeleteQuery(queryParams)

	def addEditBadge(self,badgeID,name,description,badgeURL,badgeFile,userID,callingThreadName):
		queryParams = { }

		if callingThreadName != None:
			queryParams['callingThreadName'] = callingThreadName
		queryParams['Action'] = 'InsertOrUpdate'
		queryParams['TABLE'] = 'Badges'
		queryParams['PrimaryKeyColumn'] = 'id'
		queryParams['PrimaryKey'] = badgeID
		queryParams['PrimaryKeyColumnType'] = 'VARCHAR'
		queryParams['BEFORE_INSERT_UPDATE'] = "DELETE FROM UserBadges WHERE userID='%s' AND badgeID='%s'" % (self.safeStr(userID),self.safeStr(badgeID))		
		queryParams['INSERT'] = "INSERT INTO Badges(id, badgeURL, badgeFile, name, description) VALUES('%s', '%s', '%s', '%s', '%s')" % (badgeID,self.safeStr(badgeURL),self.safeStr(badgeFile),self.safeStr(name),self.safeStr(description))
		queryParams['UPDATE'] = "UPDATE Badges SET badgeURL='%s', badgeFile='%s', name='%s', description='%s' WHERE id='%s'" % (self.safeStr(badgeURL),self.safeStr(badgeFile),self.safeStr(name),self.safeStr(description),badgeID)
		queryParams['AFTER_INSERT_UPDATE'] = "INSERT INTO UserBadges(userID,badgeID) VALUES('%s', '%s')" % (self.safeStr(userID),self.safeStr(badgeID))
		if self.insertUpdateDeleteThread != None:
			self.insertUpdateDeleteThread.insertUpdateDeleteQuery(queryParams)	

	def addEditUserLastCheckin(self,userID,createdDate,checkinID):
		queryParams = { }

		queryParams['Action'] = 'InsertOrUpdate'
		queryParams['TABLE'] = 'UserLastCheckinDate'
		queryParams['PrimaryKeyColumn'] = 'userID'
		queryParams['PrimaryKey'] = userID
		queryParams['PrimaryKeyColumnType'] = 'VARCHAR'
		queryParams['INSERT'] = "INSERT INTO UserLastCheckinDate(userID, createdDate, checkinID) VALUES('%s', '%s', '%s')" % (self.safeStr(userID),self.safeStr(createdDate),self.safeStr(checkinID))
		queryParams['UPDATE'] = "UPDATE UserLastCheckinDate SET createdDate='%s', checkinID='%s' WHERE userID='%s'" % (self.safeStr(createdDate),self.safeStr(checkinID),self.safeStr(userID))
		if self.insertUpdateDeleteThread != None:
			self.insertUpdateDeleteThread.insertUpdateDeleteQuery(queryParams)	

	def addVenueRecentCheckin(self,checkinID,userID,venueID,shout,createdDate):
		queryParams = { }

		queryParams['Action'] = 'InsertOrUpdate'
		queryParams['TABLE'] = 'VenueRecentCheckins'
		queryParams['PrimaryKeyColumn'] = 'id'
		queryParams['PrimaryKey'] = checkinID
		queryParams['PrimaryKeyColumnType'] = 'VARCHAR'
		queryParams['INSERT'] = "INSERT INTO VenueRecentCheckins(id, userID, venueID,shout,createdDate) VALUES('%s', '%s', '%s', '%s', '%s')" % (self.safeStr(checkinID),self.safeStr(userID),self.safeStr(venueID),self.safeStr(shout),self.safeStr(createdDate))
		if self.insertUpdateDeleteThread != None:
			self.insertUpdateDeleteThread.insertUpdateDeleteQuery(queryParams)	


	def addEditVenueTip(self,tipID,distance,venueID,userID,tipOrToDo,tipText,createdDate,url,sequenceID,callingThreadName):	
		queryParams = { }

		if callingThreadName != None:
			queryParams['callingThreadName'] = callingThreadName
		queryParams['Action'] = 'InsertOrUpdate'
		queryParams['TABLE'] = 'VenueTips'
		queryParams['PrimaryKeyColumn'] = 'id'
		queryParams['PrimaryKey'] = tipID
		queryParams['PrimaryKeyColumnType'] = 'VARCHAR'
		queryParams['INSERT'] = "INSERT INTO VenueTips(id, distance, venueID, tipOrToDo,tipText,userID,createdDate,url) VALUES('%s', %d, '%s', %d, '%s', '%s', '%s', '%s')" % (self.safeStr(tipID),distance,self.safeStr(venueID),tipOrToDo,self.safeStr(tipText),self.safeStr(userID),self.safeStr(createdDate),self.safeStr(url))
		if sequenceID > 0:
			queryParams['AFTER_INSERT_UPDATE'] = "INSERT INTO TipSequences(seq, tipID) VALUES(%d, '$PrimaryKey$')" % sequenceID
		
		if self.insertUpdateDeleteThread != None:
			self.insertUpdateDeleteThread.insertUpdateDeleteQuery(queryParams)	


	def addEditUserVenueStats(self,userID,venueID,mayorCheckinCount):	
		queryParams = { }

		queryParams['Action'] = 'InsertOrUpdate'
		queryParams['TABLE'] = 'UserVenueStats'
		queryParams['PrimaryKeyWhereClause'] = "userID='%s' and venueID='%s'" % (userID, venueID)
		queryParams['PrimaryKeyColumn'] = 'userID'
		queryParams['INSERT'] = "INSERT INTO UserVenueStats(userID, venueID, mayorCheckinCount) VALUES('%s', '%s', %s)" % (self.safeStr(userID),self.safeStr(venueID),mayorCheckinCount)
		queryParams['UPDATE'] = "UPDATE UserVenueStats SET mayorCheckinCount=%d WHERE userID='%s' AND venueID='%s'" % (mayorCheckinCount,self.safeStr(userID),self.safeStr(venueID))
		if self.insertUpdateDeleteThread != None:
			self.insertUpdateDeleteThread.insertUpdateDeleteQuery(queryParams)		

	
	def addEditUserDetails(self,userID,phone,twitter,facebook,email,gender):
		print 'DataManager.addEditUserDetails()'
		queryParams = { }

		queryParams['Action'] = 'InsertOrUpdate'
		queryParams['TABLE'] = 'UserDetails'
		queryParams['PrimaryKeyColumn'] = 'userID'
		queryParams['PrimaryKey'] = userID
		queryParams['PrimaryKeyColumnType'] = 'VARCHAR'
		queryParams['INSERT'] = "INSERT INTO UserDetails(userID, phone, twitter, facebook,  email, gender) VALUES('%s', '%s', '%s', '%s', '%s', '%s')" % (self.safeStr(userID),self.safeStr(phone),self.safeStr(twitter),self.safeStr(facebook),self.safeStr(email),gender)
		queryParams['UPDATE'] = "UPDATE UserDetails SET phone='%s', twitter='%s', facebook='%s', email='%s', gender='%s' WHERE userID='%s'" % (self.safeStr(phone),self.safeStr(twitter),self.safeStr(facebook),self.safeStr(email),gender,self.safeStr(userID))
		if self.insertUpdateDeleteThread != None:
			self.insertUpdateDeleteThread.insertUpdateDeleteQuery(queryParams)		


	def addEditUser(self,userID,firstName,lastName,photoFile,photoURL,callingThreadName):
		queryParams = { }

		if callingThreadName != None:
			queryParams['callingThreadName'] = callingThreadName
		queryParams['Action'] = 'InsertOrUpdate'
		queryParams['TABLE'] = 'Users'
		queryParams['PrimaryKeyColumn'] = 'id'
		queryParams['PrimaryKey'] = userID
		queryParams['PrimaryKeyColumnType'] = 'VARCHAR'
		queryParams['INSERT'] = "INSERT INTO Users(id, firstName, lastName, photoFile, photoURL) VALUES('%s', '%s', '%s', '%s', '%s')" % (self.safeStr(userID),self.safeStr(firstName),self.safeStr(lastName),self.safeStr(photoFile),self.safeStr(photoURL))
		queryParams['UPDATE'] = "UPDATE Users SET firstName='%s', lastName='%s', photoFile='%s', photoURL='%s' WHERE id='%s'" % (self.safeStr(firstName),self.safeStr(lastName),self.safeStr(photoFile),self.safeStr(photoURL),self.safeStr(userID))
		if self.insertUpdateDeleteThread != None:
			self.insertUpdateDeleteThread.insertUpdateDeleteQuery(queryParams)		

	def addEditVenueItem(self,sequenceID,venueID,name,address,crossstreet,city,state,zipCode,phone,geolat,geolong,callingThreadName):
		# build the query
		strNow = datetime.datetime.utcnow()

		queryParams = { }

		if callingThreadName != None:
			queryParams['callingThreadName'] = callingThreadName
		queryParams['Action'] = 'InsertOrUpdate'
		queryParams['TABLE'] = 'Venues'
		queryParams['PrimaryKeyColumn'] = 'id'
		queryParams['PrimaryKey'] = venueID
		queryParams['PrimaryKeyColumnType'] = 'VARCHAR'
		queryParams['INSERT'] = "INSERT INTO Venues(id, name, geolat, geolong, address, crossstreet, city, state, zipcode, phone, addedDate, updatedDate) VALUES('%s', '%s', %s, %s, '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s')" % (venueID,self.safeStr(name),geolat,geolong,self.safeStr(address),self.safeStr(crossstreet),self.safeStr(city),self.safeStr(state),self.safeStr(zipCode),self.safeStr(phone),strNow,strNow)
		queryParams['UPDATE'] = "UPDATE Venues SET name='%s', geolat=%s, geolong=%s, address='%s', crossstreet='%s', city='%s', state='%s', zipcode='%s', phone='%s', updatedDate='%s' WHERE id='%s'" % (self.safeStr(name),geolat,geolong,self.safeStr(address),self.safeStr(crossstreet),self.safeStr(city),self.safeStr(state),self.safeStr(zipCode),self.safeStr(phone),strNow,venueID)
		if sequenceID > 0:
			queryParams['AFTER_INSERT_UPDATE'] = "INSERT INTO VenueSequences(seq, venueID) VALUES(%d, '$PrimaryKey$')" % sequenceID
		if self.insertUpdateDeleteThread != None:
			self.insertUpdateDeleteThread.insertUpdateDeleteQuery(queryParams)
				
	def getNextSequenceID(self):
		if self.db.isOpen():
			sequenceValue = -1
			print 'db Open'
			query = QtSql.QSqlQuery(self.db)
			if query.exec_("INSERT INTO Sequences(Filler,SequenceID) VALUES(1,NULL);"):
				sequenceValue = query.lastInsertId().toInt()[0]
			else:
				print 'getNextSequenceID() db exec error'
			del query
			return sequenceValue
		else:
			print 'getNextSequenceID() bailing db not open'
			return -1
		

	def getSettings(self):
		if self.db.isOpen():
			settings = {}
			print 'db Open'
			query = QtSql.QSqlQuery(self.db)
			if query.exec_("SELECT settingName, settingValue FROM Settings"):
				while query.next():
					settingName = str(query.value(0).toString())
					settingValue = unicode(query.value(1).toString())
					settings[settingName] = settingValue
			del query
			return settings
		else:
			return None

