#!/usr/bin/env python2.5
#
# barriosq.py - main barrioSquare program file
# 
# barrioSquare v0.2.3
# Copyright(c) 2010 Chili Technologies LLC
# http://www.chilitechno.com/fster
#
# This file is part of barrioSquare.
#
# barrioSquare is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# barrioSquare is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with barrioSquare. If not, see <http://www.gnu.org/licenses/>.
# or write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# By using this software you agree to be bound by the terms of the foursquare.com service
# which are available at http://foursquare.com/legal/terms
# 
# This software makes extensive use of the foursquare.com api, but is not affiliated by, 
# or endorsed by foursquare and is a 3rd party application which makes use of the foursquare.com api.
#
# ============================================================================
# Name        : barriosq.py
# Author      : Chris J. Burris - chris@chilitechno.com
# Version     : 0.2.3
# Description : barrioSquare
# ============================================================================

import sys
import math

from PyQt4 import QtGui, QtCore, QtWebKit, QtNetwork, QtSql
from barrioConfig import *
from barrioStyles import *
from barriodata import *
import oauthclient
import oauth
import time
import os
import cgi
import xml
import osso
import socket
import shutil

from xml.dom.minidom import parseString, parse
# location libs
# import location
# import gobject

# thread and process libs
import thread
import subprocess

# web libraries
import webbrowser
import urllib2

# global script vars
settingsCollection = None
venueCacheDiffAge = 10
dataManager = None
disableSlickUI = True
maxLocationAquisitionCount = -1
debugErrorLogging = False
showStartupLocationSetting = False
locationAcceptClientConnections = True
locationSubprocessClientConnected = False
locationSubprocessRestartCount = 0
locationSubprocessIsRestarting = False
friendRefreshCount = 0
getLocationChildPID = 0
acquisitionCount = 0
badgeCount = 0
currentLatitude = 0
currentLongitude = 0
horizontalAccuracy = 1000
verticalAccuracy = 1000
locationMethodType = 0
fsRequestToken = None
fsRequestTokenString = ''
fsSecret = ''
fsKey = ''
userPreferencesDir = os.path.expanduser('~') + os.sep + '.barriosquare' + os.sep
hasToken = 0
locationFixAcquired = 0
qb = None
searchKeywords = ''
shoutString = ''
infoNoticeString = ''
checkinVenueID = 0
pingFriends = False
pingTwitter = False
allowIncomingPings = True
pingFacebook = False
# set FakeCheckin to True to simulate a check-in (must have really checked into a venue at least once before)
FakeCheckin = False
FakeAddVenue = False
loggedInUserID = '0'
showSplashScreen = False
doingSignout = False
locationManagerObj = None
automaticDataRefresh = True
manualLocationRefresh = False
lowBandwidthMode = False

processUserID = os.geteuid()

# print userPreferencesDir
if (not os.path.exists(userPreferencesDir)):
	# print 'Creating Pref Dir'
	os.mkdir(userPreferencesDir)
	os.mkdir(userPreferencesDir + 'venueCache' + os.sep)
	os.mkdir(userPreferencesDir + 'imageCache' + os.sep)
	os.mkdir(userPreferencesDir + 'imageCache' + os.sep + 'users' + os.sep)
	os.mkdir(userPreferencesDir + 'imageCache' + os.sep + 'icon' + os.sep)
	os.mkdir(userPreferencesDir + 'imageCache' + os.sep + 'badges' + os.sep)
	os.mkdir(userPreferencesDir + 'imageCache' + os.sep + 'icon' + os.sep + 'venue' + os.sep)
	showSplashScreen = True
	time.sleep(1)

# redirect error and std out to files for crash reporting
if debugErrorLogging and processUserID > 0:
	fsock = open(os.path.expanduser('~') + os.sep + '.barriosquare' + os.sep + 'stderr.log', 'a')
	sys.stderr = fsock

class SplashScreenDialog(QtGui.QDialog):
	def __init__(self, parent=None):
		QtGui.QDialog.__init__(self, parent)
		self.setWindowTitle(VERSION_STRING)
		self.resize(800,300)

		self.lblDesc = QtGui.QLabel(VERSION_STRING + ': Welcome! By using this application which makes extensive use of the foursquare.com API you agree to be bound by terms at http://foursquare.com/legal/terms. This application is a 3rd party application not affiliated with or endorsed by foursquare.com. This application is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.',self)
		self.lblDesc.setGeometry(5,5,700,300)
		self.lblDesc.setWordWrap(True)
		self.lblDesc.setAlignment(QtCore.Qt.AlignTop)

		self.bttnOk = QtGui.QPushButton('OK',self)
		self.bttnOk.setGeometry(620,205,175,80)
		self.bttnOk.setStyleSheet(QPUSHBUTTON_DEFAULT)

		self.connect(self.bttnOk, QtCore.SIGNAL('clicked()'),
			self.doOkClicked)
	
	def doOkClicked(self):
		self.close()
			
class ProcessingDialog(QtGui.QDialog):
	def __init__(self, parent=None):
		QtGui.QDialog.__init__(self, parent)
		self.setWindowTitle('Processing')
		p = self.palette()
		p.setColor(QtGui.QPalette.Window, QtGui.QColor(0, 0, 0))
		self.setPalette(p)
		self.resize(800,200)
		self.setWindowModality(QtCore.Qt.ApplicationModal)
		self.allowClose = True

		self.currentValue = 0

		self.lblLoadingIcon = QtGui.QLabel('',self)
		self.loadingGif = QtGui.QMovie(APP_DIRECTORY + 'loading2.gif', QtCore.QByteArray(), self)
		self.loadingGif.setCacheMode(QtGui.QMovie.CacheAll)
		self.loadingGif.setSpeed(100)
		self.loadingGif.setBackgroundColor(QtGui.QColor(0, 0, 0))
		self.lblLoadingIcon.setGeometry(10,10,50,50)
		self.lblLoadingIcon.setMovie(self.loadingGif)			

		# add descriptive text
		self.lblText = QtGui.QLabel('', self)
		self.lblText.setGeometry(65,5,600,100)
		self.lblText.setWordWrap(True)
		self.lblText.setAlignment(QtCore.Qt.AlignTop)

		# add a progress bar
		self.progressBar = QtGui.QProgressBar(self)
		self.progressBar.setGeometry(10,105,600,75)
		self.progressBar.setMinimum(0)
		self.progressBar.setMaximum(0)
		
		self.bttnCancel = QtGui.QPushButton('Cancel',self)
		self.bttnCancel.setGeometry(635,115,140,55)
		self.bttnCancel.setStyleSheet(QPUSHBUTTON_THIN_BORDER)
		self.connect(self.bttnCancel, QtCore.SIGNAL('clicked()'),self.doCancelClicked)


		# self.lblError = QtGui.QLabel('Error: Unable to contact api.foursquare.com. Please check your Internet connection and try again.',self)
		# self.lblError.setGeometry(5,5,600,190)
		# self.lblError.setWordWrap(True)
		# self.lblError.setAlignment(QtCore.Qt.AlignTop)
		# self.lblError.hide()

		# self.bttnOk = QtGui.QPushButton('OK',self)
		# self.bttnOk.setGeometry(620,5,175,80)
		# self.bttnOk.setStyleSheet(QPUSHBUTTON_DEFAULT)
		# self.bttnOk.hide()

		self.lblPoweredby = QtGui.QLabel('',self)
		self.lblPoweredby.setGeometry(5,164,225,36)
		poweredbyPixmap = QtGui.QPixmap(APP_DIRECTORY + 'powerbyfoursquare2.png')
		poweredbyPixmap2 = poweredbyPixmap.scaled(QtCore.QSize(225,36), QtCore.Qt.IgnoreAspectRatio, QtCore.Qt.SmoothTransformation)		
		self.lblPoweredby.setPixmap(poweredbyPixmap2)
		
	def doCancelClicked(self):
		self.stopAnimation()
		self.close()
		
	def setTitleAndLabelText(self, title, txt):
		self.lblText.setText(txt)
		self.setWindowTitle(title)

	def startAnimation(self):
		self.allowClose = False
		self.loadingGif.start()
		self.progressBar.setMinimum(0)
		self.progressBar.setMaximum(0)		

	def stopAnimation(self):
		self.allowClose = True
		self.loadingGif.stop()

	def setCurrentValue(self,value):
		self.currentValue = value

	def closeEvent(self, event):
		# print 'closeEvent'
		if self.allowClose:
			event.accept()
		else:
			event.ignore()
		
class NearbyWorkerThread(QtCore.QThread):
	def __init__(self, parent = None):
    		QtCore.QThread.__init__(self, parent)
		self.exiting = False

	def setup(self,seqID):
		self.sequenceID = seqID

	def run(self):
		global qb
		# print 'NearbyWorkerThread.run() Executing thread logic'
		client3 = oauthclient.SimpleOAuthClient('api.foursquare.com', 80, API_PREFIX_URL+'venues', ACCESS_TOKEN_URL, AUTHORIZATION_URL)
		consumer = oauth.OAuthConsumer(CONSUMER_KEY, CONSUMER_SECRET)
		signature_method_plaintext = oauth.OAuthSignatureMethod_PLAINTEXT()
		signature_method_hmac_sha1 = oauth.OAuthSignatureMethod_HMAC_SHA1()
	
		global currentLatitude
		global currentLongitude

		nearbyParams = {
			'l'	:	20,
			'geolat':	currentLatitude,
			'geolong':	currentLongitude,
			'oauth_token':	fsKey,
			'oauth_token_secret':	fsSecret
		}
		oauth_request = oauth.OAuthRequest.from_consumer_and_token(consumer, callback=CALLBACK_URL, http_url=API_PREFIX_URL+'venues', parameters=nearbyParams)
		oauth_request.sign_request(signature_method_plaintext, consumer, fsRequestToken)
		# print oauth_request.to_postdata()
		nearbyResultXml = client3.access_resource(oauth_request, http_url=API_PREFIX_URL+'venues', requestType='GET')
		print nearbyResultXml		
		# save venue data to cache file
		nearbyCacheFile = open(userPreferencesDir + 'nearbyCache.xml','w')
		nearbyCacheFile.write(nearbyResultXml)
		nearbyCacheFile.close()	

		parseSucces = False
		nearbyXml = None
		try:
			nearbyXml = parseString(nearbyResultXml)
			parseSucces = True
		except xml.parsers.expat.ExpatError:
			parseSucces = False

		if parseSucces:
			groupNodes = nearbyXml.getElementsByTagName('group')
			venueNodeCount = nearbyXml.getElementsByTagName('venue').length
			# set the progress bar max is double the venueCount to account for db + display
			self.emit(QtCore.SIGNAL('setProcessingDialogProgressBarMaxValue'),venueNodeCount)	
			params = ('NearbyWorkerThread',venueNodeCount,0)
			self.emit(QtCore.SIGNAL('setDatabaseExpectedResultCount'),params)
			for groupNode in groupNodes:
				# see if group type is favourites
				isFavorite = 0
				isTrending = 0		
				if groupNode.attributes["type"].value == "My Favorites":
					isFavorite = 1
				elif groupNode.attributes["type"].value == "Trending Now":	
					isTrending = 1

				# loop over xml venues and add to list widget
				nearbyNodes = groupNode.getElementsByTagName('venue')
				for node in nearbyNodes:
					venueID = node.getElementsByTagName('id')[0].firstChild.data
					venueName = node.getElementsByTagName('name')[0].firstChild.data			
					address = ''
					crossstreet = ''
					city = ''
					state = ''
					zipCode = ''
					phone = ''
					geolat = 0
					geolong = 0
					addressNode = node.getElementsByTagName('address')
					if addressNode.length > 0:
						if addressNode[0].firstChild != None:
							address = addressNode[0].firstChild.data
					crossStreetNode = node.getElementsByTagName('crossstreet')
					if crossStreetNode.length > 0:
						if crossStreetNode[0].firstChild != None:
							crossstreet = crossStreetNode[0].firstChild.data
					cityNode = node.getElementsByTagName('city')
					if cityNode.length > 0:
						if cityNode[0].firstChild != None:
							city = cityNode[0].firstChild.data
					stateNode = node.getElementsByTagName('state')
					if stateNode.length > 0:
						if stateNode[0].firstChild != None:
							state = stateNode[0].firstChild.data
					zipNode = node.getElementsByTagName('zip')
					if zipNode.length > 0:
						if zipNode[0].firstChild != None:
							zipCode = zipNode[0].firstChild.data
					phoneNode = node.getElementsByTagName('phone')
					if phoneNode.length > 0:
						if phoneNode[0].firstChild != None:
							phone = phoneNode[0].firstChild.data
					geolat = float(node.getElementsByTagName('geolat')[0].firstChild.data)
					geolong = float(node.getElementsByTagName('geolong')[0].firstChild.data)
					distance = int(node.getElementsByTagName('distance')[0].firstChild.data)

					mayorID = ''

					self.emit(QtCore.SIGNAL('addVenueItemToDatabase'),self.sequenceID,venueID,distance,venueName,address,crossstreet,city,state,zipCode,phone,isFavorite,isTrending,geolat,geolong,mayorID,'NearbyWorkerThread')
					#
					primaryCategoryNode = node.getElementsByTagName('primarycategory')
					if primaryCategoryNode.length == 1:
						catId = primaryCategoryNode[0].getElementsByTagName('id')[0].firstChild.data
						# check to see if id exists in collection
						if not catId in qb.categoryIcons:
							catNodeName = primaryCategoryNode[0].getElementsByTagName('nodename')[0].firstChild.data
							fullPathName = primaryCategoryNode[0].getElementsByTagName('fullpathname')[0].firstChild.data
							catIconUrl = primaryCategoryNode[0].getElementsByTagName('iconurl')[0].firstChild.data
							iconFilePath = userPreferencesDir + 'imageCache' + os.sep + 'icon' + os.sep + 'venue' + os.sep + qb.getFilePathForIconUrl(catIconUrl)

							if not os.path.exists(iconFilePath):
								qb.downloadVenueIcon(iconFilePath,catIconUrl)
								print "%s -> %s" % (catIconUrl,iconFilePath)
								self.emit(QtCore.SIGNAL('resizePixmap'),iconFilePath,48,48)
							# extract url
							#
							self.emit(QtCore.SIGNAL('addCategoryToDatabase'),catId,catNodeName,fullPathName,catIconUrl,iconFilePath)
							qb.categoryIcons[catId] = iconFilePath
							
						# save venue-category relationship
						self.emit(QtCore.SIGNAL('addVenueCategoryToDatabase'),catId,venueID,True)
					
					# sleep for 10ms (keeps main UI thread from becoming sluggish
					QtCore.QThread.usleep(50000)


			# enter event loop to wait for finish for db insert/update work
			self.exec_()
		if qb.signInInit:
			self.emit(QtCore.SIGNAL('signedInInitialLoad'),qb.nextInitIndex)

	def __del__(self):
		print 'NearbyWorkerThread.__del__()'
		self.exiting = True
		self.wait()
		
class NearbyTipsWorkerThread(QtCore.QThread):
	def __init__(self, parent = None):
    		QtCore.QThread.__init__(self, parent)
		self.exiting = False

	def setup(self,seqID):
		self.sequenceID = seqID

	def run(self):
		global qb
		# print 'NearbyWorkerThread.run() Executing thread logic'
		client3 = oauthclient.SimpleOAuthClient('api.foursquare.com', 80, API_PREFIX_URL+'tips', ACCESS_TOKEN_URL, AUTHORIZATION_URL)
		consumer = oauth.OAuthConsumer(CONSUMER_KEY, CONSUMER_SECRET)
		signature_method_plaintext = oauth.OAuthSignatureMethod_PLAINTEXT()
		signature_method_hmac_sha1 = oauth.OAuthSignatureMethod_HMAC_SHA1()
	
		global currentLatitude
		global currentLongitude

		nearbyParams = {
			'l'	:	30,
			'geolat':	currentLatitude,
			'geolong':	currentLongitude,
			'oauth_token':	fsKey,
			'oauth_token_secret':	fsSecret
		}
		oauth_request = oauth.OAuthRequest.from_consumer_and_token(consumer, callback=CALLBACK_URL, http_url=API_PREFIX_URL+'tips', parameters=nearbyParams)
		oauth_request.sign_request(signature_method_plaintext, consumer, fsRequestToken)
		# print oauth_request.to_postdata()
		nearbyResultXml = client3.access_resource(oauth_request, http_url=API_PREFIX_URL+'tips', requestType='GET')
		print nearbyResultXml		
		checkinCacheFile = open(userPreferencesDir + 'nearbyTipsCache.xml','w')
		checkinCacheFile.write(nearbyResultXml)
		checkinCacheFile.close()		
		# save venue data to cache file

		parseSucces = False
		nearbyXml = None
		try:
			nearbyXml = parseString(nearbyResultXml)
			parseSucces = True
		except xml.parsers.expat.ExpatError:
			parseSucces = False

		if parseSucces:
			groupNodes = nearbyXml.getElementsByTagName('group')
			tipNodeCount = nearbyXml.getElementsByTagName('tip').length
			# set the progress bar max is double the venueCount to account for db + display
			self.emit(QtCore.SIGNAL('setProcessingDialogProgressBarMaxValue'),tipNodeCount*3)	
			params = ('NearbyTipsWorkerThread',tipNodeCount*3,0)
			self.emit(QtCore.SIGNAL('setDatabaseExpectedResultCount'),params)
			for groupNode in groupNodes:
				groupType = groupNode.attributes["type"].value

				# loop over xml venues and add to list widget
				tipNodes = groupNode.getElementsByTagName('tip')
				for tipNode in tipNodes:
					venueNode = tipNode.getElementsByTagName('venue')[0]
					venueIDNodes = venueNode.getElementsByTagName('id')
					venueID = ''
					if venueIDNodes.length == 1:
						venueID = venueIDNodes[0].firstChild.data
						venueName = venueNode.getElementsByTagName('name')[0].firstChild.data			
						address = ''
						crossstreet = ''
						city = ''
						state = ''
						zipCode = ''
						phone = ''
						geolat = 0
						geolong = 0
						addressNode = venueNode.getElementsByTagName('address')
						if addressNode.length > 0:
							if addressNode[0].firstChild != None:
								address = addressNode[0].firstChild.data
						crossStreetNode = venueNode.getElementsByTagName('crossstreet')
						if crossStreetNode.length > 0:
							if crossStreetNode[0].firstChild != None:
								crossstreet = crossStreetNode[0].firstChild.data
						cityNode = venueNode.getElementsByTagName('city')
						if cityNode.length > 0:
							if cityNode[0].firstChild != None:
								city = cityNode[0].firstChild.data
						stateNode = venueNode.getElementsByTagName('state')
						if stateNode.length > 0:
							if stateNode[0].firstChild != None:
								state = stateNode[0].firstChild.data
						zipNode = venueNode.getElementsByTagName('zip')
						if zipNode.length > 0:
							if zipNode[0].firstChild != None:
								zipCode = zipNode[0].firstChild.data
						phoneNode = venueNode.getElementsByTagName('phone')
						if phoneNode.length > 0:
							if phoneNode[0].firstChild != None:
								phone = phoneNode[0].firstChild.data
						geolat = float(venueNode.getElementsByTagName('geolat')[0].firstChild.data)
						geolong = float(venueNode.getElementsByTagName('geolong')[0].firstChild.data)
						distance = int(tipNode.getElementsByTagName('distance')[0].firstChild.data)
	
						mayorID = ''
	
						self.emit(QtCore.SIGNAL('addVenueItemToDatabase'),0,venueID,0,venueName,address,crossstreet,city,state,zipCode,phone,-1,-1,geolat,geolong,mayorID,'NearbyTipsWorkerThread')
						QtCore.QThread.usleep(50000)
					else:
						# venue not found, notify gui to update
						self.emit(QtCore.SIGNAL('incrementDatabaseExpectedResultCount'),'NearbyTipsWorkerThread')
						
					# sleep for 10ms (keeps main UI thread from becoming sluggish
					
					if venueID != '':					
						tipID = tipNode.getElementsByTagName('id')[0].firstChild.data
						tipDistance = int(tipNode.getElementsByTagName('distance')[0].firstChild.data)
						# see if we already have this tip for the venue, if so, don't add it
						tipText = tipNode.getElementsByTagName('text')[0].firstChild.data
						tipCreatedInt = int(time.mktime(time.strptime(tipNode.getElementsByTagName('created')[0].firstChild.data,'%a, %d %b %y %H:%M:%S +0000')))
						tipCreatedUTC = datetime.datetime.fromtimestamp(tipCreatedInt)
	
						tipUrlNode = tipNode.getElementsByTagName('url')
						tipUrl = ''
						if tipUrlNode.length == 1:
							if tipUrlNode[0].firstChild != None:
								tipUrl = tipUrlNode[0].firstChild.data
						tipUserNode = tipNode.getElementsByTagName('user')
						tipUserID = tipUserNode[0].getElementsByTagName('id')[0].firstChild.data
						tipPhotoUrl = tipUserNode[0].getElementsByTagName('photo')[0].firstChild.data
						firstName = tipUserNode[0].getElementsByTagName('firstname')[0].firstChild.data
						lastName = ''
						lastNameNode = tipUserNode[0].getElementsByTagName('lastname')
						if lastNameNode.length == 1:
							if lastNameNode[0].firstChild != None:
								lastName = lastNameNode[0].firstChild.data
	
						# download photo if file cache not existent
						tipURLchunks = tipPhotoUrl.split('/')
						tipPhotoFile = userPreferencesDir + 'imageCache' + os.sep + 'users' + os.sep + tipURLchunks[3] + '_' + tipURLchunks[4]
						# print 'checkinPhotoFile: ' + checkinPhotoFile
						print tipPhotoUrl
						if not os.path.exists(tipPhotoFile):
							qb.getUserPhoto(tipPhotoUrl)
							
						self.emit(QtCore.SIGNAL('addUserToDatabase'),tipUserID,firstName,lastName,tipPhotoFile,tipPhotoUrl,'NearbyTipsWorkerThread')
						# print 'checkinID: %s' % tipID
						# print 'venueID: %s' % str(self.id)
						# print 'tipUserID: %s' % tipUserID
						# print 'tipText: %s' % tipText
						# print 'url: %s' % tipUrl
						self.emit(QtCore.SIGNAL('addEditVenueTip'),tipID,tipDistance,venueID,tipUserID,1,tipText,str(tipCreatedUTC),tipUrl,self.sequenceID,'NearbyTipsWorkerThread')
					else:
						self.emit(QtCore.SIGNAL('incrementDatabaseExpectedResultCount'),'NearbyTipsWorkerThread')
						self.emit(QtCore.SIGNAL('incrementDatabaseExpectedResultCount'),'NearbyTipsWorkerThread')																	
				
			# enter event loop to wait for finish for db insert/update work
			self.exec_()
		if qb.signInInit:
			self.emit(QtCore.SIGNAL('signedInInitialLoad'),qb.nextInitIndex)

	def __del__(self):
		print 'NearbyTipsWorkerThread.__del__()'
		self.exiting = True
		self.wait()		

class RefreshFriendsWorkerThread(QtCore.QThread):
	def __init__(self, parent = None):
    		QtCore.QThread.__init__(self, parent)
		self.exiting = False

	def setup(self,displayProgressBar,callingThreadName):
		self.displayProgressBar = displayProgressBar
		self.callingThreadName = callingThreadName

	def run(self):
		self.eventloopRunning = False
		global qb
		global infoNoticeString
		# print 'RefreshFriendsWorkerThread.run() Executing thread logic'
		client3 = oauthclient.SimpleOAuthClient('api.foursquare.com', 80, API_PREFIX_URL+'checkins', ACCESS_TOKEN_URL, AUTHORIZATION_URL)
		consumer = oauth.OAuthConsumer(CONSUMER_KEY, CONSUMER_SECRET)
		signature_method_plaintext = oauth.OAuthSignatureMethod_PLAINTEXT()
		signature_method_hmac_sha1 = oauth.OAuthSignatureMethod_HMAC_SHA1()
	
		global currentLatitude
		global currentLongitude

		nearbyParams = {
			'geolat':	currentLatitude,
			'geolong':	currentLongitude,
			'oauth_token':	fsKey,
			'oauth_token_secret':	fsSecret
		}
		oauth_request = oauth.OAuthRequest.from_consumer_and_token(consumer, callback=CALLBACK_URL, http_url=API_PREFIX_URL+'checkins', parameters=nearbyParams)
		oauth_request.sign_request(signature_method_plaintext, consumer, fsRequestToken)
		# print oauth_request.to_postdata()
		connectionResult = False
		try:
			checkinsResultXml = client3.access_resource(oauth_request, http_url=API_PREFIX_URL+'checkins', requestType='GET')
			connectionResult = True
		except socket.gaierror, e:
			connectionResult = False
			if e[0] == -3:
				infoNoticeString = 'Error: unable to resolve api.foursquare.com hostname'
				self.emit(QtCore.SIGNAL('displayInfoNotice()'))	
			else:
				infoNoticeString = 'Error: unable to connect to api.foursquare.com'
				self.emit(QtCore.SIGNAL('displayInfoNotice()'))	
		
		if connectionResult:
			print checkinsResultXml		
			parseSuccess = False
			try:
				checkinsXml = parseString(checkinsResultXml)
				parseSuccess = True
			except xml.parsers.expat.ExpatError:
				# print 'error parsing checkinsResultXml'
				parseSuccess = False
				infoNoticeString = 'Error: api.foursquare.com problem refreshing friends'
				self.emit(QtCore.SIGNAL('displayInfoNotice()'))
				
			if checkinsResultXml.find("INTERNAL_SERVER_ERROR") >= 0:
				parseSuccess = False
	
			if parseSuccess == True:
				errorNode = checkinsXml.getElementsByTagName('error')
				if errorNode.length == 1:
					infoNoticeString = errorNode[0].firstChild.data
					self.emit(QtCore.SIGNAL('displayInfoNotice()'))					
				else:				
					unAuthorizedNode = checkinsXml.getElementsByTagName('unauthorized')
					if unAuthorizedNode.length == 1:
						if unAuthorizedNode[0].firstChild.data == 'TOKEN_EXPIRED':
							infoNoticeString = 'Error: foursquare.com token expired. Please sign back in'
							self.emit(QtCore.SIGNAL('displayInfoNotice()'))		
					else:				
						checkinNodes = checkinsXml.getElementsByTagName('checkin')
						# signal to setup number of records
	
						# do query to checkin dates for user's friends - we only want to do inserts for new checkins after X date
						results = qb.dataManager.doSelectQueryOnMainThread('SELECT UserLastCheckinDate.userID, UserLastCheckinDate.createdDate FROM UserLastCheckinDate INNER JOIN UserFriendStatus ON UserFriendStatus.userID=UserLastCheckinDate.userID WHERE UserFriendStatus.status = 1','userID,createdDate')
						history = { }
						if results['RecordCount'] > 0:
							for row in results['Records']:
								history[str(row['userID'].toString())] = int(time.mktime(time.strptime(str(row['createdDate'].toString()),'%a, %d %b %y %H:%M:%S +0000')))
	
						mayors = { }
						del results
						results = qb.dataManager.doSelectQueryOnMainThread('SELECT venueID, userID from VenueMayors','venueID,userID')					
						if results['RecordCount'] > 0:
							for row in results['Records']:
								mayors[str(row['venueID'].toString())] = str(row['userID'].toString())
						
						# print history
	
						if self.displayProgressBar and self.callingThreadName != None:
							self.emit(QtCore.SIGNAL('setProcessingDialogProgressBarMaxValue'),checkinNodes.length)	
							self.emit(QtCore.SIGNAL('setDatabaseExpectedResultCount'),(self.callingThreadName,checkinNodes.length,0))
		
						for node in checkinNodes:
							checkinID = node.getElementsByTagName('id')[0].firstChild.data
							createdDate = node.getElementsByTagName('created')[0].firstChild.data
							createdDateInt = int(time.mktime(time.strptime(createdDate,'%a, %d %b %y %H:%M:%S +0000')))
	
							userNode = node.getElementsByTagName('user')[0]
							userID = userNode.getElementsByTagName('id')[0].firstChild.data
	
							hasCheckin = True
							setMayorship = False
							
							venueID = ''	
							venueNode = node.getElementsByTagName('venue')	
							if venueNode.length > 0:
								venueIDNode = venueNode[0].getElementsByTagName('id')
								if venueIDNode.length > 0:
									venueID = venueIDNode[0].firstChild.data							
									mayorNode = node.getElementsByTagName('ismayor')
									if mayorNode.length == 1:
										if mayorNode[0].firstChild != None:
											if mayorNode[0].firstChild.data == "true":
												# check to see if mayor exists in lookup
												if not venueID in mayors:
													setMayorship = True
												elif mayors[venueID] != userID:
													setMayorship = True
			
							if userID in history:
								# print 'userID %s in history' % userID
								# print 'createdDateInt %d =? %d' % (createdDateInt, history[userID])
								if createdDateInt > history[userID]:
									hasCheckin = False
							else:
								hasCheckin = False
					
							# print hasCheckin
					
							if not hasCheckin:
								venueID = ''	
								venueNode = node.getElementsByTagName('venue')	
								customVenueName = ''				
								# print 'venueNode.length: %d' % venueNode.length
								if venueNode.length > 0:
									address = ''
									crossstreet = ''
									city = ''
									state = ''
									zipCode = ''
									phone = ''
									geolat = 0
									geolong = 0
									distance = 0
							
									venueName = venueNode[0].getElementsByTagName('name')[0].firstChild.data			
									venueIDNode = venueNode[0].getElementsByTagName('id')
									if venueIDNode.length > 0:
										venueID = venueIDNode[0].firstChild.data
										addressNode = venueNode[0].getElementsByTagName('address')
										if addressNode.length > 0:
											if addressNode[0].firstChild != None:
												address = addressNode[0].firstChild.data
										crossStreetNode = venueNode[0].getElementsByTagName('crossstreet')
										if crossStreetNode.length > 0:
											if crossStreetNode[0].firstChild != None:
												crossstreet = crossStreetNode[0].firstChild.data
										cityNode = venueNode[0].getElementsByTagName('city')
										if cityNode.length > 0:
											if cityNode[0].firstChild != None:
												city = cityNode[0].firstChild.data
										stateNode = venueNode[0].getElementsByTagName('state')
										if stateNode.length > 0:
											if stateNode[0].firstChild != None:
												state = stateNode[0].firstChild.data
										zipNode = venueNode[0].getElementsByTagName('zip')
										if zipNode.length > 0:
											if zipNode[0].firstChild != None:
												zipCode = zipNode[0].firstChild.data
										phoneNode = venueNode[0].getElementsByTagName('phone')
										if phoneNode.length > 0:
											if phoneNode[0].firstChild != None:
												phone = phoneNode[0].firstChild.data
										geolat = float(venueNode[0].getElementsByTagName('geolat')[0].firstChild.data)
										geolong = float(venueNode[0].getElementsByTagName('geolong')[0].firstChild.data)
									else:
										customVenueName = venueName	
	
									mayorID = ''
									if customVenueName == '':
										self.emit(QtCore.SIGNAL('addVenueItemToDatabase'),0,venueID,distance,venueName,address,crossstreet,city,state,zipCode,phone,-1,-1,geolat,geolong,mayorID,None)
										QtCore.QThread.usleep(50000)
										# add/update venue		
	
								distanceNode = node.getElementsByTagName('distance')
								displayString = ''
								displayNode = node.getElementsByTagName('display')
								if displayNode.length > 0:
									if displayNode[0].firstChild != None:
										displayString = displayNode[0].firstChild.data
								calcDistance  = 0
								if distanceNode > 0:
									calcDistance = int(distanceNode[0].firstChild.data)
								shoutNodes = node.getElementsByTagName('shout')
								shout = ''
								# print 'shouts: %d' % shoutNodes.length
								if shoutNodes.length > 0:
									if shoutNodes[0].firstChild != None:
										shout = shoutNodes[0].firstChild.data
	
								self.emit(QtCore.SIGNAL('addCheckinHistoryItemToDatabase'),checkinID,venueID,userID,calcDistance,shout,createdDate,customVenueName,displayString,self.callingThreadName)
								self.emit(QtCore.SIGNAL('addEditUserLastCheckinToDatabase'),userID,createdDate,checkinID)
							else:
								# checkin existed already, increment counter
								if self.displayProgressBar and self.callingThreadName != None:
									self.emit(QtCore.SIGNAL('incrementDatabaseExpectedResultCount'),self.callingThreadName)	
	
							if setMayorship:
								self.emit(QtCore.SIGNAL('setVenueMayorship'),venueID,userID) 
						# enter event loop
						if self.displayProgressBar:
							print 'entering RefreshFriendsWorkerThread.run() event loop'
							self.eventloopRunning = True
							self.exec_()
							self.eventloopRunning = False
							print 'finished event loop in RefreshFriendsWorkerThread.run()'
			else:
				infoNoticeString = 'Error: foursquare.com api error. Try again later'
				self.emit(QtCore.SIGNAL('displayInfoNotice()'))						
		if qb.signInInit:
			self.emit(QtCore.SIGNAL('signedInInitialLoad'),qb.nextInitIndex)
	def __del__(self):
		print 'RefreshFriendsWorkerThread.__del__()'
		self.exiting = True
		self.wait()

class CheckinWorkerThread(QtCore.QThread):
	def __init__(self, parent = None):
    		QtCore.QThread.__init__(self, parent)
		self.exiting = False

	def setup(self, pFriends, pTwitter, pFacebook, vID, shoutStr):
		# print '(setup) shout: '+shoutStr
		# print '(setup) venueID %d' % vID
		self.shout = shoutStr
		self.pingFriends = pFriends
		self.pingTwitter = pTwitter
		self.pingFacebook = pFacebook
		self.venueID = vID

	def run(self):
		# print 'Executing thread logic'
		global FakeCheckin
		global infoNoticeString

		print '*** check in data ***'
		print currentLatitude
		print currentLongitude
		print self.pingFriends
		print self.pingTwitter
		print self.pingFacebook
		print self.venueID
		print self.shout
		print fsKey
		print fsSecret
		print '*** end check in data ***'


		if (FakeCheckin == False):
			client3 = oauthclient.SimpleOAuthClient('api.foursquare.com', 80, API_PREFIX_URL+'checkin', ACCESS_TOKEN_URL, AUTHORIZATION_URL)
			consumer = oauth.OAuthConsumer(CONSUMER_KEY, CONSUMER_SECRET)
			signature_method_plaintext = oauth.OAuthSignatureMethod_PLAINTEXT()
			signature_method_hmac_sha1 = oauth.OAuthSignatureMethod_HMAC_SHA1()

			isPrivate = 1
			if self.pingFriends == True:
				isPrivate = 0
			isTwitter = 0
			if self.pingTwitter == True:
				isTwitter = 1
			isFacebook = 0
			if self.pingFacebook == True:
				isFacebook = 1
	
			nearbyParams = {
				'vid'	:	self.venueID,
				'geolat' : 	currentLatitude,
				'geolong':	currentLongitude,
				'private':	isPrivate,
				'twitter':	isTwitter,
				'facebook':	isFacebook,
				'shout'	 :	self.shout,
				'oauth_token':	fsKey,
				'oauth_token_secret':	fsSecret
			}
			oauth_request = oauth.OAuthRequest.from_consumer_and_token(consumer, callback=CALLBACK_URL, http_url=API_PREFIX_URL+'checkin', parameters=nearbyParams)
			oauth_request.sign_request(signature_method_plaintext, consumer, fsRequestToken)
			# print oauth_request.to_postdata()
			checkinResultXmlString = client3.access_resource(oauth_request, http_url=API_PREFIX_URL+'checkin', requestType='POST')
			print checkinResultXmlString		
			parseSuccess = False
			try:
				checkinResultXml = parseString(checkinResultXmlString)
				parseSuccess = True
				checkinCacheFile = open(userPreferencesDir + 'checkInCache.xml','w')
				checkinCacheFile.write(checkinResultXmlString)
				checkinCacheFile.close()

				# also store a copy tagged with the venueID 
				checkinCacheFile2 = open(userPreferencesDir + 'checkInCache_vid' + str(self.venueID) + '.xml','w')
				checkinCacheFile2.write(checkinResultXmlString)
				checkinCacheFile2.close()		

			except xml.parsers.expat.ExpatError:
				print 'error parsing checkinResult'
				parseSuccess = False
				infoNoticeString = 'Error: api.foursquare.com problem. Check history before trying again'
				self.emit(QtCore.SIGNAL('displayInfoNotice()'))	
		else:
			# sleep fake checkin for 5 seconds to simulate real checkin
			time.sleep(2)		


	def __del__(self):
		print 'CheckinWorkerThread.__del__()'
		self.exiting = True
		self.wait()

class VenueListItem(QtGui.QWidget):
	def __init__(self, parent=None):
        	QtGui.QWidget.__init__(self, parent)
		self.isHighlighted = False

	def setHighlighted(self,hl):
		self.isHighlighted = hl

	def setText(self, text1, text2, iconPath):
		self.mainText = text1
		self.subtitleText = text2
		self.lblIcon = QtGui.QLabel('',self)
		self.lblIcon.setGeometry(5, 5, 65, 65)
		self.iconPath = iconPath
		if iconPath != None:
			self.lblIcon.setPixmap(QtGui.QPixmap(iconPath))

		self.lblIcon2 = QtGui.QLabel('',self)
		self.lblIcon2.setGeometry(775, 28, 15, 15)
		self.lblIcon2.setPixmap(QtGui.QPixmap(APP_DIRECTORY + 'tinyIcon.gif'))



	def paintEvent(self, event):
		paint = QtGui.QPainter()
		paint.begin(self)
		
		if not self.isHighlighted:
			paint.setPen(QtGui.QColor(255, 255, 255))
			if not disableSlickUI:
				gradient = QtGui.QLinearGradient(0, 0, 0, 75)
				gradient.setColorAt(0.0, QtGui.QColor(240, 240, 240))
				gradient.setColorAt(1.0, QtGui.QColor(200, 200, 200))
				paint.setBrush(QtGui.QBrush(gradient))
			else:
				paint.setBrush(QtGui.QColor(255, 255, 255))
		else:
			paint.setPen(QtGui.QColor(235, 235, 235))
			if not disableSlickUI:
				gradient = QtGui.QLinearGradient(0, 0, 0, 75)
				gradient.setColorAt(0.0, QtGui.QColor(100, 100, 100))
				gradient.setColorAt(1.0, QtGui.QColor(240, 240, 240))
				paint.setBrush(QtGui.QBrush(gradient))
			else:
				paint.setBrush(QtGui.QColor(235, 235, 235))
		paint.drawRect(0, 0, 800, 75)

		paint.setPen(QtGui.QColor(168, 34, 3))
		font = QtGui.QFont('Helvetica', 25, QtGui.QFont.Light)
		paint.setFont(font)
		if self.iconPath != None:
			paint.drawText(73, 34, self.mainText)
		else:
			paint.drawText(3, 34, self.mainText)

		font = QtGui.QFont('Helvetica', 15, QtGui.QFont.Light)
		paint.setFont(font)
		

		if self.iconPath != None:
			paint.drawText(76, 62, self.subtitleText)			
		else:
			paint.drawText(6, 62, self.subtitleText)

		# draw line
		pen = QtGui.QPen(QtGui.QColor(20, 20, 20), 1, QtCore.Qt.DotLine)
		paint.setPen(pen)
		paint.setBrush(QtCore.Qt.NoBrush)
	        paint.drawLine(1, 74, 800, 74)

		paint.end()
		del paint

class BadgeListItem(QtGui.QWidget):
	def __init__(self, parent=None):
        	QtGui.QWidget.__init__(self, parent)

	def setText(self, text1, text2, iconPath):
		self.mainText = text1
		self.subtitleText = text2
		self.lblIcon = QtGui.QLabel('',self)
		self.lblIcon.setGeometry(5, 5, 57, 57)
		if iconPath != None:
			self.lblIcon.setPixmap(QtGui.QPixmap(iconPath))

	def paintEvent(self, event):
		paint = QtGui.QPainter()
		paint.begin(self)

		paint.setPen(QtGui.QColor(255, 255, 255))
		paint.setBrush(QtGui.QColor(255, 255, 255))
		paint.drawRect(0, 0, 800, 75)

		paint.setPen(QtGui.QColor(168, 34, 3))
		font = QtGui.QFont('Helvetica', 30, QtGui.QFont.Light)
		paint.setFont(font)
		paint.drawText(73, 34, self.mainText)

		font = QtGui.QFont('Helvetica', 15, QtGui.QFont.Light)
		paint.setFont(font)
		paint.drawText(76, 62, self.subtitleText)

		# draw line
		pen = QtGui.QPen(QtGui.QColor(20, 20, 20), 1, QtCore.Qt.DotLine)
		paint.setPen(pen)
		paint.setBrush(QtCore.Qt.NoBrush)
	        paint.drawLine(1, 74, 800, 74)

		paint.end()
		del paint

class DefautListItem(QtGui.QWidget):
	def __init__(self, parent=None):
        	QtGui.QWidget.__init__(self, parent)
		self.isHighlighted = False

	def setHighlighted(self,hl):
		self.isHighlighted = hl

	def setText(self, text1):
		self.mainText = text1

	def paintEvent(self, event):
		global disableSlickUI
		paint = QtGui.QPainter()
		paint.begin(self)	

		# print self.mainText

		if not self.isHighlighted:
			paint.setPen(QtGui.QColor(255, 255, 255))
			if not disableSlickUI:
				gradient = QtGui.QLinearGradient(0, 0, 0, 75)
				gradient.setColorAt(0.0, QtGui.QColor(240, 240, 240))
				gradient.setColorAt(1.0, QtGui.QColor(200, 200, 200))
				paint.setBrush(QtGui.QBrush(gradient))
			else:
				paint.setBrush(QtGui.QColor(255, 255, 255))
		else:
			paint.setPen(QtGui.QColor(235, 235, 235))
			if not disableSlickUI:
				gradient = QtGui.QLinearGradient(0, 0, 0, 75)
				gradient.setColorAt(0.0, QtGui.QColor(100, 100, 100))
				gradient.setColorAt(1.0, QtGui.QColor(240, 240, 240))
				paint.setBrush(QtGui.QBrush(gradient))
			else:
				paint.setBrush(QtGui.QColor(235, 235, 235))
		paint.drawRect(0, 0, 800, 75)

		paint.setPen(QtGui.QColor(168, 34, 3))
		font = QtGui.QFont('Helvetica', 30, QtGui.QFont.Light)
		paint.setFont(font)
		paint.drawText(5, 34, self.mainText)

		# draw line
		pen = QtGui.QPen(QtGui.QColor(20, 20, 20), 1, QtCore.Qt.DotLine)
		paint.setPen(pen)
		paint.setBrush(QtCore.Qt.NoBrush)
	        paint.drawLine(1, 74, 800, 74)

		paint.end()
		del paint

class FriendListItem(QtGui.QWidget):
	def __init__(self, showDisclosureIndicator=True, parent=None):
		QtGui.QWidget.__init__(self, parent)
		      
		self.isHighlighted = False
		self.clockIcon = QtGui.QIcon(QtGui.QPixmap(APP_DIRECTORY + 'ClockIcon24.png'))
		self.showDisclosureIndicator = showDisclosureIndicator
		self.isMayor = False

	def setHighlighted(self,hl):
		self.isHighlighted = hl
		
	def setMayor(self, isMayor, mayorPixmap):
		self.isMayor = isMayor
		self.mayorPixmap = mayorPixmap

	def setText(self, text1, text2, text3, iconPath):
		self.mainText = text1
		self.subtitleText = text2
		self.dateText = text3
		self.lblIcon = QtGui.QLabel('',self)
		self.lblIcon.setGeometry(5, 5, 65, 65)
		if iconPath != None:
			self.lblIcon.setPixmap(QtGui.QPixmap(iconPath))

		if self.showDisclosureIndicator:
			self.lblIcon2 = QtGui.QLabel('',self)
			self.lblIcon2.setGeometry(775, 28, 15, 15)
			self.lblIcon2.setPixmap(QtGui.QPixmap(APP_DIRECTORY + 'tinyIcon.gif'))
			
		if self.isMayor:
			self.lblMayorIcon = QtGui.QLabel('',self)
			self.lblMayorIcon.setGeometry(73, 11, 24, 24)
			self.lblMayorIcon.setPixmap(self.mayorPixmap)

		# p = QtGui.QPalette()
		# p.setBrush(self.backgroundRole(), QtGui.QBrush(QtGui.QImage(APP_DIRECTORY + 'SignInFourSquare.png')))
		# self.setPalette(p)

	def paintEvent(self, event):
		global disableSlickUI
		paint = QtGui.QPainter()
		paint.begin(self)	

		# print self.mainText

		if not self.isHighlighted:
			paint.setPen(QtGui.QColor(255, 255, 255))
			if not disableSlickUI:
				gradient = QtGui.QLinearGradient(0, 0, 0, 75)
				gradient.setColorAt(0.0, QtGui.QColor(240, 240, 240))
				gradient.setColorAt(1.0, QtGui.QColor(200, 200, 200))
				paint.setBrush(QtGui.QBrush(gradient))
			else:
				paint.setBrush(QtGui.QColor(255, 255, 255))
		else:
			paint.setPen(QtGui.QColor(235, 235, 235))
			if not disableSlickUI:
				gradient = QtGui.QLinearGradient(0, 0, 0, 75)
				gradient.setColorAt(0.0, QtGui.QColor(100, 100, 100))
				gradient.setColorAt(1.0, QtGui.QColor(240, 240, 240))
				paint.setBrush(QtGui.QBrush(gradient))
			else:
				paint.setBrush(QtGui.QColor(235, 235, 235))
		paint.drawRect(0, 0, 800, 75)

		paint.setPen(QtGui.QColor(168, 34, 3))
		font = QtGui.QFont('Helvetica', 23, QtGui.QFont.Light)
		paint.setFont(font)
		# print '%s : len(self.mainText): %d' % (self.mainText,len(self.mainText))
		if self.isMayor:
			if len(self.mainText) > 43:
				self.mainText = self.mainText[:43] + '...'
			paint.drawText(100, 34, self.mainText)			
		else:
			if len(self.mainText) > 47:
				self.mainText = self.mainText[:47] + '...'
			paint.drawText(73, 34, self.mainText)

		font = QtGui.QFont('Helvetica', 15, QtGui.QFont.Light)
		paint.setFont(font)
		parts = self.subtitleText.split("~")

		if len(parts) > 1:
			paint.setPen(QtGui.QColor(140, 97, 106))
			paint.drawText(76, 64, parts[0])
			address = parts[0]
			addressRect = paint.boundingRect(QtCore.QRect(76,64,724,12),QtCore.Qt.AlignLeft,QtCore.QString(address))
			# print addressRect
			# paint.setBrush(QtGui.QColor(168, 34, 3))
			# paint.drawRect(addressRect.left() + addressRect.width(), 50, 25, 12)
			# add icon
			self.clockIcon.paint(paint,QtCore.QRect(addressRect.left() + addressRect.width(), 42,24,24), QtCore.Qt.AlignLeft, QtGui.QIcon.Normal, QtGui.QIcon.On)
			# draw the time
			font = QtGui.QFont('Helvetica', 15, QtGui.QFont.Light, True)
			paint.setFont(font)
			paint.drawText(addressRect.left() + addressRect.width() + 30, 64, parts[1])
		else:
			paint.drawText(76, 64, self.subtitleText)
			

		# draw line
		pen = QtGui.QPen(QtGui.QColor(20, 20, 20), 1, QtCore.Qt.DotLine)
		paint.setPen(pen)
		paint.setBrush(QtCore.Qt.NoBrush)
	        paint.drawLine(1, 74, 800, 74)

		paint.end()
		del paint

class TipListItem(QtGui.QWidget):
	def __init__(self, height, parent=None):
        	QtGui.QWidget.__init__(self, parent)
		self.widgetHeight = height

	def setText(self, text1, iconPath):
		self.mainText = text1
		self.lblIcon = QtGui.QLabel('',self)
		self.lblIcon.setGeometry(720, 5, 65, 65)
		if iconPath != None:
			self.lblIcon.setPixmap(QtGui.QPixmap(iconPath))

	def paintEvent(self, event):
		paint = QtGui.QPainter()
		paint.begin(self)

		paint.setPen(QtGui.QColor(255, 255, 255))
		paint.setBrush(QtGui.QColor(255, 255, 255))
		paint.drawRect(0, 0, 800, self.widgetHeight)

		doc = QtGui.QTextDocument()
		doc.setHtml(self.mainText)
		doc.setTextWidth(700)

		paint.setPen(QtGui.QColor(168, 34, 3))
		font = QtGui.QFont('Helvetica', 15, QtGui.QFont.Light)
		paint.setFont(font)
		rect = QtCore.QRectF(0,5,800,self.widgetHeight-5)
		options = QtGui.QTextOption()
		options.setWrapMode(QtGui.QTextOption.WordWrap)
		options.setAlignment(QtCore.Qt.AlignLeft)
		# rect = paint.boundingRect(rect, self.mainText, options)	
		# print rect

		doc.drawContents(paint, rect)

		# draw line
		pen = QtGui.QPen(QtGui.QColor(20, 20, 20), 1, QtCore.Qt.DotLine)
		paint.setPen(pen)
		paint.setBrush(QtCore.Qt.NoBrush)
	        paint.drawLine(1, self.widgetHeight - 1, 800, self.widgetHeight - 1)

		paint.end()
		del paint

class CheckInDialog(QtGui.QDialog):
	def __init__(self, id, venueName, parent=None):
		QtGui.QDialog.__init__(self, parent)

		hasTwitter = False
		hasFacebook = False
		# load settings for user
		global qb
		result = qb.dataManager.doSelectQueryOnMainThread("SELECT twitter,facebook FROM UserDetails WHERE userID='%s'" % qb.userID, "twitter,facebook")
		if result['RecordCount'] > 0:
			for row in result['Records']:
				if len(str(row['twitter'].toString())) > 0:
					hasTwitter = True
				if len(str(row['facebook'].toString())) > 0:
					hasFacebook = True			 

		p = self.palette()
		p.setColor(QtGui.QPalette.Window, QtGui.QColor(0, 0, 0))
		self.setPalette(p)
		
		# print 'Place ID:' + id
		self.venueID = id

		self.setWindowTitle('Check-In')
		self.lblTitle = QtGui.QLabel('Checking in @ ' + venueName,self)
		self.lblTitle.setFont(QtGui.QFont('Helvetica', 30))
		self.lblTitle.setGeometry(5,5,800,50)

		self.chkPingFriends = QtGui.QCheckBox('Ping my Friends',self)
		self.chkPingFriends.setGeometry(5,50,500,40)
		self.chkPingFriends.setChecked(True)

		global pingTwitter

		self.chkTwitter = QtGui.QCheckBox('Tweet this check-in',self)
		if not hasTwitter:
			self.chkTwitter.setGeometry(0,0,0,0)
		else:
			self.chkTwitter.setGeometry(5,90,500,40)
		self.chkTwitter.setChecked(pingTwitter)

		global pingFacebook

		self.chkFacebook = QtGui.QCheckBox('Post this check-in to facebook',self)
		if hasTwitter and hasFacebook:
			self.chkFacebook.setGeometry(5,130,500,40)
		elif hasFacebook and not hasTwitter:
			self.chkFacebook.setGeometry(5,90,500,40)
		else:
			self.chkFacebook.setGeometry(0,0,0,0)

		self.chkFacebook.setChecked(pingFacebook)

		self.txtShout = QtGui.QLineEdit(self)
		self.txtShout.setGeometry(5, 180, 500, 50)

		self.bttnCheckIn = QtGui.QPushButton('Check-In Here',self)
		self.bttnCheckIn.setGeometry(5,250,350,120)
		self.bttnCheckIn.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnCheckIn.setFont(QtGui.QFont('Helvetica', 30))
		# self.bttnCheckIn.setIcon(QtGui.QIcon(QtGui.QPixmap(APP_DIRECTORY + 'bttnCheckIn.png')))
		# self.bttnCheckIn.setIconSize(QtCore.QSize(300,100))

		self.connect(self.bttnCheckIn, QtCore.SIGNAL('clicked()'),
			self.doCheckInButtonClicked)

		self.resize(800,480)

		self.checkinWorker = CheckinWorkerThread()
		self.connect(self.checkinWorker, QtCore.SIGNAL('finished()'), self.checkinFinished)
		self.connect(self.checkinWorker, QtCore.SIGNAL('displayInfoNotice()'), self.displayInfoNoticeGlobal)

		self.lblLoadingIcon = QtGui.QLabel('',self)
		self.loadingGif = QtGui.QMovie(APP_DIRECTORY + 'loading2.gif', QtCore.QByteArray(), self)
		self.loadingGif.setCacheMode(QtGui.QMovie.CacheAll)
		self.loadingGif.setSpeed(100)
		self.loadingGif.setBackgroundColor(QtGui.QColor(0, 0, 0))
		self.lblLoadingIcon.setGeometry(370,290,50,50)
		self.lblLoadingIcon.setMovie(self.loadingGif)
		self.lblLoadingIcon.hide()

	def displayInfoNoticeGlobal(self):
		global infoNoticeString
		global qb
		qb.displayInfoNotice(infoNoticeString)

	def checkinFinished(self):
		# print 'checkinFinished'
		self.close()
		print 'launch Dialog from MainWindow with checkin details'
		global qb
		qb.displayCheckinDetails()

	def doCheckInButtonClicked(self):
		print 'doCheckInButtonClicked'
		print 'VenueID: ' + self.venueID
		venID = int(self.venueID)
		shout = ''
		if len(str(self.txtShout.text()).strip()) > 0:
			shout = str(self.txtShout.text()).strip()

		global shoutString
		shoutString = shout
		global checkinVenueID
		checkinVenueID = venID

		self.loadingGif.start()
		self.lblLoadingIcon.show()
		self.bttnCheckIn.setEnabled(False)
		self.bttnCheckIn.setText('Checking In...')
		# self.bttnCheckIn.setIcon(None)
		self.bttnCheckIn.setEnabled(False)

		self.checkinWorker.setup(self.chkPingFriends.isChecked(),self.chkTwitter.isChecked(),self.chkFacebook.isChecked(),venID,shout)
		self.checkinWorker.start()

class CheckinResultsDialog(QtGui.QDialog):
	def __init__(self, parent=None):
		global qb
		global infoNoticeString
		QtGui.QDialog.__init__(self, parent)

		p = self.palette()
		p.setColor(QtGui.QPalette.Window, QtGui.QColor(0, 0, 0))
		self.setPalette(p)

		self.setWindowTitle('You have checked in!')

		self.lblMessage1 = QtGui.QTextDocument(self)
		self.lblMessage1.setTextWidth(790)

		#self.lblMessage1.setAlignment(QtCore.Qt.AlignTop)

		# self.lblPoints = QtGui.QLabel('',self)
		# self.lblPoints.setGeometry(10,50,500,40)

		# self.lblMayorIcon = QtGui.QLabel('',self)
		# self.lblMayorIcon.setGeometry(10,80,50,50)

		# self.lblMayor = QtGui.QLabel('',self)
		# self.lblMayor.setGeometry(70,80,700,100)
		# self.lblMayor.setWordWrap(True)

		# self.lblMayor.setAlignment(QtCore.Qt.AlignTop)

		self.resize(800,240)

		# parse the checkin
		parseSuccess = False
		checkinsCacheFile = open(userPreferencesDir + 'checkInCache.xml','r')

		try:
			checkinXml = parse(checkinsCacheFile)
			parseSuccess = True
		except xml.parsers.expat.ExpatError:
			parseSuccess = False
		checkinsCacheFile.close()
		# get the message
		if parseSuccess:
			errorNode = checkinXml.getElementsByTagName('error')
			if errorNode.length == 1:
				qb.displayInfoNotice(errorNode[0].firstChild.data)
				message = '<body bgcolor="#000000"><font color="#ffffff">Error Retrieving Data</font></body>'				
			else:				
				message = '<body bgcolor="#000000"><font color="#ffffff">'
				if checkinXml.getElementsByTagName('message').length > 0:
					message += checkinXml.getElementsByTagName('message')[0].firstChild.data
	
				scoringNode = checkinXml.getElementsByTagName('scoring')
				hasIcon = False
				if scoringNode.length > 0:
					iconNode = scoringNode[0].getElementsByTagName('icon')
	
					if iconNode.length > 0:
						# get icon
						iconUrl = iconNode[0].firstChild.data
						photoURLchunks = iconUrl.split('/')
						iconFile = userPreferencesDir + 'imageCache' + os.sep + 'icon' + os.sep + photoURLchunks[4] + '_' + photoURLchunks[5]
						if not os.path.exists(iconFile):
							self.downloadIcon(iconUrl)
						image = QtGui.QPixmap(iconFile)
						self.lblMessage1.addResource(QtGui.QTextDocument.ImageResource,QtCore.QUrl("mydata://" + photoURLchunks[4] + '_' + photoURLchunks[5]), QtCore.QVariant(image))
						message += '<br><img src="mydata://' + photoURLchunks[4] + '_' + photoURLchunks[5] + '"> '
						# QtGui.QItemEditorFactory.defaultFactory().setPixmap('checkinPointIcon', QtGui.QPixmap(iconFile))
	
	
					pointsNode = scoringNode[0].getElementsByTagName('points')
					if (pointsNode.length > 0):
						message += ' '
						points = pointsNode[0].firstChild.data
						if int(points) == 1:
							message += str(points) + ' point'
						else:
							message += str(points) + ' points'
					messageNode = scoringNode[0].getElementsByTagName('message')
					if messageNode.length > 0 and pointsNode.length > 0:
						message += ', '
					if messageNode.length > 0:
						message += messageNode[0].firstChild.data
	
				# add mayor info
				mayorNode = checkinXml.getElementsByTagName('mayor')
				if mayorNode.length > 0:
					message += ''
					image = QtGui.QPixmap(APP_DIRECTORY + 'crown_50x50.png')
					self.lblMessage1.addResource(QtGui.QTextDocument.ImageResource,QtCore.QUrl("mydata://crown_50x50.png"), QtCore.QVariant(image))
					mayorType = mayorNode[0].getElementsByTagName('type')[0].firstChild.data
					# print mayorType
					message += '<table><tr><td valign="bottom"><img src="mydata://crown_50x50.png"></td><td valign="bottom">'
					# self.lblMayorIcon.setPixmap(QtGui.QPixmap(APP_DIRECTORY + 'crown_50x50.png'))
					mayorMessageNodes = mayorNode[0].getElementsByTagName('message')
					if mayorMessageNodes.length > 0:
						mayorMessage = mayorMessageNodes[0].firstChild.data
						message += ' ' + mayorMessage
					message += '</td></tr></table>'
				badgeNodes = checkinXml.getElementsByTagName('badge')
				if badgeNodes.length > 0:
					message += '<table>'
					for node in badgeNodes:
						badgeIconURL = node.getElementsByTagName('icon')[0].firstChild.data
						badgeURLchunks = badgeIconURL.split('/')
						badgeFile = userPreferencesDir + 'imageCache' + os.sep + 'badges' + os.sep + badgeURLchunks[4] + '_' + badgeURLchunks[5]
						if not os.path.exists(badgeFile):
							self.downloadBadge(badgeIconURL)
						image = QtGui.QPixmap(badgeFile)
						self.lblMessage1.addResource(QtGui.QTextDocument.ImageResource,QtCore.QUrl("mydata://" + badgeURLchunks[4] + '_' + badgeURLchunks[5]), QtCore.QVariant(image))
						message += '<tr><td valign="middle"><img src="mydata://' + badgeURLchunks[4] + '_' + badgeURLchunks[5] + '"></td><td>&nbsp;</td><td valign="middle">' + node.getElementsByTagName('description')[0].firstChild.data + '</td></tr>'
					message += '</table>'
				message += '</font></body>'
			# print message
			self.lblMessage1.setHtml(message)
			qScene = QtGui.QGraphicsScene(self)
			qScene.setBackgroundBrush(QtGui.QColor(0,0,0))
			# qScene.setForegroundBrush(QtGui.QColor(255,255,255))
			qItem = QtGui.QGraphicsTextItem(None, qScene)
			qItem.setDocument(self.lblMessage1)
			qView = QtGui.QGraphicsView(qScene,self)
			qView.setHorizontalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
			qView.setVerticalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
			qView.setGeometry(5,5,790,240)
			qView.setAlignment(QtCore.Qt.AlignTop)
			

					
		# add dismiss button
		# self.bttnDismiss = QtGui.QPushButton('Dismiss', self)
		# self.bttnDismiss.setGeometry(595,135,200,100)	
		# self.bttnDismiss.setStyleSheet(QPUSHBUTTON_DEFAULT)	

		# self.connect(self.bttnDismiss, QtCore.SIGNAL('clicked()'),
		#	QtCore.SLOT('close()'))

	def downloadBadge(self, badgeIconURL):
		global lowBandwidthMode
		badgeURLchunks = badgeIconURL.split('/')
		badgeFile = userPreferencesDir + 'imageCache' + os.sep + 'badges' + os.sep + badgeURLchunks[4] + '_' + badgeURLchunks[5]
		
		if lowBandwidthMode:
			shutil.copy(APP_DIRECTORY + 'default_off.png',badgeFile)				
		else:
			# print 'badgeFile: ' + badgeFile			
			photoResponse = urllib2.urlopen(badgeIconURL)
			photoData = photoResponse.read()
	
			badgeFile = open(badgeFile,'w')
			badgeFile.write(photoData)
			badgeFile.close()

	def downloadIcon(self, iconUrl):
		# print 'downloadIcon'
		photoResponse = urllib2.urlopen(iconUrl)
		photoData = photoResponse.read()

		photoURLchunks = iconUrl.split('/')
		saveFile = photoURLchunks[4] + '_' + photoURLchunks[5]

		photoFile = open(userPreferencesDir + 'imageCache' + os.sep + 'icon' + os.sep + saveFile,'w')
		photoFile.write(photoData)
		photoFile.close()

class PlaceInfoLoaderWorkerThread(QtCore.QThread):
	def __init__(self, parent = None):
    		QtCore.QThread.__init__(self, parent)
		self.exiting = False

	def setup(self, id, placeDlg, forceRefresh, dialogToShow):
		self.id = id
		self.placeDlg = placeDlg
		self.forceRefresh = forceRefresh
		self.dialogToShow = dialogToShow

	def run(self):
		global qb
		global infoNoticeString
		updatedDateInt = 0
		currentTime = time.time()

		result = qb.dataManager.doScalarQueryOnMainThread("SELECT updatedDate from Venues where id='%s'" % str(self.id))
		if result[0]:
			updatedDateInt = int(time.mktime(time.strptime(str(result[1].toString()).split('.')[0],'%Y-%m-%d %H:%M:%S')))

		# print 'PlaceInfoLoaderWorkerThread.run() Executing thread logic'
		# print 'Venue ID: ' + self.id

	
		self.forceRefresh = True

		if (self.forceRefresh == False):
			# for refresh
			timediff = currentTime - updatedDateInt
			if (timediff > venueCacheDiffAge):
				self.forceRefresh = True

		mayorPhotoUrl = None
		mayorName = None
		mayorUserID = 0
		mayorCheckinCount = 0

		parseSuccess = False

		if (self.forceRefresh == True):
			client4 = oauthclient.SimpleOAuthClient('api.foursquare.com', 80, API_PREFIX_URL+'venue', ACCESS_TOKEN_URL, AUTHORIZATION_URL)
			consumer = oauth.OAuthConsumer(CONSUMER_KEY, CONSUMER_SECRET)
			signature_method_plaintext = oauth.OAuthSignatureMethod_PLAINTEXT()
			signature_method_hmac_sha1 = oauth.OAuthSignatureMethod_HMAC_SHA1()
	
			nearbyParams = {
				'vid':	str(self.id),
				'oauth_token':	fsKey,
				'oauth_token_secret':	fsSecret
			}
			oauth_request = oauth.OAuthRequest.from_consumer_and_token(consumer, callback=CALLBACK_URL, http_url=API_PREFIX_URL+'venue', parameters=nearbyParams)
			oauth_request.sign_request(signature_method_plaintext, consumer, fsRequestToken)
			# print oauth_request.to_postdata()
			nearbyResult = client4.access_resource(oauth_request, http_url=API_PREFIX_URL+'venue', requestType='GET')
			print nearbyResult
			# save result to cache 
			# parse mayor information and download pic if not cached
			try:
				nearbyXml = parseString(nearbyResult)
				parseSuccess = True
			except xml.parsers.expat.ExpatError:
				print 'error parsing nearbyResult'
				parseSuccess = False
				# url error
				infoNoticeString = 'Error: api.foursquare.com problem retrieving venue details'
				self.emit(QtCore.SIGNAL('displayInfoNotice()'))	

			if parseSuccess == True:
				errorNode = nearbyXml.getElementsByTagName('error')
				if errorNode.length == 1:
					parseSuccess = False
					infoNoticeString = errorNode[0].firstChild.data
					self.emit(QtCore.SIGNAL('displayInfoNotice()'))					
				elif nearbyResult.find("INTERNAL_SERVER_ERROR") >= 0:
					parseSuccess = False
					infoNoticeString = 'Error: api.foursquare.com problem retrieving venue details'
					self.emit(QtCore.SIGNAL('displayInfoNotice()'))	

			if parseSuccess == True:				
				# get list of tips for venue 
				tipsDict = {}
				records = qb.dataManager.doSelectQueryOnMainThread("SELECT id from VenueTips WHERE venueID='%s'" % str(self.id),"id")
				if records['RecordCount'] > 0:
					for row in records['Records']:
						tipsDict[str(row["id"].toString())] = True
				
				mayorNodes = nearbyXml.getElementsByTagName('mayor')
				checkinNodes = nearbyXml.getElementsByTagName('checkin')
				specialsNodes = nearbyXml.getElementsByTagName('special')
				tipNodes = nearbyXml.getElementsByTagName('tip')

				if tipNodes.length == 1:
					self.placeDlg.tipsText = '1 tip'
				else:
					self.placeDlg.tipsText = '%d tips' % tipNodes.length

				tagNodes = nearbyXml.getElementsByTagName('tag')

				self.placeDlg.venueCheckinCount = checkinNodes.length

				venueNode = nearbyXml.getElementsByTagName('venue')
				self.placeDlg.venueName = venueNode[0].getElementsByTagName('name')[0].firstChild.data

				geolong = venueNode[0].getElementsByTagName('geolong')[0].firstChild.data
				geolat = venueNode[0].getElementsByTagName('geolat')[0].firstChild.data
				self.placeDlg.strLatLon = "%s,%s" % (geolat,geolong)
				addressString = ''
			
				addressNode = venueNode[0].getElementsByTagName('address')
				if addressNode.length > 0:
					if addressNode[0].firstChild != None:
						addressString = addressNode[0].firstChild.data

				crossstreetNode = venueNode[0].getElementsByTagName('crossstreet')
				if crossstreetNode.length > 0:
					if crossstreetNode[0].firstChild != None:
						addressString += ' (' + crossstreetNode[0].firstChild.data + ')'
				cityNode = venueNode[0].getElementsByTagName('city')
				cityString = ''
				if cityNode.length > 0:
					if cityNode[0].firstChild != None:
						cityString = cityNode[0].firstChild.data
				stateNode = venueNode[0].getElementsByTagName('state')
				if (stateNode.length > 0):
					if cityString != '':
						cityString += ', '
					if stateNode[0].firstChild != None:	
						cityString += stateNode[0].firstChild.data
				zipNode = venueNode[0].getElementsByTagName('zip')
				if zipNode.length > 0:
					if zipNode[0].firstChild != None:
						cityString += ' ' + zipNode[0].firstChild.data
				phoneNode = venueNode[0].getElementsByTagName('phone')
				phoneString = ''
				if phoneNode.length > 0:
					if phoneNode[0].firstChild != None:
						phoneString = '' +  phoneNode[0].firstChild.data
				
				self.placeDlg.addressString = addressString
				self.placeDlg.cityString = cityString
				self.placeDlg.phoneString = phoneString	

				# totalCount = mayorNodes.length + checkinNodes.length + specialsNodes.length + tipNodes.length + tagNodes.length
				totalCount = mayorNodes.length + checkinNodes.length + tipNodes.length

				callingThreadName = None
				if totalCount > 0:
					callingThreadName = 'PlaceInfoLoaderWorkerThread'
					self.emit(QtCore.SIGNAL('setDatabaseExpectedResultCount'),('PlaceInfoLoaderWorkerThread',totalCount,0))
					self.emit(QtCore.SIGNAL('setProcessingDialogProgressBarMaxValue'),totalCount)	

				if mayorNodes.length == 1:
					mayorUserID = mayorNodes[0].getElementsByTagName('user')[0].getElementsByTagName('id')[0].firstChild.data
					mayorCheckinCount = int(mayorNodes[0].getElementsByTagName('count')[0].firstChild.data)
					photoURL = mayorNodes[0].getElementsByTagName('photo')[0].firstChild.data
					firstName = mayorNodes[0].getElementsByTagName('firstname')[0].firstChild.data
					lastName = ''
					lastNameNode = mayorNodes[0].getElementsByTagName('lastname')
					self.placeDlg.mayorName = firstName
					if lastNameNode.length == 1:
						if lastNameNode[0].firstChild != None:
							lastName = lastNameNode[0].firstChild.data
							self.placeDlg.mayorName += ' ' + lastName
					# add mayor to db
					self.placeDlg.mayorName += ' is the mayor (%d%s)' % (mayorCheckinCount, 'x')
					photoURLchunks = photoURL.split('/')
					photoFile = userPreferencesDir + 'imageCache' + os.sep + 'users' + os.sep + photoURLchunks[3] + '_' + photoURLchunks[4]
					self.placeDlg.mayorPhotoFile = photoFile
					if not os.path.exists(photoFile):
						qb.getUserPhoto(photoURL)
					self.emit(QtCore.SIGNAL('addUserToDatabase'),mayorUserID,firstName,lastName,photoFile,photoURL,callingThreadName)
					self.emit(QtCore.SIGNAL('addEditUserVenueStats'),mayorUserID,str(self.id),mayorCheckinCount)

				for checkinNode in checkinNodes:
					# print 'checkinNode'
					createdDateInt = int(time.mktime(time.strptime(checkinNode.getElementsByTagName('created')[0].firstChild.data,'%a, %d %b %y %H:%M:%S +0000')))
					createdDateUTC = datetime.datetime.fromtimestamp(createdDateInt)
					print 'createdDateUTC: %s' % createdDateUTC
					checkinUserNode = checkinNode.getElementsByTagName('user')
					checkinID = checkinNode.getElementsByTagName('id')[0].firstChild.data
					checkinUserID = checkinUserNode[0].getElementsByTagName('id')[0].firstChild.data
					checkinPhotoUrl = checkinUserNode[0].getElementsByTagName('photo')[0].firstChild.data
					shout = ''
					shoutNode = checkinNode.getElementsByTagName('shout')
					if shoutNode.length == 1:
						if shoutNode[0].firstChild != None:
							shout = shoutNode[0].firstChild.data
					firstName = checkinUserNode[0].getElementsByTagName('firstname')[0].firstChild.data
					lastName = ''
					lastNameNode = checkinUserNode[0].getElementsByTagName('lastname')
					if lastNameNode.length == 1:
						if lastNameNode[0].firstChild != None:
							lastName = lastNameNode[0].firstChild.data

					# download photo if file cache not existent
					checkinURLchunks = checkinPhotoUrl.split('/')
					checkinPhotoFile = userPreferencesDir + 'imageCache' + os.sep + 'users' + os.sep + checkinURLchunks[3] + '_' + checkinURLchunks[4]
					# print 'checkinPhotoFile: ' + checkinPhotoFile
					if not os.path.exists(checkinPhotoFile):
						qb.getUserPhoto(checkinPhotoUrl)
					self.emit(QtCore.SIGNAL('addUserToDatabase'),checkinUserID,firstName,lastName,checkinPhotoFile,checkinPhotoUrl,callingThreadName)
					self.emit(QtCore.SIGNAL('addVenueRecentCheckin'),checkinID,checkinUserID,str(self.id),shout,str(createdDateUTC))
					# add check in to DB
	
				for tipNode in tipNodes:
					print 'tipNode'
					tipID = tipNode.getElementsByTagName('id')[0].firstChild.data
					if not tipID in tipsDict:
						# see if we already have this tip for the venue, if so, don't add it
						tipText = tipNode.getElementsByTagName('text')[0].firstChild.data
						tipCreatedInt = int(time.mktime(time.strptime(tipNode.getElementsByTagName('created')[0].firstChild.data,'%a, %d %b %y %H:%M:%S +0000')))
						tipCreatedUTC = datetime.datetime.fromtimestamp(tipCreatedInt)
	
						tipUrlNode = tipNode.getElementsByTagName('url')
						tipUrl = ''
						if tipUrlNode.length == 1:
							if tipUrlNode[0].firstChild != None:
								tipUrl = tipUrlNode[0].firstChild.data
						tipUserNode = tipNode.getElementsByTagName('user')
						tipUserID = tipUserNode[0].getElementsByTagName('id')[0].firstChild.data
						tipPhotoUrl = tipUserNode[0].getElementsByTagName('photo')[0].firstChild.data
						firstName = tipUserNode[0].getElementsByTagName('firstname')[0].firstChild.data
						lastName = ''
						lastNameNode = tipUserNode[0].getElementsByTagName('lastname')
						if lastNameNode.length == 1:
							if lastNameNode[0].firstChild != None:
								lastName = lastNameNode[0].firstChild.data
	
						# download photo if file cache not existent
						tipURLchunks = tipPhotoUrl.split('/')
						tipPhotoFile = userPreferencesDir + 'imageCache' + os.sep + 'users' + os.sep + tipURLchunks[3] + '_' + tipURLchunks[4]
						# print 'checkinPhotoFile: ' + checkinPhotoFile
						print tipPhotoUrl
						if not os.path.exists(tipPhotoFile):
							qb.getUserPhoto(tipPhotoUrl)
						self.emit(QtCore.SIGNAL('addUserToDatabase'),tipUserID,firstName,lastName,tipPhotoFile,tipPhotoUrl,callingThreadName)
						# print 'checkinID: %s' % tipID
						# print 'venueID: %s' % str(self.id)
						# print 'tipUserID: %s' % tipUserID
						# print 'tipText: %s' % tipText
						# print 'url: %s' % tipUrl
						self.emit(QtCore.SIGNAL('addEditVenueTip'),tipID,0,str(self.id),tipUserID,1,tipText,str(tipCreatedUTC),tipUrl,0,None)
					else:
						self.emit(QtCore.SIGNAL('incrementDatabaseExpectedResultCount'),callingThreadName)
				if totalCount > 0:
					self.exec_()
				self.placeDlg.displayOK = True
			else:
				print 'parseSuccess is False'
		else:
			print 'read info from db'

		# emit signal
		self.emit(QtCore.SIGNAL('nearbyItemLoadingFinished'),self.dialogToShow)

	def __del__(self):
		print 'PlaceInfoLoaderWorkerThread.__del__()'
		self.exiting = True
		self.wait()

class BadgesDialog(QtGui.QDialog):
	def __init__(self, uid, friendName, parent=None):
		QtGui.QDialog.__init__(self, parent)	
		
		if friendName == None:
			self.setWindowTitle('My Badges')
		else:
			self.setWindowTitle('%s\'s Badges' % friendName)
			
		self.resize(800,480)
		self.badgesListWidget = QtGui.QListWidget(self)
		self.badgesListWidget.setGeometry(5, 5, 820, 370)
		
		records = parent.dataManager.doSelectQueryOnMainThread("SELECT Badges.id, Badges.badgeFile, Badges.name, Badges.description FROM Badges INNER JOIN UserBadges ON UserBadges.badgeID=Badges.id WHERE UserBadges.userID='%s'" % parent.dataManager.safeStr(uid),"id,badgeFile,name,description")
		# print records
		if records['RecordCount'] > 0:
			for row in records['Records']:
				badgeItem = QtGui.QListWidgetItem('',self.badgesListWidget)
				badgeItem.setSizeHint(QtCore.QSize(770, 75))
				wItem = BadgeListItem()
				description = row['description'].toString()
				if friendName != None:
					description = description.replace('You\'ve', '%s has' % friendName)
					description = description.replace('yourself', friendName)
					description = description.replace('your', '%s\'s' % friendName)
					description = description.replace('you', friendName)
				
				wItem.setText(row['name'].toString(),description,row['badgeFile'].toString())
				self.badgesListWidget.setItemWidget(badgeItem,wItem)
				badgeItem.setStatusTip(row['id'].toString())
				
class FriendApprovalThread(QtCore.QThread):
	def __init__(self, parent = None):
    		QtCore.QThread.__init__(self, parent)
		self.exiting = False

	def setup(self, userID, approvalType, friendName):
		self.userID = userID
		self.approvalType = approvalType
		self.friendName = friendName

	def run(self):
		global infoNoticeString
		if self.approvalType == 1:
			url = 'friend/approve'
		else:
			url = 'friend/deny'
		 
		client3 = oauthclient.SimpleOAuthClient('api.foursquare.com', 80, API_PREFIX_URL+url, ACCESS_TOKEN_URL, AUTHORIZATION_URL)
		consumer = oauth.OAuthConsumer(CONSUMER_KEY, CONSUMER_SECRET)
		signature_method_plaintext = oauth.OAuthSignatureMethod_PLAINTEXT()
		signature_method_hmac_sha1 = oauth.OAuthSignatureMethod_HMAC_SHA1()

		params = {
			'uid'	:	self.userID,
			'oauth_token':	fsKey,
			'oauth_token_secret':	fsSecret
		}
		oauth_request = oauth.OAuthRequest.from_consumer_and_token(consumer, callback=CALLBACK_URL, http_url=API_PREFIX_URL+url, parameters=params)
		oauth_request.sign_request(signature_method_plaintext, consumer, fsRequestToken)
		# print oauth_request.to_postdata()
		approveResultXmlString = client3.access_resource(oauth_request, http_url=API_PREFIX_URL+url, requestType='POST')
		print approveResultXmlString		
		parseSuccess = False
		try:
			approveResultXml = parseString(approveResultXmlString)
			parseSuccess = True
			if self.approvalType == 1:
				infoNoticeString = self.friendName + ' is now your friend'
			else:
				infoNoticeString = 'You have denied ' + self.friendName + '\'s request'
			self.emit(QtCore.SIGNAL('displayInfoNotice()'))				
		except xml.parsers.expat.ExpatError:
			print 'error parsing checkinResult'
			parseSuccess = False
			infoNoticeString = 'Error: api.foursquare.com problem. Problem '
			if self.approvalType == 1:
				infoNoticeString += 'approving friend'
			else:
				infoNoticeString += 'denying friend'
			self.emit(QtCore.SIGNAL('displayInfoNotice()'))							
	def __del__(self):
		self.exiting = True
		self.wait()				
		
class FriendDetailWidget(QtGui.QWidget):		
	def __init__(self, parent=None):
		QtGui.QWidget.__init__(self, parent)	
		self.resize(800,800)
		self.lblFoo = QtGui.QLabel("foo",self)
		self.lblFoo.setGeometry(5,300,200,50)	
		
	def paint(self, painter, option, widget):
		   print 'hi'

class CustomWebViewDialog(QtGui.QMainWindow):
	def __init__(self, title, url, parent=None):
		QtGui.QMainWindow.__init__(self, parent)
		
		self.setWindowTitle(title)	
		self.web = QtWebKit.QWebView(self)
		self.web.setTextSizeMultiplier(2)		
		self.web.load(QtCore.QUrl(url))
		self.web.setGeometry(5,2,800,335)		
		
		self.bttnBack = QtGui.QPushButton('Back',self)   
		self.bttnBack.setStyleSheet(QPUSHBUTTON_BLUE) 
		self.bttnBack.setGeometry(605,340,90,80)
		
		self.bttnForward = QtGui.QPushButton('Forward',self)
		self.bttnForward.setStyleSheet(QPUSHBUTTON_DEFAULT)        		
		self.bttnForward.setGeometry(705,340,90,80)
		    
		self.connect(self.bttnBack, QtCore.SIGNAL('clicked()'), self.web.back)			
		self.connect(self.bttnForward, QtCore.SIGNAL('clicked()'), self.web.forward)
		

class FriendDetailDialog(QtGui.QMainWindow):
	def __init__(self, friendId, friendType, parent=None):
		QtGui.QMainWindow.__init__(self, parent)	
		self.setAttribute(QtCore.Qt.WA_DeleteOnClose)		
		self.resize(800,480)
		self.userID = friendId	
		self.dataManager = parent.dataManager
		self.friendType = friendType

		self.lblMessage1 = QtGui.QTextDocument(self)
		self.lblMessage1.setTextWidth(800)
		
		qScene = QtGui.QGraphicsScene(self)
		qScene.setBackgroundBrush(QtGui.QColor(0,0,0))
		# qScene.setForegroundBrush(QtGui.QColor(255,255,255))
		qItem = QtGui.QGraphicsTextItem(None, qScene)
		qItem.setDocument(self.lblMessage1)
		qView = QtGui.QGraphicsView(qScene,self)
		qView.setHorizontalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
		qView.setVerticalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
		qView.setGeometry(5,5,800,340)
		qView.setAlignment(QtCore.Qt.AlignTop)			
				
		self.bttnBadges = QtGui.QPushButton('0 Badges',self)
		self.bttnBadges.setGeometry(0,0,0,0)
		self.bttnBadges.setStyleSheet(QPUSHBUTTON_DEFAULT)        
		self.bttnAccept = QtGui.QPushButton('Accept',self)   
		self.bttnAccept.setStyleSheet(QPUSHBUTTON_BLUE)     
		if friendType == 2:
			self.bttnAccept.setGeometry(10,340,175,80)
			self.connect(self.bttnAccept, QtCore.SIGNAL('clicked()'), self.approveFriend)
			self.bttnBadges.setGeometry(0,0,0,0)
		else:
			self.bttnAccept.setGeometry(0,0,0,0)
		self.connect(self.bttnBadges, QtCore.SIGNAL('clicked()'), self.showBadges)			
		        
		self.bttnIgnore = QtGui.QPushButton('Deny',self)
		self.bttnIgnore.setStyleSheet(QPUSHBUTTON_DEFAULT)        
		if friendType == 2:
			self.bttnIgnore.setGeometry(200,340,175,80)
			self.bttnBadges.setGeometry(0,0,0,0)
			self.connect(self.bttnIgnore, QtCore.SIGNAL('clicked()'), self.denyFriend)			
		else:
			self.bttnIgnore.setGeometry(0,0,0,0)
		    	
		global qb
		# show dialog
		# load friend from server
		qb.processDlg.setTitleAndLabelText('Retrieving...','Please wait while we retrieve the user\'s details from the server.')
		qb.processDlg.startAnimation()
		qb.processDlg.show()
		
		# connect the thread to local slot
		self.connect(qb.loadUserInfoFromServerWorker, QtCore.SIGNAL('finished()'), self.friendLoadedFromServerFinished)
		qb.loadUserInfoFromServerWorker.setup(friendId,True,True)
		qb.loadUserInfoFromServerWorker.start()
		
		self.bttnTwitter = QtGui.QPushButton('Twitter',self)   
		self.bttnTwitter.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnTwitter.setGeometry(0,0,0,0)
		self.connect(self.bttnTwitter, QtCore.SIGNAL('clicked()'), self.showTwitter)				

		self.bttnFacebook = QtGui.QPushButton('Facebook',self)   
		self.bttnFacebook.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnFacebook.setGeometry(0,0,0,0)
		self.connect(self.bttnFacebook, QtCore.SIGNAL('clicked()'), self.showFacebook)			

		#=======================================================================
		# self.bttnEmail = QtGui.QPushButton('E-mail',self)   
		# self.bttnEmail.setStyleSheet(QPUSHBUTTON_DEFAULT)
		# self.bttnEmail.setGeometry(0,0,0,0)
		# 
		# self.bttnText = QtGui.QPushButton('Text',self)   
		# self.bttnText.setStyleSheet(QPUSHBUTTON_DEFAULT)
		# self.bttnText.setGeometry(0,0,0,0)
		#=======================================================================
		
	def showTwitter(self):
		self.customWeb = CustomWebViewDialog('Twitter feed for %s' % self.friendName, self.twitterUrl, self)
		self.customWeb.show()
		
	def showFacebook(self):
		self.customWeb = CustomWebViewDialog('Facebook: %s' % self.friendName, self.facebookUrl, self)
		self.customWeb.show()
		
		
	def showBadges(self):				
		self.badgesDlg = BadgesDialog(self.userID,self.friendFirstName,self)
		self.badgesDlg.exec_()
		del self.badgesDlg		
		
	def approvalThreadFinished(self):
		self.disconnect(self.approvalThread, QtCore.SIGNAL('finished()'), self.approvalThreadFinished)				
		del self.approvalThread
		self.close()
		
	def approveFriend(self):
		reply = QtGui.QMessageBox.question(self, 'Approve Friend',"Are you sure you want to approve this request? Once approved, the user will have access to your checkin history and contact information.", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)

		if reply == QtGui.QMessageBox.Yes:
			self.approvalThread = FriendApprovalThread()
			self.connect(self.approvalThread, QtCore.SIGNAL('finished()'), self.approvalThreadFinished)		
			self.approvalThread.setup(self.userID,1,self.friendName)
			self.approvalThread.start()
		
	def denyFriend(self):
		reply = QtGui.QMessageBox.question(self, 'Deny Friend',"Are you sure you want to deny this request?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)

		if reply == QtGui.QMessageBox.Yes:	
			self.approvalThread = FriendApprovalThread()
			self.connect(self.approvalThread, QtCore.SIGNAL('finished()'), self.approvalThreadFinished)				
			self.approvalThread.setup(self.userID,2,self.friendName)
			self.approvalThread.start()		

	def friendLoadedFromServerFinished(self):
		global qb
		qb.processDlg.stopAnimation()
		qb.processDlg.close()
		self.disconnect(qb.loadUserInfoFromServerWorker, QtCore.SIGNAL('finished()'), self.friendLoadedFromServerFinished)
		
		message = '<body bgcolor="#000000"><font color="#ffffff">'
		
		firstName = ''
		lastName = ''
		photoFilePath = ''
		twitter = ''
		facebook = ''
		email = ''
		phone = ''
		records = self.dataManager.doSelectQueryOnMainThread("SELECT u.firstName, u.lastName, u.photoFile, d.twitter, d.facebook, d.email, d.phone, d.gender, d.notes FROM Users u inner join UserDetails d on d.userID=u.id where u.id='%s'" % self.userID, "firstName,lastName,photoFile,twitter,facebook,email,phone,gender,notes")
		if records['RecordCount'] == 1:
			for row in records['Records']:
				firstName = unicode(row['firstName'].toString())
				lastName = unicode(row['lastName'].toString())	
				photoFilePath = str(row['photoFile'].toString())
				twitter = str(row['twitter'].toString())
				facebook = str(row['facebook'].toString())
				email = str(row['email'].toString())
				phone = str(row['phone'].toString())
				
		del records
		self.friendName = firstName + ' ' + lastName			
		# display info
		self.setWindowTitle(firstName + ' ' + lastName)
		self.friendFirstName = firstName
		message += '<table><tr><td valign="middle">'
		
		userBadgeCount = 0
		# get badge count
		records = qb.dataManager.doSelectQueryOnMainThread("SELECT count(badgeID) as BadgeCount from UserBadges WHERE userID='%s'" % self.userID,"BadgeCount")
		for row in records['Records']:
			userBadgeCount = int(row['BadgeCount'].toString())
		print 'badgeCount: %d' % badgeCount
		if userBadgeCount > 0:
			self.bttnBadges.setText('%d Badges' % userBadgeCount)
			self.bttnBadges.setGeometry(10,340,125,80)
			
		if self.friendType == 2:
			self.bttnAccept.setGeometry(605,340,90,80)
			self.bttnIgnore.setGeometry(705,340,90,80)

		# modify photofile path:
		print 'photoFilePath: %s' % photoFilePath
		fileChunks = photoFilePath.split("/")
		photoFile = fileChunks[6]
		print 'photoFile: %s' % photoFile
		photoFileChunks = photoFile.split("_")
		extension = ''
		print 'len(photoFileChunks): %d' % len(photoFileChunks)
		if len(photoFileChunks) == 4:
			bigFile = "/%s/%s/%s/%s/%s/%s_%s_%s" % (fileChunks[1],fileChunks[2],fileChunks[3],fileChunks[4],fileChunks[5],photoFileChunks[0],photoFileChunks[2],photoFileChunks[3])
			extension = photoFileChunks[3].split(".")[1]
		elif len(photoFileChunks) == 3:
			bigFile = "/%s/%s/%s/%s/%s/%s_%s" % (fileChunks[1],fileChunks[2],fileChunks[3],fileChunks[4],fileChunks[5],photoFileChunks[0],photoFileChunks[2])
			extension = photoFileChunks[2].split(".")[1]
		print 'bigFile: %s' % bigFile
		
		
		if os.path.exists(bigFile):
			print 'display pixmap'
			image = QtGui.QPixmap(bigFile)			
			self.lblMessage1.addResource(QtGui.QTextDocument.ImageResource,QtCore.QUrl("mydata://user_photo." + extension), QtCore.QVariant(image))
			message += '<img src="mydata://user_photo.' + extension + '" width="100" height="100">'				
		else:
			message += '&nbsp';
		
		message += '</td><td>&nbsp;</td><td valign="middle" style="font-size:50px;">'
		message += self.friendName
		message += '</td></tr><tr><td colspan="3"><table>'
		
		itemCount = 0
		offset = 145
		bttnLength = 100
		if len(twitter) > 0:
			twitterIcon = QtGui.QPixmap(APP_DIRECTORY + 'twitter-icon.png')			
			self.lblMessage1.addResource(QtGui.QTextDocument.ImageResource,QtCore.QUrl("mydata://twitter_icon.png"), QtCore.QVariant(twitterIcon))
			message += '<tr><td align="right"><img src="mydata://twitter_icon.png" width="35" height="35"></td><td>&nbsp;%s</td></tr>' % twitter
			itemCount = itemCount + 1
			self.bttnTwitter.setGeometry(offset,340,bttnLength,80)
			offset = offset + (bttnLength + 10)
			self.twitterUrl = 'http://m.twitter.com/%s' % twitter
		if len(facebook) > 0:
			fbIcon = QtGui.QPixmap(APP_DIRECTORY + 'facebook-icon.png')			
			self.lblMessage1.addResource(QtGui.QTextDocument.ImageResource,QtCore.QUrl("mydata://facebook_icon.png"), QtCore.QVariant(fbIcon))						
			message += '<tr><td align="right"><img src="mydata://facebook_icon.png" width="35" height="35"></td><td>&nbsp;YES</td></tr>'
			itemCount = itemCount + 1
			self.bttnFacebook.setGeometry(offset,340,bttnLength,80)
			offset = offset + (bttnLength + 10)
			self.facebookUrl = 'http://touch.facebook.com/profile.php?id=%s' % facebook
		if len(email) > 0:
			emailIcon = QtGui.QPixmap(APP_DIRECTORY + 'email-icon.png')			
			self.lblMessage1.addResource(QtGui.QTextDocument.ImageResource,QtCore.QUrl("mydata://email_icon.png"), QtCore.QVariant(emailIcon))									
			message += '<tr><td align="right"><img src="mydata://email_icon.png" width="35" height="35"></td><td>&nbsp;%s</td></tr>' % email
			#===================================================================
			# itemCount = itemCount + 1
			# self.bttnEmail.setGeometry(offset,340,bttnLength,80)
			# offset = offset + (bttnLength + 10)	
			#===================================================================
		if len(phone) > 0:
			phoneIcon = QtGui.QPixmap(APP_DIRECTORY + 'phone-icon.png')			
			self.lblMessage1.addResource(QtGui.QTextDocument.ImageResource,QtCore.QUrl("mydata://phone_icon.png"), QtCore.QVariant(phoneIcon))												
			message += '<tr><td align="right"><img src="mydata://phone_icon.png" width="35" height="35"></td><td>&nbsp;%s</td></tr>' % phone
			#===================================================================
			# itemCount = itemCount + 1
			# self.bttnText.setGeometry(offset,340,bttnLength,80)
			#===================================================================
		
		message +='</table></td></tr></table>'

		message += '</font></body>'

		print message
		self.lblMessage1.setHtml(message)		
		
	def __del__(self):
		print 'FriendDetailDialog destructor'	
			
			
class MyFriendsDialog(QtGui.QMainWindow):
	def __init__(self, uid, defaultTabIndex, parent=None):
		global qb
		QtGui.QMainWindow.__init__(self, parent)	
		self.setWindowTitle('My Friends')
		self.resize(800,480)
		
		self.dataManager = parent.dataManager

		self.tabWidget = QtGui.QTabWidget(self)
		self.tabWidget.setGeometry(0, 0, 800, 330)
		self.tabWidget.setStyleSheet("QTabBar::tab { height: 0px; width: 180px; }");

		self.friendsTab = QtGui.QWidget()
		self.tabWidget.addTab(self.friendsTab, QtCore.QString())

		self.requestsTab = QtGui.QWidget()
		self.tabWidget.addTab(self.requestsTab, QtCore.QString())

		self.pendingTab = QtGui.QWidget()
		self.tabWidget.addTab(self.pendingTab, QtCore.QString())

		self.friendsListWidget = QtGui.QListWidget(self.friendsTab)
		self.friendsListWidget.setGeometry(5, 5, 820, 330)
		self.friendsListWidget.setStyleSheet(QLISTWIDGET_DEFAULT)

		p = self.friendsListWidget.palette()
		p.setColor(QtGui.QPalette.Highlight, QtGui.QColor(255, 255, 184))
		p = self.friendsListWidget.setPalette(p)

		self.pendingListWidget = QtGui.QListWidget(self.pendingTab)
		self.pendingListWidget.setGeometry(5, 5, 820, 330)
		self.pendingListWidget.setStyleSheet(QLISTWIDGET_DEFAULT)

		p = self.pendingListWidget.palette()
		p.setColor(QtGui.QPalette.Highlight, QtGui.QColor(255, 255, 184))
		p = self.pendingListWidget.setPalette(p)

		self.bttnFriends = QtGui.QPushButton('', self)			
		self.bttnFriends.setGeometry(5, 338, 86, 80)
		if defaultTabIndex == 0:
			self.bttnFriends.setStyleSheet(QPUSHBUTTON_HIGHLIGHT)
			self.tabWidget.setCurrentWidget(self.friendsTab)
		else:
			self.bttnFriends.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnFriends.setIcon(QtGui.QIcon(QtGui.QPixmap(APP_DIRECTORY + 'friendsIcon.png')))
		self.bttnFriends.setIconSize(QtCore.QSize(70,70))
		self.connect(self.bttnFriends, QtCore.SIGNAL('clicked()'), self.doShowFriendsTab)

		self.bttnPending = QtGui.QPushButton('', self)			
		self.bttnPending.setGeometry(100, 338, 80, 80)
		self.bttnPending.setIcon(QtGui.QIcon(QtGui.QPixmap(APP_DIRECTORY + 'friendsPendingIcon.png')))
		self.bttnPending.setIconSize(QtCore.QSize(70,70))
		
		if defaultTabIndex == 1:
			self.bttnPending.setStyleSheet(QPUSHBUTTON_HIGHLIGHT)
			self.tabWidget.setCurrentWidget(self.pendingTab)	
		else:
			self.bttnPending.setStyleSheet(QPUSHBUTTON_DEFAULT)
#		self.bttnPending.setIcon(QtGui.QIcon(QtGui.QPixmap(APP_DIRECTORY + 'friendsIcon.png')))
#		self.bttnPending.setIconSize(QtCore.QSize(70,70))
		self.connect(self.bttnPending, QtCore.SIGNAL('clicked()'), self.doShowPendingTab)

		records = self.dataManager.doSelectQueryOnMainThread("SELECT Users.id, Users.firstName, Users.lastName, Users.photoFile, UserFriendStatus.status, Venues.name, UserLastCheckinDate.createdDate, ud.phone, ud.twitter, ud.email FROM Users INNER JOIN UserFriendStatus ON UserFriendStatus.userID=users.id LEFT JOIN UserLastCheckinDate ON UserLastCheckinDate.userID=Users.id LEFT JOIN UserCheckinHistory ON UserCheckinHistory.id=UserLastCheckinDate.checkinID LEFT JOIN Venues on Venues.id=UserCheckinHistory.venueID LEFT JOIN UserDetails ud on ud.userID=Users.id order by Users.firstName, Users.lastName","id,firstName,lastName,photoFile,status,name,createdDate,phone,twitter,email")
		# print records
		if records['RecordCount'] > 0:
			for row in records['Records']:
				status = row['status'].toInt()[0]
				if status == 1:
					# print row['firstName'].toString()
					friendItem = QtGui.QListWidgetItem('',self.friendsListWidget)
					friendItem.setSizeHint(QtCore.QSize(770, 75))
					wItem = FriendListItem()

					venueName = unicode(row['name'].toString())
					if len(venueName):
						# do date diff calc
						venueName += " ~" + qb.calcDateString(str(row['createdDate'].toString()), True, 0)

					firstName = unicode(row['firstName'].toString())
					lastName = unicode(row['lastName'].toString())
					if len(lastName) > 0:
						firstName += " " + lastName
					
					wItem.setText(firstName,venueName,'',row['photoFile'].toString())
					self.friendsListWidget.setItemWidget(friendItem,wItem)
					friendItem.setStatusTip(row['id'].toString())	
				elif status == 2 or status == 3:
					# print row['firstName'].toString()
					friendItem = QtGui.QListWidgetItem('',self.pendingListWidget)
					friendItem.setSizeHint(QtCore.QSize(770, 75))
					wItem = FriendListItem()
					
					firstName = unicode(row['firstName'].toString())
					lastName = unicode(row['lastName'].toString())
					twitter = unicode(row['twitter'].toString())
					phone = unicode(row['phone'].toString())
					email = unicode(row['email'].toString())
					
					if len(lastName) > 0:
						firstName += " " + lastName			
						
					detailsString = ''
					if len(phone) > 0:
						detailsString = 'phone: %s' % phone
						
					if len(email) > 0:
						if len(detailsString) > 0:
							detailsString = '%s, ' % detailsString
						detailsString = '%semail: %s' % (detailsString,email)	

					if len(twitter) > 0:
						if len(detailsString) > 0:
							detailsString = '%s, ' % detailsString
						detailsString = '%stwitter: %s' % (detailsString,twitter)	
						
					print detailsString													
			
					wItem.setText(firstName,detailsString,'',row['photoFile'].toString())
					self.pendingListWidget.setItemWidget(friendItem,wItem)
					friendItem.setStatusTip(row['id'].toString())	
					
		self.connect(self.friendsListWidget, QtCore.SIGNAL('itemClicked(QListWidgetItem*)'),self.doFriendListClicked)
		self.connect(self.pendingListWidget, QtCore.SIGNAL('itemClicked(QListWidgetItem*)'),self.doPendingListClicked)		

	def doFriendListClicked(self,item):
		self.friendDialog = FriendDetailDialog(item.statusTip(),1,self)
		self.friendDialog.show()
		
	def doPendingListClicked(self,item):
		self.friendDialog = FriendDetailDialog(item.statusTip(),2,self)
		self.friendDialog.show()		

	def doShowFriendsTab(self):
		self.setWindowTitle('My Friends')	
		self.bttnFriends.setStyleSheet(QPUSHBUTTON_HIGHLIGHT)
		self.bttnPending.setStyleSheet(QPUSHBUTTON_DEFAULT)
		# self.bttnPlaces.setStyleSheet(QPUSHBUTTON_DEFAULT)
		# self.bttnSearch.setStyleSheet(QPUSHBUTTON_DEFAULT)
		# self.bttnHistory.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.tabWidget.setCurrentWidget(self.friendsTab)

	def doShowPendingTab(self):
		self.setWindowTitle('Pending Friend Requests')		
		self.bttnFriends.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnPending.setStyleSheet(QPUSHBUTTON_HIGHLIGHT)	
		self.tabWidget.setCurrentWidget(self.pendingTab)

	def closeEvent(self, event):
		del self.friendsListWidget
		del self.pendingListWidget
		del self.tabWidget		
		del self.bttnFriends
		del self.bttnPending	
		event.accept()
		self.emit(QtCore.SIGNAL('finished()'))

	def __del__(self):
		print 'MyFriendsDialog destructor'


class MyLocationDialog(QtGui.QMainWindow):
	def __init__(self, strLatLon, parent=None):
		global loggedInUserID
		QtGui.QMainWindow.__init__(self, parent)
		self.dataManager = parent.dataManager	
		self.strLatLon = strLatLon
		self.setWindowTitle('My Information')
		self.resize(800,480)
		self.web = QtWebKit.QWebView(self)
		
		self.web.load(QtCore.QUrl('http://maps.google.com/maps/api/staticmap?center=' + self.strLatLon + '&size=600x400&maptype=roadmap&markers=color:red|' + self.strLatLon + '&zoom=16&sensor=false&key=' + GOOGLE_MAPS_API_KEY))
		self.web.setGeometry(5,5,600,400)

		# self.lblInfo = QtGui.QLabel('NOTE: Your actual location may be different than that which is indicated on the map due to differences in how the location of your device is obtained (GPS, Cell Tower, etc)',self);
		# self.lblInfo.setGeometry(5,250,600,120)
		# self.lblInfo.setWordWrap(True)

		self.web.show()

		# add buttons for badges, map, etc
		self.bttnMap = QtGui.QPushButton('Google Map',self)
		# self.bttnMap.setGeometry(610,5,185,80)
		self.bttnMap.setGeometry(0,0,0,0)
		self.bttnMap.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnMap.hide()
		
		userBadgeCount = 0
		# get badge count
		records = qb.dataManager.doSelectQueryOnMainThread("SELECT count(badgeID) as BadgeCount from UserBadges WHERE userID='%s'" % loggedInUserID,"BadgeCount")
		for row in records['Records']:
			userBadgeCount = int(row['BadgeCount'].toString())
					
		if userBadgeCount == 1:
			badgeStr = '%d Badge' % userBadgeCount
		else:
			badgeStr = '%d Badges' % userBadgeCount
		# add buttons for badges, map, etc
		self.bttnBadges = QtGui.QPushButton(badgeStr,self)
		self.bttnBadges.setGeometry(610,5,185,80) #.setGeometry(610,95,185,80)
		self.bttnBadges.setStyleSheet(QPUSHBUTTON_DEFAULT)

		# location updated automatically so ignore this
		# self.bttnRefresh = QtGui.QPushButton('Refresh Location',self)
		# self.bttnRefresh.setGeometry(610,185,185,80)
		# self.bttnRefresh.setStyleSheet(QPUSHBUTTON_DEFAULT)

		self.bttnFriends = QtGui.QPushButton('My Friends',self)
		self.bttnFriends.setGeometry(610,95,185,80) #.setGeometry(610,185,185,80)
		self.bttnFriends.setStyleSheet(QPUSHBUTTON_DEFAULT)

		self.connect(self.bttnBadges, QtCore.SIGNAL('clicked()'),
			self.doBadgesButtonClicked)

		self.connect(self.bttnFriends, QtCore.SIGNAL('clicked()'),
			self.doFriendsButtonClicked)

		# self.connect(self.bttnRefresh, QtCore.SIGNAL('clicked()'),
		#	self.doRefreshLocationClicked)

	def doFriendsButtonClicked(self):
		self.friendsDialog = MyFriendsDialog(0,0,self)
		self.friendsDialog.show()

	def doRefreshLocationClicked(self):
		print 'doRefreshLocationClicked'
		global locationManagerObj
		locationManagerObj.acquireLocationFix()

	def doBadgesButtonClicked(self):
		print 'doBagdesButtonClicked'
		global loggedInUserID
		self.badgesDlg = BadgesDialog(loggedInUserID,None,self)
		self.badgesDlg.exec_()
		del self.badgesDlg

	def __del__(self):
		del self.dataManager
		

class WhosHereDialog(QtGui.QMainWindow):
	def __init__(self, venueID, parent=None):
		QtGui.QMainWindow.__init__(self, parent)	
		global qb
		self.dataManager = qb.dataManager

		self.setWindowTitle('Who\'s Here')
		self.resize(800,480)
		self.whosHereListWidget = QtGui.QListWidget(self)
		self.whosHereListWidget.setGeometry(5, 5, 820, 370)
		self.whosHereListWidget.setStyleSheet(QLISTWIDGET_DEFAULT)
		self.connect(self.whosHereListWidget, QtCore.SIGNAL('itemClicked(QListWidgetItem*)'),self.doFriendListClicked)		

		p = self.whosHereListWidget.palette()
		p.setColor(QtGui.QPalette.Highlight, QtGui.QColor(255, 255, 184))
		p = self.whosHereListWidget.setPalette(p)

		minDate = str(datetime.datetime.fromtimestamp(time.time() - 10800))
		results = qb.dataManager.doSelectQueryOnMainThread("SELECT VenueRecentCheckins.userID, VenueRecentCheckins.createdDate, Users.firstName, Users.lastName, Users.photoFile, VenueRecentCheckins.shout FROM VenueRecentCheckins INNER JOIN Users ON Users.id=VenueRecentCheckins.userID WHERE VenueRecentCheckins.venueID='%s' AND VenueRecentCheckins.createdDate >='%s' ORDER BY VenueRecentCheckins.createdDate desc" % (venueID,minDate),'userID,createdDate,firstName,lastName,photoFile,shout')
		if results['RecordCount'] > 0:
			for row in results['Records']:
				checkinItem = QtGui.QListWidgetItem('',self.whosHereListWidget)
				checkinItem.setSizeHint(QtCore.QSize(770, 75))
				wItem = FriendListItem()
				checkinString = unicode(row['firstName'].toString())
				checkinString += ' ' + unicode(row['lastName'].toString())
				
				shout = unicode(row['shout'].toString())
				if len(shout) > 0:
					checkinString += ' ("' + shout + '")'
				
				photoFile = str(row['photoFile'].toString())
				dateStr = "~" + qb.calcDateString(str(row['createdDate'].toString()),True, 1)
				
				wItem.setText(checkinString,dateStr,'',photoFile)
				self.whosHereListWidget.setItemWidget(checkinItem,wItem)
				checkinItem.setStatusTip(str(row['userID'].toString()))
		else:
			print 'no one here'
			checkinItem = QtGui.QListWidgetItem('',self.whosHereListWidget)
			checkinItem.setSizeHint(QtCore.QSize(770, 75))
			wItem = DefautListItem()			
			wItem.setText('No one is checked in here')
			self.whosHereListWidget.setItemWidget(checkinItem,wItem)
			checkinItem.setStatusTip('-1')
		del results
		
	def doFriendListClicked(self,item):
		if item.statusTip() != '-1':
			self.friendDialog = FriendDetailDialog(item.statusTip(),1,self)
			self.friendDialog.show()
		


class GetPendingFriendRequestsForUserWorkerThread(QtCore.QThread):
	def __init__(self, parent = None):
	    		QtCore.QThread.__init__(self, parent)
			self.exiting = False

	def run(self):
		global qb		
		print 'GetPendingFriendRequestsForUserWorkerThread.run()'
		client3 = oauthclient.SimpleOAuthClient('api.foursquare.com', 80, API_PREFIX_URL+'friend/requests', ACCESS_TOKEN_URL, AUTHORIZATION_URL)
		consumer = oauth.OAuthConsumer(CONSUMER_KEY, CONSUMER_SECRET)
		signature_method_plaintext = oauth.OAuthSignatureMethod_PLAINTEXT()
		signature_method_hmac_sha1 = oauth.OAuthSignatureMethod_HMAC_SHA1()

		params = {
			'oauth_token':	fsKey,
			'oauth_token_secret':	fsSecret			
		}

		oauth_request = oauth.OAuthRequest.from_consumer_and_token(consumer, callback=CALLBACK_URL, http_url=API_PREFIX_URL+'friend/requests', parameters=params)
		oauth_request.sign_request(signature_method_plaintext, consumer, fsRequestToken)
		# print oauth_request.to_postdata()
		friendsXmlString = client3.access_resource(oauth_request, http_url=API_PREFIX_URL+'friend/requests', requestType='GET')
		# print friendsXmlString		
		parseSuccess = False
		try:
			friendsXml = parseString(friendsXmlString)
			parseSuccess = True
			# download photos
			userNodes = friendsXml.getElementsByTagName('user')
			friendIDList = ''
			if userNodes.length > 0:
				for userNode in userNodes:
					userID = userNode.getElementsByTagName('id')[0].firstChild.data
					# save user info to database
					firstName = userNode.getElementsByTagName('firstname')[0].firstChild.data
					lastName = ''
					lastNameNode = userNode.getElementsByTagName('lastname')
					if lastNameNode.length > 0:
						if lastNameNode[0].firstChild != None:
							lastName = lastNameNode[0].firstChild.data

					photoFile = ''
					photoURL = ''

					photoURL = userNode.getElementsByTagName('photo')[0].firstChild.data
					photoURLchunks = photoURL.split('/')
					photoFile = userPreferencesDir + 'imageCache' + os.sep + 'users' + os.sep + photoURLchunks[3] + '_' + photoURLchunks[4]
					# print 'photoFile: ' + photoFile			
					# if cached file doesn't exist for user, download it now
					if not os.path.exists(photoFile):
						qb.getUserPhoto(photoURL)	
						
					self.emit(QtCore.SIGNAL('addUserToDatabase'),userID,firstName,lastName,photoFile,photoURL,None)
					phone = ''
					twitter = ''
					facebook = ''
					email = ''
					gender = ''
					phoneNode = userNode.getElementsByTagName('phone')
					if phoneNode.length > 0:
						if phoneNode[0].firstChild != None:
							phone = phoneNode[0].firstChild.data
					twitterNode = userNode.getElementsByTagName('twitter')
					if twitterNode.length > 0:
						if twitterNode[0].firstChild != None:
							twitter = twitterNode[0].firstChild.data
					facebookNode = userNode.getElementsByTagName('facebook')
					if facebookNode.length > 0:
						if facebookNode[0].firstChild != None:
							facebook = facebookNode[0].firstChild.data
					emailNode = userNode.getElementsByTagName('email')
					if emailNode.length > 0:
						if emailNode[0].firstChild != None:
							email = emailNode[0].firstChild.data
					genderNode = userNode.getElementsByTagName('gender')
					if genderNode.length > 0:
						if genderNode[0].firstChild != None:
							if genderNode[0].firstChild.data == 'male':
								gender = 'M'
							elif genderNode[0].firstChild.data == 'female':
								gender = 'F'

					self.emit(QtCore.SIGNAL('addEditUserDetails'),userID,phone,twitter,facebook,email,gender)
					self.emit(QtCore.SIGNAL('addUserFriendStatus'),userID,2)
					friendIDList = '%s\'%s\',' % (friendIDList,qb.dataManager.safeStr(userID))
			if len(friendIDList) > 0:
				friendIDList = '%s' % friendIDList[:len(friendIDList)-1]
				sql = "DELETE FROM UserFriendStatus WHERE status in (2,3) and userID NOT IN (%s)" % friendIDList
				print sql
				self.emit(QtCore.SIGNAL('doDeleteQueryInBackgroundThread'),sql)
				
			newFriendRequestCount = qb.dataManager.doScalarQueryOnMainThread("SELECT count(*) as theCount FROM UserFriendStatus WHERE status=2")[1].toInt()[0]
			print 'newFriendRequestCount: %d' % newFriendRequestCount
			if newFriendRequestCount > 0:
				QtCore.QThread.usleep(5000000)
				self.emit(QtCore.SIGNAL('showDialogHasFriendsForApproval'),newFriendRequestCount)

		except xml.parsers.expat.ExpatError:
			print 'error retrieving pending approval'
			parseSuccess = False
			infoNoticeString = 'Error: api.foursquare.com problem retrieving data'
			self.emit(QtCore.SIGNAL('displayInfoNotice()'))	

	def getUserPhoto(self,photoURL):
		global lowBandwidthMode
		print 'getUserPhoto'
		# save filename as userpix_thumbs_61003_1256906281858.jpg
		photoURLchunks = photoURL.split('/')
		saveFile = photoURLchunks[3] + '_' + photoURLchunks[4]
		if (not os.path.exists(userPreferencesDir + 'imageCache' + os.sep + 'users' + os.sep + saveFile)):
			if lowBandwidthMode:
				shutil.copy(APP_DIRECTORY + 'iconBlankBoy.png',userPreferencesDir + 'imageCache' + os.sep + 'users' + os.sep + saveFile)				
			else:
				print 'download photo file: ' + photoURL
				photoResponse = urllib2.urlopen(photoURL)
				photoData = photoResponse.read()
	
				photoFile = open(userPreferencesDir + 'imageCache' + os.sep + 'users' + os.sep + saveFile,'w')
				photoFile.write(photoData)
				photoFile.close()

class GetFriendsForUserWorkerThread(QtCore.QThread):
	def __init__(self, parent = None):
	    		QtCore.QThread.__init__(self, parent)
			self.exiting = False

	def setup(self,userID,displayProgressBar):
		self.userID = userID
		self.displayProgressBar = displayProgressBar

	def run(self):
		print 'GetFriendsForUserWorkerThread.run()'
		global qb
		global loggedInUserID
		client3 = oauthclient.SimpleOAuthClient('api.foursquare.com', 80, API_PREFIX_URL+'friends', ACCESS_TOKEN_URL, AUTHORIZATION_URL)
		consumer = oauth.OAuthConsumer(CONSUMER_KEY, CONSUMER_SECRET)
		signature_method_plaintext = oauth.OAuthSignatureMethod_PLAINTEXT()
		signature_method_hmac_sha1 = oauth.OAuthSignatureMethod_HMAC_SHA1()

		params = {
			'oauth_token':	fsKey,
			'oauth_token_secret':	fsSecret
		}
		if self.userID != '0':
			params['uid'] = self.userID
			contextUserID = self.userID
		else:
			contextUserID = loggedInUserID

		oauth_request = oauth.OAuthRequest.from_consumer_and_token(consumer, callback=CALLBACK_URL, http_url=API_PREFIX_URL+'friends', parameters=params)
		oauth_request.sign_request(signature_method_plaintext, consumer, fsRequestToken)
		# print oauth_request.to_postdata()
		friendsXmlString = client3.access_resource(oauth_request, http_url=API_PREFIX_URL+'friends', requestType='GET')
		print friendsXmlString		
		parseSuccess = False
		try:
			friendsXml = parseString(friendsXmlString)
			parseSuccess = True
			# download photos
			userNodes = friendsXml.getElementsByTagName('user')
			# delete existing user-friend relationships
			if userNodes.length > 0:
				callingThreadName = None
				if self.displayProgressBar:
					callingThreadName = 'GetFriendsForUserWorkerThread'
					self.emit(QtCore.SIGNAL('setDatabaseExpectedResultCount'),(callingThreadName,userNodes.length,0))
					self.emit(QtCore.SIGNAL('setProcessingDialogProgressBarMaxValue'),userNodes.length)	
				friendIDList = ''
				for userNode in userNodes:
					userID = userNode.getElementsByTagName('id')[0].firstChild.data
					friendIDList = '%s\'%s\',' % (friendIDList,qb.dataManager.safeStr(userID))
					
					# print 'userID: %s' % userID
					# save user info to database
					firstName = userNode.getElementsByTagName('firstname')[0].firstChild.data
					lastName = ''
					lastNameNode = userNode.getElementsByTagName('lastname')
					if lastNameNode.length > 0:
						if lastNameNode[0].firstChild != None:
							lastName = lastNameNode[0].firstChild.data

					photoFile = ''
					photoURL = ''

					photoURL = userNode.getElementsByTagName('photo')[0].firstChild.data
					photoURLchunks = photoURL.split('/')
					photoFile = userPreferencesDir + 'imageCache' + os.sep + 'users' + os.sep + photoURLchunks[3] + '_' + photoURLchunks[4]
					# print 'photoFile: ' + photoFile			
					# if cached file doesn't exist for user, download it now
					if not os.path.exists(photoFile):
						qb.getUserPhoto(photoURL)	

					self.emit(QtCore.SIGNAL('addUserToDatabase'),userID,firstName,lastName,photoFile,photoURL,callingThreadName)
					self.emit(QtCore.SIGNAL('addUserFriendStatus'),userID,1)
				if len(friendIDList) > 0:
					friendIDList = '%s' % friendIDList[:len(friendIDList)-1]
					sql = "DELETE FROM UserFriendStatus WHERE status=1 and userID NOT IN (%s)" % friendIDList
					print sql
					self.emit(QtCore.SIGNAL('doDeleteQueryInBackgroundThread'),sql)

				if self.displayProgressBar:
					self.exec_()
						
			qb.lastTimeFriendsListRefreshed = time.gmtime()
			self.emit(QtCore.SIGNAL('saveSettingToDB'),'lastTimeFriendsListRefreshed',str(datetime.datetime.utcnow()))

		except xml.parsers.expat.ExpatError:
			print 'error retrieving friends'
			parseSuccess = False
			infoNoticeString = 'Error: api.foursquare.com problem retrieving friends list'
			self.emit(QtCore.SIGNAL('displayInfoNotice()'))	

		if qb.signInInit:
			self.emit(QtCore.SIGNAL('signedInInitialLoad'),qb.nextInitIndex)

	def getUserPhoto(self,photoURL):
		global lowBandwidthMode
		print 'getUserPhoto'
		# save filename as userpix_thumbs_61003_1256906281858.jpg
		photoURLchunks = photoURL.split('/')
		saveFile = photoURLchunks[3] + '_' + photoURLchunks[4]
		if (not os.path.exists(userPreferencesDir + 'imageCache' + os.sep + 'users' + os.sep + saveFile)):
			if lowBandwidthMode:
				shutil.copy(APP_DIRECTORY + 'iconBlankBoy.png',userPreferencesDir + 'imageCache' + os.sep + 'users' + os.sep + saveFile)				
			else:			
				print 'download photo file: ' + photoURL
				photoResponse = urllib2.urlopen(photoURL)
				photoData = photoResponse.read()
	
				photoFile = open(userPreferencesDir + 'imageCache' + os.sep + 'users' + os.sep + saveFile,'w')
				photoFile.write(photoData)
				photoFile.close()

	def __del__(self):
		print 'GetFriendsForUserWorkerThread.__del__()'
		self.exiting = True
		self.wait()
	

class AddTipOrToDoInBackgroundThread(QtCore.QThread):
	def __init__(self, parent = None):
	    		QtCore.QThread.__init__(self, parent)
			self.exiting = False

	def setup(self,venueID,addType,tipString,userID):
		self.venueID = venueID
		self.tipString = tipString
		self.addType = addType
		self.userID = userID
	
	def run(self):
		client3 = oauthclient.SimpleOAuthClient('api.foursquare.com', 80, API_PREFIX_URL+'addtip', ACCESS_TOKEN_URL, AUTHORIZATION_URL)
		consumer = oauth.OAuthConsumer(CONSUMER_KEY, CONSUMER_SECRET)
		signature_method_plaintext = oauth.OAuthSignatureMethod_PLAINTEXT()
		signature_method_hmac_sha1 = oauth.OAuthSignatureMethod_HMAC_SHA1()

		nearbyParams = {
			'vid'	:	self.venueID,
			'geolat' : 	currentLatitude,
			'geolong':	currentLongitude,
			'text':		self.tipString,
			'type':		self.addType,
			'oauth_token':	fsKey,
			'oauth_token_secret':	fsSecret
		}
		oauth_request = oauth.OAuthRequest.from_consumer_and_token(consumer, callback=CALLBACK_URL, http_url=API_PREFIX_URL+'addtip', parameters=nearbyParams)
		oauth_request.sign_request(signature_method_plaintext, consumer, fsRequestToken)
		print oauth_request.to_postdata()
		addtipResultXmlString = client3.access_resource(oauth_request, http_url=API_PREFIX_URL+'addtip', requestType='POST')
		# print addtipResultXmlString
		tipID = '12345'
				
		parseSuccess = False
		created = False
		try:
			addtipResultXml = parseString(addtipResultXmlString)
			parseSuccess = True
			createdNodes = addtipResultXml.getElementsByTagName('created')
			if createdNodes.length > 0:
				created = True
				tipCreatedInt = int(time.mktime(time.strptime(createdNodes[0].firstChild.data,'%a, %d %b %y %H:%M:%S +0000')))
				tipCreatedUTC = datetime.datetime.fromtimestamp(tipCreatedInt)

				tipID = addtipResultXml.getElementsByTagName('id')[0].firstChild.data
				# add tip to local db for venue
				self.emit(QtCore.SIGNAL('addEditVenueTip'),tipID,0,self.venueID,self.userID,1,self.tipString,str(tipCreatedUTC),'',0,None)
 
		except xml.parsers.expat.ExpatError:
			print 'error parsing add tip'
			parseSuccess = False
			infoNoticeString = 'Error: api.foursquare.com problem. Check tips before trying again'
			self.emit(QtCore.SIGNAL('displayInfoNotice()'))	

		if created:
			self.emit(QtCore.SIGNAL('addTipSuccess()'))	
		else:	
			self.emit(QtCore.SIGNAL('addTipFailed()'))	

	def __del__(self):
		print 'AddTipOrToDoInBackgroundThread.__del__()'
		self.exiting = True
		self.wait()

class AddTipDialog(QtGui.QMainWindow):
	def __init__(self, venueID, venueName, parent=None):
		QtGui.QMainWindow.__init__(self, parent)	
		
		p = self.palette()
		p.setColor(QtGui.QPalette.Window, QtGui.QColor(0, 0, 0))
		self.setPalette(p)
		
		self.venueID = venueID
		self.setWindowTitle('Add a tip for ' + venueName)
		self.lblName = QtGui.QLabel('Add a Tip',self)
		self.lblName.setGeometry(5,5,100,25)
		self.txtTip = QtGui.QTextEdit(self)
		self.txtTip.setAcceptRichText(False)
		self.txtTip.setGeometry(5,35,790,250)

		self.bttnAddTip = QtGui.QPushButton('Add Tip',self)
		self.bttnAddTip.setGeometry(640,300,150,80)
		self.bttnAddTip.setStyleSheet(QPUSHBUTTON_DEFAULT)

		self.connect(self.bttnAddTip, QtCore.SIGNAL('clicked()'),
			self.doAddTipClicked)

		global qb
		
		self.addTipWorker = AddTipOrToDoInBackgroundThread()
		self.connect(self.addTipWorker, QtCore.SIGNAL('addTipSuccess()'), self.addTipSuccess)
		self.connect(self.addTipWorker, QtCore.SIGNAL('addTipFailed()'), self.addTipFailed)
		self.connect(self.addTipWorker, QtCore.SIGNAL('displayInfoNotice()'), self.displayInfoNoticeGlobal)
		self.connect(self.addTipWorker, QtCore.SIGNAL('addEditVenueTip'),qb.dataManager.addEditVenueTip)		
		
		self.lblLoadingIcon = QtGui.QLabel('',self)
		self.loadingGif = QtGui.QMovie(APP_DIRECTORY + 'loading2.gif', QtCore.QByteArray(), self)
		self.loadingGif.setCacheMode(QtGui.QMovie.CacheAll)
		self.loadingGif.setSpeed(100)
		self.loadingGif.setBackgroundColor(QtGui.QColor(0, 0, 0))
		self.lblLoadingIcon.setGeometry(570,315,50,50)
		self.lblLoadingIcon.setMovie(self.loadingGif)
		self.lblLoadingIcon.hide()
		self.loadingGif.start()
		self.tipAdded = False
		
	def closeEvent(self, event):
		tipStr = unicode(self.txtTip.toPlainText()).strip()
		if len(tipStr) > 0 and not self.tipAdded:
			reply = QtGui.QMessageBox.question(self, 'Cancel?',"Are you sure you want to cancel adding this tip?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
			if reply == QtGui.QMessageBox.Yes:
				self.addingVenue = False
				event.accept()
			else:
				event.ignore()
		else:
			event.accept()			

	def doAddTipClicked(self):
		global qb
		global loggedInUserID
		tipStr = unicode(self.txtTip.toPlainText()).strip()		
		if len(tipStr) == 0:
			qb.displayInfoNotice('Cannot add a blank tip')				
		else:
			self.txtTip.setEnabled(False)
			self.bttnAddTip.setText('Adding')
			self.bttnAddTip.setEnabled(False)
			self.lblLoadingIcon.show()
			self.loadingGif.start()
			self.addTipWorker.setup(self.venueID,'tip',tipStr,loggedInUserID)
			self.addTipWorker.start()

	def addTipSuccess(self):
		del self.addTipWorker
		global qb
		qb.displayInfoNotice('Tip added successfully')	
		self.tipAdded = True
		self.close()

	def addTipFailed(self):
		self.txtTip.setEnabled(True)
		self.lblLoadingIcon.hide()
		self.loadingGif.stop()
		self.bttnAddTip.setText('Add Tip')
		self.bttnAddTip.setEnabled(True)		
		global qb
		qb.displayInfoNotice('Failed to add tip')		
	
	def displayInfoNoticeGlobal(self):
		global infoNoticeString
		global qb
		qb.displayInfoNotice(infoNoticeString)
		
class TipsDialog(QtGui.QMainWindow):
	def __init__(self, venueID, parent=None):
		QtGui.QMainWindow.__init__(self, parent)	

		global qb

		self.setWindowTitle('Tips')
		self.resize(800,480)
		self.venueID = venueID
		self.tipsListWidget = QtGui.QListWidget(self)
		self.tipsListWidget.setGeometry(5, 5, 820, 350)
		p = self.tipsListWidget.palette()
		p.setColor(QtGui.QPalette.Highlight, QtGui.QColor(255, 255, 184))
		p.setColor(QtGui.QPalette.Base, QtGui.QColor(255, 0, 0))
		p = self.tipsListWidget.setPalette(p)
		self.tipsListWidget.setStyleSheet(QLISTWIDGET_DEFAULT)
	
		self.venueName = unicode(qb.dataManager.doScalarQueryOnMainThread("SELECT name FROM Venues where id='%s'" % self.venueID)[1].toString())
		results = qb.dataManager.doSelectQueryOnMainThread("SELECT VenueTips.id, VenueTips.userID, VenueTips.createdDate, Users.firstName, Users.lastName, Users.photoFile, VenueTips.tipText, VenueTips.url FROM VenueTips INNER JOIN Users ON Users.id=VenueTips.userID WHERE VenueTips.venueID='%s' ORDER BY VenueTips.createdDate desc" % self.venueID,'id,userID,createdDate,firstName,lastName,photoFile,tipText,url')
		if results['RecordCount'] == 1:
			tipStr = '%d tip for %s' % (results['RecordCount'],self.venueName)
		else:
			tipStr = '%d tips for %s' % (results['RecordCount'],self.venueName)
		if results['RecordCount'] > 0:
			for row in results['Records']:
				tipItem = QtGui.QListWidgetItem('',self.tipsListWidget)

				tipString = '<b>' + unicode(row['firstName'].toString())
				lastName = unicode(row['lastName'].toString())
				if len(lastName):
					tipString += ' ' + lastName
				tipString += '</b> says: <i>"'
				tipString += unicode(row['tipText'].toString()) + '"</i>'
				
				# calculate the height of the row based on the length of the tip

				print 'line len: %d' % len(tipString)
				lines = math.ceil(len(tipString) / 40)
				print 'lines: %d' % lines
				height = lines * 30
				print 'height: %d' % height
				if height < 75:
					height = 75
	
				tipItem.setSizeHint(QtCore.QSize(770, height))
				wItem = TipListItem(height)

				wItem.setText(tipString,str(row['photoFile'].toString()))
				self.tipsListWidget.setItemWidget(tipItem,wItem)
				tipItem.setStatusTip(str(row['id'].toString()))
		else:
			tipItem = QtGui.QListWidgetItem('',self.tipsListWidget)
			tipItem.setSizeHint(QtCore.QSize(770, 75))
			wItem = DefautListItem()			
			wItem.setText('No Tips for this Venue')
			self.tipsListWidget.setItemWidget(tipItem,wItem)
			tipItem.setStatusTip('-1')

		del results

		self.setWindowTitle(tipStr)

		# add button for adding tip
		self.bttnAddTip = QtGui.QPushButton('+',self)
		self.bttnAddTip.setGeometry(740,355,60,60)
		self.connect(self.bttnAddTip, QtCore.SIGNAL('clicked()'),
			self.doShowAddTip)
		
		# parse output
	def doShowAddTip(self):
		addTipDlg = AddTipDialog(self.venueID,self.venueName,self)
		addTipDlg.show()


		
class PlaceInfoDialog(QtGui.QMainWindow):
	def __init__(self, id, mainWindow, parent=None):
		QtGui.QMainWindow.__init__(self, parent)	

		self.resize(800,480)

		p = self.palette()
		p.setColor(QtGui.QPalette.Window, QtGui.QColor(0, 0, 0))
		self.setPalette(p)

		self.tipsText = ''

		# thread out reading results into separate thread

		print 'Place ID:' + id
		self.venueID = str(id)
		self.hasSpecials = False
		self.venueCheckinCount = 0
		self.strLatLon = ''
		self.displayOK = False

		# self.setModal(1)
		self.setWindowTitle('Place Info')
		self.venueName = ''
		self.mayorName = ''

		self.addressString = ''
		self.cityString = ''
		self.phoneString = ''

		self.lblMessage1 = QtGui.QTextDocument(self)
		self.lblMessage1.setTextWidth(600)

		# hildonized probably doesn't need cancel button
		# self.bttnCancel = QtGui.QPushButton('Cancel', self)
		# self.bttnCancel.setGeometry(675, 25, 150, 80)

		# self.lblName = QtGui.QLabel('',self)
		# self.lblName.setFont(QtGui.QFont('Helvetica', 30))
		# self.lblName.setGeometry(5,175,600,50)

		# self.lblAddress = QtGui.QLabel('',self)
		# self.lblAddress.setFont(QtGui.QFont('Helvetica', 15))
		# self.lblAddress.setGeometry(5,210,600,50)

		# self.lblCity = QtGui.QLabel('',self)
		# self.lblCity.setFont(QtGui.QFont('Helvetica', 15))
		# self.lblCity.setGeometry(5,230,600,50)

		# self.lblPhone = QtGui.QLabel('',self)
		# self.lblPhone.setFont(QtGui.QFont('Helvetica', 15))
		# self.lblPhone.setGeometry(5,250,300,50)

		# add a button for tips
		self.bttnCheckIn = QtGui.QPushButton('Check-In Here',self)
		self.bttnCheckIn.setGeometry(620,10,175,80)
		self.bttnCheckIn.setStyleSheet(QPUSHBUTTON_DEFAULT)		

		# add a button for tips
		self.bttnTips = QtGui.QPushButton('0 Tips',self)
		self.bttnTips.setGeometry(620,100,175,80)
		self.bttnTips.setStyleSheet(QPUSHBUTTON_DEFAULT)

		# add a button for venue
		self.bttnMap = QtGui.QPushButton('View on 4SQ',self)
		self.bttnMap.setGeometry(620,190,175,80)
		self.bttnMap.setStyleSheet(QPUSHBUTTON_DEFAULT)

		# add label
		# self.lblDisplay1 = QtGui.QLabel('',self)
		# self.lblDisplay1.setGeometry(0,0,1,1)

		# add label
		# self.lblDisplay2 = QtGui.QLabel('',self)
		# self.lblDisplay2.setGeometry(0,0,1,1)

		self.web = QtWebKit.QWebView(self)
		
		self.web.load(QtCore.QUrl.fromLocalFile(APP_DIRECTORY + 'loading.html'))
		self.web.setGeometry(5,2,600,200)

		self.web.show()

		self.connect(self.bttnMap, QtCore.SIGNAL('clicked()'),
			self.doMapButtonClicked)

		self.connect(self.bttnCheckIn, QtCore.SIGNAL('clicked()'),
			self.doCheckInButtonClicked)

		self.connect(self.bttnTips, QtCore.SIGNAL('clicked()'),
			self.doShowTips)

		self.bttnCheckinsList = QtGui.QPushButton('',self)
		self.bttnCheckinsList.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnCheckinsList.hide()

		self.connect(self.bttnCheckinsList, QtCore.SIGNAL('clicked()'),
			self.doShowRecentCheckins)
		
		# self.bttnMayorIcon = QtGui.QPushButton('',self)

		# self.connect(self.bttnCancel, QtCore.SIGNAL('clicked()'), 
		#	self, QtCore.SLOT('close()'))

	def doShowTips(self):
		print 'doShowTips'
		self.tipsDlg = TipsDialog(self.venueID,self)
		self.tipsDlg.show()

	def doShowRecentCheckins(self):
		print 'doShowRecentCheckins'
		self.whosHereDlg = WhosHereDialog(self.venueID,self)
		self.whosHereDlg.show()

	def loadingFinished(self):
		print 'self.venueCheckinCount: %d' % self.venueCheckinCount
		
		message = '<body bgcolor="#000000"><font color="#ffffff">'

		print 'loadingFinished'
		print self.venueName
		titleStyle = 'margin: 0px; padding: 0px; font-size: 40px; line-height: 20px;'
		if len(self.venueName) > 25:
			titleStyle = 'font-size: 30px; line-height: 15px;'
		message += '<p style="%s">' % titleStyle
		message += self.venueName + '</p><p style="margin: 0px; line-height: 20px; font-size: 20px;">'
		# self.lblName.setText(self.venueName)
		# self.lblAddress.setText(self.addressString)
		if self.addressString != '':
			message += self.addressString + '<br>'
		if self.cityString != '':
			message += self.cityString
		if self.phoneString != '':
			message += '&nbsp;&nbsp;&nbsp;tel:' + self.phoneString
		message += '</p>'

		if self.mayorName != '':
			image = QtGui.QPixmap(self.mayorPhotoFile)
			self.lblMessage1.addResource(QtGui.QTextDocument.ImageResource,QtCore.QUrl("mydata://mayor_photo.png"), QtCore.QVariant(image))

			message += '<table><tr><td valign="middle"><img src="mydata://mayor_photo.png"></td><td>&nbsp;</td><td valign="middle">'
			message += self.mayorName
			message += '</td></tr></table>'

		# self.lblCity.setText(self.cityString)
		# self.lblPhone.setText(self.phoneString)
		self.setWindowTitle(self.venueName)
		self.web.load(QtCore.QUrl('http://maps.google.com/maps/api/staticmap?center=' + self.strLatLon + '&size=600x200&maptype=roadmap&markers=color:red|' + self.strLatLon + '&zoom=16&sensor=false&key=' + GOOGLE_MAPS_API_KEY))
		if self.hasSpecials:
			self.bttnSpecials = QtGui.QPushButton(self.specialsText,self)
			self.bttnSpecials.setGeometry(620,280,175,80)
			self.bttnSpecials.setStyleSheet(QPUSHBUTTON_DEFAULT)
			# connect the slot
			self.connect(self.bttnSpecials, QtCore.SIGNAL('clicked()'),
				self.doSpecialsButtonClicked)

		if self.venueCheckinCount > 0:
			if self.venueCheckinCount == 1:
				self.bttnCheckinsList.setText('%d Person Here' % self.venueCheckinCount)
			else:
				self.bttnCheckinsList.setText('%d People Here' % self.venueCheckinCount)
			
			if self.hasSpecials:
				self.bttnCheckinsList.setGeometry(435,280,175,80)
			else:
				self.bttnCheckinsList.setGeometry(620,280,175,80)
			self.bttnCheckinsList.show()

		self.bttnTips.setText(self.tipsText)

		# if self.mayorName != '':
		#	self.lblDisplay2.setGeometry(85, 290, 300, 30)
		#	self.lblDisplay2.setText(self.mayorName)

		# if self.mayorPhotoFile != '':
		#	self.lblDisplay1.setGeometry(5, 290, 75, 75)
		#	userPhotoPixmap = QtGui.QPixmap(self.mayorPhotoFile)
		#	if userPhotoPixmap != None:
		#		self.lblDisplay1.setPixmap(userPhotoPixmap)
		#	else:
		#		print 'userPhotoPixmap is None'

		message += '</font></body>'
		self.lblMessage1.setHtml(message)


		qScene = QtGui.QGraphicsScene(self)
		qScene.setBackgroundBrush(QtGui.QColor(0,0,0))
		# qScene.setForegroundBrush(QtGui.QColor(255,255,255))
		qItem = QtGui.QGraphicsTextItem(None, qScene)
		qItem.setDocument(self.lblMessage1)
		qView = QtGui.QGraphicsView(qScene,self)
		qView.setHorizontalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
		qView.setVerticalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
		qView.setGeometry(5,205,600,240)
		qView.setAlignment(QtCore.Qt.AlignTop)


	def doSpecialsButtonClicked(self):
		print 'doSpecialsClicked'

	def doMapButtonClicked(self):
		url = VENUE_URL + self.venueID
		print 'Opening URL: ' + url
		webbrowser.open_new(url)
	
	def doCheckInButtonClicked(self):
		self.checkInDlg = CheckInDialog(self.venueID,self.venueName)
		self.checkInDlg.show()

class HistoryWorkerThread(QtCore.QThread):
	def __init__(self, parent = None):
    		QtCore.QThread.__init__(self, parent)
		self.exiting = False

	def setup(self,userID,maxHistory):
		self.userID = userID
		self.maxHistory = maxHistory

	def run(self):
		global qb
		global infoNoticeString
		client3 = oauthclient.SimpleOAuthClient('api.foursquare.com', 80, API_PREFIX_URL+'history', ACCESS_TOKEN_URL, AUTHORIZATION_URL)
		consumer = oauth.OAuthConsumer(CONSUMER_KEY, CONSUMER_SECRET)
		signature_method_plaintext = oauth.OAuthSignatureMethod_PLAINTEXT()
		signature_method_hmac_sha1 = oauth.OAuthSignatureMethod_HMAC_SHA1()
	
		nearbyParams = {
			'l':	100,
			'oauth_token':	fsKey,
			'oauth_token_secret':	fsSecret
		}
		print 'qb.lastHistoryID: %s' % qb.lastHistoryID
		# if qb.lastHistoryID == '0':
		# 	nearbyParams['l'] = 5000
		# else:
#		# 	nearbyParams['l'] = 100
		#	nearbyParams['sinceid'] = qb.lastHistoryID

		oauth_request = oauth.OAuthRequest.from_consumer_and_token(consumer, callback=CALLBACK_URL, http_url=API_PREFIX_URL+'history', parameters=nearbyParams)
		oauth_request.sign_request(signature_method_plaintext, consumer, fsRequestToken)
		# print oauth_request.to_postdata()
		historyResultXml = client3.access_resource(oauth_request, http_url=API_PREFIX_URL+'history', requestType='GET')
		print historyResultXml		
		# save venue data to cache file
		# catch invalid xml
		parseSuccess = False
		try:
			historyXml = parseString(historyResultXml)
			parseSuccess = True
		except xml.parsers.expat.ExpatError:
			parseSuccess = False

		if parseSuccess:
			errorNode = historyXml.getElementsByTagName('error')
			if errorNode.length == 1:
				infoNoticeString = errorNode[0].firstChild.data
				self.emit(QtCore.SIGNAL('displayInfoNotice()'))					
			else:			
				unAuthorizedNode = historyXml.getElementsByTagName('unauthorized')
				if unAuthorizedNode.length == 1:
					if unAuthorizedNode[0].firstChild.data == 'TOKEN_EXPIRED':
						infoNoticeString = 'Error: foursquare.com token expired. Please sign back in'
						self.emit(QtCore.SIGNAL('displayInfoNotice()'))		
				else:			
					checkinNodes = historyXml.getElementsByTagName('checkin')
					if checkinNodes.length > 0:
						params = ('HistoryWorkerThread',checkinNodes.length,0)
						self.emit(QtCore.SIGNAL('setDatabaseExpectedResultCount'),params)
						self.emit(QtCore.SIGNAL('setProcessingDialogProgressBarMaxValue'),checkinNodes.length)	
	
						for node in checkinNodes:
							venueID = ''	
							venueNode = node.getElementsByTagName('venue')	
							address = ''
							crossstreet = ''
							city = ''
							state = ''
							zipCode = ''
							phone = ''
							geolat = 0
							geolong = 0
							distance = 0
							if venueNode.length > 0:
								venueIDNode = venueNode[0].getElementsByTagName('id')
								venueName = venueNode[0].getElementsByTagName('name')[0].firstChild.data			
								if venueIDNode.length > 0:
									venueID = venueIDNode[0].firstChild.data
									addressNode = venueNode[0].getElementsByTagName('address')
									if addressNode.length > 0:
										if addressNode[0].firstChild != None:
											address = addressNode[0].firstChild.data
									crossStreetNode = venueNode[0].getElementsByTagName('crossstreet')
									if crossStreetNode.length > 0:
										if crossStreetNode[0].firstChild != None:
											crossstreet = crossStreetNode[0].firstChild.data
									cityNode = venueNode[0].getElementsByTagName('city')
									if cityNode.length > 0:
										if cityNode[0].firstChild != None:
											city = cityNode[0].firstChild.data
									stateNode = venueNode[0].getElementsByTagName('state')
									if stateNode.length > 0:
										if stateNode[0].firstChild != None:
											state = stateNode[0].firstChild.data
									zipNode = venueNode[0].getElementsByTagName('zip')
									if zipNode.length > 0:
										if zipNode[0].firstChild != None:
											zipCode = zipNode[0].firstChild.data
									phoneNode = venueNode[0].getElementsByTagName('phone')
									if phoneNode.length > 0:
										if phoneNode[0].firstChild != None:
											phone = phoneNode[0].firstChild.data
									geolat = float(venueNode[0].getElementsByTagName('geolat')[0].firstChild.data)
									geolong = float(venueNode[0].getElementsByTagName('geolong')[0].firstChild.data)
	
									mayorID = ''
									self.emit(QtCore.SIGNAL('addVenueItemToDatabase'),0,venueID,distance,venueName,address,crossstreet,city,state,zipCode,phone,-1,-1,geolat,geolong,mayorID,None)
									QtCore.QThread.usleep(50000)
									# add/update venue
	
							checkinID = node.getElementsByTagName('id')[0].firstChild.data
							userID = self.userID
	
							calcDistance = 0			
							createdDate = node.getElementsByTagName('created')[0].firstChild.data
							shoutNodes = node.getElementsByTagName('shout')
							shout = ''
							# print 'shouts: %d' % shoutNodes.length
							if shoutNodes.length > 0:
								shout = shoutNodes[0].firstChild.data
							# print type(userID)
	
							self.emit(QtCore.SIGNAL('addCheckinHistoryItemToDatabase'),checkinID,venueID,userID,calcDistance,shout,createdDate,'','','HistoryWorkerThread')
					
						self.exec_()
						# enter event loop
				self.emit(QtCore.SIGNAL('reloadMainWindowWithResultsOfHistory()'))
		else:
			print 'error parsing response'

		if qb.signInInit:
			self.emit(QtCore.SIGNAL('signedInInitialLoad'),qb.nextInitIndex)

	def __del__(self):
		print 'HistoryWorkerThread.__del__()'
		self.exiting = True
		self.wait()


class SearchWorkerThread(QtCore.QThread):
	def __init__(self, parent = None):
    		QtCore.QThread.__init__(self, parent)
		self.exiting = False

	def setup(self,seqID):
		self.sequenceID = seqID

	def run(self):
		global infoNoticeString
		client3 = oauthclient.SimpleOAuthClient('api.foursquare.com', 80, API_PREFIX_URL+'venues', ACCESS_TOKEN_URL, AUTHORIZATION_URL)
		consumer = oauth.OAuthConsumer(CONSUMER_KEY, CONSUMER_SECRET)
		signature_method_plaintext = oauth.OAuthSignatureMethod_PLAINTEXT()
		signature_method_hmac_sha1 = oauth.OAuthSignatureMethod_HMAC_SHA1()
	
		global searchKeywords
		global currentLatitude
		global currentLongitude

		nearbyParams = {
			'geolat':	currentLatitude,
			'geolong':	currentLongitude,
			'q':	searchKeywords
		}
		oauth_request = oauth.OAuthRequest.from_consumer_and_token(consumer, callback=CALLBACK_URL, http_url=API_PREFIX_URL+'venues', parameters=nearbyParams)
		oauth_request.sign_request(signature_method_plaintext, consumer, fsRequestToken)
		print oauth_request.to_postdata()
		connectionResult = False
		try:
			searchResultXml = client3.access_resource(oauth_request, http_url=API_PREFIX_URL+'venues', requestType='GET')
			print searchResultXml
			connectionResult = True
		except socket.gaierror, e:
			connectionResult = False
			if e[0] == -3:
				infoNoticeString = 'Error: unable to resolve api.foursquare.com hostname'
				self.emit(QtCore.SIGNAL('displayInfoNotice()'))	
			else:
				infoNoticeString = 'Error: unable to connect to api.foursquare.com'
				self.emit(QtCore.SIGNAL('displayInfoNotice()'))	
		
		if connectionResult:
			parseSuccess = False
			try:
				searchXml = parseString(searchResultXml)
				parseSuccess = True
			except xml.parsers.expat.ExpatError:
				parseSuccess = False

			if parseSuccess:
				errorNode = searchXml.getElementsByTagName('error')
				if errorNode.length == 1:
					infoNoticeString = errorNode[0].firstChild.data
					self.emit(QtCore.SIGNAL('displayInfoNotice()'))					
				else:						
					# process the nodes
					nearbyNodes = searchXml.getElementsByTagName('venue')
					if nearbyNodes.length > 0:
						self.emit(QtCore.SIGNAL('showProcessingDialog()'))
						self.emit(QtCore.SIGNAL('setProcessingDialogProgressBarMaxValue'),nearbyNodes.length)	
						self.emit(QtCore.SIGNAL('setDatabaseExpectedResultCount'),('SearchWorkerThread',nearbyNodes.length,0))
	
					for node in nearbyNodes:
						venueID = node.getElementsByTagName('id')[0].firstChild.data
						venueName = node.getElementsByTagName('name')[0].firstChild.data			
						address = ''
						crossstreet = ''
						city = ''
						state = ''
						zipCode = ''
						phone = ''
						geolat = 0
						geolong = 0
						addressNode = node.getElementsByTagName('address')
						if addressNode.length > 0:
							if addressNode[0].firstChild != None:
								address = addressNode[0].firstChild.data
						crossStreetNode = node.getElementsByTagName('crossstreet')
						if crossStreetNode.length > 0:
							if crossStreetNode[0].firstChild != None:
								crossstreet = crossStreetNode[0].firstChild.data
						cityNode = node.getElementsByTagName('city')
						if cityNode.length > 0:
							if cityNode[0].firstChild != None:
								city = cityNode[0].firstChild.data
						stateNode = node.getElementsByTagName('state')
						if stateNode.length > 0:
							if stateNode[0].firstChild != None:
								state = stateNode[0].firstChild.data
						zipNode = node.getElementsByTagName('zip')
						if zipNode.length > 0:
							if zipNode[0].firstChild != None:
								zipCode = zipNode[0].firstChild.data
						phoneNode = node.getElementsByTagName('phone')
						if phoneNode.length > 0:
							if phoneNode[0].firstChild != None:
								phone = phoneNode[0].firstChild.data
						geolat = float(node.getElementsByTagName('geolat')[0].firstChild.data)
						geolong = float(node.getElementsByTagName('geolong')[0].firstChild.data)
						distance = int(node.getElementsByTagName('distance')[0].firstChild.data)
	
						mayorID = ''
	
						self.emit(QtCore.SIGNAL('addVenueItemToDatabase'),self.sequenceID,venueID,distance,venueName,address,crossstreet,city,state,zipCode,phone,-1,-1,geolat,geolong,mayorID,'SearchWorkerThread')
						
						# sleep for 10ms (keeps main UI thread from becoming sluggish
						QtCore.QThread.usleep(50000)
	
					# event loop
					if nearbyNodes.length > 0:
						self.exec_()
			self.emit(QtCore.SIGNAL('reloadMainWindowWithResultsOfSearch()'))

	def __del__(self):
		print 'SearchWorkerThread.__del__()'
		self.exiting = True
		self.wait()

class SearchDialog(QtGui.QDialog):
	def __init__(self, parent=None):
		QtGui.QDialog.__init__(self, parent)
		self.parent = parent

		self.setModal(1)
		self.setWindowTitle('Search for Venue')

		self.resize(800,100)

		# lbl for email
		lblSearch = QtGui.QLabel('Keywords:', self)
		lblSearch.setGeometry(10, 15, 150, 75)
		lblSearch.setFont(QtGui.QFont('Helvetica', 25))

		# txt field for email
		self.txtKeywords = QtGui.QLineEdit(self)
		# non-hildon: txtEmail.setGeometry(190, 10, 220, 50)
		self.txtKeywords.setGeometry(170, 20, 460, 60)
		self.txtKeywords.setFont(QtGui.QFont('Helvetica', 27))

		self.bttnDoSearch = QtGui.QPushButton('Search', self)
		self.bttnDoSearch.setGeometry(640, 10, 150, 80)
		self.bttnDoSearch.setStyleSheet(QPUSHBUTTON_DEFAULT)

		# bttnCancel = QtGui.QPushButton('Cancel', self)
		# bttnCancel.setGeometry(400, 150, 150, 80)

		self.connect(self.bttnDoSearch, QtCore.SIGNAL('clicked()'),
			self.doSearchButtonClicked)
		self.searchWorker = SearchWorkerThread()
		self.connect(self.searchWorker, QtCore.SIGNAL('finished()'), self.searchFinished)
		self.connect(self.searchWorker, QtCore.SIGNAL('displayInfoNotice()'), self.displayInfoNoticeGlobal)
		self.connect(self.searchWorker, QtCore.SIGNAL('reloadMainWindowWithResultsOfSearch()'), self.reloadMainWindowWithSearchResults)
		self.connect(self.searchWorker, QtCore.SIGNAL('setDatabaseExpectedResultCount'), self.parent.setDatabaseExpectedResultCount)
		self.connect(self.searchWorker, QtCore.SIGNAL('addVenueItemToDatabase'), self.parent.addVenueItemToDatabase)
		self.connect(self.searchWorker, QtCore.SIGNAL('setProcessingDialogProgressBarMaxValue'), self.parent.setProcessingDialogProgressBarMaxValue)
		self.connect(self.searchWorker, QtCore.SIGNAL('showProcessingDialog()'), self.showProcessingDialog)

	def displayInfoNoticeGlobal(self):
		global infoNoticeString
		global qb
		qb.displayInfoNotice(infoNoticeString)

	def showProcessingDialog(self):
		self.parent.processDlg.setTitleAndLabelText('Processing','Please wait while we process the results. This can take up to 30 seconds depending on how much additional data needs to be downloaded from the servers.')
		self.parent.processDlg.startAnimation()
		self.parent.processDlg.show()

	def doSearchButtonClicked(self):
		print 'doSearchButtonClicked'
		global qb
		keywords = '' + unicode(self.txtKeywords.text()).strip()
		print 'Keywords: ' + keywords
		global searchKeywords
		searchKeywords = keywords
		self.bttnDoSearch.setText('Searching...')
		self.searchSequenceID = self.parent.dataManager.getNextSequenceID()
		self.searchWorker.setup(self.searchSequenceID)
		self.searchWorker.start()

	def reloadMainWindowWithSearchResults(self):
		global qb
		self.parent.processDlg.stopAnimation()
		self.parent.processDlg.close()
		qb.loadSearchResults(self.searchSequenceID)

	def searchFinished(self):
		print 'searchFinished'
		# clean up resources
		del self.searchWorker
		self.close()

class ConfirmDialog(QtGui.QDialog):
	def __init__(self, titleString, confirmString, parent=None):
		QtGui.QDialog.__init__(self, parent)

class AboutDialog(QtGui.QDialog):
	def __init__(self, parent=None):
		QtGui.QDialog.__init__(self, parent)
		self.setWindowTitle('About barrioSquare')
		self.resize(800,480)

class SignInWorkerThread(QtCore.QThread):
	def __init__(self, parent = None):
    		QtCore.QThread.__init__(self, parent)
		self.exiting = False

	def setup(self,email,password):
		self.email = email
		self.password = password

	def run(self):
		print 'SignInWorkerThread.run() Executing thread logic'
		global qb
		global infoNoticeString
		print 'emailOrPhone: 	' + self.email
		print 'password:	' + self.password

		print '** OAuth **'
		client = oauthclient.SimpleOAuthClient(SERVER, PORT, REQUEST_TOKEN_URL, ACCESS_TOKEN_URL, AUTHORIZATION_URL)
		client2 = oauthclient.SimpleOAuthClient('api.foursquare.com', 80, AUTHORIZATION_EXCHANGE_URL, ACCESS_TOKEN_URL, AUTHORIZATION_URL)
		consumer = oauth.OAuthConsumer(CONSUMER_KEY, CONSUMER_SECRET)
		signature_method_plaintext = oauth.OAuthSignatureMethod_PLAINTEXT()
		signature_method_hmac_sha1 = oauth.OAuthSignatureMethod_HMAC_SHA1()
	
		fourSquareCredentials = {
			'fs_username':	self.email,
			'fs_password':	self.password
		}	

		print '* Do Authentication Exchange *'
		oauth_request = oauth.OAuthRequest.from_consumer_and_token(consumer, callback=CALLBACK_URL, http_url=AUTHORIZATION_EXCHANGE_URL, parameters=fourSquareCredentials)
		oauth_request.sign_request(signature_method_plaintext, consumer, None)
		authResult = None
		clientConnectErrorString = ''
		clientConnectResult = 0
		try:
			authResult = client2.fetch_request_token(oauth_request)
			clientConnectResult = 0
		except socket.error, e:
			print 'socket error connecting to api endpoint'
			print e
			clientConnectResult = e[0]
			clientConnectErrorString = e[1]

		if clientConnectResult > 0:
			infoNoticeString = 'Error: ' + clientConnectErrorString
			self.emit(QtCore.SIGNAL('displayInfoNotice()'))	

		elif authResult[1] == True:
			if authResult[0] != None:
				print authResult
				global fsRequestToken
				fsRequestToken = authResult[0]
				# save token to file
				global hasToken
				hasToken = 1
				global fsRequestTokenString
				fsRequestTokenString = fsRequestToken.to_string()
				print fsRequestTokenString
				params = cgi.parse_qs(fsRequestTokenString, keep_blank_values=False)
				key = params['oauth_token'][0]
				global fsKey
				fsKey = key
				secret = params['oauth_token_secret'][0]
				global fsSecret
				fsSecret = secret
	
				fsRequestToken = oauth.OAuthToken(key, secret)
				print fsRequestToken
				print fsKey
				print fsSecret

				# save the token to the database
				self.emit(QtCore.SIGNAL('setOAuthTokenSetting'),str(fsRequestToken))

				time.sleep(1)
				# authorize the token
				oauth_request = oauth.OAuthRequest.from_token_and_callback(token=fsRequestToken, http_url=client.authorization_url)
				response = client.authorize_token(oauth_request)
				print response
				self.emit(QtCore.SIGNAL('setSignInSuccess'),True)	
			else:
				# login incorrect, display error
				# self.lblError.setText('Username or password incorrect')
				# use OSSO
				infoNoticeString = 'Username or password incorrect'
				self.emit(QtCore.SIGNAL('displayInfoNotice()'))	
		else:
			infoNoticeString = 'foursquare.com Gateway Error'
			self.emit(QtCore.SIGNAL('displayInfoNotice()'))				

		time.sleep(1)

	def __del__(self):
		print 'SignInWorkerThread.__del__()'
		self.exiting = True
		self.wait()


class SignInDialog(QtGui.QDialog):
	def __init__(self, parent=None):
		QtGui.QDialog.__init__(self, parent)
		self.SigningIn = False
		self.SignInSuccess = False

		p = self.palette()
		p.setColor(QtGui.QPalette.Window, QtGui.QColor(0, 0, 0))
		self.setPalette(p)

		self.setModal(1)
		self.setWindowTitle('Sign In')

		# lbl for email
		lblEmail = QtGui.QLabel('Phone Number / E-mail:', self)
		lblEmail.setGeometry(20, 30, 250, 20)

		# txt field for email
		self.txtEmail = QtGui.QLineEdit(self)
		# non-hildon: txtEmail.setGeometry(190, 10, 220, 50)
		self.txtEmail.setGeometry(270, 10, 220, 50)

		# lbl for password
		lblPasswd = QtGui.QLabel('Password:', self)
		lblPasswd.setGeometry(160, 80, 200, 20)

		self.lblError = QtGui.QLabel('',self)
		self.lblError.setGeometry(10,100,600,50)

		# txt field for email
		self.txtPasswd = QtGui.QLineEdit(self)
		# non-hildon: txtPasswd.setGeometry(190, 65, 220, 50)
		self.txtPasswd.setGeometry(270, 65, 220, 50)
		self.txtPasswd.setEchoMode(QtGui.QLineEdit.Password)

		lblInfo = QtGui.QLabel('Login will be via foursquare.com\'s OAuth mechanism to obtain a token. User credentials are not stored. When you sign out of the app, the token is destroyed.',self)
		lblInfo.setGeometry(5,250,790,200)
		lblInfo.setWordWrap(True)
		lblInfo.setAlignment(QtCore.Qt.AlignTop)

		self.bttnSignIn2 = QtGui.QPushButton('Sign-In', self)
		self.bttnSignIn2.setGeometry(70, 135, 500, 100)

		signInPixmap = QtGui.QPixmap(APP_DIRECTORY + 'SignInFourSquareX.png')
		# signInPixmap2 = signInPixmap.scaled(QtCore.QSize(300,40), QtCore.Qt.IgnoreAspectRatio, QtCore.Qt.SmoothTransformation)		
	
		self.bttnSignIn2.setIcon(QtGui.QIcon(signInPixmap))
		self.bttnSignIn2.setIconSize(QtCore.QSize(500,100))
		self.bttnSignIn2.setStyleSheet(QPUSHBUTTON_NOBORDER_BLACK)
		
		self.lblLoadingIcon = QtGui.QLabel('',self)
		self.loadingGif = QtGui.QMovie(APP_DIRECTORY + 'loading2.gif', QtCore.QByteArray(), self)
		self.loadingGif.setCacheMode(QtGui.QMovie.CacheAll)
		self.loadingGif.setSpeed(100)
		self.loadingGif.setBackgroundColor(QtGui.QColor(0, 0, 0))
		self.lblLoadingIcon.setGeometry(550,155,50,50)
		self.lblLoadingIcon.setMovie(self.loadingGif)
		self.lblLoadingIcon.hide()

		# bttnCancel = QtGui.QPushButton('Cancel', self)
		# bttnCancel.setGeometry(400, 150, 150, 80)

		self.resize(800,480)

		self.signInWorker = SignInWorkerThread()
		self.connect(self.signInWorker, QtCore.SIGNAL('finished()'), self.signInCompleted)
		self.connect(self.signInWorker, QtCore.SIGNAL('setSignInSuccess'), self.setSignInSuccess)
		self.connect(self.signInWorker, QtCore.SIGNAL('setOAuthTokenSetting'), self.setOAuthTokenSetting)
		self.connect(self.signInWorker, QtCore.SIGNAL('displayInfoNotice()'), self.displayInfoNoticeGlobal)

		# self.connect(bttnCancel, QtCore.SIGNAL('clicked()'), 
		#	self, QtCore.SLOT('close()'))
		self.connect(self.bttnSignIn2, QtCore.SIGNAL('clicked()'),
			self.doSignInClicked)

	def setOAuthTokenSetting(self,token):
		global qb
		qb.dataManager.saveSetting('OAuthToken',token)

	def displayInfoNoticeGlobal(self):
		global infoNoticeString
		global qb
		qb.displayInfoNotice(infoNoticeString)

	def setSignInSuccess(self,completed):
		self.SignInSuccess = completed

	def closeEvent(self, event):
		if self.SigningIn:
			reply = QtGui.QMessageBox.question(self, 'Cancel?',"Are you sure you want to cancel sign in?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
			if reply == QtGui.QMessageBox.Yes:
				self.SigningIn = False
				event.accept()
			else:
				event.ignore()
		else:
			event.accept()

	def signInCompleted(self):
		self.bttnSignIn2.setEnabled(True)
		self.lblLoadingIcon.hide()
		self.loadingGif.stop()
		self.SigningIn = False
		if self.SignInSuccess:
			# emit signOutFinished
			self.emit(QtCore.SIGNAL('signOutFinished()'))	
			self.close()
	
	def pause(self):
		print ''
		time.sleep(1)

	# @QtCore.pyqtSlot()
	def doSignInClicked(self):
		self.bttnSignIn2.setEnabled(False)
		self.lblLoadingIcon.show()
		self.loadingGif.start()
		self.SigningIn = True		
		self.signInWorker.setup(str(self.txtEmail.text()),str(self.txtPasswd.text()))
		self.signInWorker.start()	

class ConfirmSignOutDialog(QtGui.QDialog):
	def __init__(self, parent=None):
		QtGui.QDialog.__init__(self, parent)
		self.setWindowTitle('Sign out?')
		self.resize(800,200)
		self.lblSignout = QtGui.QLabel('Are you sure you want to sign out of foursquare.com? Your OAuth token will be destroyed. You should also remove BarrioSquare from your account by visiting http://foursquare.com/settings',self)
		self.lblSignout.setGeometry(5,5,600,190)
		self.lblSignout.setWordWrap(True)
		self.lblSignout.setAlignment(QtCore.Qt.AlignTop)

		self.bttnOk = QtGui.QPushButton('OK',self)
		self.bttnOk.setGeometry(620,5,175,80)
		self.bttnOk.setStyleSheet(QPUSHBUTTON_DEFAULT)

		self.bttnCancel = QtGui.QPushButton('Cancel',self)
		self.bttnCancel.setGeometry(620,95,175,80)
		self.bttnCancel.setStyleSheet(QPUSHBUTTON_DEFAULT)

		self.connect(self.bttnOk, QtCore.SIGNAL('clicked()'),
			self.buttonOkClicked)	

		self.connect(self.bttnCancel, QtCore.SIGNAL('clicked()'),
			self.buttonCancelClicked)

	def buttonOkClicked(self):
		print 'buttonOkClicked'
		global doingSignout
		doingSignout = True
		self.close()

	def buttonCancelClicked(self):
		print 'buttonCancelClicked'
		global doingSignout
		doingSignout = False
		self.close()

class FriendCheckinDetailDialog(QtGui.QMainWindow):
	def __init__(self, id, parent=None):
		self.parent = parent
		QtGui.QMainWindow.__init__(self, parent)
		# mark as destructable
		self.setAttribute(QtCore.Qt.WA_DeleteOnClose)
		self.dataManager = parent.dataManager
		print 'checkin id: %s' % id
		self.checkinID = id


		p = self.palette()
		p.setColor(QtGui.QPalette.Window, QtGui.QColor(0, 0, 0))
		self.setPalette(p)

		self.resize(800,480)

		self.lblMessage1 = QtGui.QTextDocument(self)
		self.lblMessage1.setTextWidth(800)

		self.bttnVenue = QtGui.QPushButton('Venue Info',self)
		self.bttnVenue.setGeometry(615,95,175,80)
		self.bttnVenue.setStyleSheet(QPUSHBUTTON_DEFAULT)

		self.connect(self.bttnVenue, QtCore.SIGNAL('clicked()'),
			self.doVenueButtonClicked)

		# add a button for tips
		self.bttnCheckin = QtGui.QPushButton('Check-In Here',self)
		self.bttnCheckin.setGeometry(615,5,175,80)
		self.bttnCheckin.setStyleSheet(QPUSHBUTTON_DEFAULT)
		
		self.bttnFriendDetail = QtGui.QPushButton('Friend Detail',self)
		self.bttnFriendDetail.setGeometry(615,185,175,80)
		self.bttnFriendDetail.setStyleSheet(QPUSHBUTTON_DEFAULT)		
		
		self.connect(self.bttnCheckin, QtCore.SIGNAL('clicked()'),self.doCheckinButtonClicked)		
		self.connect(self.bttnFriendDetail, QtCore.SIGNAL('clicked()'),self.doFriendInfoClicked)		

		self.web = QtWebKit.QWebView(self)
		
		self.web.load(QtCore.QUrl.fromLocalFile(APP_DIRECTORY + 'loading.html'))
		self.web.setGeometry(5,2,600,300)

		self.web.show()

		self.venueName = ''
		geolat = ''
		geolong	= ''
		display = ''
		shout = ''
		firstName = ''
		self.venueID = ''

		self.strLatLon = ''
		records = parent.dataManager.doSelectQueryOnMainThread("SELECT Venues.name, Venues.geolat, Venues.geolong, UserCheckinHistory.id, UserCheckinHistory.userID, Users.firstName, Users.lastName, UserCheckinHistory.displayString, UserCheckinHistory.venueID, UserCheckinHistory.shout, UserCheckinHistory.calculatedDistance, UserCheckinHistory.customVenue from UserCheckinHistory INNER JOIN Users ON Users.id=UserCheckinHistory.userID LEFT JOIN Venues ON Venues.id=UserCheckinHistory.VenueID WHERE UserCheckinHistory.id='%s'" % id,"name,geolat,geolong,id,userID,firstName,lastName,displayString,venueID,shout,calculatedDistance,customVenue")
		# print records
		if records['RecordCount'] > 0:
			for row in records['Records']:
				self.venueName = unicode(row['name'].toString())
				geolat = str(row['geolat'].toString())
				geolong = str(row['geolong'].toString())				
				if len(geolat) and len(geolong):
					self.strLatLon = geolat + ',' + geolong
				display = unicode(row['displayString'].toString())
				shout = unicode(row['shout'].toString())
				firstName = unicode(row['firstName'].toString())
				self.venueID = str(row['venueID'].toString())
				self.userID = str(row['userID'].toString())
		del records

		# print venueName
		if len(self.strLatLon) > 0:
			self.web.load(QtCore.QUrl('http://maps.google.com/maps/api/staticmap?center=' + self.strLatLon + '&size=600x300&maptype=roadmap&markers=color:red|' + self.strLatLon + '&zoom=16&sensor=false&key=' + GOOGLE_MAPS_API_KEY))
		else:
			self.web.hide()

		self.setWindowTitle(display)

		message = '<body bgcolor="#000000"><font color="#ffffff">'
		message += "<p style='font-size: 30px; line-height: 15px;'>" + display + "</p>"
		if len(shout) > 0:
			message += "<p style='font-size: 24px; line-height: 15px;'>" + firstName + " says: <i>" + shout + "</i></p>"
		message += '</font></body>'

		self.lblMessage1.setHtml(message)

		qScene = QtGui.QGraphicsScene(self)
		qScene.setBackgroundBrush(QtGui.QColor(0,0,0))
		# qScene.setForegroundBrush(QtGui.QColor(255,255,255))
		qItem = QtGui.QGraphicsTextItem(None, qScene)
		qItem.setDocument(self.lblMessage1)
		qView = QtGui.QGraphicsView(qScene,self)
		qView.setHorizontalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
		qView.setVerticalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
		qView.setGeometry(5,300,800,150)
		qView.setAlignment(QtCore.Qt.AlignTop)
		
	def doFriendInfoClicked(self):
		self.friendDetailDialog = FriendDetailDialog(self.userID,1,self)
		self.friendDetailDialog.show()
	
	def doVenueButtonClicked(self):
		self.placeInfoDlg = PlaceInfoDialog(self.venueID,self.parent,self)

		self.parent.loadingWorker.setup(self.venueID, self.placeInfoDlg, False, 'FriendCheckinDetailDialog.placeInfoDlg')
		self.parent.loadingWorker.start()

		# show processing dialog
		self.parent.processDlg.setTitleAndLabelText('Loading...','Please wait while we load the selected item. We may contact the server to refresh with the latest information')
		self.parent.processDlg.startAnimation()
		self.parent.processDlg.show()
		
	def doCheckinButtonClicked(self):
		self.checkInDlg = CheckInDialog(self.venueID,self.venueName)
		self.checkInDlg.exec_()
		print 'hello!'	
		
	def __del__(self):
		print 'FriendCheckinDetailDialog destructor'	
		
		
class SettingEditDialog(QtGui.QMainWindow):
	def __init__(self, settingItem, parent=None):
		QtGui.QMainWindow.__init__(self, parent)	
		self.setWindowTitle('Edit Setting')
		self.settingItem = settingItem
		self.settingName = self.settingItem.statusTip()
		self.parent = parent
		self.settingItem = settingItem
		records = self.parent.dataManager.doSelectQueryOnMainThread("SELECT userFriendlyName, settingName, settingValue, fieldType FROM Settings WHERE userEditable='Y' AND settingName='%s' order by userFriendlyName" % self.settingName,"userFriendlyName,settingName,settingValue,fieldType")
		# print records
		self.fieldType = ''
		self.userFriendlyName = ''
		if records['RecordCount'] > 0:
			for row in records['Records']:
				self.fieldType = str(row['fieldType'].toString())
				self.userFriendlyName = str(row['userFriendlyName'].toString())
				self.settingValue = str(row['settingValue'].toString())
				
		self.lblSettingName = QtGui.QLabel(self.userFriendlyName, self)
		self.lblSettingName.setGeometry(5,5,790,50)
		self.lblSettingName.setFont(QtGui.QFont('Helvetica', 30))
		
		if self.fieldType == 'B':
			# dropdown with True/False
			self.comboBox = QtGui.QComboBox(self)
			self.comboBox.setGeometry(5,60,790,50)
			self.comboBox.addItem("True",QtCore.QVariant("True"))
			self.comboBox.addItem("False",QtCore.QVariant("False"))
			if self.settingValue == "True":
				self.comboBox.setCurrentIndex(0)
			else:
			    self.comboBox.setCurrentIndex(1)	
		elif self.fieldType == 'S':
			self.txtField = QtGui.QTextEdit(self)
			self.txtField.setGeometry(5,60,790,270)
			self.txtField.setText(self.settingValue)
			
			
		# add save button
		self.bttnSave = QtGui.QPushButton('Save',self)
		self.bttnSave.setGeometry(5,340,175,80)
		self.bttnSave.setStyleSheet(QPUSHBUTTON_DEFAULT)
	
		self.bttnCancel = QtGui.QPushButton('Cancel',self)
		self.bttnCancel.setGeometry(200,340,175,80)
		self.bttnCancel.setStyleSheet(QPUSHBUTTON_DEFAULT)
		
		self.connect(self.bttnSave, QtCore.SIGNAL('clicked()'),	self.doBttnSaveClicked)
		self.connect(self.bttnCancel, QtCore.SIGNAL('clicked()'),	self.doBttnCancelClicked)		
		
	def doBttnSaveClicked(self):
		if self.fieldType == 'B':
			newFieldVal = unicode(self.comboBox.itemData(self.comboBox.currentIndex(),QtCore.Qt.UserRole).toString()) 
		elif self.fieldType == 'S':
			newFieldVal = unicode(self.txtField.text())
		print 'newFieldVal: %s' % newFieldVal
		self.parent.dataManager.saveSetting(self.settingName,newFieldVal)
		# update the parent list widget with new value
		wItem = VenueListItem()

		wItem.setText(self.userFriendlyName,newFieldVal,None)		
		self.parent.settingsListWidget.setItemWidget(self.settingItem,wItem)
		global qb
		qb.doReloadSettings()
		self.close()
		
	def doBttnCancelClicked(self):
		self.close()

class SettingsDialog(QtGui.QMainWindow):
	def __init__(self, parent=None):
		QtGui.QMainWindow.__init__(self, parent)	
		self.setWindowTitle('Settings')
		self.resize(800,480)
		# self.scrollableArea = QtGui.QScrollArea(self)
		self.dataManager = parent.dataManager

		self.settingsListWidget = QtGui.QListWidget(self)
		self.settingsListWidget.setGeometry(5, 5, 820, 400)
		self.settingsListWidget.setStyleSheet(QLISTWIDGET_DEFAULT)

		self.connect(self.settingsListWidget, QtCore.SIGNAL('itemClicked(QListWidgetItem*)'),self.doSettingItemClicked)

		p = self.settingsListWidget.palette()
		p.setColor(QtGui.QPalette.Highlight, QtGui.QColor(255, 255, 184))
		p = self.settingsListWidget.setPalette(p)

		records = self.dataManager.doSelectQueryOnMainThread("SELECT userFriendlyName, settingName, settingValue FROM Settings WHERE userEditable='Y' order by userFriendlyName","userFriendlyName,settingName,settingValue")
		# print records
		if records['RecordCount'] > 0:
			for row in records['Records']:
				settingItem = QtGui.QListWidgetItem('',self.settingsListWidget)
				settingItem.setSizeHint(QtCore.QSize(770, 75))
				wItem = VenueListItem()

				userFriendlyName = str(row['userFriendlyName'].toString())
				settingName = str(row['settingName'].toString())
				settingValue = unicode(row['settingValue'].toString())

				wItem.setText(userFriendlyName,settingValue,None)
				self.settingsListWidget.setItemWidget(settingItem,wItem)
				settingItem.setStatusTip(settingName)	

	
	
	def doSettingItemClicked(self,item):
		self.settingDlg = SettingEditDialog(item,self)
		self.settingDlg.show()
		
		

class LocationSettingsDialog(QtGui.QDialog):
	def __init__(self, parent=None):
		QtGui.QDialog.__init__(self, parent)	
		self.setWindowTitle('Location Settings')
		self.resize(800,480)

		global locationMethodType
		
		self.radioLocationUSER = QtGui.QRadioButton('Use System Default',self)
		self.radioLocationUSER.setGeometry(5,5,700,27)
		if locationMethodType == 0:
			self.radioLocationUSER.setChecked(True)

		self.radioLocationCWP = QtGui.QRadioButton('Use Complementary Wireless Positioning',self)
		self.radioLocationCWP.setGeometry(5,70,700,27)
		if locationMethodType == 1:
			self.radioLocationCWP.setChecked(True)

		self.radioLocationACWP = QtGui.QRadioButton('Use Assisted Complementary Wireless Positioning',self)
		self.radioLocationACWP.setGeometry(5,135,700,27)
		if locationMethodType == 2:
			self.radioLocationACWP.setChecked(True)

		self.radioLocationGNSS = QtGui.QRadioButton('Use Global Navigation Satellite System',self)
		self.radioLocationGNSS.setGeometry(5,200,700,27)
		if locationMethodType == 3:
			self.radioLocationGNSS.setChecked(True)

		self.radioLocationAGNSS = QtGui.QRadioButton('Use Assisted Global Navigation Satellite System',self)
		self.radioLocationAGNSS.setGeometry(5,265,700,27)
		if locationMethodType == 4:
			self.radioLocationAGNSS.setChecked(True)	

		self.bttnOk = QtGui.QPushButton('OK',self)
		self.bttnOk.setGeometry(620,295,175,80)
		self.bttnOk.setStyleSheet(QPUSHBUTTON_DEFAULT)

		self.connect(self.bttnOk, QtCore.SIGNAL('clicked()'),
			self.doBttnOkClicked)	

	def doBttnOkClicked(self):
		self.bttnOk.setEnabled(False)
		global qb
		global locationMethodType
		currentType = qb.locationMethodType
		if self.radioLocationUSER.isChecked():
			locationMethodType = 0
		elif self.radioLocationCWP.isChecked():
			locationMethodType = 1
		elif self.radioLocationACWP.isChecked():
			locationMethodType = 2
		elif self.radioLocationGNSS.isChecked():
			locationMethodType = 3
		elif self.radioLocationAGNSS.isChecked():
			locationMethodType = 4 
		
		# save
		qb.locationMethodType = locationMethodType
		qb.saveSettingToDB('locationMethodType',str(locationMethodType))
		qb.locationManagerObj.setLocationMethodType(locationMethodType)

		if currentType != locationMethodType:
			reply = QtGui.QMessageBox.question(self, 'Location Method Changed',"Attempt to acquire your location based on your new settings?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
			if reply == QtGui.QMessageBox.Yes:
				print 'reinit location process'
				# reinit the location settings
				qb.locationManagerObj.restartSubprocess()	
		self.close()

class LoadNearbyVenuesFromDB(QtCore.QThread):
	def __init__(self, parent = None):
    		QtCore.QThread.__init__(self, parent)
		self.exiting = False

	def setup(self,sequenceID):
		self.sequenceID = sequenceID

	def run(self):
		print 'LoadNearbyVenuesFromDB'
		self.emit(QtCore.SIGNAL('doSelectQueryInBackground'),'select vc.categoryID, Venues.id,Venues.name,Venues.address,Venues.crossstreet,Venues.distance, Venues.isFavorite, Venues.isTrending from Venues inner join VenueSequences on VenueSequences.venueID=Venues.id left join VenueCategories vc on (vc.venueID=Venues.id and vc.isPrimary=1) WHERE VenueSequences.seq=%d ORDER by isFavorite desc, isTrending desc, distance' % self.sequenceID,'placesListWidget','categoryID,id,name,address,crossstreet,distance,isFavorite,isTrending')
		self.emit(QtCore.SIGNAL('clearPlacesListWidget()'))

		# add an item to the end of the list for adding a new venue.
		# self.emit(QtCore.SIGNAL('addItemToPlacesListWidget'),'Add a venue','click to add a venue to foursquare.com','-2',None)
		self.emit(QtCore.SIGNAL('dismissProcessingDialog()'))

	def __del__(self):
		print 'LoadNearbyVenuesFromDB.__del__()'
		self.exiting = True
		self.wait()


class LoadFriendsCheckinsFromFile(QtCore.QThread):
	def __init__(self, parent = None):
    		QtCore.QThread.__init__(self, parent)
		self.exiting = False

	def setup(self,dataManager):
		self.dataManager = dataManager

	def run(self):
		global qb
		global infoNoticeString
		global friendRefreshCount

		# do sql
		limit = 0
		limitRS = self.dataManager.doScalarQueryOnMainThread("select count(userID) as theCount FROM UserFriendStatus where status=1")
		print limitRS
		if limitRS[0]:
			limit = limitRS[1].toInt()[0]
		print limit

		self.emit(QtCore.SIGNAL('doSelectQueryInBackground'),"SELECT VenueMayors.UserID as mayorUserID,UserCheckinHistory.shout, UserCheckinHistory.displayString, UserCheckinHistory.CustomVenue, UserCheckinHistory.id,UserCheckinHistory.VenueID,Venues.name,Venues.address,Venues.crossstreet, UserCheckinHistory.calculatedDistance,Users.photoFile,UserCheckinHistory.createdDate from UserCheckinHistory inner join UserFriendStatus on UserFriendStatus.UserID=UserCheckinHistory.UserID inner join UserLastCheckinDate on UserLastCheckinDate.userID=UserFriendStatus.userID and UserCheckinHistory.id=UserLastCheckinDate.checkinID inner join Users on Users.id=UserFriendStatus.UserID left join Venues on Venues.id=UserCheckinHistory.venueID left join VenueMayors on (VenueMayors.venueID=UserCheckinHistory.venueID and VenueMayors.userID=Users.id) WHERE UserFriendStatus.status=1 order by UserCheckinHistory.createdDate desc LIMIT %d" % limit,'friendsListWidget','mayorUserID,shout,displayString,CustomVenue,id,venueID,name,address,crossstreet,calculatedDistance,photoFile,createdDate')
		self.emit(QtCore.SIGNAL('clearFriendsListWidget()'))
		self.emit(QtCore.SIGNAL('dismissProcessingDialog()'))

	def __del__(self):
		print 'LoadFriendsCheckinsFromFile.__del__()'
		self.exiting = True
		self.wait()

class LoadUserInfoFromServerThread(QtCore.QThread):
	def __init__(self, parent = None):
    		QtCore.QThread.__init__(self, parent)
		self.exiting = False
		self.callingThreadName = None

	def setup(self,userid,downloadBadges,updateProgressBar):
		self.userID = userid
		self.downloadBadges = downloadBadges
		self.updateProgressBar = updateProgressBar

	def run(self):
		print 'LoadUserInfoFromServerThread.run()'
		global infoNoticeString
		global qb
		global lowBandwidthMode

		# print 'doGetUserDetailInBackgroundThread'
		client3 = oauthclient.SimpleOAuthClient('api.foursquare.com', 80, API_PREFIX_URL+'user', ACCESS_TOKEN_URL, AUTHORIZATION_URL)
		consumer = oauth.OAuthConsumer(CONSUMER_KEY, CONSUMER_SECRET)
		signature_method_plaintext = oauth.OAuthSignatureMethod_PLAINTEXT()
		signature_method_hmac_sha1 = oauth.OAuthSignatureMethod_HMAC_SHA1()
		print self.userID
		if self.userID != '0':
			wsParams = {
				'uid':	self.userID,
				'oauth_token':	fsKey,
				'oauth_token_secret':	fsSecret
			}
		else:
			wsParams = {
				'oauth_token':	fsKey,
				'oauth_token_secret':	fsSecret
			}
		if self.downloadBadges:
			wsParams['badges'] = 1
		
		oauth_request = oauth.OAuthRequest.from_consumer_and_token(consumer, callback=CALLBACK_URL, http_url=API_PREFIX_URL+'user', parameters=wsParams)
		oauth_request.sign_request(signature_method_plaintext, consumer, fsRequestToken)
		# print oauth_request.to_postdata()
		connectionResult = False
		try:
			userResultXml = client3.access_resource(oauth_request, http_url=API_PREFIX_URL+'user', requestType='GET')
			connectionResult = True
		except socket.gaierror, e:
			connectionResult = False
			if e[0] == -3:
				infoNoticeString = 'Error: unable to resolve api.foursquare.com hostname'
				self.emit(QtCore.SIGNAL('displayInfoNotice()'))	
			else:
				infoNoticeString = 'Error: unable to connect to api.foursquare.com'
				self.emit(QtCore.SIGNAL('displayInfoNotice()'))	
		
		if connectionResult:
			print userResultXml		
			# save user data to cache file
			parseSuccess = False
			# process result
			try:
				userXml = parseString(userResultXml)
				parseSuccess = True
			except xml.parsers.expat.ExpatError:
				print 'error parsing userResultXml!'
				parseSuccess = False
				print userResultXml
				parseSuccess = False
				infoNoticeString = 'Error: api.foursquare.com problem refreshing user details'
				self.emit(QtCore.SIGNAL('displayInfoNotice()'))

			if parseSuccess == True:			
				errorNode = userXml.getElementsByTagName('error')
				if errorNode.length == 1:
					infoNoticeString = errorNode[0].firstChild.data
					self.emit(QtCore.SIGNAL('displayInfoNotice()'))					
				else:
					# check to see if token expired
					unAuthorizedNode = userXml.getElementsByTagName('unauthorized')
					if unAuthorizedNode.length == 1:
						if unAuthorizedNode[0].firstChild.data == 'TOKEN_EXPIRED':
							infoNoticeString = 'Error: foursquare.com token expired. Please sign back in'
							self.emit(QtCore.SIGNAL('displayInfoNotice()'))						
					else:
						userNode = userXml.getElementsByTagName('user')
						if self.userID == '0':
							global loggedInUserID					
							loggedInUserID = userNode[0].getElementsByTagName('id')[0].firstChild.data
							contextUserID  = loggedInUserID
							# save the userID to settings
							self.emit(QtCore.SIGNAL('saveSettingToDB'),'loggedInUserID',loggedInUserID)
							print 'logged in user: %s' % loggedInUserID
						else:
							contextUserID = self.userID
	
						firstName = userNode[0].getElementsByTagName('firstname')[0].firstChild.data
						lastName = ''
						lastNameNode = userNode[0].getElementsByTagName('lastname')
						if lastNameNode.length > 0:
							if lastNameNode[0].firstChild != None:
								lastName = lastNameNode[0].firstChild.data
	
						photoFile = ''
						photoURL = ''
	
						photoURL = userNode[0].getElementsByTagName('photo')[0].firstChild.data
						photoURLchunks = photoURL.split('/')
						photoFile = userPreferencesDir + 'imageCache' + os.sep + 'users' + os.sep + photoURLchunks[3] + '_' + photoURLchunks[4]
						bigPhotoFile = userPreferencesDir + 'imageCache' + os.sep + 'users' + os.sep + 'userpix_' + photoURLchunks[4]					
						# big photo file:
						bigPhotoURL = "%s//%s/userpix/%s" % (photoURLchunks[0],photoURLchunks[2],photoURLchunks[4])
						print "bigPhotoURL: %s" % bigPhotoURL
						
						# print 'photoFile: ' + photoFile			
						# if cached file doesn't exist for user, download it now
						if not os.path.exists(photoFile):
							qb.getUserPhoto(photoURL)	
							
						if not os.path.exists(bigPhotoFile):
							qb.getUserPhotoBig(bigPhotoURL)							
	
						self.emit(QtCore.SIGNAL('addUserToDatabase'),contextUserID,firstName,lastName,photoFile,photoURL,self.callingThreadName)
	
						phone = ''
						twitter = ''
						facebook = ''
						email = ''
						gender = ''
						phoneNode = userNode[0].getElementsByTagName('phone')
						if phoneNode.length > 0:
							if phoneNode[0].firstChild != None:
								phone = phoneNode[0].firstChild.data
						twitterNode = userNode[0].getElementsByTagName('twitter')
						if twitterNode.length > 0:
							if twitterNode[0].firstChild != None:
								twitter = twitterNode[0].firstChild.data
						facebookNode = userNode[0].getElementsByTagName('facebook')
						if facebookNode.length > 0:
							if facebookNode[0].firstChild != None:
								facebook = facebookNode[0].firstChild.data
						emailNode = userNode[0].getElementsByTagName('email')
						if emailNode.length > 0:
							if emailNode[0].firstChild != None:
								email = emailNode[0].firstChild.data
						genderNode = userNode[0].getElementsByTagName('gender')
						if genderNode.length > 0:
							if genderNode[0].firstChild != None:
								if genderNode[0].firstChild.data == 'male':
									gender = 'M'
								elif genderNode[0].firstChild.data == 'female':
									gender = 'F'
	
						self.emit(QtCore.SIGNAL('addEditUserDetails'),contextUserID,phone,twitter,facebook,email,gender)
	
						settingsNode = userXml.getElementsByTagName('settings')
						if settingsNode.length > 0:
							twitterNode = settingsNode[0].getElementsByTagName('sendtotwitter')
							if twitterNode.length > 0:
								if twitterNode[0].firstChild.data == 'true':
									global pingTwitter
									pingTwitter = True
	
							facebookNode = settingsNode[0].getElementsByTagName('sendtofacebook')
							if facebookNode.length > 0:
								if facebookNode[0].firstChild.data == 'true':
									global pingFacebook
									pingFacebook = True
	
						badgesNodes = userXml.getElementsByTagName('badge')
						if self.userID == '0':
							global badgeCount
							badgeCount = badgesNodes.length
	
						if self.downloadBadges:
							if badgesNodes.length > 0:
								callingThreadName = None
								if self.updateProgressBar:
									# update progress bar with count of badges
									self.emit(QtCore.SIGNAL('setProcessingDialogProgressBarMaxValue'),badgesNodes.length)			
									self.emit(QtCore.SIGNAL('setDatabaseExpectedResultCount'),('LoadUserInfoFromServerThread',badgesNodes.length,0))
									callingThreadName = 'LoadUserInfoFromServerThread'
	
								for node in badgesNodes:
									name = node.getElementsByTagName('name')[0].firstChild.data
									badgeID = node.getElementsByTagName('id')[0].firstChild.data
									description = node.getElementsByTagName('description')[0].firstChild.data
									badgeIconURL = node.getElementsByTagName('icon')[0].firstChild.data
									badgeURLchunks = badgeIconURL.split('/')
									badgeFilePath = userPreferencesDir + 'imageCache' + os.sep + 'badges' + os.sep + badgeURLchunks[4] + '_' + badgeURLchunks[5]
									print 'badgeFile: ' + badgeFilePath			
									# if cached file doesn't exist for user, download it now
									if not os.path.exists(badgeFilePath):
										if lowBandwidthMode:
											shutil.copy(APP_DIRECTORY + 'default_off.png',badgeFile)														
										else:
											photoResponse = urllib2.urlopen(badgeIconURL)
											photoData = photoResponse.read()
		
											badgeFile = open(badgeFilePath,'w')
											badgeFile.write(photoData)
											badgeFile.close()
									# save the badge to the database
									self.emit(QtCore.SIGNAL('addBadgeToDatabase'),badgeID,name,description,badgeIconURL,badgeFilePath,contextUserID,callingThreadName)
	
								if self.updateProgressBar:
									self.exec_()						
				userXml.unlink()
		if qb.signInInit:
			self.emit(QtCore.SIGNAL('signedInInitialLoad'),qb.nextInitIndex)				

	def __del__(self):
		print 'LoadUserInfoFromServerThread.__del__()'
		self.exiting = True
		self.wait()

class UserHistoryLoaderThread(QtCore.QThread):
	def __init__(self, parent = None):
    		QtCore.QThread.__init__(self, parent)
		self.exiting = False

	def setup(self,userID,mainWindow):
		self.userID = userID
		self.mainWindow = mainWindow

	def run(self):
		print 'UserHistoryLoaderThread.run()'
		# set the max history value as historyID
		if self.mainWindow.dataManager != None:
			result = self.mainWindow.dataManager.doScalarQueryOnMainThread("SELECT id FROM UserCheckinHistory WHERE userID in ('%s','0') ORDER BY createdDate DESC LIMIT 1" % self.userID)
			if result[0]:
				checkinID = str(result[1].toString())
				# save the setting
				self.mainWindow.saveSettingToDB('lastHistoryID',checkinID)
				self.mainWindow.lastHistoryID = checkinID

		# TODO: change limit to be read from settings
		self.emit(QtCore.SIGNAL('doSelectQueryInBackground'),"SELECT Venues.id,Venues.name,Venues.address,Venues.crossstreet,Venues.distance,UserCheckinHistory.shout,UserCheckinHistory.createdDate from UserCheckinHistory left join Venues on UserCheckinHistory.venueID=Venues.id WHERE UserCheckinHistory.userID in ('%s','0') ORDER by UserCheckinHistory.createdDate desc LIMIT 30" % self.userID,'historyListWidget','id,name,address,crossstreet,distance,shout,createdDate')
		self.emit(QtCore.SIGNAL('clearHistoryListWidget()'))
		self.emit(QtCore.SIGNAL('dismissProcessingDialog()'))

	def __del__(self):
		print 'UserHistoryLoaderThread.__del__()'
		self.exiting = True
		self.wait()

# background event loop thread to friends list and if location changed update nearby places.
class BackgroundRefreshThread(QtCore.QThread):
	def __init__(self, parent = None):
    		QtCore.QThread.__init__(self, parent)
		self.exiting = False

	def run(self):
		print 'thread logic'

	def __del__(self):
		print 'BackgroundRefreshThread.__del__()'
		self.exiting = True
		self.wait()

class AddVenueWorkerThread(QtCore.QThread):
	def __init__(self, parent = None):
    		QtCore.QThread.__init__(self, parent)
		self.exiting = False
		self.venueName = ''
		self.address = ''
		self.crossStreet = ''
		self.city = ''
		self.state = ''
		self.zipCode = ''
		self.phone = ''

	def setup(self,venueName,address,crossStreet,city,state,zipCode,phone):
		self.venueName = venueName
		self.address = address
		self.crossStreet = crossStreet
		self.city = city
		self.state = state
		self.zipCode = zipCode
		self.phone = phone

	def run(self):
		global FakeAddVenue
		global infoNoticeString
		print 'thread logic'
		parseSuccess = False

		if not FakeAddVenue:
			client3 = oauthclient.SimpleOAuthClient('api.foursquare.com', 80, API_PREFIX_URL+'addvenue', ACCESS_TOKEN_URL, AUTHORIZATION_URL)
			consumer = oauth.OAuthConsumer(CONSUMER_KEY, CONSUMER_SECRET)
			signature_method_plaintext = oauth.OAuthSignatureMethod_PLAINTEXT()
			signature_method_hmac_sha1 = oauth.OAuthSignatureMethod_HMAC_SHA1()

			params = {
				'geolat' : 	currentLatitude,
				'geolong':	currentLongitude,
				'name':		self.venueName,
				'oauth_token':	fsKey,
				'oauth_token_secret':	fsSecret
			}

			if self.address != '':
				params['address'] = self.address
			if self.crossStreet != '':
				params['crossstreet'] = self.crossStreet
			if self.city != '':
				params['city'] = self.city
			if self.state != '':
				params['state'] = self.state
			if self.zipCode != '':
				params['zip'] = self.zipCode
			if self.phone != '':
				params['phone'] = self.phone

			oauth_request = oauth.OAuthRequest.from_consumer_and_token(consumer, callback=CALLBACK_URL, http_url=API_PREFIX_URL+'addvenue', parameters=params)
			oauth_request.sign_request(signature_method_plaintext, consumer, fsRequestToken)
			print oauth_request.to_postdata()
			addResultXmlString = client3.access_resource(oauth_request, http_url=API_PREFIX_URL+'addvenue', requestType='POST')
			print addResultXmlString

			try:
				addResultXml = parseString(addResultXmlString)
				parseSuccess = True
				addVenueCacheFile = open(userPreferencesDir + 'addVenueCache.xml','w')
				addVenueCacheFile.write(addResultXmlString)
				addVenueCacheFile.close()
			except xml.parsers.expat.ExpatError:
				print 'error parsing checkinResult'
				parseSuccess = False

		else:
			print 'fake add venue'
			addResultXmlFile = open(userPreferencesDir + 'addVenueCache.xml','r')
			addResultXmlString = ''
			for line in addResultXmlFile:
				addResultXmlString += line
			addResultXmlFile.close()
			print addResultXmlString			

		if not parseSuccess:
			try:
				addResultXml = parseString(addResultXmlString)
				parseSuccess = True
			except xml.parsers.expat.ExpatError:
				print 'error parsing checkinResult'
				parseSuccess = False
				infoNoticeString = 'Error: api.foursquare.com problem. Error adding venue.'
				self.emit(QtCore.SIGNAL('displayInfoNotice()'))	

		if parseSuccess:
			errorNodes = addResultXml.getElementsByTagName('error')
			if errorNodes.length > 0:
				# has error
				errorString = errorNodes[0].firstChild.data
				self.emit(QtCore.SIGNAL('setAddVenueResult'),0,0,'',errorString)	
			else:
				venueNodes = addResultXml.getElementsByTagName('venue')
				if venueNodes.length > 0:
					venueIDnode = venueNodes[0].getElementsByTagName('id')
					venueID = int(venueIDnode[0].firstChild.data)
					venueNameNode = venueNodes[0].getElementsByTagName('name')
					venueName = venueNameNode[0].firstChild.data
					self.emit(QtCore.SIGNAL('setAddVenueResult'),1,venueID,venueName,'')	

	def __del__(self):
		print 'AddVenueWorkerThread.__del__()'
		self.exiting = True
		self.wait()


class AddVenueWindow(QtGui.QMainWindow):
	def __init__(self, parent=None):
		QtGui.QMainWindow.__init__(self, parent)
		p = self.palette()
		p.setColor(QtGui.QPalette.Window, QtGui.QColor(0, 0, 0))
		self.setPalette(p)

		self.setWindowTitle('Add a venue')
		self.addSuccess = 0
		self.addingVenue = True
		self.errorMessage = ''
		self.venueName = ''

		# self.scrollArea = QtGui.QScrollArea(self)
		
		container = QtGui.QWidget(self)
		container.setGeometry(0,0,800,420)
		
		self.lblVenueName = QtGui.QLabel('Venue Name:', container)
		self.lblVenueName.setGeometry(5,5,200,60)
		self.lblVenueName.setFont(QtGui.QFont('Helvetica', 20))
		self.txtVenueName = QtGui.QLineEdit(container)
		self.txtVenueName.setGeometry(210,5,580,60)

		self.lblAddress = QtGui.QLabel('Address:', container)
		self.lblAddress.setGeometry(5,65,200,60)
		self.lblAddress.setFont(QtGui.QFont('Helvetica', 20))
		self.txtAddress = QtGui.QLineEdit(container)
		self.txtAddress.setGeometry(210,65,580,60)

		self.lblXStreet = QtGui.QLabel('Cross Street:', container)
		self.lblXStreet.setGeometry(5,125,200,60)
		self.lblXStreet.setFont(QtGui.QFont('Helvetica', 20))
		self.txtXStreet = QtGui.QLineEdit(container)
		self.txtXStreet.setGeometry(210,125,580,60)

		self.lblCity = QtGui.QLabel('City:', container)
		self.lblCity.setGeometry(5,185,200,60)
		self.lblCity.setFont(QtGui.QFont('Helvetica', 20))
		self.txtCity = QtGui.QLineEdit(container)
		self.txtCity.setGeometry(210,185,580,60)

		self.lblState = QtGui.QLabel('State/Province:', container)
		self.lblState.setGeometry(5,245,200,60)
		self.lblState.setFont(QtGui.QFont('Helvetica', 20))
		self.txtState = QtGui.QLineEdit(container)
		self.txtState.setGeometry(210,245,240,60)

		self.lblZip = QtGui.QLabel('Zip/Postal Code:', container)
		self.lblZip.setGeometry(5,305,200,60)
		self.lblZip.setFont(QtGui.QFont('Helvetica', 20))
		self.txtZip = QtGui.QLineEdit(container)
		self.txtZip.setGeometry(210,305,240,60)

		self.lblPhone = QtGui.QLabel('Phone:', container)
		self.lblPhone.setGeometry(5,365,200,60)
		self.lblPhone.setFont(QtGui.QFont('Helvetica', 20))
		self.txtPhone = QtGui.QLineEdit(container)
		self.txtPhone.setGeometry(210,365,240,60)

		self.bttnAddVenue = QtGui.QPushButton('Add Venue', container)
		self.bttnAddVenue.setGeometry(530,290,175,80)
		self.bttnAddVenue.setStyleSheet(QPUSHBUTTON_DEFAULT)

		self.connect(self.bttnAddVenue, QtCore.SIGNAL('clicked()'),
			self.doValidateInput)

		self.lblLoadingIcon = QtGui.QLabel('',self)
		self.loadingGif = QtGui.QMovie(APP_DIRECTORY + 'loading2.gif', QtCore.QByteArray(), self)
		self.loadingGif.setCacheMode(QtGui.QMovie.CacheAll)
		self.loadingGif.setSpeed(100)
		self.loadingGif.setBackgroundColor(QtGui.QColor(0, 0, 0))
		self.lblLoadingIcon.setGeometry(720,305,50,50)
		self.lblLoadingIcon.setMovie(self.loadingGif)
		self.lblLoadingIcon.hide()

		# container.setMinimumSize(QtCore.QSize(800,600))
		# self.scrollArea.setWidget(container)
		# self.scrollArea.setGeometry(0,0,800,420)

		self.addWorker = AddVenueWorkerThread()
		self.connect(self.addWorker ,QtCore.SIGNAL('finished()'),self.addVenueProcessFinished)
		self.connect(self.addWorker, QtCore.SIGNAL('setAddVenueResult'), self.setAddVenueResult)

	def setAddVenueResult(self,status,venueID,venueName,errorString):
		self.addSuccess = status
		self.venueID = venueID
		self.errorMessage = errorString
		self.venueName = venueName

	def closeEvent(self, event):
		if self.addingVenue:
			reply = QtGui.QMessageBox.question(self, 'Cancel?',"Are you sure you want to cancel adding this venue?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
			if reply == QtGui.QMessageBox.Yes:
				self.addingVenue = False
				event.accept()
			else:
				event.ignore()
		else:
			event.accept()

	def addVenueProcessFinished(self):
		self.loadingGif.stop()
		self.lblLoadingIcon.hide()
		# disable the activity indicator
		if self.addSuccess == 1:
			self.addingVenue = False
			# display message box asking for user wants to checkin
			print 'display ask'
			reply = QtGui.QMessageBox.question(self, 'Venue Added',"Venue successfully added. Do you want to check in to this venue you just added?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
			# emit signal to main window to close this window and open checkin dialog for venue
			if reply == QtGui.QMessageBox.Yes:
				self.emit(QtCore.SIGNAL('closeVenueAddWindowAndCheckIn'),self.venueID,self.venueName,True)	
			else:
				self.emit(QtCore.SIGNAL('closeVenueAddWindowAndCheckIn'),0,'',False)	

		elif self.addSuccess == 0:
			reply = QtGui.QMessageBox.question(self, 'Error',self.errorMessage, QtGui.QMessageBox.Ok)			
			self.setEnableDisableInputFields(True)


	def setEnableDisableInputFields(self,setBool):
		self.txtVenueName.setEnabled(setBool)
		self.txtAddress.setEnabled(setBool)
		self.txtXStreet.setEnabled(setBool)
		self.txtCity.setEnabled(setBool)
		self.txtState.setEnabled(setBool)
		self.txtZip.setEnabled(setBool)
		self.txtPhone.setEnabled(setBool)
		self.bttnAddVenue.setText('Add Venue')
		self.bttnAddVenue.setEnabled(True)

	def doValidateInput(self):
		# validate form input
		# require venueName, address, city, state
		vName = str(self.txtVenueName.text()).strip()
		address = str(self.txtAddress.text()).strip()
		city = str(self.txtCity.text()).strip()
		crossStreet = str(self.txtXStreet.text()).strip()
		state = str(self.txtState.text()).strip()
		zipCode = str(self.txtZip.text()).strip()
		phone = str(self.txtPhone.text()).strip()

		self.setEnableDisableInputFields(False)

		if ((vName == '') or (address == '') or (city == '')):
			reply = QtGui.QMessageBox.question(self, 'Missing Fields',"The following fields are required to add a location: Venue Name, Address, City", QtGui.QMessageBox.Ok)
			self.setEnableDisableInputFields(True)
		else:			
			self.addWorker.setup(vName,address,crossStreet,city,state,zipCode,phone)
			self.bttnAddVenue.setText('Adding...')
			self.bttnAddVenue.setEnabled(False)
			self.loadingGif.start()
			self.lblLoadingIcon.show()
			self.addWorker.start()

class MainWindow(QtGui.QMainWindow):
	def __init__(self, parent=None):
		QtGui.QMainWindow.__init__(self, parent)
		
		self.doMainWindowInit()
		
	def resizePixmap(self,filePath,x,y):
		pixmap = QtGui.QPixmap(filePath)
		pixmap2 = pixmap.scaled(QtCore.QSize(x,y), QtCore.Qt.IgnoreAspectRatio, QtCore.Qt.SmoothTransformation)		
		pixmap2.save(filePath,None,-1)
		del pixmap2
		del pixmap		
		
	def downloadVenueIcon(self,iconFilePath,catIconUrl):
		photoResponse = urllib2.urlopen(catIconUrl)
		photoData = photoResponse.read()

		badgeFile = open(iconFilePath,'w')
		badgeFile.write(photoData)
		badgeFile.close()			
		
	def getFilePathForIconUrl(self,url):
		chunks = url.split("/")
		filePath = ''
		for i in range(4,len(chunks)):
			filePath = '%s%s' % (filePath,chunks[i])
			if i < len(chunks)-1:
				filePath = '%s_' % filePath
		return filePath
	
	def loadCategories(self):
		self.categoryIcons = { }
		records = self.dataManager.doSelectQueryOnMainThread("SELECT id,iconFilePath FROM Categories", "id,iconFilePath")
		if records['RecordCount'] > 0:
			for row in records['Records']:
				self.categoryIcons[str(row['id'].toString())] = str(row['iconFilePath'].toString())
				
		del records
		print self.categoryIcons
		
			
	def doReloadSettings(self):
		self.settingsCollection = self.dataManager.getSettings()
		global automaticDataRefresh
		global manualLocationRefresh
		global lowBandwidthMode
		if self.settingsCollection['automaticDataRefresh'] == 'True':
			automaticDataRefresh = True
		else:
			automaticDataRefresh = False
		if self.settingsCollection['manualLocationRefresh'] == 'True':
			manualLocationRefresh = True
		else:
			manualLocationRefresh = False
		if self.settingsCollection['lowBandwidthMode'] == 'True':
			lowBandwidthMode = True
			self.lowBandwidthModeSetting = True
		else:
		    lowBandwidthMode = False
		    self.lowBandwidthModeSetting = False

	def doMainWindowInit(self):
		global automaticDataRefresh
		global manualLocationRefresh
		self.databaseOperationRecords = { }
		self.placeInfoDlg = None
		self.processDlg = None
		self.nearbyFriendsCheckins = { }

		self.dataManager = DataManager(APP_DIRECTORY + 'barriosq.db', userPreferencesDir + 'barriosq.db')
		self.connect(self.dataManager.insertUpdateDeleteThread, QtCore.SIGNAL('queryFinishedFromWorkerThread'), self.dataManagerQueryFinished)
		self.connect(self.dataManager.selectQueryThread, QtCore.SIGNAL('pushRowToUIListWidgetFromWorkerThread'), self.pushRowToUIListWidget)
		
		self.doReloadSettings()
		self.loadCategories()
		
		print self.settingsCollection

		global GOOGLE_MAPS_API_KEY
		GOOGLE_MAPS_API_KEY = self.settingsCollection['googleMapsAPIKey']

		self.nearbySequenceID = 0
		self.signInInit = False
		self.nextInitIndex = 0

		if 'nearbySequenceID' in self.settingsCollection:
			self.nearbySequenceID = int(self.settingsCollection['nearbySequenceID'])
		global locationMethodType
		self.locationMethodType = int(self.settingsCollection['locationMethodType'])
		locationMethodType = self.locationMethodType
		global currentLatitude
		global currentLongitude
		global horizontalAccuracy
		global verticalAccuracy
		saveLocation = self.settingsCollection['currentLocation'].split('|')
		currentLatitude = float(saveLocation[0])
		currentLongitude = float(saveLocation[1])
		horizontalAccuracy = float(saveLocation[2])
		verticalAccuracy = float(saveLocation[3])

		self.locationManagerObj = LocationManager()		
		self.locationManagerObj.setLocationMethodType(self.locationMethodType)
		self.connect(self.locationManagerObj.locationBackgroundWorker,QtCore.SIGNAL('displayInfoNotice'), self.displayInfoNotice)
		self.connect(self.locationManagerObj.locationBackgroundWorker,QtCore.SIGNAL('setLocationMethodType'), self.setLocationMethodType)
		# connect the locationManager's background worker to slot
		self.connect(self.locationManagerObj.locationBackgroundWorker,QtCore.SIGNAL('saveSettingToDB'),self.dataManager.saveSetting)

		if not manualLocationRefresh:
			self.locationManagerObj.acquireLocationFix()
		self.lastTimeFriendsListRefreshed = int(time.mktime(time.strptime(self.settingsCollection['lastTimeFriendsListRefreshed'].split('.')[0],'%Y-%m-%d %H:%M:%S')))

		self.userID = self.settingsCollection['loggedInUserID']
		self.maxHistoryToDisplay = int(self.settingsCollection['maxHistoryToDisplay'])
		if self.settingsCollection['lastHistoryID'] == 'None':
			self.lastHistoryID = 0
		else:
			self.lastHistoryID = self.settingsCollection['lastHistoryID']

		global loggedInUserID
		loggedInUserID = self.userID

		global fsRequestToken
		global fsKey
		global fsSecret
		fsRequestToken = self.settingsCollection['OAuthToken']
		if fsRequestToken == 'None':
			fsRequestToken = None
		else:
			params = cgi.parse_qs(fsRequestToken, keep_blank_values=False)
			fsKey = params['oauth_token'][0]
			fsSecret = params['oauth_token_secret'][0]
			fsRequestToken = oauth.OAuthToken(fsKey, fsSecret)

		self.setWindowIcon(QtGui.QIcon(QtGui.QPixmap(APP_DIRECTORY + 'barrioSquare.png')))

		self.osso_c = osso.Context("barrioSquare", SHORT_VERSION_STRING, False)
		self.osso_rpc = osso.Rpc(self.osso_c)

		self.locationDialog = None
		self.setWindowTitle('BarrioSquare')
		self.processDlg = None

		# set menu
		# self.menubar = self.menuBar()
		# entry = self.menubar.addAction('&About')
		# entry = self.menubar.addAction('&Sign Out')


		#label = QtGui.QLabel('testing', self)
		#label.setGeometry(10, 60, 50, 20)

		self.resize(800,480)

		# add menu
		#
		# self.menuBar = QtGui.QMenuBar(self)
		# self.menuBarMainMenu = self.menuBar.addMenu('BQ')
		# if (fsRequestToken == None):
		#	self.menuBarMainMenuSignInOut = self.menuBarMainMenu.addAction('Sign In')
		# else:
		#	self.menuBarMainMenuSignInOut = self.menuBarMainMenu.addAction('Sign Out')
		self.bttnSignIn = QtGui.QPushButton('', self)			
		if (fsRequestToken == None):
			self.bttnSignIn.setGeometry(5, 338, 80, 80)
			self.bttnSignIn.setStyleSheet(QPUSHBUTTON_DEFAULT)
			self.bttnSignIn.setIcon(QtGui.QIcon(QtGui.QPixmap(APP_DIRECTORY + 'signOutIcon.png')))
			self.bttnSignIn.setIconSize(QtCore.QSize(70,70))
		else:
			self.bttnSignIn.hide()


		# button for search
		self.bttnSearch = QtGui.QPushButton('', self)			
		self.bttnSearch.setGeometry(630, 338, 80, 80)
		self.bttnSearch.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnSearch.setIcon(QtGui.QIcon(QtGui.QPixmap(APP_DIRECTORY + 'searchIcon.png')))
		self.bttnSearch.setIconSize(QtCore.QSize(70,70))

		# button for location
		self.bttnLocation = QtGui.QPushButton('', self)
		self.bttnLocation.setGeometry(90, 338, 80, 80)

		if (fsRequestToken == None):			
			self.bttnLocation.hide()
		self.bttnLocation.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnLocation.setIcon(QtGui.QIcon(QtGui.QPixmap(APP_DIRECTORY + 'myInfoIcon.png')))
		self.bttnLocation.setIconSize(QtCore.QSize(70,70))

		# button for settings
		self.bttnSettings = QtGui.QPushButton('', self)
		if (fsRequestToken == None):
			self.bttnSettings.setGeometry(90, 338, 80, 80)
		else:
			self.bttnSettings.setGeometry(5, 338, 80, 80)
		self.bttnSettings.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnSettings.setIcon(QtGui.QIcon(QtGui.QPixmap(APP_DIRECTORY + 'settingsIcon.png')))
		self.bttnSettings.setIconSize(QtCore.QSize(70,70))

		self.bttnHistory = QtGui.QPushButton('', self)			
		self.bttnHistory.setGeometry(367, 338, 80, 80)
		self.bttnHistory.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnHistory.setIcon(QtGui.QIcon(QtGui.QPixmap(APP_DIRECTORY + 'historyIcon.png')))
		self.bttnHistory.setIconSize(QtCore.QSize(70,70))

		self.connect(self.bttnHistory, QtCore.SIGNAL('clicked()'),
			self.doShowHistoryTab)
		
		self.bttnTips = QtGui.QPushButton('', self)			
		self.bttnTips.setGeometry(281, 338, 80, 80)
		self.bttnTips.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnTips.hide()
		if fsRequestToken == None:
			self.bttnTips.hide()
		# self.bttnTips.setIcon(QtGui.QIcon(QtGui.QPixmap(APP_DIRECTORY + 'historyIcon.png')))
		# self.bttnTips.setIconSize(QtCore.QSize(70,70))

		self.connect(self.bttnTips, QtCore.SIGNAL('clicked()'),
			self.doShowTipsTab)		

		self.bttnFriends = QtGui.QPushButton('', self)			
		self.bttnFriends.setGeometry(453, 338, 86, 80)
		self.bttnFriends.setStyleSheet(QPUSHBUTTON_HIGHLIGHT)
		self.bttnFriends.setIcon(QtGui.QIcon(QtGui.QPixmap(APP_DIRECTORY + 'friendsIcon.png')))
		self.bttnFriends.setIconSize(QtCore.QSize(70,70))

		self.connect(self.bttnFriends, QtCore.SIGNAL('clicked()'),
			self.doShowFriendsTab)

		self.bttnPlaces = QtGui.QPushButton('', self)			
		self.bttnPlaces.setGeometry(545, 338, 80, 80)
		self.bttnPlaces.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnPlaces.setIcon(QtGui.QIcon(QtGui.QPixmap(APP_DIRECTORY + 'placesIcon.png')))
		self.bttnPlaces.setIconSize(QtCore.QSize(70,70))
			
		# self.placesMenu = QtGui.QMenu(self)
		# self.bttnPlacesAddPlaceAction = self.placesMenu.addAction('Add Place')
		# self.connect(self.bttnPlacesAddPlaceAction, QtCore.SIGNAL("triggered()"), self.doAddPlaceTriggered)
		# self.bttnPlaces.setMenu(self.placesMenu)

		self.connect(self.bttnPlaces, QtCore.SIGNAL('clicked()'),
			self.doShowPlacesTab)

		# push menu
		self.settingsMenu = QtGui.QMenu(self)

		self.settingsMenuAboutAction = self.settingsMenu.addAction('About')
		self.connect(self.settingsMenuAboutAction, QtCore.SIGNAL("triggered()"), self.doAboutActionTriggered)

		self.settingsAction = self.settingsMenu.addAction('Settings')
		self.connect(self.settingsAction, QtCore.SIGNAL("triggered()"), self.doSettingsActionTriggered)


		self.settingsMenuClearCacheAction = self.settingsMenu.addAction('Clear Cache')
		self.connect(self.settingsMenuClearCacheAction, QtCore.SIGNAL("triggered()"), self.doClearCacheActionTriggered)

		self.settingLocationMenuAction = self.settingsMenu.addAction('Location Settings')

		self.connect(self.settingLocationMenuAction, QtCore.SIGNAL("triggered()"), self.doShowLocationSettingsDialog)
		
		if (fsRequestToken != None): 
			self.confirmSignOutDlg = ConfirmSignOutDialog()
			self.connect(self.confirmSignOutDlg, QtCore.SIGNAL('finished(int)'),self.onSignOutDialogClosed)

			self.signOutAction = self.settingsMenu.addAction(QtGui.QIcon(QtGui.QPixmap(APP_DIRECTORY + 'signOutIcon.png')),'Sign Out')
			# self.connect(self.signOutAction, QtCore.SIGNAL("triggered()"), self.doSignInClicked())

		self.bttnSettings.setMenu(self.settingsMenu)

		self.connect(self.bttnLocation, QtCore.SIGNAL('clicked()'),
			self.doShowLocationDialog)

		if (fsRequestToken == None):
			self.bttnSearch.hide()
			self.bttnLocation.hide()
			self.bttnPlaces.hide()
			self.bttnFriends.hide()
			self.bttnHistory.hide()

		# button for refresh
		self.bttnRefresh = QtGui.QPushButton('', self)			
		self.bttnRefresh.setGeometry(715, 338, 80, 80)
		self.bttnRefresh.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnRefresh.setIcon(QtGui.QIcon(QtGui.QPixmap(APP_DIRECTORY + 'refreshIcon.png')))
		self.bttnRefresh.setIconSize(QtCore.QSize(70,70))

		if (fsRequestToken == None):
			self.bttnRefresh.hide()

		# dialog for sign in
		self.signInDlg = SignInDialog()

		# dialog for search
		self.searchDlg = SearchDialog(self)

		# add a tab widget
		self.tabWidget = QtGui.QTabWidget(self)
		self.tabWidget.setGeometry(0, 0, 800, 330)

		self.friendsTab = QtGui.QWidget()
		self.tabWidget.addTab(self.friendsTab, QtCore.QString())

		self.placesTab = QtGui.QWidget()
		self.tabWidget.addTab(self.placesTab, QtCore.QString())

		self.historyTab = QtGui.QWidget()
		self.tabWidget.addTab(self.historyTab, QtCore.QString())

		self.searchResultsTab = QtGui.QWidget()
		self.tabWidget.addTab(self.searchResultsTab, QtCore.QString())
		
		self.tipsTab = QtGui.QWidget()
		self.tabWidget.addTab(self.tipsTab, QtCore.QString())		

		self.tabWidget.setTabText(self.tabWidget.indexOf(self.friendsTab),QtGui.QApplication.translate('MainWindow','Friends','Friends',QtGui.QApplication.UnicodeUTF8))
		self.tabWidget.setTabText(self.tabWidget.indexOf(self.placesTab),QtGui.QApplication.translate('MainWindow','Places','Places',QtGui.QApplication.UnicodeUTF8))
		self.tabWidget.setTabText(self.tabWidget.indexOf(self.historyTab),QtGui.QApplication.translate('MainWindow','History','History',QtGui.QApplication.UnicodeUTF8))
		self.tabWidget.setTabText(self.tabWidget.indexOf(self.searchResultsTab),QtGui.QApplication.translate('MainWindow','Search Results','Search Results',QtGui.QApplication.UnicodeUTF8))
		self.tabWidget.setTabText(self.tabWidget.indexOf(self.tipsTab),QtGui.QApplication.translate('MainWindow','Tips','Tips',QtGui.QApplication.UnicodeUTF8))		
		
		self.tabWidget.setStyleSheet("QTabBar::tab { height: 0px; width: 180px; }");

		# add list widget for friends
		self.friendsListWidget = QtGui.QListWidget(self.friendsTab)
		self.friendsListWidget.setGeometry(0, 0, 820, 330) #310
		self.friendsListWidget.setStyleSheet(QLISTWIDGET_DEFAULT)

		p = self.friendsListWidget.palette()
		p.setColor(QtGui.QPalette.Highlight, QtGui.QColor(255, 255, 184))
		p = self.friendsListWidget.setPalette(p)

		# add list widget for places
		self.placesListWidget = QtGui.QListWidget(self.placesTab)
		self.placesListWidget.setGeometry(0, 0, 820, 330) #310
		self.placesListWidget.setStyleSheet(QLISTWIDGET_DEFAULT)

		p = self.placesListWidget.palette()
		p.setColor(QtGui.QPalette.Highlight, QtGui.QColor(255, 255, 184))
		p = self.placesListWidget.setPalette(p)

		# add list widget for history
		self.historyListWidget = QtGui.QListWidget(self.historyTab)
		self.historyListWidget.setGeometry(0, 0, 820, 330) #310
		self.historyListWidget.setStyleSheet(QLISTWIDGET_DEFAULT)

		p = self.historyListWidget.palette()
		p.setColor(QtGui.QPalette.Highlight, QtGui.QColor(255, 255, 184))
		p = self.historyListWidget.setPalette(p)

		# add list widget for search
		self.searchListWidget = QtGui.QListWidget(self.searchResultsTab)
		self.searchListWidget.setGeometry(0, 0, 820, 330) #310
		self.searchListWidget.setStyleSheet(QLISTWIDGET_DEFAULT)

		p = self.searchListWidget.palette()
		p.setColor(QtGui.QPalette.Highlight, QtGui.QColor(255, 255, 184))
		p = self.searchListWidget.setPalette(p)
		
		# add list widget for search
		self.tipListWidget = QtGui.QListWidget(self.tipsTab)
		self.tipListWidget.setGeometry(0, 0, 820, 330) #310
		self.tipListWidget.setStyleSheet(QLISTWIDGET_DEFAULT)

		p = self.tipListWidget.palette()
		p.setColor(QtGui.QPalette.Highlight, QtGui.QColor(255, 255, 184))
		p = self.tipListWidget.setPalette(p)		
		

		self.loadingWorker = PlaceInfoLoaderWorkerThread()
		self.connect(self.loadingWorker, QtCore.SIGNAL('displayInfoNotice()'), self.displayInfoNoticeGlobal)
		self.connect(self.loadingWorker, QtCore.SIGNAL('nearbyItemLoadingFinished'), self.nearbyItemLoadingFinished)
		self.connect(self.loadingWorker, QtCore.SIGNAL('addEditUserVenueStats'),self.dataManager.addEditUserVenueStats)
		self.connect(self.loadingWorker, QtCore.SIGNAL('addUserToDatabase'),self.dataManager.addEditUser)
		self.connect(self.loadingWorker, QtCore.SIGNAL('addEditVenueTip'),self.dataManager.addEditVenueTip)
		self.connect(self.loadingWorker, QtCore.SIGNAL('addVenueRecentCheckin'),self.dataManager.addVenueRecentCheckin)
		self.connect(self.loadingWorker, QtCore.SIGNAL('setDatabaseExpectedResultCount'), self.setDatabaseExpectedResultCount)
		self.connect(self.loadingWorker, QtCore.SIGNAL('setProcessingDialogProgressBarMaxValue'), self.setProcessingDialogProgressBarMaxValue)
		self.connect(self.loadingWorker, QtCore.SIGNAL('incrementDatabaseExpectedResultCount'), self.incrementDatabaseExpectedResultCount)		


		self.friendsListWorker = GetFriendsForUserWorkerThread()
		self.connect(self.friendsListWorker, QtCore.SIGNAL('finished()'), self.friendsListWorkerFinished)
		self.connect(self.friendsListWorker, QtCore.SIGNAL('addUserToDatabase'),self.dataManager.addEditUser)
		self.connect(self.friendsListWorker, QtCore.SIGNAL('doDeleteQueryInBackgroundThread'),self.dataManager.doDeleteQueryInBackgroundThread)
		self.connect(self.friendsListWorker, QtCore.SIGNAL('saveSettingToDB'), self.dataManager.saveSetting)
		self.connect(self.friendsListWorker, QtCore.SIGNAL('doLoadFriendsCheckings'),self.doLoadFriendsCheckings)
		self.connect(self.friendsListWorker, QtCore.SIGNAL('setDatabaseExpectedResultCount'), self.setDatabaseExpectedResultCount)
		self.connect(self.friendsListWorker, QtCore.SIGNAL('setProcessingDialogProgressBarMaxValue'), self.setProcessingDialogProgressBarMaxValue)
		self.connect(self.friendsListWorker, QtCore.SIGNAL('signedInInitialLoad'), self.signedInInitialLoad)
		self.connect(self.friendsListWorker, QtCore.SIGNAL('addUserFriendStatus'),self.dataManager.addUserFriendStatus)
		
		# thread to load venues from file
		self.loadNearbyVenuesWorker = LoadNearbyVenuesFromDB()
		self.connect(self.loadNearbyVenuesWorker, QtCore.SIGNAL('clearPlacesListWidget()'), self.clearPlacesListWidget)
		self.connect(self.loadNearbyVenuesWorker, QtCore.SIGNAL('doSelectQueryInBackground'), self.dataManager.doSelectQueryInBackgroundThread)
		self.connect(self.loadNearbyVenuesWorker, QtCore.SIGNAL('addItemToPlacesListWidget'), self.addItemToPlacesListWidget)
		self.connect(self.loadNearbyVenuesWorker, QtCore.SIGNAL('displayInfoNotice()'), self.displayInfoNoticeGlobal)
		self.connect(self.loadNearbyVenuesWorker, QtCore.SIGNAL('dismissProcessingDialog()'), self.dismissProcessingDialog)

		# thread to load checkins from file and update UI
		self.loadFriendsCheckinsWorker = LoadFriendsCheckinsFromFile()
		self.loadFriendsCheckinsWorker.setup(self.dataManager)
		self.connect(self.loadFriendsCheckinsWorker, QtCore.SIGNAL('signOut()'),self.onSignOutDialogClosed)
		self.connect(self.loadFriendsCheckinsWorker, QtCore.SIGNAL('doSelectQueryInBackground'), self.dataManager.doSelectQueryInBackgroundThread)
		self.connect(self.loadFriendsCheckinsWorker, QtCore.SIGNAL('clearFriendsListWidget()'), self.clearFriendsListWidget)
		self.connect(self.loadFriendsCheckinsWorker, QtCore.SIGNAL('addItemToFriendsListWidget'), self.addItemToFriendsListWidget)
		self.connect(self.loadFriendsCheckinsWorker, QtCore.SIGNAL('displayInfoNotice()'), self.displayInfoNoticeGlobal)
		self.connect(self.loadFriendsCheckinsWorker, QtCore.SIGNAL('dismissProcessingDialog()'), self.dismissProcessingDialog)
		self.connect(self.loadFriendsCheckinsWorker, QtCore.SIGNAL('finished()'), self.finishedLoadingFriendsCheckingsFromFile)

		# worker thread to retrieve checkins from server
		self.refreshFriendsWorker = RefreshFriendsWorkerThread()
		self.connect(self.refreshFriendsWorker, QtCore.SIGNAL('finished()'), self.loadFriendsCheckingsResultsFromFile)
		self.connect(self.refreshFriendsWorker, QtCore.SIGNAL('displayInfoNotice()'), self.displayInfoNoticeGlobal)
		self.connect(self.refreshFriendsWorker, QtCore.SIGNAL('addUserToDatabase'),self.dataManager.addEditUser)
		self.connect(self.refreshFriendsWorker, QtCore.SIGNAL('setDatabaseExpectedResultCount'), self.setDatabaseExpectedResultCount)
		self.connect(self.refreshFriendsWorker, QtCore.SIGNAL('setProcessingDialogProgressBarMaxValue'), self.setProcessingDialogProgressBarMaxValue)
		self.connect(self.refreshFriendsWorker, QtCore.SIGNAL('addCheckinHistoryItemToDatabase'), self.dataManager.addCheckinHistoryItem)
		self.connect(self.refreshFriendsWorker, QtCore.SIGNAL('addVenueItemToDatabase'), self.addVenueItemToDatabase)
		self.connect(self.refreshFriendsWorker, QtCore.SIGNAL('signedInInitialLoad'), self.signedInInitialLoad)
		self.connect(self.refreshFriendsWorker, QtCore.SIGNAL('addEditUserLastCheckinToDatabase'), self.dataManager.addEditUserLastCheckin)
		self.connect(self.refreshFriendsWorker, QtCore.SIGNAL('incrementDatabaseExpectedResultCount'), self.incrementDatabaseExpectedResultCount)
		self.connect(self.refreshFriendsWorker, QtCore.SIGNAL('setVenueMayorship'),self.dataManager.setVenueMayorship)

		# nearby worker
		self.nearbyPlacesWorker = NearbyWorkerThread()
		self.connect(self.nearbyPlacesWorker, QtCore.SIGNAL('finished()'), self.loadNearby)
		self.connect(self.nearbyPlacesWorker, QtCore.SIGNAL('setDatabaseExpectedResultCount'), self.setDatabaseExpectedResultCount)
		self.connect(self.nearbyPlacesWorker, QtCore.SIGNAL('addVenueItemToDatabase'), self.addVenueItemToDatabase)
		self.connect(self.nearbyPlacesWorker, QtCore.SIGNAL('setProcessingDialogProgressBarMaxValue'), self.setProcessingDialogProgressBarMaxValue)
		self.connect(self.nearbyPlacesWorker, QtCore.SIGNAL('signedInInitialLoad'), self.signedInInitialLoad)
		self.connect(self.nearbyPlacesWorker, QtCore.SIGNAL('addCategoryToDatabase'), self.dataManager.addEditCategory)
		self.connect(self.nearbyPlacesWorker, QtCore.SIGNAL('addVenueCategoryToDatabase'), self.dataManager.addVenueCategory)
		self.connect(self.nearbyPlacesWorker, QtCore.SIGNAL('resizePixmap'), self.resizePixmap)
		
		# self.connect(self.nearbyPlacesWorker, QtCore.SIGNAL('setProcessingDialogProgressBarValue'), self.setProcessingDialogProgressBarValue)
		self.nearbyTipsWorker = NearbyTipsWorkerThread()
		self.connect(self.nearbyTipsWorker, QtCore.SIGNAL('finished()'), self.loadNearbyTips)
		self.connect(self.nearbyTipsWorker, QtCore.SIGNAL('setDatabaseExpectedResultCount'), self.setDatabaseExpectedResultCount)
		self.connect(self.nearbyTipsWorker, QtCore.SIGNAL('addVenueItemToDatabase'), self.addVenueItemToDatabase)
		self.connect(self.nearbyTipsWorker, QtCore.SIGNAL('setProcessingDialogProgressBarMaxValue'), self.setProcessingDialogProgressBarMaxValue)
		self.connect(self.nearbyTipsWorker, QtCore.SIGNAL('signedInInitialLoad'), self.signedInInitialLoad)
		self.connect(self.nearbyTipsWorker, QtCore.SIGNAL('addEditVenueTip'),self.dataManager.addEditVenueTip)
		self.connect(self.nearbyTipsWorker, QtCore.SIGNAL('addUserToDatabase'),self.dataManager.addEditUser)
		self.connect(self.nearbyTipsWorker, QtCore.SIGNAL('incrementDatabaseExpectedResultCount'), self.incrementDatabaseExpectedResultCount)				

		# user info fro server worker
		self.loadUserInfoFromServerWorker = LoadUserInfoFromServerThread()
		self.connect(self.loadUserInfoFromServerWorker, QtCore.SIGNAL('displayInfoNotice()'), self.displayInfoNoticeGlobal)
		self.connect(self.loadUserInfoFromServerWorker, QtCore.SIGNAL('saveSettingToDB'), self.dataManager.saveSetting)
		self.connect(self.loadUserInfoFromServerWorker, QtCore.SIGNAL('setDatabaseExpectedResultCount'), self.setDatabaseExpectedResultCount)
		self.connect(self.loadUserInfoFromServerWorker, QtCore.SIGNAL('setProcessingDialogProgressBarMaxValue'), self.setProcessingDialogProgressBarMaxValue)
		self.connect(self.loadUserInfoFromServerWorker, QtCore.SIGNAL('addEditUserDetails'),self.dataManager.addEditUserDetails)
		# cross connect the signal directly to dataManager's method(slot)
		self.connect(self.loadUserInfoFromServerWorker, QtCore.SIGNAL('addBadgeToDatabase'), self.dataManager.addEditBadge)
		self.connect(self.loadUserInfoFromServerWorker, QtCore.SIGNAL('addUserToDatabase'),self.dataManager.addEditUser)
		self.connect(self.loadUserInfoFromServerWorker, QtCore.SIGNAL('signedInInitialLoad'), self.signedInInitialLoad)

		# history loader worker
		self.historyLoaderWorker = UserHistoryLoaderThread()
		self.connect(self.historyLoaderWorker, QtCore.SIGNAL('doSelectQueryInBackground'), self.dataManager.doSelectQueryInBackgroundThread)
		self.connect(self.historyLoaderWorker, QtCore.SIGNAL('clearHistoryListWidget()'), self.clearHistoryListWidget)
		self.connect(self.historyLoaderWorker, QtCore.SIGNAL('addItemToHistoryListWidget'), self.addItemToHistoryListWidget)
		self.connect(self.historyLoaderWorker, QtCore.SIGNAL('displayInfoNotice()'), self.displayInfoNoticeGlobal)

		self.connect(self.bttnSignIn, QtCore.SIGNAL('clicked()'),self.doSignInClicked)	

		self.signInDlg = SignInDialog()		
		self.connect(self.signInDlg, QtCore.SIGNAL('signOutFinished()'),self.onSignInDialogClosed)

		self.connect(self.bttnRefresh, QtCore.SIGNAL('clicked()'),self.doRefreshListWidget)		
		self.connect(self.bttnSearch, QtCore.SIGNAL('clicked()'),self.showSearchDialog)
		# print 'Bind Places signal'
		self.connect(self.placesListWidget, QtCore.SIGNAL('itemClicked(QListWidgetItem*)'),self.doNearbyItemClicked)
		# print 'Bind Search signal'
		self.connect(self.searchListWidget, QtCore.SIGNAL('itemClicked(QListWidgetItem*)'),self.doNearbyItemClicked)
		# print 'Bind Friends signal'
		self.connect(self.friendsListWidget, QtCore.SIGNAL('itemClicked(QListWidgetItem*)'),self.doFriendItemClicked)
		self.connect(self.historyListWidget, QtCore.SIGNAL('itemClicked(QListWidgetItem*)'),self.doNearbyItemClicked)

		self.historyWorker = HistoryWorkerThread()
		self.connect(self.historyWorker, QtCore.SIGNAL('finished()'),self.historyFinished)
		self.connect(self.historyWorker, QtCore.SIGNAL('reloadMainWindowWithResultsOfHistory()'), self.reloadMainWindowWithHistoryResults)		
		self.connect(self.historyWorker, QtCore.SIGNAL('addCheckinHistoryItemToDatabase'), self.dataManager.addCheckinHistoryItem)
		self.connect(self.historyWorker, QtCore.SIGNAL('setDatabaseExpectedResultCount'), self.setDatabaseExpectedResultCount)
		self.connect(self.historyWorker, QtCore.SIGNAL('setProcessingDialogProgressBarMaxValue'), self.setProcessingDialogProgressBarMaxValue)
		self.connect(self.historyWorker, QtCore.SIGNAL('addVenueItemToDatabase'), self.addVenueItemToDatabase)
		self.connect(self.historyWorker, QtCore.SIGNAL('signedInInitialLoad'), self.signedInInitialLoad)
		self.connect(self.historyWorker, QtCore.SIGNAL('displayInfoNotice()'), self.displayInfoNoticeGlobal)

		self.processDlg = ProcessingDialog()
		self.connect(self.processDlg, QtCore.SIGNAL('finished(int)'),
			self.doProcessingDialogClosed)

		self.pendingFriendsWorker = GetPendingFriendRequestsForUserWorkerThread()
		self.connect(self.pendingFriendsWorker, QtCore.SIGNAL('finished()'), self.pendingFriendsWorkerFinished)
		self.connect(self.pendingFriendsWorker, QtCore.SIGNAL('showDialogHasFriendsForApproval'), self.showDialogHasFriendsForApproval)		
		self.connect(self.pendingFriendsWorker, QtCore.SIGNAL('addUserToDatabase'),self.dataManager.addEditUser)
		self.connect(self.pendingFriendsWorker, QtCore.SIGNAL('doDeleteQueryInBackgroundThread'),self.dataManager.doDeleteQueryInBackgroundThread)
		self.connect(self.pendingFriendsWorker, QtCore.SIGNAL('addUserFriendStatus'),self.dataManager.addUserFriendStatus)
		self.connect(self.pendingFriendsWorker, QtCore.SIGNAL('addEditUserDetails'),self.dataManager.addEditUserDetails)

		mayorPixmap0 = QtGui.QPixmap(APP_DIRECTORY + 'crown.png')
		self.mayorPixmap = mayorPixmap0.scaled(QtCore.QSize(24,24), QtCore.Qt.IgnoreAspectRatio, QtCore.Qt.SmoothTransformation)		

		
		if (fsRequestToken != None):
			if automaticDataRefresh:
				self.doGetUserDetailForLoggedInUser()
			self.loadFriendsCheckingsResultsFromFile()
			 				
		 	self.loadNearby()
			self.reloadMainWindowWithHistoryResults()

			currentTime = int(time.mktime(time.gmtime()))
			timediff = currentTime - self.lastTimeFriendsListRefreshed
			print 'timediff: %d' % timediff
			# for refresh
			if automaticDataRefresh:
				if (timediff > 5):
					self.friendsListWorker.setup('0',False)
					self.friendsListWorker.start()
				else:
					del self.friendsListWorker
					self.friendsListWorker = None
					self.pendingFriendsWorker.start()	
		# else:
		#	self.doSignInClicked()
		
	def setLocationMethodType(self,typeID):
		self.locationMethodType = typeID

	def doSettingsActionTriggered(self):
		self.settingsDlg = SettingsDialog(self)
		self.settingsDlg.show()

	def incrementDatabaseExpectedResultCount(self,threadName):
		self.dataManagerQueryFinished(threadName)

	def saveSettingToDB(self,settingName,settingValue):
		self.dataManager.saveSetting(settingName,settingValue)

	def setProcessingDialogProgressBarValue(self,value):
		if self.processDlg != None:
			self.processDlg.setCurrentValue(value)
			self.processDlg.progressBar.setValue(value)
		
	def setProcessingDialogProgressBarMaxValue(self,maxValue):
		if self.processDlg != None:
			self.processDlg.progressBar.setMaximum(maxValue)

	def doSelectQueryInBackground(self,queryString,listWidget,columnList):
		self.dataManager.doSelectQueryInBackgroundThread(queryString,listWidget,columnList)

	def pushRowToUIListWidget(self,row):
		# print '***************** pushRowToUIListWidget ************'
		# if self.processDlg != None:
		# 	newValue = self.processDlg.currentValue + 1
		#	print 'newValue: %d' % newValue
		#	self.setProcessingDialogProgressBarValue(newValue)			

		# print row
		# print row['_UIListWidget']
		if row['_UIListWidget'] == 'placesListWidget':
			if 'Finished' in row:
				print 'placesListWidget finished'
				self.addItemToPlacesListWidget('Add a venue','click to add a venue to foursquare.com','-2',None)				
			else:
				isTrending = str(row['isTrending'].toString())
				isFav = str(row['isFavorite'].toString())			
				name = unicode(row['name'].toString())
				address = unicode(row['address'].toString())
				crossstreet = unicode(row['crossstreet'].toString())
				distance = str(row['distance'].toString())
				categoryID = str(row['categoryID'].toString())
				iconFile = None
				
				# print self.categoryIcons 
				
				if len(categoryID) > 0:
					if categoryID in self.categoryIcons:				
						iconFile = self.categoryIcons[categoryID]
					else:
						iconFile = APP_DIRECTORY + 'question.png'
				else:
					iconFile = APP_DIRECTORY + 'question.png'
				
				if isTrending == '1':
					iconFile = APP_DIRECTORY + 'Trending.png'
				elif isFav == '1':
					iconFile = APP_DIRECTORY + 'Star.png'
				# print 'distance: %s' % distance
				if len(crossstreet) > 0:
					address += ' (' + crossstreet + ')'
				if len(distance) > 0:
					address += ' ~' + unicode(self.calcMetersAsString(distance))
				venueID = str(row['id'].toString())
				self.addItemToPlacesListWidget(name,address,venueID,iconFile)
		elif row['_UIListWidget'] == 'historyListWidget':
			if 'Finished' in row:
				print 'historyListWidget finished'
			else:			
				name = unicode(row['name'].toString())
				address = unicode(row['address'].toString())
				crossstreet = unicode(row['crossstreet'].toString())
				if len(crossstreet) > 0:
					address += ' (' + crossstreet + ')'
				venueID = str(row['id'].toString())
				shout = unicode(row['shout'].toString())
				# print 'venueID: %s' % venueID
				if len(venueID) == 0:
					OffGrid = True
				else:
					OffGrid = False
				self.addItemToHistoryListWidget(name,shout,address,OffGrid,venueID)
		elif row['_UIListWidget'] == 'friendsListWidget':
			if 'Finished' in row:
				print 'friendsListWidget finished'
				print self.nearbyFriendsCheckins
			else:				
				# shout,displayString,CustomVenue,id,name,address,crossstreet,calculatedDistance,photoFile,createdDate
				venueName = unicode(row['name'].toString())
				address = unicode(row['address'].toString())
				crossstreet = unicode(row['crossstreet'].toString())
				if len(crossstreet) > 0:
					address += ' (' + crossstreet + ')'
				venueID = str(row['venueID'].toString())
				checkinID = str(row['id'].toString())
				displayString = unicode(row['displayString'].toString())
				photoFile = str(row['photoFile'].toString())
				mayorUserID = str(row['mayorUserID'].toString())
				distance = int(row['calculatedDistance'].toString())
				isMayor = False
				if len(mayorUserID) > 0:
					isMayor = True
				OffGrid = False
				if len(venueID) == 0:
					OffGrid = True			
				dateStr = unicode(self.calcDateString(str(row["createdDate"].toString()), False, 1))
				
				timeSinceEpoch = int(time.mktime(time.strptime(str(row["createdDate"].toString()),'%Y-%m-%d %H:%M:%S')))
				currentTimeSinceEpoch = int(time.mktime(time.gmtime()))
				timeDiffSecs = currentTimeSinceEpoch - timeSinceEpoch
				# print 'timeDiffSeconds: %d distance: %d' % (timeDiffSecs,distance)
				if timeDiffSecs < 7200 and distance < 200000:
					self.nearbyFriendsCheckins[checkinID] = distance
				
				address += ' ~' + dateStr
				shoutString = unicode(row["shout"].toString())
				if len(shoutString):
					displayString += ' ("' + shoutString + '")'
				if OffGrid:
					self.addItemToFriendsListWidget(displayString,address,photoFile,OffGrid,'-1',isMayor)
				else:
					self.addItemToFriendsListWidget(displayString,address,photoFile,OffGrid,checkinID,isMayor)
		elif row['_UIListWidget'] == 'searchListWidget':
			if 'Finished' in row:
				print 'searchListWidget finished'
				nearbyItem = QtGui.QListWidgetItem('',self.searchListWidget)	
				nearbyItem.setSizeHint(QtCore.QSize(770, 75))
				wItem = VenueListItem()
				wItem.setText('Add a venue','click to add a venue to foursquare.com',APP_DIRECTORY + 'AddItem.png')
				self.searchListWidget.setItemWidget(nearbyItem,wItem)
				nearbyItem.setStatusTip('-2')				
			else:				
				name = unicode(row['name'].toString())
				address = unicode(row['address'].toString())
				crossstreet = unicode(row['crossstreet'].toString())
				distance = str(row['distance'].toString())
				iconFile = None
				# print 'distance: %s' % distance
				if len(crossstreet) > 0:
					address += ' (' + crossstreet + ')'
				if len(distance) > 0:
					address += ' ~' + unicode(self.calcMetersAsString(distance))
				venueID = str(row['id'].toString())
	
				nearbyItem = QtGui.QListWidgetItem('',self.searchListWidget)	
				nearbyItem.setSizeHint(QtCore.QSize(770, 75))
				wItem = VenueListItem()
				wItem.setText(name,address,None)
				self.searchListWidget.setItemWidget(nearbyItem,wItem)
				nearbyItem.setStatusTip(venueID)

	def dataManagerQueryFinished(self,threadName):
		if threadName in self.databaseOperationRecords:
			# print 'MainWindow.dataManagerQueryFinished(%s)' % threadName
			self.databaseOperationRecords[threadName]['RecordsCurrent'] += 1
			self.setProcessingDialogProgressBarValue(self.databaseOperationRecords[threadName]['RecordsCurrent'])
			print 'current %s: %d of %d total' % (threadName, self.databaseOperationRecords[threadName]['RecordsCurrent'],self.databaseOperationRecords[threadName]['RecordsTotal'])
			if self.databaseOperationRecords[threadName]['RecordsCurrent'] >= self.databaseOperationRecords[threadName]['RecordsTotal']:
				time.sleep(1)
				print 'Total Record Count Finished'
				# need to quit the event loop in the child thread
				if threadName == 'NearbyWorkerThread':
					self.nearbyPlacesWorker.quit()
				elif threadName == 'HistoryWorkerThread':
					self.historyWorker.quit()
				elif threadName == 'RefreshFriendsWorkerThread':
					if self.refreshFriendsWorker.eventloopRunning:
						self.refreshFriendsWorker.quit()
				elif threadName == 'GetFriendsForUserWorkerThread':
					self.friendsListWorker.quit()
				elif threadName == 'LoadUserInfoFromServerThread':
					self.loadUserInfoFromServerWorker.quit()
				elif threadName == 'PlaceInfoLoaderWorkerThread':
					self.loadingWorker.quit()
				elif threadName == 'SearchWorkerThread':
					if self.searchDlg != None:
						self.searchDlg.searchWorker.quit()
				elif threadName == 'NearbyTipsWorkerThread':
					self.nearbyTipsWorker.quit()

	def setDatabaseExpectedResultCount(self,params):
		print 'setDatabaseExpectedResultCount'
		print params
		self.databaseOperationRecords[params[0]] = { 'RecordsTotal': params[1], 'RecordsCurrent' : params[2] }

	def addEditUserToDatabase(self,userID,firstName,lastName,photoFile,photoURL,callingThreadName):
		self.dataManager.addEditUser(userID,firstName,lastName,photoFile,photoURL,callingThreadName)

	def addBadgeToDatabase(self,badgeID,name,description,badgeURL,badgeFile,userID,callingThreadName):
		self.dataManager.addEditBadge(badgeID,name,description,badgeURL,badgeFile,userID,callingThreadName)

	# slot to add item to database using data layer
	def addVenueItemToDatabase(self,sequenceID,venueID,distance,name,address,crossstreet,city,state,zipCode,phone,isFav,isTrending,geolat,geolong,mayorID,callingThreadName):	
		self.dataManager.addEditVenueItem(sequenceID,venueID,name,address,crossstreet,city,state,zipCode,phone,geolat,geolong,callingThreadName)		
		# print 'distance: %d' % distance
		if distance > 0:
			self.dataManager.updateVenueDistance(venueID,distance)
		if isTrending >= 0 and isFav >= 0:
			self.dataManager.updateVenueIsTrendingFavorite(venueID,isTrending,isFav)

	def showDialogHasFriendsForApproval(self,approvalCount):
		print 'showDialogHasFriendsForApproval'
		print 'approvalCount: %d' % approvalCount
		if approvalCount == 1:
			msg = "You have 1 pending friend request. "
		else:
			msg = "You have %d pending friend requests. " % approvalCount
		msg += "Would you like to view "
		if approvalCount == 1:
			msg += "this"
		else:
			msg += "these"
		msg += ' requests now? Click "Ignore" to not be reminded about this request again.'
		reply = QtGui.QMessageBox.question(self, 'Friends awaiting approval',msg, QtGui.QMessageBox.Yes, QtGui.QMessageBox.No, QtGui.QMessageBox.Ignore)
		if reply == QtGui.QMessageBox.Ignore:
			print 'ignore'
			# copy the friend requests xml to an _Ignore file - compare every server friend/requests against this file. if there is a diff, reprompt the user
			self.dataManager.ignorePendingFriends()
		elif reply == QtGui.QMessageBox.Yes:
			self.myFriendsWindow = MyFriendsDialog('0',1,self)
			self.connect(self.myFriendsWindow, QtCore.SIGNAL('finished()'),self.doMyFriendsWindowClosed)
			self.myFriendsWindow.show()

	def doMyFriendsWindowClosed(self):
		print 'doMyFriendsWindowClosed'
		self.disconnect(self.myFriendsWindow, QtCore.SIGNAL('finished()'),self.doMyFriendsWindowClosed)

	def friendsListWorkerFinished(self):
		print 'friendsListWorkerFinished'
		del self.friendsListWorker
		self.friendsListWorker = None
		self.pendingFriendsWorker.start()

	def pendingFriendsWorkerFinished(self):
		del self.pendingFriendsWorker
		self.pendingFriendsWorker = None

	def doProcessingDialogClosed(self):
		print 'doProcessingDialogClosed'
		self.processDlg.stopAnimation()

	def doAddPlaceTriggered(self):
		print 'doAddPlaceTriggered'

	def doAboutActionTriggered(self):
		QtGui.QMessageBox.about(self, 'About ' + VERSION_STRING,"Copyright (c) 2010 Chili Technologies LLC\nVisit http://google.com/group/barriosquare or http://chilitechno.com/fster for more information.")

	def doClearCacheActionTriggered(self):
		reply = QtGui.QMessageBox.question(self, 'Clear Cache?',"Are you sure you want to clear the cache? Cached place data, recent history, friends checkins, and other resources will be removed from device.", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
		if reply == QtGui.QMessageBox.Yes:
			# TODO: do delete cache items
			print 'TODO'

	def finishedLoadingFriendsCheckingsFromFile(self):
		global friendRefreshCount
		friendRefreshCount = friendRefreshCount + 1
		print 'friendRefreshCount = %d' % friendRefreshCount
		# track friends reload count - if first reload count, i.e. first reload from startup, then do another refresh
		if friendRefreshCount == 1:
			self.doLoadFriendsCheckings(False)
		
	def closeEvent(self, event):
		if self.settingsCollection['promptOnExit'] == 'True':
			reply = QtGui.QMessageBox.question(self, 'Quit?',"Are you sure you want to quit barrioSquare?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
		else:
			reply = QtGui.QMessageBox.Yes
		if reply == QtGui.QMessageBox.Yes:
			global getLocationChildPID
			global locationAcceptClientConnections
			locationAcceptClientConnections = False
			if getLocationChildPID > 0:
				# kill subprocess before exit
				try:
					os.kill(getLocationChildPID, 9)
				except OSError:
					print 'error killing child, already terminated?'
			self.dataManager.shutdown()
			# exit all child thread event loops
			self.loadingWorker.quit()			
			self.loadNearbyVenuesWorker.quit()
			self.loadFriendsCheckinsWorker.quit()
			self.refreshFriendsWorker.quit()
			self.nearbyPlacesWorker.quit()
			self.loadUserInfoFromServerWorker.quit()
			self.historyLoaderWorker.quit()
			self.historyWorker.quit()
			if self.friendsListWorker != None:
				self.friendsListWorker.quit()
			if self.pendingFriendsWorker != None:
				self.pendingFriendsWorker.quit()			
			event.accept()						
		else:
			event.ignore()

	def checkUnauthorized(self,xmlString):
		IsUnauthorized = 0
		unauthorizedNodes = xmlString.getElementsByTagName('unauthorized')
		if unauthorizedNodes.length > 0:
			IsUnauthorized = 1
			if unauthorizedNodes[0].firstChild.data == 'TOKEN_EXPIRED':
				IsUnauthorized = 1
		else:
			IsUnauthorized = 0
		return IsUnauthorized

	def addItemToFriendsListWidget(self,displayStr,addressString,photoFile,OffGrid,checkinId,isMayor):
		# this method is called from our worker thread to update UI on main thread
		checkinItem = QtGui.QListWidgetItem('',self.friendsListWidget)
		checkinItem.setSizeHint(QtCore.QSize(770, 75))
		wItem = FriendListItem(not OffGrid)

		wItem.setMayor(isMayor,self.mayorPixmap)
		wItem.setText(displayStr,addressString,'dateStr',photoFile)
		self.friendsListWidget.setItemWidget(checkinItem,wItem)
		if OffGrid:
			checkinItem.setStatusTip('-1')
		else:
			checkinItem.setStatusTip(checkinId)

	def addItemToHistoryListWidget(self,venueName,shout,addressString,OffGrid,venueID):
		nearbyItem = QtGui.QListWidgetItem('',self.historyListWidget)	
		nearbyItem.setSizeHint(QtCore.QSize(770, 75))
		wItem = VenueListItem()
		if venueName != '':
			wItem.setText(venueName,addressString,None)
		else:
			if len(shout):
				wItem.setText('You said: ' + shout,addressString,None)
			else:
				wItem.setText('[Off the Grid]',addressString,None)
		self.historyListWidget.setItemWidget(nearbyItem,wItem)
		nearbyItem.setStatusTip(venueID)

	def addItemToPlacesListWidget(self,venueName,addressString,venueID,iconFile):
		if venueID != '-2':
			nearbyItem = QtGui.QListWidgetItem('',self.placesListWidget)	
			nearbyItem.setSizeHint(QtCore.QSize(770, 75))
			wItem = VenueListItem()
			wItem.setText(venueName,addressString,iconFile)
			self.placesListWidget.setItemWidget(nearbyItem,wItem)
			nearbyItem.setStatusTip(venueID)
		else:
			# use friend list item to add item to places list widget with "Connecting Icon"
			checkinItem = QtGui.QListWidgetItem('',self.placesListWidget)
			checkinItem.setSizeHint(QtCore.QSize(770, 75))
			wItem = VenueListItem()

			wItem.setText(venueName,addressString,APP_DIRECTORY + 'AddItem.png')			
			self.placesListWidget.setItemWidget(checkinItem,wItem)
			checkinItem.setStatusTip(venueID)

	def clearHistoryListWidget(self):
		self.historyListWidget.clear()
			
	def clearPlacesListWidget(self):
		self.placesListWidget.clear()

	def clearFriendsListWidget(self):
		self.friendsListWidget.clear()
		
	def doShowTipsTab(self):
		self.bttnTips.setStyleSheet(QPUSHBUTTON_HIGHLIGHT)		
		self.bttnFriends.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnPlaces.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnSearch.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnHistory.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.tabWidget.setCurrentWidget(self.tipsTab)
	
	def doShowHistoryTab(self):
		self.bttnTips.setStyleSheet(QPUSHBUTTON_DEFAULT)				
		self.bttnFriends.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnPlaces.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnSearch.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnHistory.setStyleSheet(QPUSHBUTTON_HIGHLIGHT)
		self.tabWidget.setCurrentWidget(self.historyTab)

	def doShowFriendsTab(self):
		self.bttnTips.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnFriends.setStyleSheet(QPUSHBUTTON_HIGHLIGHT)
		self.bttnPlaces.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnSearch.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnHistory.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.tabWidget.setCurrentWidget(self.friendsTab)

	def doShowPlacesTab(self):
		self.bttnTips.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnFriends.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnPlaces.setStyleSheet(QPUSHBUTTON_HIGHLIGHT)
		self.bttnSearch.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnHistory.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.tabWidget.setCurrentWidget(self.placesTab)

	def doShowLocationSettingsDialog(self):
		# print 'doShowLocationSettingsDialog'
		self.locationSettingsDlg = LocationSettingsDialog()
		self.locationSettingsDlg.show()

	def historyFinished(self):
		self.processDlg.stopAnimation()
		self.processDlg.close()

	def simpleNetworkTest(self):
		networkResult = False
		try:
			response = urllib2.urlopen('http://foursquare.com/img/scoring/3.png')
			networkResult = True
		except:
			networkResult = False
		return networkResult

	def testNetworkConnection(self):
		client3 = oauthclient.SimpleOAuthClient('api.foursquare.com', 80, API_PREFIX_URL+'test', ACCESS_TOKEN_URL, AUTHORIZATION_URL)
		consumer = oauth.OAuthConsumer(CONSUMER_KEY, CONSUMER_SECRET)
		signature_method_plaintext = oauth.OAuthSignatureMethod_PLAINTEXT()
		signature_method_hmac_sha1 = oauth.OAuthSignatureMethod_HMAC_SHA1()
	
		nearbyParams = {
			'test':	'ok'
		}
		oauth_request = oauth.OAuthRequest.from_consumer_and_token(consumer, callback=CALLBACK_URL, http_url=API_PREFIX_URL+'test', parameters=nearbyParams)
		oauth_request.sign_request(signature_method_plaintext, consumer, fsRequestToken)
		print oauth_request.to_postdata()
		testResultXml = client3.access_resource(oauth_request, http_url=API_PREFIX_URL+'test', requestType='GET')

	def reloadMainWindowWithHistoryResults(self):
		# print 'reloadMainWindowWithHistoryResults'
		# start the history worker loader thread
		self.historyLoaderWorker.setup(self.userID,self)
		self.historyLoaderWorker.start()
	
	def dismissProcessingDialog(self):
		self.processDlg.stopAnimation()
		self.processDlg.close()		
		self.processDlg.progressBar.reset()


	def displayInfoNotice(self,infoString):
		note = osso.SystemNote(self.osso_c)
		result = note.system_note_infoprint(infoString)

	def displayInfoNoticeGlobal(self):
		global infoNoticeString
		if infoNoticeString.find("token expired") >= 0:
			self.processDlg.stopAnimation()
			self.processDlg.close()
			self.processDlg.progressBar.reset()
		self.displayInfoNotice(infoNoticeString)

	def locationAcquired(self):
		print 'locationAcquired'
		self.displayInfoNotice('Location Updated')
		if self.locationDialog != None:		
			strLatLon = '%f' % currentLatitude
			strLatLon += ',%f' % currentLongitude
			print strLatLon
			self.locationDialog.strLatLon = strLatLon
			self.locationDialog.web.load(QtCore.QUrl('http://maps.google.com/maps/api/staticmap?center=' + self.locationDialog.strLatLon + '&size=600x245&maptype=roadmap&markers=color:red|' + self.locationDialog.strLatLon + '&zoom=14&sensor=false&key=' + GOOGLE_MAPS_API_KEY))
		
	def doShowLocationDialog(self):
		global currentLatitude
		global currentLongitude

		strLatLon = '%f' % currentLatitude
		strLatLon += ',%f' % currentLongitude

		self.locationDialog = MyLocationDialog(strLatLon,self)
		self.locationDialog.show()

	def doSignInClicked(self):
		# print 'doSignInClicked'
		global fsRequestToken
	
		if fsRequestToken == None:
			self.signInDlg.show()
		else:
			global doingSignout
			doingSignout = False		
			self.confirmSignOutDlg.show()

	def doRefreshListWidget(self):
		# see which tab is showing
		# self.getNearby()
		print 'current tab index: %d' % self.tabWidget.currentIndex()

		if self.tabWidget.currentIndex() < 5:
			refreshTxt = ''
			if self.tabWidget.currentIndex() == 0:
				refreshTxt = 'Please wait while we contact the server to refresh your friends\' recent checkin list. This action may take up to 30 seconds to complete depending on the server load.'
			elif self.tabWidget.currentIndex() == 1:
				refreshTxt = 'Please wait while we contact the server to refresh the nearby venue list. This action may take up to 30 seconds to complete depending on the server load.'
			elif self.tabWidget.currentIndex() == 2:
				refreshTxt = 'Please wait while we contact the server to refresh your checkin history. This action may take up to 30 seconds to complete depending on the server load.'
			elif self.tabWidget.currentIndex() == 4:
				refreshTxt = 'Please wait while we contact the server to refresh the nearby tip list. This action may take up to 30 seconds to complete depending on the server load.'

			self.processDlg.setTitleAndLabelText('Refreshing',refreshTxt)
			self.processDlg.startAnimation()
			self.processDlg.show()
			if self.tabWidget.currentIndex() == 0:
				# refresh friends
				self.doLoadFriendsCheckings(True)
			elif self.tabWidget.currentIndex() == 1:
				# refresh nearby
				self.getNearby()
			elif self.tabWidget.currentIndex() == 2:
				self.historyWorker.setup(self.userID,self.maxHistoryToDisplay)
				self.historyWorker.start()
			elif self.tabWidget.currentIndex() == 4:
				self.getNearbyTips()
				
	def getNearbyTips(self):
		self.nearbyTipsSequenceID = self.dataManager.getNextSequenceID()
		self.nearbyTipsWorker.setup(self.nearbyTipsSequenceID)
		self.nearbyTipsWorker.start()
		# save the sequence to database
		self.dataManager.saveSetting('nearbyTipsSequenceID',str(self.nearbyTipsSequenceID))		

	def doGetUserDetailForLoggedInUser(self):
		# print 'doGetUserDetailForLoggedInUser'
		# call worker thread
		self.loadUserInfoFromServerWorker.setup('0',True,False)
		self.loadUserInfoFromServerWorker.start()
	
	def showSearchDialog(self):
		self.tabWidget.setCurrentWidget(self.searchResultsTab)
		self.bttnFriends.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnPlaces.setStyleSheet(QPUSHBUTTON_DEFAULT)
		self.bttnSearch.setStyleSheet(QPUSHBUTTON_HIGHLIGHT)
		self.searchDlg = SearchDialog(self)
		self.searchDlg.show()

	def signedInInitialLoad(self,initIndex):
		print 'signedInInitialLoad: %d' % initIndex
		refreshTxt = ''
		if initIndex == 0:
			self.signInInit = True
			refreshTxt = 'Please wait while we contact the server to retrieve your foursquare.com settings. This action may take up to 30 seconds to complete depending on the server load.'
		elif initIndex == 1:
			refreshTxt = 'Please wait while we contact the server to refresh your friends\' list. This action may take up to 30 seconds to complete depending on the server load.'
		elif initIndex == 2:
			refreshTxt = 'Please wait while we contact the server to refresh your friends\' recent checkin list. This action may take up to 30 seconds to complete depending on the server load.'
		elif initIndex == 3:
			refreshTxt = 'Please wait while we contact the server to refresh the nearby venue list. This action may take up to 30 seconds to complete depending on the server load.'
		elif initIndex == 4:
			refreshTxt = 'Please wait while we contact the server to refresh your checkin history. This action may take up to 30 seconds to complete depending on the server load.'
		elif initIndex == 5:
			self.signInInit = False

		self.processDlg.setTitleAndLabelText('Refreshing',refreshTxt)

		if initIndex == 0:
			self.processDlg.startAnimation()
			self.processDlg.show()
			self.loadUserInfoFromServerWorker.setup('0',True,True)
			self.loadUserInfoFromServerWorker.start()
		elif initIndex == 1:
			self.friendsListWorker.setup('0',True)
			self.friendsListWorker.start()
		elif initIndex == 2:
			self.refreshFriendsWorker.setup(True,'RefreshFriendsWorkerThread')
			self.refreshFriendsWorker.start()
		elif initIndex == 3:
			self.nearbySequenceID = self.dataManager.getNextSequenceID()
			self.nearbyPlacesWorker.setup(self.nearbySequenceID)
			self.nearbyPlacesWorker.start()
			# save the sequence to database
			self.dataManager.saveSetting('nearbySequenceID',str(self.nearbySequenceID))
		elif initIndex == 4:
			self.historyWorker.setup(self.userID,self.maxHistoryToDisplay)
			self.historyWorker.start()
		elif initIndex == 5:
			self.dismissProcessingDialog()

		self.nextInitIndex = initIndex + 1
	
	# @QtCore.pyqtSlot()
	def onSignInDialogClosed(self):
		if (hasToken == 1):
			self.bttnSignIn.setText('')
			self.bttnSearch.show()
			self.bttnRefresh.show()
			self.bttnLocation.show()
			self.bttnFriends.show()
			self.bttnPlaces.show()	
			self.bttnHistory.show()
			self.doShowFriendsTab()
			self.signedInInitialLoad(0)
			self.bttnSettings.setGeometry(5, 338, 80, 80)
			self.bttnSignIn.hide()
			self.bttnLocation.show()
			
		else:
			self.bttnSignIn.setText('')
			self.bttnSearch.hide()
			self.bttnRefresh.hide()
			self.bttnLocation.hide()
			self.bttnFriends.hide()
			self.bttnPlaces.hide()
			self.bttnHistory.hide()
	
	def onSignOutDialogClosed(self):
		print 'onSignOutDialogClosed'
		global doingSignout
		if doingSignout:
			doingSignout = False
			print 'doSignOut'	
			global fsRequestToken
			global fsRequestTokenString
			global fsSecret
			global fsKey
			global hasToken
			fsRequestToken = None
			fsRequestTokenString = ''
			fsSecret = ''
			fsKey = ''
			hasToken = 0
			# delete tokenFile
			self.saveSettingToDB('OAuthToken','None')
			#os.remove(userPreferencesDir + 'tokenFile')
			self.bttnSignIn.setText('')
			self.bttnSearch.hide()
			self.bttnRefresh.hide()
			self.bttnLocation.hide()
			self.bttnFriends.hide()
			self.bttnPlaces.hide()
			self.bttnHistory.hide()
			# reset the friends list widgets
			self.friendsListWidget.clear()

	def doSignOut(self):
		print 'Signing out'
		global doingSignout
		doingSignout = False		
		self.confirmSignOutDlg.show()

	def calcDateString(self, strDate, fullWord, formatType):
		if formatType == 0:
			timeSinceEpoch = int(time.mktime(time.strptime(strDate,'%a, %d %b %y %H:%M:%S +0000')))
		else:
			timeSinceEpoch = int(time.mktime(time.strptime(strDate,'%Y-%m-%d %H:%M:%S')))

		currentTimeSinceEpoch = int(time.mktime(time.gmtime()))
		# print 'timeSinceEpoch: %d' % timeSinceEpoch
		# print 'currentTimeSinceEpoch %d' % currentTimeSinceEpoch
		timeDiffSecs = currentTimeSinceEpoch - timeSinceEpoch
		# print 'timeDiffSecs: %d' % timeDiffSecs
		if timeDiffSecs < 60:
			if fullWord:
				timeString = str(timeDiffSecs) + ' secs ago'
			else:
				timeString = str(timeDiffSecs) + 's ago'
		elif timeDiffSecs < 3600:
			mins = int(math.ceil(timeDiffSecs / 60))
			if fullWord:
				timeString = str(mins) + ' mins ago'
			else:
				timeString = str(mins) + 'm ago'
		elif timeDiffSecs < 18000:
			hours = int(math.floor(timeDiffSecs / 3600))
			mins = int(math.ceil((timeDiffSecs - (3600 * hours)) / 60))
			if fullWord:
				timeString = str(hours) + ' hours ' + str(mins) + ' mins ago'
			else:
				timeString = str(hours) + 'h ' + str(mins) + 'm ago'
		elif timeDiffSecs < 86400:
			hours = int(math.ceil(timeDiffSecs / 3600))
			if fullWord:
				timeString = str(hours) + ' hours ago'
			else:
				timeString = str(hours) + 'h ago'
		else:
			days = int(math.ceil(timeDiffSecs / 86400))
			if fullWord:
				timeString = str(days) + ' days ago'
			else:
				timeString = str(days) + 'd ago'
		return timeString
		
	def loadFriendsCheckingsResultsFromFile(self):
		print 'loadFriendsCheckingsResults'
		self.nearbyFriendsCheckins = { }
		self.loadFriendsCheckinsWorker.start()

	def doLoadFriendsCheckings(self,displayProgressBar):		
		if displayProgressBar:
			self.refreshFriendsWorker.setup(True,'RefreshFriendsWorkerThread')
		else:
			self.refreshFriendsWorker.setup(False, None)
		self.refreshFriendsWorker.start()

	def displayCheckinDetails(self):
		print 'displayCheckinDetails'
		self.checkinResultsDlg = CheckinResultsDialog()
		self.checkinResultsDlg.show()

	def loadSearchResults(self,sequenceID):
		print 'loadSearchResults'
		self.searchListWidget.clear()
		self.tabWidget.setCurrentWidget(self.searchResultsTab)
		self.doSelectQueryInBackground('SELECT distinct Venues.id,Venues.name,Venues.address,Venues.crossstreet,Venues.distance from Venues inner join VenueSequences on VenueSequences.venueID=Venues.id WHERE VenueSequences.seq=%d ORDER by distance' % sequenceID,'searchListWidget','id,name,address,crossstreet,distance')

	def calcMetersAsString(self,mtr):
		meters = int(mtr)
		returnString = ''
		if (meters < 1000):
			returnString = str(meters) + 'm'
		else:
			km = float(meters) / 1000.0
			returnString = '%.1f' % km
			returnString += 'km'
		return returnString
	
	def loadNearbyTips(self):
		print 'loadNearbyTips'
		self.loadNearbyFinished()
		
	def loadNearbyFinished(self):
		self.processDlg.stopAnimation()
		self.processDlg.close()
	
	def loadNearby(self):
		self.loadNearbyVenuesWorker.setup(self.nearbySequenceID)
		self.loadNearbyVenuesWorker.start()
		
	def getNearby(self):
		print 'getNearby'
		self.nearbySequenceID = self.dataManager.getNextSequenceID()
		self.nearbyPlacesWorker.setup(self.nearbySequenceID)
		self.nearbyPlacesWorker.start()
		# save the sequence to database
		self.dataManager.saveSetting('nearbySequenceID',str(self.nearbySequenceID))
	
	def doFriendItemClicked(self,item):
		print 'doFriendItemClicked'
		print item.statusTip()
		self.friendsListWidget.itemWidget(item).setHighlighted(True)
		self.friendsListWidget.itemWidget(item).repaint()

		if str(item.statusTip()) != '-1':
			self.friendCheckingDlg = FriendCheckinDetailDialog(str(item.statusTip()),self)
			self.friendCheckingDlg.show()
	
		self.friendsListWidget.itemWidget(item).setHighlighted(False)
		self.friendsListWidget.itemWidget(item).update()
	
	def doNearbyItemClicked(self,item):
		print 'Item Clicked: ' + item.statusTip()
		venueID = int(str(item.statusTip()))
		if self.tabWidget.currentIndex() == 1:
			self.placesListWidget.itemWidget(item).setHighlighted(True)
			self.placesListWidget.itemWidget(item).repaint()	
		elif self.tabWidget.currentIndex() == 2:
			self.historyListWidget.itemWidget(item).setHighlighted(True)
			self.historyListWidget.itemWidget(item).repaint()	
		elif self.tabWidget.currentIndex() == 3:
			self.searchListWidget.itemWidget(item).setHighlighted(True)
			self.searchListWidget.itemWidget(item).repaint()		

		if venueID > 0:
			self.placeInfoDlg = PlaceInfoDialog(item.statusTip(),self,self)

			self.loadingWorker.setup(item.statusTip(), self.placeInfoDlg, False, 'MainWindow.PlaceInfoDlg')
			self.loadingWorker.start()

			# show processing dialog
			self.processDlg.setTitleAndLabelText('Loading...','Please wait while we load the selected item. We may contact the server to refresh with the latest information')
			self.processDlg.startAnimation()
			self.processDlg.show()

		elif venueID == -2:
			# load add venue 
			self.addVenue = AddVenueWindow(self)
			# connect to the new window
			self.connect(self.addVenue, QtCore.SIGNAL('closeVenueAddWindowAndCheckIn'), self.closeVenueAddWindowAndCheckIn)			
			self.addVenue.show()		

		if self.tabWidget.currentIndex() == 1:
			self.placesListWidget.itemWidget(item).setHighlighted(False)
			self.placesListWidget.itemWidget(item).update()	
		elif self.tabWidget.currentIndex() == 2:
			self.historyListWidget.itemWidget(item).setHighlighted(False)
			self.historyListWidget.itemWidget(item).update()	
		elif self.tabWidget.currentIndex() == 3:
			self.searchListWidget.itemWidget(item).setHighlighted(False)
			self.searchListWidget.itemWidget(item).update()

	def closeVenueAddWindowAndCheckIn(self,venueID,venueName,doCheckIn):
		print 'closeVenueAddWindowAndCheckIn'
		# immediately disconnect the slot
		self.disconnect(self.addVenue, QtCore.SIGNAL('closeVenueAddWindowAndCheckIn'), self.closeVenueAddWindowAndCheckIn)			
		# load new window for checkin
		self.addVenue.close()
		del self.addVenue
		if doCheckIn:
			# load up checkin dialog
			self.checkInDlg = CheckInDialog(str(venueID),venueName)
			self.checkInDlg.show()

	def nearbyItemLoadingFinished(self,dialogToShow):
		print 'nearbyItemLoadingFinished - executing on main gui thread'
		if dialogToShow == 'MainWindow.PlaceInfoDlg':
			self.placeInfoDlg.loadingFinished()
		elif dialogToShow == 'FriendCheckinDetailDialog.placeInfoDlg':
			self.friendCheckingDlg.placeInfoDlg.loadingFinished()
		
		if self.processDlg != None:
			self.processDlg.stopAnimation()
			self.processDlg.close()
		
		if dialogToShow == 'MainWindow.PlaceInfoDlg':
			if self.placeInfoDlg.displayOK:
				self.placeInfoDlg.show()
		elif dialogToShow == 'FriendCheckinDetailDialog.placeInfoDlg':
			if self.friendCheckingDlg.placeInfoDlg.displayOK:
				self.friendCheckingDlg.placeInfoDlg.show()

		#
		# elif self.friendCheckingDlg.processDlg != None:
		#	self.friendCheckingDlg.placeInfoDlg.show()
		
	def getUserPhotoBig(self,photoURL):
		print 'getUserPhotoBig'
		# save filename as userpix_thumbs_61003_1256906281858.jpg
		photoURLchunks = photoURL.split('/')
		saveFile = 'userpix_' + photoURLchunks[4]
		
		if self.lowBandwidthModeSetting:	
			shutil.copy(APP_DIRECTORY + 'iconBlankBoy.png',userPreferencesDir + 'imageCache' + os.sep + 'users' + os.sep + saveFile)			
		else:	
			photoResponse = urllib2.urlopen(photoURL)
			photoData = photoResponse.read()
			photoFile = open(userPreferencesDir + 'imageCache' + os.sep + 'users' + os.sep + saveFile,'w')
			photoFile.write(photoData)
			photoFile.close()
		
	def getUserPhoto(self,photoURL):
		print 'getUserPhoto'
		photoURLchunks = photoURL.split('/')
		saveFile = photoURLchunks[3] + '_' + photoURLchunks[4]
		
		if self.lowBandwidthModeSetting:
			# save a mock file to the location regular file would be saved. 
			# international roaming is expensive - this will reduce impact of bandwidth related charges
			shutil.copy(APP_DIRECTORY + 'iconBlankBoy.png',userPreferencesDir + 'imageCache' + os.sep + 'users' + os.sep + saveFile)		
		else:
			photoResponse = urllib2.urlopen(photoURL)
			photoData = photoResponse.read()
	
			# save filename as userpix_thumbs_61003_1256906281858.jpg	
			photoFile = open(userPreferencesDir + 'imageCache' + os.sep + 'users' + os.sep + saveFile,'w')
			photoFile.write(photoData)
			photoFile.close()

class LocationManagerThread(QtCore.QThread):
	def __init__(self, parent = None):
    		QtCore.QThread.__init__(self, parent)
		self.exiting = False

	def setLocationMethodType(self,lType):
		self.locationMethodType = lType

	def setPort(self,port):
		self.serverPort = port

	def run(self):
		# print 'LocationManagerThread.start()'
		global locationSubprocessIsRestarting
		global locationSubprocessRestartCount
		global locationMethodType
		locationSubprocessRestartCount = locationSubprocessRestartCount + 1
		locationSubprocessIsRestarting = False		

		child = subprocess.Popen(['python',GET_LOCATION_SCRIPT,str(self.locationMethodType),str(self.serverPort)], shell=False, stdout=None)
		global getLocationChildPID
		getLocationChildPID = child.pid
		# print 'child process ID: %d' % getLocationChildPID
		child.wait()
		# print 'child process finished'

	def __del__(self):
		print 'LocationManagerThread.__del__()'
		self.exiting = True
		self.wait()

class LocationBackgroundUpdateThread(QtCore.QThread):
	def __init__(self, parent = None):
    		QtCore.QThread.__init__(self, parent)
		self.exiting = False

	def run(self):		
		global currentLatitude
		global currentLongitude
		global horizontalAccuracy
		global verticalAccuracy
		global acquisitionCount
		global locationSubprocessClientConnected
		global locationAcceptClientConnections

		print 'LocationBackgroundUpdateThread.run()'
		# create a background TCP server to listen for location updates
		self.server = QtNetwork.QTcpServer()
		listening = self.server.listen(QtNetwork.QHostAddress.LocalHost, 0)
		self.serverPort	= self.server.serverPort()	
		print 'serverPort is: %d' % self.serverPort

		while listening:
			while locationAcceptClientConnections:
				print 'Listening for client connection...'			
				self.emit(QtCore.SIGNAL('launchChildProcess'),self.serverPort)
				waitingForConnect = self.server.waitForNewConnection(120000)
				if waitingForConnect[0]:
					print 'client connected'
					locationSubprocessClientConnected = True
					self.connSock = self.server.nextPendingConnection()
					print self.connSock.state()
					while self.connSock.state() == QtNetwork.QAbstractSocket.ConnectedState:
						print 'waiting for data...'
						waitingForData = self.connSock.waitForReadyRead(3600000)
						print waitingForData
						if waitingForData:
							bytesAvailable = self.connSock.bytesAvailable()
							# print 'bytesAvailable: %d' % bytesAvailable
							# read bytes
							line = self.connSock.read(bytesAvailable).replace("\n","").replace("\r","")
							print line
							commandPacket = line.split("|")
							# print commandPacket
							command = commandPacket[0]
							# print command
							if command == 'UPDATING_LOCATION':
								# print 'updating location'
								# UPDATE_LOCATION|latitude|longitude|horzaccuracy|vertaccuracy
								currentLatitude = float(commandPacket[1])
								currentLongitude = float(commandPacket[2])
								horizontalAccuracy = float(commandPacket[3])
								verticalAccuracy = float(commandPacket[4])
								acquisitionCount = acquisitionCount + 1
								# save location to DB
								settingValue = '%s|%s|%s|%s' % (commandPacket[1],commandPacket[2],commandPacket[3],commandPacket[4])
								# emit signal back to mainWindow (main GUI) to save setting
								self.emit(QtCore.SIGNAL('saveSettingToDB'),'currentLocation',settingValue)
							elif command == 'INITIALIZING':
								print 'OK, child process connected to socket. received init'
							elif command == 'QUITTING':
								print 'child process quitting, restart it'
								self.connSock.setSocketState(QtNetwork.QAbstractSocket.ClosingState)
							elif command == 'ERROR_LOCATION_NOT_ENABLED':
								print 'error accessing GPS'
								locationAcceptClientConnections = False
								self.emit(QtCore.SIGNAL('displayInfoNotice'),'Unable to determine your location, please check your settings')
								self.server.close()
								self.emit(QtCore.SIGNAL('setLocationMethodType'),-1)
								
					print 'client disconnected'
					locationSubprocessClientConnected = False
			# close the server
			self.server.close()
		print 'LocationBackgroundUpdateThread.run() ending...'
			
	def __del__(self):
		print 'LocationBackgroundUpdateThread.__del__()'
		self.exiting = True
		self.wait()

class LocationManager(QtCore.QObject):
	def __init__(self):
		QtCore.QObject.__init__(self)
		self.locationWorker = LocationManagerThread()
		self.locationBackgroundWorker = LocationBackgroundUpdateThread()
		# self.connect(self.locationWorker, QtCore.SIGNAL('finished()'), self.loadLocationFromFile)
		self.connect(self.locationBackgroundWorker, QtCore.SIGNAL('displayInfoNotice()'), self.displayInfoNoticeGlobal)		
		self.connect(self.locationBackgroundWorker, QtCore.SIGNAL('restartSubProcess()'), self.restartSubprocess)
		self.connect(self.locationBackgroundWorker, QtCore.SIGNAL('launchChildProcess'), self.launchChildProcess)				

	def setLocationMethodType(self,lType):
		self.locationMethodType = lType
		self.locationWorker.setLocationMethodType(self.locationMethodType)

	def launchChildProcess(self,port):
		if not locationSubprocessClientConnected:
			self.locationWorker.setPort(port)
			self.locationWorker.start()

	def restartSubprocess(self):
		global getLocationChildPID
		global locationSubprocessIsRestarting
		global acquisitionCount
		acquisitionCount = 0
		print 'subprocess pid: %d' % getLocationChildPID
		if getLocationChildPID > 0:
			os.kill(getLocationChildPID, 9)
			time.sleep(2)

	def displayInfoNoticeGlobal(self):
		global infoNoticeString
		global qb
		if qb != None:
			qb.displayInfoNotice(infoNoticeString)

	def acquireLocationFix(self):
		print 'LocationManager.acquireLocationFix'
		# self.locationWorker.start()
		self.locationBackgroundWorker.start()
	
app = QtGui.QApplication(sys.argv)

# check to see if user is running as root
print 'os.geteuid() = %d' % processUserID
if processUserID == 0:
	q = QtGui.QMainWindow()
	lbl = QtGui.QLabel('BarrioSquare cannot be run as root. Make sure you run as a normal user. If you run this from the command line, make sure you do not sudo gainroot',q)
	lbl.setGeometry(5,5,790,400)
	lbl.setFont(QtGui.QFont('Helvetica', 30))
	lbl.setWordWrap(True)
	q.show()
else:

	# set up a separate thread for location acquisition
	locationFixAcquired = 0

	if showSplashScreen:
		splashScreen = SplashScreenDialog()
		splashScreen.show()

	if showStartupLocationSetting:
		startupLocationDlg = StartupLocationSettingDialog()
		startupLocationDlg.show()

	# appSettings = CustomSettingsProvider()
	# appSettings.initializeBaseSettings()

	qb = MainWindow()
	qb.show()
sys.exit(app.exec_())

