#include "netcable.h"
#include "ui_netcable.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>

Netcable::Netcable(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Netcable)
{
    ui->setupUi(this);

    //Set Window
    this->setWindowTitle(tr("Ethernet"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    //Set A Image
    imgSceneA = new QGraphicsScene(ui->imgA);
    QGraphicsPixmapItem *itemA;
    QPixmap mImgA("/opt/bander/images/568A.jpg");
    ui->imgA->setScene(imgSceneA);
    mImgA = mImgA.scaled(QSize(440, 440), Qt::KeepAspectRatio);
    itemA = new QGraphicsPixmapItem(mImgA);
    imgSceneA->addItem(itemA);

    //Set B Image
    imgSceneB = new QGraphicsScene(ui->imgB);
    QGraphicsPixmapItem *itemB;
    QPixmap mImgB("/opt/bander/images/568b.jpg");
    ui->imgB->setScene(imgSceneB);
    mImgB = mImgB.scaled(QSize(440, 440), Qt::KeepAspectRatio);
    itemB = new QGraphicsPixmapItem(mImgB);
    imgSceneB->addItem(itemB);

    //Button Text
    ui->radioButton_A->setText("586A");
    ui->radioButton_B->setText("586B");

    //Initial Setup
    ui->imgA->hide();
    ui->imgB->show();
    ui->radioButton_A->setChecked(false);
    ui->radioButton_B->setChecked(true);

    // For Connecting Keyboard Buttons
          connectSignals();

}

Netcable::~Netcable()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Netcable::connectSignals()
{
      connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
     connect(new QShortcut(QKeySequence(Qt::Key_Left), this), SIGNAL(activated()), this, SLOT(on_radioButton_A_clicked()));
     connect(new QShortcut(QKeySequence(Qt::Key_Right), this), SIGNAL(activated()), this, SLOT(on_radioButton_B_clicked()));
}

void Netcable::on_radioButton_A_clicked()
{
    ui->imgB->hide();
    ui->imgA->show();
    ui->radioButton_A->setChecked(true);
    ui->radioButton_B->setChecked(false);
}

void Netcable::on_radioButton_B_clicked()
{
    ui->imgA->hide();
    ui->imgB->show();
    ui->radioButton_A->setChecked(false);
    ui->radioButton_B->setChecked(true);
}
