#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>

class About;
class Help;
class Bands;
class Ohms;
class Values;
class Pinouts;

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    // Note that this will only have an effect on Symbian and Fremantle.
    void setOrientation(ScreenOrientation orientation);

    void showExpanded();


private slots:

    // For Connecting Keyboard buttons
    void connectSignals();

    //Slots
    void on_actionAbout_triggered();

    void on_actionHelp_triggered();

    void on_pushButtonBands_clicked();

    void on_pushButtonOhms_clicked();

    void on_pushButtonValues_clicked();

    void on_pushButtonPinouts_clicked();

private:
    Ui::MainWindow *ui;
    About *about;
    Help *help;
    Bands *bands;
    Ohms *ohms;
    Values *values;
    Pinouts *pinouts;
};

#endif // MAINWINDOW_H
