#include "mainwindow.h"
#include "ui_mainwindow.h"

#include "about.h"
#include "help.h"
#include "bands.h"
#include "ohms.h"
#include "values.h"
#include "selectwindows/pinouts.h"

#include <QtCore/QCoreApplication>
#include <QDesktopServices>
#include <QUrl>
#include <QShortcut>

MainWindow::MainWindow(QWidget *parent):
    QMainWindow(parent),
    ui(new Ui::MainWindow),
      about(0),
      help(0),
      bands(0),
      ohms(0),
      values(0),
      pinouts(0)
{
    ui->setupUi(this);

    //Window Text
    this->setWindowTitle("Bander");
    setAttribute(Qt::WA_Maemo5StackedWindow);

    //Set Button Text
    ui->pushButtonBands->setText(tr("Band Converter"));
    ui->pushButtonOhms->setText(tr("Ohm's Law"));
    ui->pushButtonValues->setText(tr("Value Converter"));
    ui->pushButtonPinouts->setText(tr("Pinouts"));

    // Set Button Icons
    ui->pushButtonBands->setIcon(QPixmap("/opt/bander/icons/align_just_icon&32.png"));
    ui->pushButtonOhms->setIcon(QPixmap("/opt/bander/icons/sq_up_icon&32.png"));
    ui->pushButtonValues->setIcon(QPixmap("/opt/bander/icons/calc_icon&32.png"));
    ui->pushButtonPinouts->setIcon(QPixmap("/opt/bander/icons/push_pin_icon&32.png"));


    about = new About(this);
    help = new Help(this);
    bands = new Bands(this);
    ohms = new Ohms(this);
    values = new Values(this);
    pinouts = new Pinouts(this);

    // For Connecting Keyboard Buttons
    connectSignals();
}

MainWindow::~MainWindow()
{
    if (about) delete (about);
    if (help) delete (help);
    if (bands) delete (bands);
    if (ohms) delete (ohms);
    if (values) delete (values);
    if (pinouts) delete (pinouts);
    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#if defined(Q_OS_SYMBIAN) || defined(Q_WS_SIMULATOR)
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showMaximized();
#else
    show();
#endif
}

// Keyboard Button Signals - remember to include QShortcut
void MainWindow::connectSignals()
{

// Keyboard Key Signals
  connect(new QShortcut(QKeySequence(Qt::Key_Q), this), SIGNAL(activated()), this, SLOT(on_pushButtonBands_clicked()));
  connect(new QShortcut(QKeySequence(Qt::Key_W), this), SIGNAL(activated()), this, SLOT(on_pushButtonOhms_clicked()));
  connect(new QShortcut(QKeySequence(Qt::Key_E), this), SIGNAL(activated()), this, SLOT(on_pushButtonValues_clicked()));
  connect(new QShortcut(QKeySequence(Qt::Key_R), this), SIGNAL(activated()), this, SLOT(on_pushButtonPinouts_clicked()));
}

// End of Keyboard Signals

//Menu

void MainWindow::on_actionAbout_triggered()
{
    about->show();
}

void MainWindow::on_actionHelp_triggered()
{
    help->show();
}

void MainWindow::on_pushButtonBands_clicked()
{
    bands->show();
}

void MainWindow::on_pushButtonOhms_clicked()
{
    ohms->show();
}

void MainWindow::on_pushButtonValues_clicked()
{
    values->show();
}

void MainWindow::on_pushButtonPinouts_clicked()
{
    pinouts->show();
}
