#include "resistors.h"
#include "utilities.h"

#include "ui_resistors.h"

#include <QString>
#include <math.h>
#include <QPixmap>
#include <QIcon>
#include <QResizeEvent>

Resistors::Resistors(QWidget *parent) :
        QDialog(parent),
        ui(new Ui::Resistors),
        portrait(false),
        fiveBand(false)
{
    ui->setupUi(this);

    // Add items in all comboboxes
    ui->comboBox_1->addItem(createIcon("#000000"),"Black");
    ui->comboBox_1->addItem(createIcon("#AA5500"),"Brown");
    ui->comboBox_1->addItem(createIcon("#FF0000"),"Red");
    ui->comboBox_1->addItem(createIcon("#FFAA00"),"Orange");
    ui->comboBox_1->addItem(createIcon("#FFFF00"),"Yellow");
    ui->comboBox_1->addItem(createIcon("#00FF00"),"Green");
    ui->comboBox_1->addItem(createIcon("#0000FF"),"Blue");
    ui->comboBox_1->addItem(createIcon("#AA55FF"),"Violet");
    ui->comboBox_1->addItem(createIcon("#808080"),"Grey");
    ui->comboBox_1->addItem(createIcon("#FFFFFF"),"White");

    ui->comboBox_2->addItem(createIcon("#000000"),"Black");
    ui->comboBox_2->addItem(createIcon("#AA5500"),"Brown");
    ui->comboBox_2->addItem(createIcon("#FF0000"),"Red");
    ui->comboBox_2->addItem(createIcon("#FFAA00"),"Orange");
    ui->comboBox_2->addItem(createIcon("#FFFF00"),"Yellow");
    ui->comboBox_2->addItem(createIcon("#00FF00"),"Green");
    ui->comboBox_2->addItem(createIcon("#0000FF"),"Blue");
    ui->comboBox_2->addItem(createIcon("#AA55FF"),"Violet");
    ui->comboBox_2->addItem(createIcon("#808080"),"Grey");
    ui->comboBox_2->addItem(createIcon("#FFFFFF"),"White");

    ui->comboBox_2v->addItem(createIcon("#000000"),"Black");
    ui->comboBox_2v->addItem(createIcon("#AA5500"),"Brown");
    ui->comboBox_2v->addItem(createIcon("#FF0000"),"Red");
    ui->comboBox_2v->addItem(createIcon("#FFAA00"),"Orange");
    ui->comboBox_2v->addItem(createIcon("#FFFF00"),"Yellow");
    ui->comboBox_2v->addItem(createIcon("#00FF00"),"Green");
    ui->comboBox_2v->addItem(createIcon("#0000FF"),"Blue");
    ui->comboBox_2v->addItem(createIcon("#AA55FF"),"Violet");
    ui->comboBox_2v->addItem(createIcon("#808080"),"Grey");
    ui->comboBox_2v->addItem(createIcon("#FFFFFF"),"White");

    ui->comboBox_3->addItem(createIcon("#000000"),"Black");
    ui->comboBox_3->addItem(createIcon("#AA5500"),"Brown");
    ui->comboBox_3->addItem(createIcon("#FF0000"),"Red");
    ui->comboBox_3->addItem(createIcon("#FFAA00"),"Orange");
    ui->comboBox_3->addItem(createIcon("#FFFF00"),"Yellow");
    ui->comboBox_3->addItem(createIcon("#00FF00"),"Green");
    ui->comboBox_3->addItem(createIcon("#0000FF"),"Blue");
    ui->comboBox_3->addItem(createIcon("#AA55FF"),"Violet");
    ui->comboBox_3->addItem(createIcon("#808080"),"Grey");
    ui->comboBox_3->addItem(createIcon("#FFFFFF"),"White");

    ui->comboBox_3v->addItem(createIcon("#000000"),"Black");
    ui->comboBox_3v->addItem(createIcon("#AA5500"),"Brown");
    ui->comboBox_3v->addItem(createIcon("#FF0000"),"Red");
    ui->comboBox_3v->addItem(createIcon("#FFAA00"),"Orange");
    ui->comboBox_3v->addItem(createIcon("#FFFF00"),"Yellow");
    ui->comboBox_3v->addItem(createIcon("#00FF00"),"Green");
    ui->comboBox_3v->addItem(createIcon("#0000FF"),"Blue");
    ui->comboBox_3v->addItem(createIcon("#AA55FF"),"Violet");
    ui->comboBox_3v->addItem(createIcon("#808080"),"Grey");
    ui->comboBox_3v->addItem(createIcon("#FFFFFF"),"White");

    ui->comboBox_4->addItem(createIcon("#000000"),"Black");
    ui->comboBox_4->addItem(createIcon("#AA5500"),"Brown");
    ui->comboBox_4->addItem(createIcon("#FF0000"),"Red");
    ui->comboBox_4->addItem(createIcon("#FFAA00"),"Orange");
    ui->comboBox_4->addItem(createIcon("#FFFF00"),"Yellow");
    ui->comboBox_4->addItem(createIcon("#00FF00"),"Green");
    ui->comboBox_4->addItem(createIcon("#0000FF"),"Blue");
    ui->comboBox_4->addItem(createIcon("#AA55FF"),"Violet");
    ui->comboBox_4->addItem(createIcon("#808080"),"Grey");
    ui->comboBox_4->addItem(createIcon("#FFFFFF"),"White");
    ui->comboBox_4->addItem(createIcon("#FFFF80"),"Gold");
    ui->comboBox_4->addItem(createIcon("#DBDBDB"),"Silver");

    ui->comboBox_4v->addItem(createIcon("#000000"),"Black");
    ui->comboBox_4v->addItem(createIcon("#AA5500"),"Brown");
    ui->comboBox_4v->addItem(createIcon("#FF0000"),"Red");
    ui->comboBox_4v->addItem(createIcon("#FFAA00"),"Orange");
    ui->comboBox_4v->addItem(createIcon("#FFFF00"),"Yellow");
    ui->comboBox_4v->addItem(createIcon("#00FF00"),"Green");
    ui->comboBox_4v->addItem(createIcon("#0000FF"),"Blue");
    ui->comboBox_4v->addItem(createIcon("#AA55FF"),"Violet");
    ui->comboBox_4v->addItem(createIcon("#808080"),"Grey");
    ui->comboBox_4v->addItem(createIcon("#FFFFFF"),"White");
    ui->comboBox_4v->addItem(createIcon("#FFFF80"),"Gold");
    ui->comboBox_4v->addItem(createIcon("#DBDBDB"),"Silver");

    ui->comboBox_5->addItem(createIcon("#000000"),"Black");
    ui->comboBox_5->addItem(createIcon("#AA5500"),"Brown");
    ui->comboBox_5->addItem(createIcon("#FF0000"),"Red");
    ui->comboBox_5->addItem(createIcon("#FFAA00"),"Orange");
    ui->comboBox_5->addItem(createIcon("#FFFF00"),"Yellow");
    ui->comboBox_5->addItem(createIcon("#00FF00"),"Green");
    ui->comboBox_5->addItem(createIcon("#0000FF"),"Blue");
    ui->comboBox_5->addItem(createIcon("#AA55FF"),"Violet");
    ui->comboBox_5->addItem(createIcon("#808080"),"Grey");
    ui->comboBox_5->addItem(createIcon("#FFFF80"),"Gold");
    ui->comboBox_5->addItem(createIcon("#DBDBDB"),"Silver");
    ui->comboBox_5->addItem("No Color");

    ui->comboBox_5v->addItem(createIcon("#000000"),"Black");
    ui->comboBox_5v->addItem(createIcon("#AA5500"),"Brown");
    ui->comboBox_5v->addItem(createIcon("#FF0000"),"Red");
    ui->comboBox_5v->addItem(createIcon("#FFAA00"),"Orange");
    ui->comboBox_5v->addItem(createIcon("#FFFF00"),"Yellow");
    ui->comboBox_5v->addItem(createIcon("#00FF00"),"Green");
    ui->comboBox_5v->addItem(createIcon("#0000FF"),"Blue");
    ui->comboBox_5v->addItem(createIcon("#AA55FF"),"Violet");
    ui->comboBox_5v->addItem(createIcon("#808080"),"Grey");
    ui->comboBox_5v->addItem(createIcon("#FFFF80"),"Gold");
    ui->comboBox_5v->addItem(createIcon("#DBDBDB"),"Silver");
    ui->comboBox_5v->addItem("No Color");

    // Connect signals and slots
    QObject::connect(ui->radioButtonResistor, SIGNAL(toggled(bool)), this, SLOT(recalculate()));
    QObject::connect(ui->radioButtonInductor, SIGNAL(toggled(bool)), this, SLOT(recalculate()));
    QObject::connect(ui->radioButton4Band, SIGNAL(toggled(bool)), this, SLOT(recalculate()));
    QObject::connect(ui->radioButton5Band, SIGNAL(toggled(bool)), this, SLOT(recalculate()));
    QObject::connect(ui->comboBox_1, SIGNAL(currentIndexChanged(int)), this, SLOT(recalculate()));
    QObject::connect(ui->comboBox_2, SIGNAL(currentIndexChanged(int)), this, SLOT(recalculate()));
    QObject::connect(ui->comboBox_3, SIGNAL(currentIndexChanged(int)), this, SLOT(recalculate()));
    QObject::connect(ui->comboBox_4, SIGNAL(currentIndexChanged(int)), this, SLOT(recalculate()));
    QObject::connect(ui->comboBox_5, SIGNAL(currentIndexChanged(int)), this, SLOT(recalculate()));

    // The UI is designed with 5 band mode as default. This is quite deliberate.
    // This call will switch to 4 band default and trigger hiding the third band
    // and recalculation at the same time:
    ui->radioButton4Band->click();
}

Resistors::~Resistors()
{
    delete ui;
}

void Resistors::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void Resistors::resizeEvent(QResizeEvent *event)
{
    portrait = event->size().width() <= 480;

    ui->comboBox_2->setVisible(!portrait);
    ui->comboBox_3->setVisible(!portrait && fiveBand);
    ui->comboBox_4->setVisible(!portrait);
    ui->comboBox_5->setVisible(!portrait);

    ui->comboBox_2v->setVisible(portrait);
    ui->comboBox_3v->setVisible(portrait && fiveBand);
    ui->comboBox_4v->setVisible(portrait);
    ui->comboBox_5v->setVisible(portrait);
}

void Resistors::recalculate()
{
    // These 3 lines might possibly be a good idea to take out
    // to another slot.
    fiveBand = ui->radioButton5Band->isChecked();
    ui->comboBox_3->setVisible(!portrait && fiveBand);
    ui->comboBox_3v->setVisible(portrait && fiveBand);

    // First two bands give tens and units
    double rez = ui->comboBox_1->currentIndex() * 10.0
               + ui->comboBox_2->currentIndex();

    // Third band is optional; if present, it changes the
    // first two bands to hundreds and tens and adds units
    if (fiveBand)
       rez = rez * 10.0 + ui->comboBox_3->currentIndex();

    // Fourth (third in 4-band configuration) band is a multiplier
    switch (ui->comboBox_4->currentIndex())
    {
    case 10:
        rez /= 10.0;
        break;
    case 11:
        rez /= 100.0;
        break;
    default:
        rez *= pow(10, ui->comboBox_4->currentIndex());
        break;
    }

    // In inductor mode, units are microHenries
    // In resistor mode, units are Ohms
    QChar unit;
    if (ui->radioButtonInductor->isChecked())
    {
        rez *= 1e-6;
        unit = 'H';
    }
    else
        unit = QChar(0x2126);   // Unicode 'omega' character

    // Normalize rez to max. 3 digits plus an SI prefix
    QString s = Utils::normalize(rez, unit);

    // Add tolerance
    static const QString tolerance[] =
    {
        "20% (M)",   // black (used on inductors or 5 band resistors)
        "1% (F)",    // brown
        "2% (G)",    // red
        "3% (military)", // orange
        "4% (military)", // yellow
        "0.5% (D)",  // green
        "0.25% (C)", // blue
        "0.1% (B)",  // violet
        "0.05% (A)", // grey
        "5% (J)",    // gold
        "10% (K)",   // silver
        "20% (M)"    // no color (turns 4 band into 3 band)
    };

    s.append(' ');
    s.append(QChar(0x00B1));   // Unicode '+/-' sign
    s.append(tolerance[ui->comboBox_5->currentIndex()]);

    ui->label_ohm->setText(s);
}

// Used for drawing color in comboBoxes
QIcon Resistors::createIcon(QString colorName)
{
    QPixmap iconPixmap(32,32);
    iconPixmap.fill(QColor(colorName));
    QIcon itemIcon(iconPixmap);
    return itemIcon;
}
