#include "netcable.h"
#include "ui_netcable.h"

Netcable::Netcable(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Netcable)
{
    ui->setupUi(this);

    //Set Window
    this->setWindowTitle(tr("Network Cables"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    //Set A Image
    imgSceneA = new QGraphicsScene(ui->imgA);
    QGraphicsPixmapItem *itemA;
    QPixmap mImgA("/opt/bander/images/568A.jpg");
    ui->imgA->setScene(imgSceneA);
    mImgA = mImgA.scaled(QSize(440, 440), Qt::KeepAspectRatio);
    itemA = new QGraphicsPixmapItem(mImgA);
    imgSceneA->addItem(itemA);

    //Set B Image
    imgSceneB = new QGraphicsScene(ui->imgB);
    QGraphicsPixmapItem *itemB;
    QPixmap mImgB("/opt/bander/images/568b.jpg");
    ui->imgB->setScene(imgSceneB);
    mImgB = mImgB.scaled(QSize(440, 440), Qt::KeepAspectRatio);
    itemB = new QGraphicsPixmapItem(mImgB);
    imgSceneB->addItem(itemB);

    //Button Text
    ui->pushButton_A->setText("586A");
    ui->pushButton_B->setText("586B");

    //Initial Setup
    ui->imgA->hide();
    ui->imgB->show();
    ui->pushButton_A->setDisabled(false);
    ui->pushButton_B->setDisabled(true);

}

Netcable::~Netcable()
{
    delete ui;
}

void Netcable::on_pushButton_A_clicked()
{
    ui->imgA->show();
    ui->imgB->hide();
    ui->pushButton_A->setDisabled(true);
    ui->pushButton_B->setDisabled(false);
}

void Netcable::on_pushButton_B_clicked()
{
    ui->imgA->hide();
    ui->imgB->show();
    ui->pushButton_A->setDisabled(false);
    ui->pushButton_B->setDisabled(true);
}
