#include "caps.h"
#include "utilities.h"

#include "ui_caps.h"

#include <math.h>

Caps::Caps(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Caps),
    multiplier(1.0)
{
    ui->setupUi(this);

    //Window Text
    this->setWindowTitle("Value Converter");

    // Add items in all comboboxes etc.
    ui->comboUnit->addItem(QChar(0x2126));  // Unicode 'omega' character
    reloadCombo();

    // Connect signals and slots
    connect(ui->comboValue, SIGNAL(currentIndexChanged(int)), this, SLOT(recalculate()));
    connect(ui->comboPrefix, SIGNAL(currentIndexChanged(int)), this, SLOT(recalculate()));
    connect(ui->comboUnit, SIGNAL(currentIndexChanged(int)), this, SLOT(recalculate()));

    recalculate();
}

Caps::~Caps()
{
    delete ui;
}

void Caps::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void Caps::on_buttonTimes10_clicked()
{
    ui->buttonDiv10->setEnabled(true);
    if ((multiplier *= 10.0) >= 100000.0)
        ui->buttonTimes10->setEnabled(false);

    reloadCombo();
}

void Caps::on_buttonDiv10_clicked()
{
    ui->buttonTimes10->setEnabled(true);
    if ((multiplier /= 10.0) <= 0.0001)
        ui->buttonDiv10->setEnabled(false);

    reloadCombo();
}

void Caps::reloadCombo()
{
    static const double value[] = {
        // The first value is 1 but without adding a small fraction,
        // rounding errors in the normalization process mean that
        // 1nF is "normalized" to 1000pF rather than expected 1nF :(
        1.000001, 1.1, 1.2, 1.3, 1.5, 1.6, 1.8,
        2.0, 2.2, 2.4, 2.7, 3.0, 3.3, 3.6, 3.9,
        4.0, 4.3, 4.7, 5.0, 5.1, 5.6, 6.0, 6.2,
        6.8, 7.0, 7.5, 8.0, 8.2, 9.0, 9.1
    };

    const int index = ui->comboValue->currentIndex();

    ui->comboValue->clear();
    for (size_t i = 0; i < sizeof value / sizeof value[0]; ++i)
    {
        const double d = value[i] * multiplier;
        ui->comboValue->addItem(QString::number(d), d);
    }

    ui->comboValue->setCurrentIndex(index < 0 ? 0 : index);
}

void Caps::recalculate()
{
    int index = ui->comboValue->currentIndex();
    double value = ui->comboValue->itemData(index).toDouble();

    value *= pow10(3 * (ui->comboPrefix->currentIndex() - 4));

    ui->labelResult->setText(Utils::normalize(value, ui->comboUnit->currentText()));
}
