#include "utilities.h"

namespace Utils {

QString normalize(double d, const QString &unit)
{
    int prefix = 0;
    for (; prefix > -8 && d > 0.0 && d < 1.0; prefix--)
        d *= 1000.0;
    for (; prefix < 8 && d >= 1000.0; prefix++)
        d /= 1000.0;

    static const QString SI[] =
    {
        "y", "z", "a", "f", "p", "n",
        QChar(0x00B5),  // Unicode 'micro' character
        "m",
        "",
        "k", "M", "G", "T", "P", "E", "Z", "Y"
    };

    QString result;
    result.setNum(d);
    result.append(' ');
    result.append(SI[prefix + 8]);
    result.append(unit);

    return result;
}

}
