#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>

class About;
class Help;
class Caps;
class Resistors;
class Calculations;

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    // Note that this will only have an effect on Symbian and Fremantle.
    void setOrientation(ScreenOrientation orientation);

    void showExpanded();


private slots:

    // For Connecting Keyboard buttons
    void connectSignals();

    //Slots
    void on_actionAbout_triggered();

    void on_actionHelp_triggered();

    void on_pushButtonCalculations_clicked();

    void on_pushButtonCaps_clicked();

    void on_pushButtonColors_clicked();

private:
    Ui::MainWindow *ui;
    About *about;
    Help *help;
    Caps *caps;
    Resistors *resistors;
    Calculations *calculations;
};

#endif // MAINWINDOW_H
