#include "power.h"
#include "ui_power.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>
#include <QString>
#include <QLineEdit>
#include <QObject>
#include <math.h>

Power::Power(QWidget *parent) :
        QDialog(parent),
        ui(new Ui::Power)
{
    ui->setupUi(this);   
}

Power::~Power()
{
    delete ui;
}

//Voltage Tab

void Power::on_TP_pushButton_Calculate_clicked()
{
       int result = 0;
       long iNumber = 10;
       QString str = QString::number(iNumber);
       bool ok;
       int value1 = ui->TP_lineEdit_I->text().toInt(&ok, 10);
       int value2 = ui->TP_lineEdit_V->text().toInt(&ok, 10);
       result = value1*value2;
       ui->TP_lineEdit_P->setText(str.setNum(result));
}

void Power::on_TP_pushButton_Clear_clicked()
{
       ui->TP_lineEdit_P->setText(tr(""));
       ui->TP_lineEdit_I->setText(tr(""));
       ui->TP_lineEdit_V->setText(tr(""));
}

//Current Tab

void Power::on_TI_pushButton_Calculate_clicked()
{
       int result = 0;
       long iNumber = 10;
       QString str = QString::number(iNumber);
       bool ok;
       int value1 = ui->TI_lineEdit_P->text().toInt(&ok, 10);
       int value2 = ui->TI_lineEdit_V->text().toInt(&ok, 10);
       result = value1/value2;
       ui->TI_lineEdit_I->setText(str.setNum(result));
}

void Power::on_TI_pushButton_Clear_clicked()
{
       ui->TI_lineEdit_P->setText(tr(""));
       ui->TI_lineEdit_I->setText(tr(""));
       ui->TI_lineEdit_V->setText(tr(""));
}

//Resistance Tab

void Power::on_TV_pushButton_Calculate_clicked()
{
       int result = 0;
       long iNumber = 10;
       QString str = QString::number(iNumber);
       bool ok;
       int value1 = ui->TV_lineEdit_P->text().toInt(&ok, 10);
       int value2 = ui->TV_lineEdit_I->text().toInt(&ok, 10);
       result = value1/value2;
       ui->TV_lineEdit_V->setText(str.setNum(result));
}

void Power::on_TV_pushButton_Clear_clicked()
{
       ui->TV_lineEdit_P->setText(tr(""));
       ui->TV_lineEdit_I->setText(tr(""));
       ui->TV_lineEdit_V->setText(tr(""));

}
