#include "badgewindow.h"
#include "ui_badgewindow.h"

#include "dialogday.h"
#include <QDebug>
#include "badgedata.h"
#include "dialogsearch.h"
#include <QMessageBox>
#include <QtMaemo5/QMaemo5InformationBox>

BadgeWindow::BadgeWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::BadgeWindow)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_Maemo5StackedWindow);
    ui->menuBar->addAction(ui->actionSearch);
    ui->menuBar->addAction(ui->actionInfo);
#ifndef Q_WS_MAEMO_5
    ui->menuBar->addAction(ui->actionClose);
#endif
    connect(ui->actionSearch, SIGNAL(triggered()), this, SLOT(search()));
    connect(ui->actionClose, SIGNAL(triggered()), this, SLOT(close()));
    connect(ui->actionInfo, SIGNAL(triggered()), this, SLOT(info()));


    showMaximized();
}



void BadgeWindow::selectedDay(QDate date)
{
    DialogDay day;
    BadgeData data;

    TimeTable tt;
    tt.day = date;
    if (data.getTimetable(tt) == false) {
        tt.entrance = QTime::currentTime();
        tt.exit = QTime::currentTime();
        tt.firstPause = QTime::currentTime();
        tt.endFirstPause = QTime::currentTime();
        tt.secondPause = QTime::currentTime();
        tt.endSecondPause = QTime::currentTime();
    }

    tt = day.getTimes(tt);
    if (tt.wrong() != TimeTable::WRONG) {
        BadgeData data;
        data.setTimetable(tt);
    }

}

void BadgeWindow::search()
{
    DialogSearch searchDialog;
    int total;
    QString message;
    QString hours;
    QString minutes;
    bool ok;

    total = searchDialog.totalHours(ok);
    if (ok) {
            qDebug() << "TIME " << total;
        hours.setNum((int)(total / 3600));
        minutes.setNum((int) ((total % 3600) / 60));
        message = "Total time is: " + hours + " hours and " + minutes + " minutes";
        QMessageBox::information(this, tr("Badge"), tr(message.toLatin1()));
    }

}

void BadgeWindow::info()
{
    QMessageBox::aboutQt(this);
    QMaemo5InformationBox::information(this, tr("(c) 2009 Nicola De Filippo - nicola@nicoladefilippo.it\n"
                         "This program is licensed to you under terms of the GNU General Public\n"
                        "License Version 2 as published by Free Software Foundation. This gives\n"
                        "you legal permission to copy, distribute and/or modify this software under\n"
                        "certain conditions. For details, see the file 'COPYING' that came with this\n"
                        "software distribution. If you did not get the file, send email to author.\n\n"
                        "The program is provided AS IS with No WARRANTY OF ANY KIND,\n"
                        "INCLUDING THE WARRANTY OF DESIGN, MERCHANTABILITY AND\n"
                        "FITNESS FOR PARTICULAR PURPOSE"));
}

BadgeWindow::~BadgeWindow()
{
    delete ui;
}
