#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>
#include "settings.h"


namespace Ui {
    class Dialog;
}


/*!
  SettingsDialog provides the user interface to modify the data of the Settings
  class.
*/
class SettingsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit SettingsDialog(Settings *settings, QWidget *parent = 0);
    void SaveData();

protected:
    void resizeEvent(QResizeEvent * event);

private slots:
    void ShowHelp();


private:
    //! autogenerated user interface
    Ui::Dialog *ui;

    //! the width:height ratio when a layout change shall appear
    const static float LAYOUT_CHANGE_RATIO = 1.5;

    //! reference to global application settings
    Settings * const itsSettings;

    //! indication whether the screen has horizontal or vertical design
    bool itsHorizontalLayout;
};

#endif // SETTINGSDIALOG_H
