/*
babyphone - A baby monitor application on the Nokia N900.
    Copyright (C) 2010  Roman Morawek <maemo@morawek.at>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef USERNOTIFIER_H
#define USERNOTIFIER_H

#include <QObject>
#include <QTimer>
#include <QtDBus>
#include "settings.h"


#ifndef Q_WS_MAEMO_5
  #error "DBUS user notification is only supported for Maemo 5"
#endif


class UserNotifier : public QObject
{
    Q_OBJECT
public:
    explicit UserNotifier(Settings *settings, QObject *parent = 0);
    bool Notify();

signals:
    void notifyFinished();

public slots:

private slots:
    void callSetupTimer();
    void callEstablished(const QDBusMessage&);
    void receiveCall(const QDBusMessage&);

private:
    bool handleCall(const bool takeCall) const;


private:
    Settings* const itsSettings;
    QTimer *itsCallTimer;
};

#endif // USERNOTIFIER_H
