/*
babyphone - A baby monitor application on the Nokia N900.
    Copyright (C) 2010  Roman Morawek <maemo@morawek.at>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef SETTINGS_H
#define SETTINGS_H

#include <QSettings>


class Settings : public QSettings
{
    Q_OBJECT
public:
    explicit Settings(QObject *parent = 0);
    void Save();

signals:

public slots:
    void ShowDialog();


public:
    // variable settings
    int itsAudioAmplify;
    int itsAudioTimer;
    QString itsPhonenumber;

    int itsRecallTimer;
    bool itsRejectIncomingCalls;

    // constant settings
    const int CALL_SETUP_TIMER;
    const int CALL_HOLD_TIMER;
    const int MSG_BOX_TIMEOUT;

    const int THRESHOLD_VALUE;
    const int VOLUME_COUNTER_MAX;
    const int VOLUME_COUNTER_DEC;

    const int GRAPH_MIN_VALUE;
    const int GRAPH_MAX_VALUE;
    const int GRAPH_WIDTH;
    const int GRAPH_HEIGHT;

    const int AUDIO_SAMPLE_INTERVAL;
    const int AUDIO_SAMPLE_SUBINTERVAL;
    const int AUDIO_ON_TIMER;
    const int AUDIO_OFF_TIMER;


private:
};


#endif // SETTINGS_H
