/*
babyphone - A baby monitor application on the Nokia N900.
    Copyright (C) 2010  Roman Morawek <maemo@morawek.at>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>

#include "audiomonitor.h"
#include "usernotifier.h"
#include "audiolevelgraphicsscene.h"
#include "settings.h"


namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    void changeEvent(QEvent *e);

private:

private slots:
    void refreshAudioData(int counter, int value);
    void notifyFinished();
    void startAudio();
    void stopAudio();

    void on_pushButton_clicked();
    void on_spinBox_volume_valueChanged();
    void on_spinBox_timeWeight_valueChanged();
    void on_spinBox_recallTimer_valueChanged();
    void on_lineEdit_phone_textChanged();


private:
    // GUI related members
    Ui::MainWindow *ui;
    AudioLevelGraphicsScene *itsAudioLevelGraphics;
    AudioLevelGraphicsScene *itsAudioCounterGraphics;

    // application settings
    Settings *itsSettings;

    // the audio monitor
    AudioMonitor *itsAudioMonitor;
    // the phone handler
    UserNotifier *itsUserNotifier;

    // application status
    bool itsMonitorActive;
    bool itsNotificationPending;
};


#endif // MAINWINDOW_H
