/*
babyphone - A baby monitor application on the Nokia N900.
    Copyright (C) 2010  Roman Morawek <maemo@morawek.at>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <QObject>
#include <QAudioInput>
#include "settings.h"


class AudioMonitor : public QIODevice
{
    Q_OBJECT
public:
    AudioMonitor(Settings *settings, QObject *parent);
    ~AudioMonitor();

    void start();
    void stop();

    qint64 readData(char *data, qint64 maxlen);
    qint64 writeData(const char *data, qint64 len);

    QAudioInput *itsDevice;
    int itsCounter;
    bool itsActive;

private:


signals:
    void update(int counter, int value);

private slots:
    void status();


private:
    QAudioFormat itsAudioFormat;
    Settings* const itsSettings;
};

