/*
 * connection-watcher.h - Header for ConnectionWatcher
 * Copyright (C) 2010 Guillaume Desmottes
 * @author Guillaume Desmottes <gdesmott@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __CONNECTION_WATCHER_H__
#define __CONNECTION_WATCHER_H__

#include <glib-object.h>
#include <telepathy-glib/connection.h>

G_BEGIN_DECLS

typedef struct _ConnectionWatcher ConnectionWatcher;
typedef struct _ConnectionWatcherClass ConnectionWatcherClass;

struct _ConnectionWatcherClass {
    GObjectClass parent_class;
};

struct _ConnectionWatcher {
    GObject parent;
};

GType connection_watcher_get_type(void);

/* TYPE MACROS */
#define CONNECTION_WATCHER_TYPE \
  (connection_watcher_get_type())
#define CONNECTION_WATCHER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), CONNECTION_WATCHER_TYPE, ConnectionWatcher))
#define CONNECTION_WATCHER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), CONNECTION_WATCHER_TYPE, ConnectionWatcherClass))
#define CONNECTION_IS_WATCHER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), CONNECTION_WATCHER_TYPE))
#define CONNECTION_IS_WATCHER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), CONNECTION_WATCHER_TYPE))
#define CONNECTION_WATCHER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTION_WATCHER_TYPE, ConnectionWatcherClass))

ConnectionWatcher * connection_watcher_new (void);

void connection_watcher_start (ConnectionWatcher *watcher);

G_END_DECLS

#endif /* #ifndef __CONNECTION_WATCHER_H__*/
