#!/bin/sh

#if [ "$(id -u)" != "0" ] ; then
#    root<<EOF
#EOF
#	exit $?
#fi

pixmaps="/usr/share/pixmaps/*"
extras="/usr/share/icons/awoken-icon-theme/extras/*"

if [ "$(ls -A /home/user/.awoken-extras/orig/)" ]; then
	echo ""
else
	mkdir /home/user/.awoken-extras/orig/
	cp $pixmaps".png" "/home/user/.awoken-extras/orig/"
fi	

case "$1" in
    '-'[Cc] | '--change')
        for pics in $pixmaps
        do 
            pix=`basename ${pics}`
            for img in $extras
            do
                ico=`basename ${img}`

                    if [ "${pix}" = "${ico}" ]; then                    	
                    	rm ${pics}
                    	cp ${img} /usr/share/pixmaps/
                    	echo ""
                    fi
                    
            done
        done
    exit
    ;;
    '-'[Bb] | '--backup')
        for pics in $pixmaps
        do 
            pix=`basename ${pics}`
            for img in $extras
            do
                ico=`basename ${img}`

                    if [ "${pix}" = "${ico}" ]; then                    	
                    	rm ${pics}.orig
                    	cp ${pics} ${pics}.orig
                    	echo ""
                    fi
                    
            done
        done
    exit
    ;;
    '-'[Rr] | '--reset')
        for pics in $pixmaps
        do 
            pix=`basename ${pics}`
            for img in $extras
            do
                ico=`basename ${img}`

                    if [ "${pix}" = "${ico}" ]; then                    	
                    	rm ${pics}
                    	mv ${pics}.orig ${pics}
                    	echo ""
                    fi
                    
            done
        done
    exit
    ;;
esac