#include "central.h"
#include "QLineEdit"
#include "mainwindow.h"
#include "QVBoxLayout"
#include <QHBoxLayout>
#include <QGridLayout>
#include "QtMessaging/QMessage"
#include <QtMessaging/QMessageFilter>
#include <qmessage.h>
#include <qmessagefilter.h>
#include <QDate>
#include <QLabel>
#include <QPushButton>
#include <QProcess>
#include <QCheckBox>
#include <QSettings>
#include <QScrollArea>
#include <QWidget>
#include <QComboBox>
#include <QMessageBox>
#include "qmessagemanager.h"
#include <qmessagemanager.h>

void maemoBanner(QString string)
{
    QProcess *myProcess = new QProcess;
    QString program = "dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"" + string + "\"";
    myProcess->execute(program);
}

using namespace QtMobility;

Central::Central(QWidget *parent) :
    QWidget(parent)
{
    QLabel *label1;
    label1 = new QLabel(tr("Delete by Text:"));

    stringa1CheckBox = new QCheckBox;
    stringa2CheckBox = new QCheckBox;
    stringa3CheckBox = new QCheckBox;
    stringa4CheckBox = new QCheckBox;
    stringa1LineEdit = new QLineEdit("");
    stringa2LineEdit = new QLineEdit("");
    stringa3LineEdit = new QLineEdit("");
    stringa4LineEdit = new QLineEdit("");

    QHBoxLayout *label1Layout = new QHBoxLayout;
    label1Layout->addWidget(label1);
    label1Layout->addStretch();

    QGridLayout *contenutoLayout = new QGridLayout;
    contenutoLayout->addWidget(stringa1CheckBox, 0, 0);
    contenutoLayout->addWidget(stringa2CheckBox, 1, 0);
    contenutoLayout->addWidget(stringa3CheckBox, 2, 0);
    contenutoLayout->addWidget(stringa4CheckBox, 3, 0);
    contenutoLayout->addWidget(stringa1LineEdit, 0, 1);
    contenutoLayout->addWidget(stringa2LineEdit, 1, 1);
    contenutoLayout->addWidget(stringa3LineEdit, 2, 1);
    contenutoLayout->addWidget(stringa4LineEdit, 3, 1);

    QLabel *label2;
    label2=new QLabel(tr("Delete by Sender:"));

    stringa5CheckBox = new QCheckBox;
    stringa6CheckBox = new QCheckBox;
    stringa5LineEdit = new QLineEdit("");
    stringa6LineEdit = new QLineEdit("");
    stringa7CheckBox = new QCheckBox;
    stringa8CheckBox = new QCheckBox;
    stringa7LineEdit = new QLineEdit("");
    stringa8LineEdit = new QLineEdit("");

    QHBoxLayout *label2Layout = new QHBoxLayout;
    label2Layout->addWidget(label2);

    QHBoxLayout *mittente1Layout = new QHBoxLayout;
    mittente1Layout->addWidget(stringa5CheckBox);
    mittente1Layout->addWidget(stringa5LineEdit);
    mittente1Layout->addSpacing(40);
    mittente1Layout->addWidget(stringa6CheckBox);
    mittente1Layout->addWidget(stringa6LineEdit);

    QHBoxLayout *mittente2Layout = new QHBoxLayout;
    mittente2Layout->addWidget(stringa7CheckBox);
    mittente2Layout->addWidget(stringa7LineEdit);
    mittente2Layout->addSpacing(40);
    mittente2Layout->addWidget(stringa8CheckBox);
    mittente2Layout->addWidget(stringa8LineEdit);

    QLabel *label3;
    infoButton = new QPushButton;
    infoButton->setIcon(QIcon("/opt/AutoRemoveSms/info.png"));
    label3 = new QLabel(tr("Delete by Date:"));
    dataCheckBox = new QCheckBox;
    dayBox=new QComboBox;
        for (int i=1; i<32; i++)
        {
            dayBox->insertItem(i, QString::number(i));
        }

    monthBox = new QComboBox;
    monthBox->insertItem(1, tr("January"));
    monthBox->insertItem(2, tr("Febrary"));
    monthBox->insertItem(3, tr("March"));
    monthBox->insertItem(4, tr("April"));
    monthBox->insertItem(5, tr("May"));
    monthBox->insertItem(6, tr("June"));
    monthBox->insertItem(7, tr("July"));
    monthBox->insertItem(8, tr("Agoust"));
    monthBox->insertItem(9, tr("September"));
    monthBox->insertItem(10, tr("October"));
    monthBox->insertItem(11, tr("November"));
    monthBox->insertItem(12, tr("December"));
    yearBox = new QComboBox;
        for (int i=2009; i<2020; i++)
        {
            yearBox->insertItem(i, QString::number(i));
        }
    dataRCheckBox = new QCheckBox;
    dataRComboBox = new QComboBox;
    dataRComboBox->insertItem(0, tr("1 Year ago"));
    dataRComboBox->insertItem(1, tr("6 Months ago"));
    dataRComboBox->insertItem(2, tr("1 Month ago"));
    dataRComboBox->insertItem(3, tr("1 Week ago"));
    dataRComboBox->insertItem(4, tr("1 Day ago"));
    dataRComboBox->setFixedWidth(364);

    QHBoxLayout *label3Layout = new QHBoxLayout;
    label3Layout->addWidget(label3);

    QHBoxLayout *date1Layout = new QHBoxLayout;
    date1Layout->addWidget(dataCheckBox);
    date1Layout->addWidget(dayBox);
    date1Layout->addWidget(monthBox);
    date1Layout->addWidget(yearBox);
    date1Layout->addStretch();
    date1Layout->addWidget(infoButton);

    QHBoxLayout *date2Layout = new QHBoxLayout;
    date2Layout->addWidget(dataRCheckBox);
    date2Layout->addWidget(dataRComboBox);
    date2Layout->addStretch();

    deleteButton = new QPushButton(tr("Delete"));
    deleteButton->setIcon(QIcon("/opt/AutoRemoveSms/button_cancel.png"));
    backgroundCheckBox = new QCheckBox(tr("Activate Background"));
    backgroundCheckBox->setFixedWidth(320);

    QHBoxLayout *deleteLayout = new QHBoxLayout;
    deleteLayout->addWidget(backgroundCheckBox);
    deleteLayout->addWidget(deleteButton);

    QVBoxLayout *mainLayout = new QVBoxLayout;
    mainLayout->addSpacing(10);
    mainLayout->addLayout(label1Layout);
    mainLayout->addLayout(contenutoLayout);
    mainLayout->addSpacing(20);
    mainLayout->addLayout(label2Layout);
    mainLayout->addLayout(mittente1Layout);
    mainLayout->addLayout(mittente2Layout);
    mainLayout->addSpacing(20);
    mainLayout->addLayout(label3Layout);
    mainLayout->addLayout(date1Layout);
    mainLayout->addLayout(date2Layout);
    mainLayout->addSpacing(20);
    mainLayout->addLayout(deleteLayout);
    mainLayout->addStretch();

    setLayout(mainLayout);

    connect(deleteButton, SIGNAL(clicked()), this, SLOT(deleteButtonClicked()));
    connect(infoButton, SIGNAL(clicked()), this, SLOT(infoClicked()));

    readSettings();
}



void Central::deleteButtonClicked()
{

    if (stringa1CheckBox->isChecked())
    {
        if (stringa1LineEdit->text().size()<4)
        {
            QString message = (tr("String too short, skipping"));
            maemoBanner(message);
        }
        else
        {
            QtMobility::QMessageFilter include_Filter1(QMessageFilter::bySubject(stringa1LineEdit->text()));
            include_Filter1 &= QMessageFilter::byType(QMessage::Sms);
            if (QMessageManager().removeMessages(include_Filter1))
             {
                QString messaggio(tr("Messages with '")); messaggio.append(stringa1LineEdit->text()); messaggio.append(tr("' deleted!"));
                maemoBanner(messaggio);
             }
        }
    }

    if (stringa2CheckBox->isChecked())
    {
        if (stringa2LineEdit->text().size()<4)
        {
            QString message = (tr("String too short, skipping"));
            maemoBanner(message);
        }
        else
        {
            QtMobility::QMessageFilter include_Filter1(QMessageFilter::bySubject(stringa2LineEdit->text()));
            include_Filter1 &= QMessageFilter::byType(QMessage::Sms);
            if (QMessageManager().removeMessages(include_Filter1))
             {
                QString messaggio(tr("Messages with '")); messaggio.append(stringa2LineEdit->text()); messaggio.append(tr("' deleted!"));
                maemoBanner(messaggio);
             }
        }
    }

    if (stringa3CheckBox->isChecked())
    {
        if (stringa3LineEdit->text().size()<4)
        {
            QString message = (tr("String too short, skipping"));
            maemoBanner(message);
        }
        else
        {
            QtMobility::QMessageFilter include_Filter1(QMessageFilter::bySubject(stringa3LineEdit->text()));
            include_Filter1 &= QMessageFilter::byType(QMessage::Sms);
            if (QMessageManager().removeMessages(include_Filter1))
             {
                QString messaggio(tr("Messages with '")); messaggio.append(stringa3LineEdit->text()); messaggio.append(tr("' deleted!"));
                maemoBanner(messaggio);
             }
        }
    }

    if (stringa4CheckBox->isChecked())
    {
        if (stringa4LineEdit->text().size()<4)
        {
            QString message = (tr("String too short, skipping"));
            maemoBanner(message);
        }
        else
        {
            QtMobility::QMessageFilter include_Filter1(QMessageFilter::bySubject(stringa4LineEdit->text()));
            include_Filter1 &= QMessageFilter::byType(QMessage::Sms);
            if (QMessageManager().removeMessages(include_Filter1))
             {
                QString messaggio(tr("Messages with '")); messaggio.append(stringa4LineEdit->text()); messaggio.append(tr("' deleted!"));
                maemoBanner(messaggio);
             }
        }
    }

    if (stringa5CheckBox->isChecked())
    {
        if (stringa5LineEdit->text().isEmpty())
        {
            QString message = (tr("String is empty, skipping"));
            maemoBanner(message);
        }
        else
        {
            QMessageFilter include_Filter1(QMessageFilter::bySender(stringa5LineEdit->text(), QMessageDataComparator::Equal));
            include_Filter1 &= QMessageFilter::byType(QMessage::Sms);
            if (QMessageManager().removeMessages(include_Filter1))
             {
                QString messaggio(tr("Messages by '")); messaggio.append(stringa5LineEdit->text()); messaggio.append(tr("' deleted!"));
                maemoBanner(messaggio);
             }
        }
    }

    if (stringa6CheckBox->isChecked())
    {
        if (stringa6LineEdit->text().isEmpty())
        {
            QString message = (tr("String is empty, skipping"));
            maemoBanner(message);
        }
        else
        {
            QMessageFilter include_Filter1(QMessageFilter::bySender(stringa6LineEdit->text(), QMessageDataComparator::Equal));
            include_Filter1 &= QMessageFilter::byType(QMessage::Sms);
            if (QMessageManager().removeMessages(include_Filter1))
             {
                QString messaggio(tr("Messages by '")); messaggio.append(stringa6LineEdit->text()); messaggio.append(tr("' deleted!"));
                maemoBanner(messaggio);
             }
        }
    }

    if (stringa7CheckBox->isChecked())
    {
        if (stringa7LineEdit->text().isEmpty())
        {
            QString message = (tr("String is empty, skipping"));
            maemoBanner(message);
        }
        else
        {
            QMessageFilter include_Filter1(QMessageFilter::bySender(stringa7LineEdit->text(), QMessageDataComparator::Equal));
            include_Filter1 &= QMessageFilter::byType(QMessage::Sms);
            if (QMessageManager().removeMessages(include_Filter1))
             {
                QString messaggio(tr("Messages by '")); messaggio.append(stringa7LineEdit->text()); messaggio.append(tr("' deleted!"));
                maemoBanner(messaggio);
             }
        }
    }

    if (stringa8CheckBox->isChecked())
    {
        if (stringa8LineEdit->text().isEmpty())
        {
            QString message = (tr("String is empty, skipping"));
            maemoBanner(message);
        }
        else
        {
            QMessageFilter include_Filter1(QMessageFilter::bySender(stringa8LineEdit->text(), QMessageDataComparator::Equal));
            include_Filter1 &= QMessageFilter::byType(QMessage::Sms);
            if (QMessageManager().removeMessages(include_Filter1))
             {
                QString messaggio(tr("Messages by '")); messaggio.append(stringa8LineEdit->text()); messaggio.append(tr("' deleted!"));
                maemoBanner(messaggio);
             }
        }
    }

    if (dataCheckBox->isChecked())
    {
        QDateTime maximumDate;
        QDate data;
        data.setDate(yearBox->currentIndex()+2009, monthBox->currentIndex()+1, dayBox->currentIndex()+1);
        if (!data.isValid())
        {
            QString message = (tr("Date is not valid!"));
            maemoBanner(message);
        }
        else
        {
        maximumDate.setDate(data);

        QMessageFilter include_Filter1(QMessageFilter::byTimeStamp(maximumDate, QMessageDataComparator::LessThan));
        include_Filter1 &= QMessageFilter::byType(QMessage::Sms);
        if (QMessageManager().removeMessages(include_Filter1))
         {
                QString messaggio(tr("Messages received before "));messaggio.append(data.toString("dd.MM.yyyy")); messaggio.append(tr(" deleted!"));
                maemoBanner(messaggio);
         }
      }
    }

    if (dataRCheckBox->isChecked())
    {
        QDateTime maximumDate;
        QDate data;
        data=(QDate::currentDate());

        if (dataRComboBox->currentIndex() == 0)
        {
            data=data.addYears(-1);
                    }

        if (dataRComboBox->currentIndex()== 1)
        {
            data=data.addMonths(-6);
        }

        if (dataRComboBox->currentIndex()==2)
        {
            data=data.addMonths(-1);
        }

        if (dataRComboBox->currentIndex()==3)
        {
            data=data.addDays(-7);
        }

        if (dataRComboBox->currentIndex()==4)
        {
            data=data.addDays(-1);
        }

        maximumDate.setDate(data);
        QMessageFilter include_Filter1(QMessageFilter::byTimeStamp(maximumDate, QMessageDataComparator::LessThan));
        include_Filter1 &= QMessageFilter::byType(QMessage::Sms);
        if (QMessageManager().removeMessages(include_Filter1))
         {
                QString messaggio(tr("Messages older than "));

                switch (dataRComboBox->currentIndex())
                {
                case (0) :  messaggio.append(tr("1 year")); break;
                case (1) :  messaggio.append(tr("6 months")); break;
                case (2) :  messaggio.append(tr("1 month")); break;
                case (3) :  messaggio.append(tr("1 week")); break;
                case (4) :  messaggio.append(tr("1 day")); break;
                }

                messaggio.append(tr(" deleted!"));
                maemoBanner(messaggio);
    }
   }
}

void Central::readSettings()
{
    QSettings settings("Maemo", "AutoRemoveSms");

    stringa1LineEdit->setText(settings.value("stringa1LineEdit", "Ti ho cercato alle").toString());
    stringa2LineEdit->setText(settings.value("stringa2LineEdit", "Sono di nuovo disponibile").toString());
    stringa3LineEdit->setText(settings.value("stringa3LineEdit", "Natale con Sky! 60canali Cinema").toString());
    stringa4LineEdit->setText(settings.value("stringa6LineEdit", "Impara a giocare a Poker").toString());
    stringa5LineEdit->setText(settings.value("stringa4LineEdit", "4115").toString());
    stringa6LineEdit->setText(settings.value("stringa5LineEdit", "42774").toString());
    stringa7LineEdit->setText(settings.value("stringa7LineEdit", "4040").toString());
    stringa8LineEdit->setText(settings.value("stringa8LineEdit", "414").toString());

    stringa1CheckBox->setChecked(settings.value("stringa1CheckBox", false).toBool());
    stringa2CheckBox->setChecked(settings.value("stringa2CheckBox", false).toBool());
    stringa3CheckBox->setChecked(settings.value("stringa3CheckBox", false).toBool());
    stringa4CheckBox->setChecked(settings.value("stringa6CheckBox", false).toBool());
    stringa5CheckBox->setChecked(settings.value("stringa4CheckBox", false).toBool());
    stringa6CheckBox->setChecked(settings.value("stringa5CheckBox", false).toBool());
    stringa7CheckBox->setChecked(settings.value("stringa7CheckBox", false).toBool());
    stringa8CheckBox->setChecked(settings.value("stringa8CheckBox", false).toBool());

    dataCheckBox->setChecked(settings.value("dataCheckBox", false).toBool());
    dataRCheckBox->setChecked(settings.value("dataRCheckBox", false).toBool());
    dayBox->setCurrentIndex(settings.value("dayBox", 0).toInt());
    monthBox->setCurrentIndex(settings.value("monthBox", 0).toInt());
    yearBox->setCurrentIndex(settings.value("yearBox", 0).toInt());
    dataRComboBox->setCurrentIndex(settings.value("dataRComboBox", 0).toInt());

    backgroundCheckBox->setChecked(settings.value("backgroundCheckBox", false).toBool());
}

void Central::writeSettings()
{
    QSettings settings("Maemo", "AutoRemoveSms");

    settings.setValue("stringa1LineEdit", stringa1LineEdit->text());
    settings.setValue("stringa2LineEdit", stringa2LineEdit->text());
    settings.setValue("stringa3LineEdit", stringa3LineEdit->text());
    settings.setValue("stringa6LineEdit", stringa4LineEdit->text());
    settings.setValue("stringa4LineEdit", stringa5LineEdit->text());
    settings.setValue("stringa5LineEdit", stringa6LineEdit->text());
    settings.setValue("stringa7LineEdit", stringa7LineEdit->text());
    settings.setValue("stringa8LineEdit", stringa8LineEdit->text());

    settings.setValue("stringa1CheckBox", stringa1CheckBox->isChecked());
    settings.setValue("stringa2CheckBox", stringa2CheckBox->isChecked());
    settings.setValue("stringa3CheckBox", stringa3CheckBox->isChecked());
    settings.setValue("stringa6CheckBox", stringa4CheckBox->isChecked());
    settings.setValue("stringa4CheckBox", stringa5CheckBox->isChecked());
    settings.setValue("stringa5CheckBox", stringa6CheckBox->isChecked());
    settings.setValue("stringa7CheckBox", stringa7CheckBox->isChecked());
    settings.setValue("stringa8CheckBox", stringa8CheckBox->isChecked());

    settings.setValue("dataCheckBox", dataCheckBox->isChecked());
    settings.setValue("dataRCheckBox", dataRCheckBox->isChecked());
    settings.setValue("dayBox", dayBox->currentIndex());
    settings.setValue("monthBox", monthBox->currentIndex());
    settings.setValue("yearBox", yearBox->currentIndex());
    settings.setValue("dataRComboBox", dataRComboBox->currentIndex());

    settings.setValue("backgroundCheckBox", backgroundCheckBox->isChecked());
}

Central::~Central()
{
   QString program = tr("AutoRemoveSms: Settings saved!");
   maemoBanner(program);
   writeSettings();
}

void Central::infoClicked()
{
    QMessageBox::about(this, tr("Info about Delete by Date"),
                tr("<p>The first option will delete all sms received before the picked date. The second one will delete all the sms older than the chosen option."));
}
