#include "mainwindow.h"
#include "central.h"
#include <QAction>
#include <QApplication>
#include <QMenu>
#include <QMenuBar>
#include <QMessageBox>
#include <QScrollArea>




MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
    w=new Central();

    QScrollArea *scrollArea=new QScrollArea;

    scrollArea->setWidget(w);
    w->setMinimumWidth(790);

    setCentralWidget(scrollArea);



    //setCentralWidget(w);


    createActions();
    createMenus();
	
	setWindowTitle("AutoRemoveSms");


}

MainWindow::~MainWindow()
{

}

void MainWindow::createActions()
{

    aboutAction = new QAction(tr("&About"), this);
    //aboutAction->setIcon(QIcon("/usr/share/icons/hicolor/32x32/hildon/general_help.png"));
    aboutQtAction = new QAction("About QT", this);
    connect(aboutAction, SIGNAL(triggered()), this, SLOT(about()));
    connect(aboutQtAction, SIGNAL(triggered()), this, SLOT(aboutQt()));






}


void MainWindow::createMenus()
{
    QMenu *menu;
    menu = menuBar()->addMenu(tr("MENU TITLE"));
    menu->addAction(aboutAction);
    menu->addAction(aboutQtAction);
}



void MainWindow::about()
{
    QMessageBox::about(this, tr("About AutoRemoveSms"),
                tr("<h2>AutoRemoveSms 0.3.2</h2>"
                   "<p>"
                   "<p>AutoRemoveSms is an application that allow you to delete your sms by Text, Sender or Received Date. It can be scheduled with Alarmed to auto remove your messages with planned events."
                   "<p>"
                   "<p>Written by GGiovanni (ggiovanni88@yahoo.it)"));

}

void MainWindow::aboutQt()
{
    QApplication::aboutQt();

}



