#include "central.h"
#include "QLineEdit"
#include "mainwindow.h"
#include "QVBoxLayout"
#include <QHBoxLayout>
#include <QGridLayout>
#include "QtMessaging/QMessage"
//#include "QtMessaging/QMessageId"
#include <QtMessaging/QMessageFilter>
//#include <QMessageBox>
#include <qmessage.h>
#include <qmessagefilter.h>
#include <QDate>
#include <QLabel>
#include <QPushButton>
#include <QProcess>
#include <QCheckBox>
#include <QSettings>
#include <QScrollArea>
#include <QWidget>
#include <QComboBox>
#include <QMessageBox>
#include "qmessagemanager.h"
#include <qmessagemanager.h>


using namespace QtMobility;




Central::Central(QWidget *parent) :
    QWidget(parent)
{
    QLabel *label1;
    label1 = new QLabel("Delete by Text:");

    stringa1CheckBox = new QCheckBox;
    stringa2CheckBox = new QCheckBox;
    stringa3CheckBox = new QCheckBox;
    stringa1LineEdit = new QLineEdit("");
    stringa2LineEdit = new QLineEdit("");
    stringa3LineEdit = new QLineEdit("");

    QHBoxLayout *label1Layout = new QHBoxLayout;
    label1Layout->addWidget(label1);
    label1Layout->addStretch();

    QGridLayout *contenutoLayout = new QGridLayout;
    contenutoLayout->addWidget(stringa1CheckBox, 0, 0);
    contenutoLayout->addWidget(stringa2CheckBox, 1, 0);
    contenutoLayout->addWidget(stringa3CheckBox, 2, 0);
    contenutoLayout->addWidget(stringa1LineEdit, 0, 1);
    contenutoLayout->addWidget(stringa2LineEdit, 1, 1);
    contenutoLayout->addWidget(stringa3LineEdit, 2, 1);

    QLabel *label2;
    label2=new QLabel("Delete by Sender:");

    stringa4CheckBox = new QCheckBox;
    stringa5CheckBox = new QCheckBox;
    stringa4LineEdit = new QLineEdit("");
    stringa5LineEdit = new QLineEdit("");

    QHBoxLayout *label2Layout = new QHBoxLayout;
    label2Layout->addWidget(label2);

    QHBoxLayout *mittenteLayout = new QHBoxLayout;
    mittenteLayout->addWidget(stringa4CheckBox);
    mittenteLayout->addWidget(stringa4LineEdit);
    mittenteLayout->addSpacing(40);
    mittenteLayout->addWidget(stringa5CheckBox);
    mittenteLayout->addWidget(stringa5LineEdit);


    QLabel *label3;
    infoButton = new QPushButton;
    infoButton->setIcon(QIcon("/opt/AutoRemoveSms/info.png"));
        label3 = new QLabel("Delete by Date:");
    dataCheckBox = new QCheckBox;
    dayBox=new QComboBox;
        for (int i=1; i<32; i++)
        {
            dayBox->insertItem(i, QString::number(i));
        }
    //dayBox->insertItem(1, "01");
    monthBox = new QComboBox;
    monthBox->insertItem(1, "January");
    monthBox->insertItem(2, "Febrary");
    monthBox->insertItem(3, "March");
    monthBox->insertItem(4, "April");
    monthBox->insertItem(5, "May");
    monthBox->insertItem(6, "June");
    monthBox->insertItem(7, "July");
    monthBox->insertItem(8, "Agoust");
    monthBox->insertItem(9, "September");
    monthBox->insertItem(10, "October");
    monthBox->insertItem(11, "November");
    monthBox->insertItem(12, "December");
    yearBox = new QComboBox;
        for (int i=2009; i<2020; i++)
        {
            yearBox->insertItem(i, QString::number(i));
        }
    QHBoxLayout *label3Layout = new QHBoxLayout;
    label3Layout->addWidget(label3);

    QHBoxLayout *dateLayout = new QHBoxLayout;
    dateLayout->addWidget(dataCheckBox);
    dateLayout->addWidget(dayBox);
    dateLayout->addWidget(monthBox);
    dateLayout->addWidget(yearBox);
    dateLayout->addStretch();
    dateLayout->addWidget(infoButton);






    deleteButton = new QPushButton("Delete");
    //deleteButton->setFixedWidth(500);
    deleteButton->setIcon(QIcon("/opt/AutoRemoveSms/button_cancel.png"));
    backgroundCheckBox = new QCheckBox("Activate Background");
    backgroundCheckBox->setFixedWidth(320);
    //backgroundCheckBox->setDisabled(true);

    QHBoxLayout *deleteLayout = new QHBoxLayout;
    deleteLayout->addWidget(backgroundCheckBox);
    deleteLayout->addWidget(deleteButton);

    QVBoxLayout *mainLayout = new QVBoxLayout;
    mainLayout->addSpacing(10);
    mainLayout->addLayout(label1Layout);
    mainLayout->addLayout(contenutoLayout);
    mainLayout->addSpacing(20);
    mainLayout->addLayout(label2Layout);
    mainLayout->addLayout(mittenteLayout);
    mainLayout->addSpacing(20);
    mainLayout->addLayout(label3Layout);
    mainLayout->addLayout(dateLayout);
    mainLayout->addSpacing(20);
    mainLayout->addLayout(deleteLayout);
    mainLayout->addStretch();




    setLayout(mainLayout);

    connect(deleteButton, SIGNAL(clicked()), this, SLOT(deleteButtonClicked()));
    connect(infoButton, SIGNAL(clicked()), this, SLOT(infoClicked()));



    readSettings();


}



void Central::deleteButtonClicked()
{

    if (stringa1CheckBox->isChecked())
    {

        QtMobility::QMessageFilter include_Filter1(QMessageFilter::bySubject(stringa1LineEdit->text()));
        include_Filter1 &= QMessageFilter::byType(QMessage::Sms);
        if (QMessageManager().removeMessages(include_Filter1))
         {
            QString messaggio("Messages with '");
            messaggio.append(stringa1LineEdit->text());
            messaggio.append("'' deleted!");
            QString program = "dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"" + messaggio + "\"";
            QProcess *myProcess = new QProcess(this);
            myProcess->execute(program);
         }
    }

    if (stringa2CheckBox->isChecked())
    {
        QtMobility::QMessageFilter include_Filter1(QMessageFilter::bySubject(stringa2LineEdit->text()));
        include_Filter1 &= QMessageFilter::byType(QMessage::Sms);
        if (QMessageManager().removeMessages(include_Filter1))
         {
            QString messaggio("Messages with '");
            messaggio.append(stringa2LineEdit->text());
            messaggio.append("'deleted!");
            QString program = "dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"" + messaggio + "\"";
            QProcess *myProcess = new QProcess(this);
            myProcess->execute(program);
         }
    }

    if (stringa3CheckBox->isChecked())
    {
        QMessageFilter include_Filter1(QMessageFilter::bySubject(stringa3LineEdit->text()));
        include_Filter1 &= QMessageFilter::byType(QMessage::Sms);
        if (QMessageManager().removeMessages(include_Filter1))
         {
            QString messaggio("Messages with '");
            messaggio.append(stringa3LineEdit->text());
            messaggio.append("' deleted!");
            QString program = "dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"" + messaggio + "\"";
            QProcess *myProcess = new QProcess(this);
            myProcess->execute(program);
         }
    }

    if (stringa4CheckBox->isChecked())
    {
        QMessageFilter include_Filter1(QMessageFilter::bySender(stringa4LineEdit->text(), QMessageDataComparator::Equal));
        include_Filter1 &= QMessageFilter::byType(QMessage::Sms);
        if (QMessageManager().removeMessages(include_Filter1))
         {
            QString messaggio("Messages by '");
            messaggio.append(stringa4LineEdit->text());
            messaggio.append("' deleted!");
            QString program = "dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"" + messaggio + "\"";
            QProcess *myProcess = new QProcess(this);
            myProcess->execute(program);
         }
    }

    if (stringa5CheckBox->isChecked())
    {
        QMessageFilter include_Filter1(QMessageFilter::bySender(stringa5LineEdit->text(), QMessageDataComparator::Equal));
        include_Filter1 &= QMessageFilter::byType(QMessage::Sms);
        if (QMessageManager().removeMessages(include_Filter1))
         {
                QString messaggio("Messages by '");
                messaggio.append(stringa5LineEdit->text());
                messaggio.append("' deleted!");
                QString program = "dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"" + messaggio + "\"";
                QProcess *myProcess = new QProcess(this);
                myProcess->execute(program);
         }
    }

    if (dataCheckBox->isChecked())
    {
        QDateTime maximumDate;
        QDate data;
        data.setDate(yearBox->currentIndex()+2009, monthBox->currentIndex()+1, dayBox->currentIndex()+1);
        if (!data.isValid())
        {
            QString program = "dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"Date is not valid!\"";
            QProcess *myProcess = new QProcess(this);
            myProcess->execute(program);


        }
        else
        {
        maximumDate.setDate(data);



        QMessageFilter include_Filter1(QMessageFilter::byTimeStamp(maximumDate, QMessageDataComparator::LessThan));
        include_Filter1 &= QMessageFilter::byType(QMessage::Sms);
        if (QMessageManager().removeMessages(include_Filter1))
         {
                QString messaggio("Messages received before ");
                messaggio.append(data.toString("dd.MM.yyyy"));
                messaggio.append(" deleted!");
                QString program = "dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"" + messaggio + "\"";
                QProcess *myProcess = new QProcess(this);
                myProcess->execute(program);
         }
      }
    }
}

void Central::readSettings()
{
    QSettings settings("Maemo", "AutoRemoveSms");

    QString stringa1 = settings.value("stringa1LineEdit", "Ti ho cercato alle").toString();
    stringa1LineEdit->setText(stringa1);

    QString stringa2 = settings.value("stringa2LineEdit", "Sono di nuovo disponibile").toString();
    stringa2LineEdit->setText(stringa2);

    QString stringa3 = settings.value("stringa3LineEdit", "Natale con Sky! 60canali Cinema").toString();
    stringa3LineEdit->setText(stringa3);

    stringa1CheckBox->setChecked(settings.value("stringa1CheckBox", true).toBool());
    stringa2CheckBox->setChecked(settings.value("stringa2CheckBox", false).toBool());
    stringa3CheckBox->setChecked(settings.value("stringa3CheckBox", false).toBool());

    stringa4LineEdit->setText(settings.value("stringa4LineEdit", "4115").toString());
    stringa5LineEdit->setText(settings.value("stringa5LineEdit", "42774").toString());
    stringa4CheckBox->setChecked(settings.value("stringa4CheckBox", false).toBool());
    stringa5CheckBox->setChecked(settings.value("stringa5CheckBox", false).toBool());

    dataCheckBox->setChecked(settings.value("dataCheckBox", false).toBool());
    dayBox->setCurrentIndex(settings.value("dayBox", 0).toInt());
    monthBox->setCurrentIndex(settings.value("monthBox", 0).toInt());
    yearBox->setCurrentIndex(settings.value("yearBox", 0).toInt());

    backgroundCheckBox->setChecked(settings.value("backgroundCheckBox", false).toBool());


}

void Central::writeSettings()
{
    QSettings settings("Maemo", "AutoRemoveSms");

    settings.setValue("stringa1LineEdit", stringa1LineEdit->text());
    settings.setValue("stringa2LineEdit", stringa2LineEdit->text());
    settings.setValue("stringa3LineEdit", stringa3LineEdit->text());

    settings.setValue("stringa1CheckBox", stringa1CheckBox->isChecked());
    settings.setValue("stringa2CheckBox", stringa2CheckBox->isChecked());
    settings.setValue("stringa3CheckBox", stringa3CheckBox->isChecked());

    settings.setValue("stringa4LineEdit", stringa4LineEdit->text());
    settings.setValue("stringa5LineEdit", stringa5LineEdit->text());
    settings.setValue("stringa4CheckBox", stringa4CheckBox->isChecked());
    settings.setValue("stringa5CheckBox", stringa5CheckBox->isChecked());

    settings.setValue("dataCheckBox", dataCheckBox->isChecked());
    settings.setValue("dayBox", dayBox->currentIndex());
    settings.setValue("monthBox", monthBox->currentIndex());
    settings.setValue("yearBox", yearBox->currentIndex());

    settings.setValue("backgroundCheckBox", backgroundCheckBox->isChecked());
}

Central::~Central()
{
    QString program = "dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:\"AutoRemoveSms: Impostazioni salvate!\"";
             QProcess *myProcess = new QProcess(this);
             myProcess->execute(program);

   writeSettings();
}

void Central::infoClicked()
{
    QMessageBox::about(this, tr("Info about Delete by Date"),
                tr("<p>If activated, all messages received before the  "
                   "<p>selected date will be deleted "));
}
