#!/usr/bin/env python

import sys, os
from PyQt4 import QtGui
from PyQt4 import QtCore
 
class TextEditor(QtGui.QMainWindow):    
 
    def __init__(self, parent=None):
        QtGui.QMainWindow.__init__(self, parent)
        self.setWindowTitle('AutoFreeWifi Configuration')
        
        hLayout = QtGui.QHBoxLayout()
        self.labelid = QtGui.QLabel()
        self.labelid.setText("Identifiant")
        self.login = QtGui.QLineEdit()
        hLayout.addWidget(self.labelid)
        hLayout.addWidget(self.login)
        
        hLayout2 = QtGui.QHBoxLayout()
        self.labelpwd = QtGui.QLabel()
        self.labelpwd.setText("Mot de passe")
        self.password = QtGui.QLineEdit()
        self.password.setEchoMode(QtGui.QLineEdit.Password)
        hLayout2.addWidget(self.labelpwd)
        hLayout2.addWidget(self.password)
 
        hLayout3 = QtGui.QHBoxLayout()
        
        buttonOK = QtGui.QDialogButtonBox()
        buttonOK.setStandardButtons(QtGui.QDialogButtonBox.Cancel|QtGui.QDialogButtonBox.Ok)
        
        hLayout3.addWidget(buttonOK)

        vLayout = QtGui.QVBoxLayout()
        vLayout.addLayout(hLayout)
        vLayout.addLayout(hLayout2)
        vLayout.addLayout(hLayout3)
 
        self.mainframe = QtGui.QFrame()
        self.mainframe.setLayout(vLayout)
        self.setCentralWidget(self.mainframe)

        QtCore.QObject.connect(buttonOK, QtCore.SIGNAL("accepted()"), self.accept)
        QtCore.QObject.connect(buttonOK, QtCore.SIGNAL("rejected()"), self.reject)
        
    def accept(self):
        login = self.login.text()
        password = self.password.text()

        dir = "/home/user/.AutoFreeWifi"
        if not os.path.exists(dir):
            os.makedirs(dir)

        f = open( os.path.join(dir, "login.conf"), "w")
        f.write("LOGIN=\""+login+"\"\n")
        f.write("PASSWORD=\""+password+"\"\n")
        f.close()

        self.close()

    def reject(self):
        self.close()
        
if __name__ == '__main__':    

    #Creating Qt application
    app = QtGui.QApplication(sys.argv)
 
    myTextEditor = TextEditor()
    myTextEditor.show()
 
    #Initing application
    sys.exit(app.exec_())
