#!/usr/bin/env python

import sys


def _cmd_apply_blacklist(): #{{{1
    from PyQt4.QtCore import QCoreApplication
    from ACE_gui import ACESettings
    from ACE_file import ACEFile
    from ACE_utils import apply_blacklist

    app = QCoreApplication(sys.argv)

    settings = ACESettings()
    blacklists = settings.getBlacklist()

    dicts = ACEFile()

    changed = False
    for i in dicts.getLanguages():
        if i in blacklists:
            dictList = dicts.getDict(i)

            if apply_blacklist(dictList, blacklists[i]):
                dicts.setDict(i, dictList)
                changed = True

    if changed:
        dicts.write()

def _cmd_run_gui(): #{{{1
    from PyQt4.QtGui  import QApplication, QMessageBox
    from ACE_gui      import ACEMainWindow
    import traceback

    app = QApplication(sys.argv)

    try:
        w = ACEMainWindow()
        w.show()
        w.setupMenu()
        w.setupScreen()
        w.loadData()

        app.exec_()
    except Exception, e:
        QMessageBox.critical(None, 'Error', traceback.format_exc(2))

if __name__ == '__main__':

    if '--apply-blacklist' in sys.argv:
        _cmd_apply_blacklist()
    else:
        _cmd_run_gui()

    sys.exit()
