#!/usr/bin/env python

from PyQt4.QtCore import QSettings

class ACESettings(): #{{{1
    def __init__(self): #{{{2
        self._settings = QSettings('Auto-Complete Editor', 'Auto-Complete Editor')

    def getDelMode(self): #{{{2
        if self._settings.contains('DeleteMode'):
            return self._settings.value('DeleteMode').toString()
        else:
            return 'Normal'

    def getDisplayDictionary(self): #{{{2
        if self._settings.contains('displayDictionary'):
            return self._settings.value('displayDictionary').toInt()[0]
        else:
            return 0

    def getBlacklist(self): #{{{2
        blacklist = {}

        self._settings.beginGroup('blacklist')
        if self._settings.contains('languages'):
            s = self._settings.value('languages').toString()
            langList = s.split(',')

            for i in langList:
                blacklist[int(i)] = self._settings.value(i).toStringList()

        self._settings.endGroup()

        return blacklist

    def getEncoding(self): #{{{2
        if self._settings.contains('charEncoding'):
            return self._settings.value('charEncoding').toString()
        else:
            return 'Default'

    def setDelMode(self, mode): #{{{2
        self._settings.setValue('DeleteMode', mode)

    def setDisplayDictionary(self, dict): #{{{2
        self._settings.setValue('displayDictionary', dict)

    def setBlacklist(self, langList, blacklist): #{{{2
        self._settings.remove('blacklist')

        if len(langList) == 0:
            return

        self._settings.beginGroup('blacklist')
        self._settings.setValue('languages', ','.join(langList))

        for i in langList:
            self._settings.setValue(i, blacklist[int(i)])

        self._settings.endGroup()

    def setEncoding(self, enc): #{{{2
        if enc == 'Default':
            self._settings.remove('charEncoding')
        else:
            self._settings.setValue('charEncoding', enc)
