#!/usr/bin/env python

import errno
import sys

from PyQt4.QtCore import QCoreApplication, QFile, QIODevice, QString
from ACE_utils import bytesToInt

langCodeLookup = {
    3: 'en_GB',
    4: 'fr_FR',
    5: 'de_DE',
    6: 'es_ES',
    8: 'pt_PT',
    9: 'sv_SE',
    10: 'fi_FI',
    11: 'no_NO',
    12: 'da_DK',
    13: 'nl_NL',
    14: 'el_GR',
    22: 'pl_PL',
    23: 'cs_CZ',
    39: 'ru_RU',
    46: 'en_US',
    47: 'it_IT',
    51: 'es_MX',
    52: 'fr_CA',
}

langFile = '/usr/share/i18n-locale-resolver/generic.data'

_langLookup = {}

class ACELanguages(): #{{{1
    def __init__(self): #{{{2
        if len(_langLookup) == 0:
            self._read()

    def _read(self): #{{{2
        file = QFile(langFile)

        if not file.exists:
            raise IOError(errno.ENOENT, "File not found", langFile)

        if not file.open(QIODevice.ReadOnly):
            raise IOError(errno.EIO, "Cannot open file", langFile)

        if not file.seek(0x15):
            raise IOError(errno.EIO, "Error seeking in file", langFile)

        curLanguage = ''
        curTerritory = ''
        while not file.atEnd():
            entryID = bytesToInt(file.read(1))

            if entryID == 0x44:
                entryLength = bytesToInt(file.read(1))
                entryKey = file.read(entryLength)
            elif entryID == 0x45:
                entryLength = bytesToInt(file.read(1))
                entryKey = file.read(entryLength)
                entryLength = bytesToInt(file.read(1))
                entryName = file.read(entryLength)

                if entryKey[0] != '_':
                    curLanguage = entryKey

                    _langLookup[curLanguage] = entryName
                else:
                    curTerritory = entryKey

                    _langLookup[curLanguage + curTerritory] = entryName
            elif entryID == 0x54:
                entryLength = bytesToInt(file.read(1))
                entryKey = file.read(entryLength)
                entryLength = bytesToInt(file.read(1))
                entryName = file.read(entryLength)

                _langLookup[entryKey + curTerritory] = entryName

        file.close()

    def getNameFromCode(self, code): #{{{2
        lwrCode = code.lower()
        codeLanguage = lwrCode[0:lwrCode.find('_')]
        langName = None

        if codeLanguage in _langLookup:
            langName = _langLookup[codeLanguage]

            if lwrCode in _langLookup:
                langName += ' (' + _langLookup[lwrCode] + ')'

        return langName

    def getCodeFromID(self, id): #{{{2
        if id in langCodeLookup:
            return langCodeLookup[id]

    def getNameFromID(self, id): #{{{2
        return self.getNameFromCode(self.getCodeFromID(id))

if __name__ =='__main__': #{{{1
    app = QCoreApplication(sys.argv)
    lang = ACELanguages()
    print lang.getNameFromCode('ru_RU')
