#include "playlist.h"
#include "ui_playlist.h"
#include <QMap>
#include <QPushButton>


Playlist::Playlist(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Playlist)
{
    ui->setupUi(this);
    playlistlist = new Playlists();
    this->updateList();
    ui->treeWidget->setColumnCount(1);
 //   ui->treeWidget->setColumnWidth(0,300);

 //   box->setLayout();
 //   box->addButton("Open", QDialogButtonBox::AcceptRole);
 //   box->addButton("Remove", QDialogButtonBox::RejectRole );
 /*   box->hide();
    connect(box, SIGNAL(accepted()), this, SLOT(openArticle()));
    connect(box, SIGNAL(rejected()), this, SLOT(deleteArticle()));
    */



}

Playlist::~Playlist()
{
    delete ui;
}

void Playlist::on_treeWidget_itemClicked(QTreeWidgetItem *item, int column)
{

 //   if (column == 0)
 //   {
        if (item->childCount() == 0)
        {

            this->articleSelected(item, column);
            this->hide();
          /*  clickedItem = item;
            clickedColumn = column;
            box->show();
           // this->articleSelected(item, column);*/
        }
        else
        {
            this->playlistSelected(item->takeChildren(), column);
            this->hide();
        }


 //   }
  /*  if (column == 1)
    {
        if (item->childCount() == 0)
            playlistlist->removePlaylistItem(item->data(1, 1).toString(), column, item->parent());

        else
            playlistlist->removePlaylist(item->text(column));

        this->updateList();
    }*/

}

void Playlist::openArticle()
{
    this->articleSelected(this->clickedItem, this->clickedColumn);
    this->hide();
}

void Playlist::deleteArticle()
{
    playlistlist->removePlaylistItem(this->clickedItem->text(this->clickedColumn), this->clickedColumn, this->clickedItem->parent());
    this->updateList();
}

QStringList Playlist::getPlaylists()
{
    return playlistlist->getPlaylistTitles();
}

void Playlist::addToPlaylist(QString playlist, QString article)
{
    playlistlist->addNewItemToPlaylist(playlist, article);
    this->updateList();
}

void Playlist::updateList()
{
    this->ui->treeWidget->clear();
    QPushButton *button = new QPushButton("Remove");
    QList<QTreeWidgetItem *> items;
//    QList<QTreeWidgetItem *> removes;
    foreach(QString title, this->playlistlist->getPlaylistTitles())
    {

        QTreeWidgetItem *item = new QTreeWidgetItem(QStringList(title));
        ui->treeWidget->setItemWidget(item, 0, button);
        QList<QTreeWidgetItem*> children;

  //      QTreeWidgetItem *itemRemove = new QTreeWidgetItem(QStringList("Remove"));
  //      itemRemove->setData(1, Qt::DisplayRole, QVariant(title));
  //      QList<QTreeWidgetItem*> removeChildren;

        foreach (QString article, this->playlistlist->getPlaylistContent(title))
        {

            QTreeWidgetItem *temp = new QTreeWidgetItem(QStringList(article));
            ui->treeWidget->setItemWidget(temp, 0, new QPushButton("Remove"));
     //       temp->setData(1,Qt::DisplayRole, QVariant(article));
     //       removeChildren.append(temp);
            children.append(temp);

        }
        item->addChildren(children);
     //   itemRemove->addChildren(removeChildren);
        items.append(item);
     //   removes.append(itemRemove);
       // item->set
        //this->ui->treeWidget->addTopLevelItem(item);
    }
    this->ui->treeWidget->insertTopLevelItems(0, items);
   // this->ui->treeWidget->insertTopLevelItems(0, removes);
}

