#include "playlists.h"
#include <QSettings>
#include <QFile>
#include <QDebug>
#include <QDesktopServices>

Playlists::Playlists()
{
    playlistFile = new QFile(QDesktopServices::storageLocation(QDesktopServices::DocumentsLocation) + "playlists.dat");
    if (playlistFile->open(QIODevice::ReadOnly))
    {
        QDataStream in(playlistFile);   // we will serialize the data into the file
        in >> this->playlists;
        playlistFile->close();
    }
    else
        qDebug()<<"file error";
}

QStringList Playlists::getPlaylistContent(QString title)
{
    QStringList articles;
    articles = playlists.value(title);
    return articles;
}

QMap<QString, QStringList> Playlists::getPlaylists()
{
    return this->playlists;
}

QStringList Playlists::getPlaylistTitles()
{
    QStringList titles = playlists.keys();
    return titles;
}

void Playlists::addNewItemToPlaylist(QString title, QString item)
{
    QStringList items = this->playlists.take(title);
    items.append(item);
    this->playlists.insert(title, items);
    if (playlistFile->open(QIODevice::WriteOnly))
    {
        QDataStream out(playlistFile);   // we will serialize the data into the file
        out << this->playlists;
        playlistFile->close();
    }
    else
        qDebug()<<"write error";

}

void Playlists::removePlaylistItem(QTreeWidgetItem *item, int column, QTreeWidgetItem *parent)
{
    QStringList items;
    items = playlists.value(parent->text(column));
    int i = 0;
    foreach (QString playlistItem, items)
    {
        if (playlistItem == item->text(column))
        {
            items.removeAt(i);
            break;
        }
        i ++;
    }
}

void Playlists::removePlaylist(QString title)
{
    playlists.remove(title);

}
