#ifndef PLAYLISTS_H
#define PLAYLISTS_H
#include <QMap>
#include <QStringList>
#include <QFile>
#include <QTreeWidgetItem>

class Playlists : public QObject
{
public:
    Playlists();
    QStringList getPlaylistTitles();
    QMap<QString, QStringList> getPlaylists();
    QStringList getPlaylistContent(QString title);
    void addNewItemToPlaylist(QString title, QString item);
    void removePlaylist(QString title);
    void removePlaylistItem(QTreeWidgetItem *item, int column, QTreeWidgetItem *parent);

private:
    QMap<QString, QStringList> playlists;
    QFile *playlistFile;
};

#endif // PLAYLISTS_H
