#include "playlist.h"
#include "ui_playlist.h"
#include <QMap>
#define NORMAL "normal"
#define REMOVE "remove"
#ifdef Q_WS_MAEMO5
#include <QtMaemo5/QMaemo5InformationBox>
#endif

Playlist::Playlist(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Playlist)
{
    ui->setupUi(this);
    playlistlist = new Playlists();
    this->updateList();
    ui->treeWidget->setColumnCount(1);
    mode = NORMAL;



}

Playlist::~Playlist()
{
    delete ui;
}

void Playlist::on_treeWidget_itemClicked(QTreeWidgetItem *item, int column)
{
    if (mode == NORMAL)
    {
        if (item->childCount() == 0)
            this->articleSelected(item, column);

        else
            this->playlistSelected(item->takeChildren(), column);

        this->hide();
    }
    if (mode == REMOVE)
    {
        if (item->childCount() == 0)
            playlistlist->removePlaylistItem(item, column, item->parent());

        else
            playlistlist->removePlaylist(item->text(column));

        this->updateList();
       // this->hide();
    }
}

QStringList Playlist::getPlaylists()
{
    return playlistlist->getPlaylistTitles();
}

void Playlist::addToPlaylist(QString playlist, QString article)
{
    playlistlist->addNewItemToPlaylist(playlist, article);
    this->updateList();
}

void Playlist::updateList()
{
    this->ui->treeWidget->clear();
    QList<QTreeWidgetItem *> items;
    foreach(QString title, this->playlistlist->getPlaylistTitles())
    {
        QTreeWidgetItem *item = new QTreeWidgetItem(QStringList(title));
        QList<QTreeWidgetItem*> children;
        foreach (QString article, this->playlistlist->getPlaylistContent(title))
            children.append(new QTreeWidgetItem(QStringList(article)));
        item->addChildren(children);
        items.append(item);
       // item->set
        //this->ui->treeWidget->addTopLevelItem(item);
    }
    this->ui->treeWidget->insertTopLevelItems(0, items);
}

void Playlist::setMode(QString mode)
{
    this->mode = mode;
    #ifdef Q_WS_MAEMO5
    QMaemo5InformationBox::information(this, "Remove playlists or playlist items by clicking on them",
                                                QMaemo5InformationBox::DefaultTimeout);
    #endif
}

