#include "network.h"
#include <QDebug>
#include <QObject>
#define SEARCH 1
#define ARTICLE 2
#define PARSE 3

Network::Network()
{

    dataHandler = new DataHandler();


}
Network::~Network()
{
    dataHandler->deleteLater();
}

void Network::startRequest(QUrl url)
{
    dataHandler->removeFiles();
    reply = qnam.get(QNetworkRequest(url));
    connect(reply, SIGNAL(finished()), this, SLOT(httpFinished()));
    connect(reply, SIGNAL(readyRead()),this, SLOT(httpReadyRead()));
 //   connect(reply, SIGNAL(downloadProgress(qint64,qint64)), this, SLOT(followDownloadProgress(qint64,qint64)));
}

/*void Network::followDownloadProgress(qint64 received, qint64 total)
{
    this->downloadProgress(received, total);
}*/

void Network::httpFinished()
{
    if (reply->error())
        qDebug()<<"Error "<<reply->errorString();

    else
    {
        dataHandler->dataReceived(reply, mode);
        if (mode == SEARCH)
            this->searchTitlesReceived(dataHandler->getSearchTitles());
        else if (mode == ARTICLE && onlySaveArticle == false)
        {
            this->articleContentReceived(dataHandler->getCurrentArticleTitle(), dataHandler->getArticleFromFile());
        }
        else if (mode == ARTICLE && onlySaveArticle == true)
            this->playlistArticleSaved();
    }

}

void Network::httpReadyRead()
{

}

void Network::searchKeyWord(QString key)
{
    mode = SEARCH;
    QString path("http://en.wikipedia.org/w/api.php?action=opensearch&search="+key+"&format=xml");
    url.setUrl(path);
    this->startRequest(url);
}

void Network::retrieveArticle(QString title, bool infile, bool forplaylist)
{
    onlySaveArticle = forplaylist;
    if (title.contains(" "))
        title.replace(" ", "_");
    dataHandler->setCurrentArticle(title);
    if (infile)
    {
        this->articleContentReceived(title, dataHandler->getArticleFromFile());
        return;
    }
    mode = ARTICLE;

    QString path("http://en.wikipedia.org/w/api.php?action=parse&page="+title+"&prop=text|links&format=xml");
    url.setUrl(path);
    this->startRequest(url);

}

void Network::parseWikiText(QString title, QString article)
{
   // qDebug()<<article<<"\n";
    mode = PARSE;
    QString path("http://en.wikipedia.org/w/api.php?action=parse&text="+article);
    url.setUrl(path);
    this->startRequest(url);
}

void Network::fileSaved(QString title)
{
    dataHandler->addFileToSaved(title);
}
