#include "player.h"
#include "ui_player.h"
#include <QFile>
#include <QDesktopServices>
#include <QDebug>


Player::Player(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Player)
{
    ui->setupUi(this);
    reload = false;
    playing = false;
    audio = new Audio();
    //connect(audio,SIGNAL(finished()), this, SLOT(playingFinished()));
}

Player::~Player()
{
    delete ui;
}

void Player::openArticle(QString itemName, QString text)
{
    path = itemName.toLower().normalized(QString::NormalizationForm_D)+".txt";

    QStringList links;
    QFile *articleLinks = new QFile(QDesktopServices::storageLocation(QDesktopServices::DocumentsLocation) + "/AudioWiki/"+ itemName.toLower().normalized(QString::NormalizationForm_D)+".dat");
    if (articleLinks->open(QIODevice::ReadOnly))
    {
        QDataStream out(articleLinks);   // we will serialize the data into the file
        out >> links;
        articleLinks->close();
    }

    linkWidget = new LinkList(links, this);
    linkWidget->hide();
    connect(linkWidget, SIGNAL(linkClicked(QListWidgetItem*)), this, SLOT(linkListWidget_itemClicked(QListWidgetItem*)));

    if (!reload)
    {

        if (itemName.contains("_"))
            itemName.replace("_", " ");

        QListWidgetItem *item = new QListWidgetItem(itemName);

        ui->playListWidget->insertItem(ui->playListWidget->count(), item);

        if (ui->playListWidget->count() > 1)
            ui->playListWidget->setCurrentRow(ui->playListWidget->count()-1);

    }
    else
    {

        reload = false;
    }


    ui->articleBrowser->setText(text);

    audio->createWav(path);

}

void Player::clearCurrentArticles()
{
    ui->playListWidget->clear();
    ui->articleBrowser->clear();
}

void Player::clear()
{
    ui->playListWidget->clear();
    ui->articleBrowser->clear();
}

void Player::linkListWidget_itemClicked(QListWidgetItem *item)
{
    this->openArticleFromLink(item);
}

void Player::on_backwardButton_clicked()
{
    if (this->ui->playListWidget->currentRow() >= 1 )
    {
        reload = true;
        this->ui->playListWidget->item(this->ui->playListWidget->currentRow())->setSelected(false);
        this->ui->playListWidget->setCurrentRow(this->ui->playListWidget->currentRow()-1,QItemSelectionModel::Select);
        this->openArticleFromLink(ui->playListWidget->currentItem());
    }

}

void Player::on_forwardButton_clicked()
{
    if (this->ui->playListWidget->currentRow() <= ui->playListWidget->count())
    {
        reload = true;
        this->ui->playListWidget->item(this->ui->playListWidget->currentRow())->setSelected(false);
        this->ui->playListWidget->setCurrentRow(this->ui->playListWidget->currentRow()+1,QItemSelectionModel::Select);
        this->openArticleFromLink(ui->playListWidget->currentItem());
    }

}

void Player::setPlaylistFocus()
{
    reload = true;
    this->ui->playListWidget->setCurrentRow(0, QItemSelectionModel::Select);
    this->openArticleFromLink(ui->playListWidget->currentItem());
}

void Player::on_playListWidget_itemClicked(QListWidgetItem *item)
{
    reload = true;
    this->openArticleFromLink(item);
}

void Player::on_linksButton_clicked()
{
    linkWidget->show();
}

void Player::on_playPauseButton_clicked()
{
   // system("espeak -f "+ path);

    if (!playing)
    {
        audio->play();
        playing = true;
    }
    else
    {
        audio->pause();
        playing = false;
    }

}

void Player::playingFinished()
{
    playing = false;
}
