#ifndef DATAHANDLER_H
#define DATAHANDLER_H

#include <QObject>
#include <xmlparser.h>
#include <QNetworkReply>
#include <articleparser.h>

class DataHandler : public QObject
{
    Q_OBJECT
public:
    explicit DataHandler(QObject *parent = 0);
    ~DataHandler();
    void dataReceived(QNetworkReply *reply, int mode);
    QList<QString> getSearchTitles();
    QMap<QString, QStringList> getArticleContent();
    void setCurrentArticle(QString articleName);
    QString getArticleFromFile();
    QString getCurrentArticleTitle();
    void addFileToSaved(QString title);
    void removeFiles();

signals:

public slots:


private:
    XMLParser *parser;
    QList<QString> searchTitles;
    QMap<QString, QStringList> articleContent;
    QFile *article;
    QFile *articleLinks;
    QString currentArticleTitle;
    void saveArticleToFile(QMap<QString, QStringList> content);
    ArticleParser *articleParser;
    QList<QString> *savedFiles;
    QList<QString> *allLoadedFiles;
    QStringList articleLinkList;

};

#endif // DATAHANDLER_H
