#include "audio.h"
#include <stdlib.h>
#include <QProcess>
#include <QSound>
#include <QDebug>
#include <QFile>
#include <QDesktopServices>
#include <phonon/MediaObject>
#include <phonon/MediaSource>

//#include "flite.h"



Audio::Audio(QObject *parent) :
    QObject(parent)
{


}
/*extern "C" {
    cst_voice* register_cmu_us_kal();
}*/
void Audio::createWav(QString filename)
{


    QString audio = filename;
    audio.chop(3);
    audio.append("wav");
    audioFile = new QFile(QDesktopServices::storageLocation(QDesktopServices::DocumentsLocation) + "/AudioWiki/"+ audio);
    if (!audioFile->open(QIODevice::ReadWrite))
        qDebug()<<"cannot write to file";
    else
    {
        QString program = "flite"; //espeak
        QStringList arguments;

        arguments << "-f" << filename << "-o" << audio; //arguments << "-f" << filename << "-s" << "110" << "-v " << "en/en-rp" << -w << audio;
        qDebug()<<arguments;
        QProcess *myProcess = new QProcess();

        file = audio;

        myProcess->start(program, arguments);
        myProcess->waitForFinished();

        music = Phonon::createPlayer(Phonon::MusicCategory,
                                      Phonon::MediaSource(audioFile->fileName()));


   /*         flite_init();
            cst_voice *v;
            v = register_cmu_us_kal();
            cst_wave *audioWav;
            audioWav = flite_text_to_wave("hello", v);
            //audioFile = flite_text_to_wave("hello", v);*/


        connect(music, SIGNAL(finished()), this, SLOT(audioFinished()));

        audioFile->close();
    }

}

void Audio::audioFinished()
{
    this->finished();
}

void Audio::play()
{

    music->play();
}

void Audio::pause()
{
    music->pause();
}

